/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb;

import fr.gael.drb.DrbAbstractSequence;
import fr.gael.drb.DrbItem;
import fr.gael.drb.DrbSequence;
import fr.gael.drb.value.Float;
import fr.gael.drb.value.Int;
import fr.gael.drb.value.ValueArray;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class DrbDefaultSequence
extends ArrayList<DrbItem>
implements DrbSequence {
    private static Logger logger = Logger.getLogger(DrbDefaultSequence.class);
    private List<DrbItem> itemList = this;

    public DrbDefaultSequence() {
    }

    public DrbDefaultSequence(DrbItem item) {
        super(1);
        this.add(0, item);
    }

    public DrbDefaultSequence(DrbSequence sequence) {
        super(sequence == null ? 0 : sequence.getLength());
        if (sequence != null) {
            for (int index = 0; index < sequence.getLength(); ++index) {
                this.add(index, sequence.getItem(index));
            }
        }
    }

    protected DrbDefaultSequence(DrbDefaultSequence sequence) {
        super(sequence.itemList);
    }

    @Override
    public ValueArray atomize() {
        return DrbAbstractSequence.atomize(this);
    }

    @Override
    public final DrbItem getItem(int index) {
        if (index < 0 || index >= this.size()) {
            return null;
        }
        return (DrbItem)this.get(index);
    }

    @Override
    public final int getLength() {
        return this.size();
    }

    @Override
    public DrbSequence addItem(int index, DrbItem item) throws NullPointerException, UnsupportedOperationException, IndexOutOfBoundsException {
        if (item == null) {
            throw new NullPointerException("DrbDefaultSequence.addItem() : cannot add a null item");
        }
        this.itemList.add(index, item);
        return this;
    }

    public DrbSequence addItem(DrbItem item) throws NullPointerException, UnsupportedOperationException {
        return this.addItem(this.getLength(), item);
    }

    @Override
    public DrbSequence removeItem(int index) throws IndexOutOfBoundsException, UnsupportedOperationException {
        this.itemList.remove(index);
        return this;
    }

    @Override
    public String toString() {
        String str = "";
        for (int i = 0; i < this.getLength(); ++i) {
            if (i != 0) {
                str = str + ", ";
            }
            str = str + this.getItem(i);
        }
        return str;
    }

    public static void main(String[] args) {
        Float val = new Float(2.0f);
        DrbDefaultSequence singleton = new DrbDefaultSequence(val);
        System.out.println("$singleton=" + singleton);
        System.out.println("data($singleton)=" + singleton.atomize());
        DrbDefaultSequence sequence = new DrbDefaultSequence();
        for (int i = 0; i < 3; ++i) {
            sequence.addItem(new Int(i));
        }
        System.out.println("$sequence=" + sequence);
        System.out.println("data($sequence)=" + sequence.atomize());
        DrbDefaultSequence copy = new DrbDefaultSequence(sequence);
        System.out.println("$copy=" + copy);
    }
}

