/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.sdf;

import fr.gael.drb.impl.sdf.RandomAccessData;
import fr.gael.drb.value.BinaryInteger;
import fr.gael.drb.value.Byte;
import fr.gael.drb.value.ByteArray;
import fr.gael.drb.value.DateTime;
import fr.gael.drb.value.Double;
import fr.gael.drb.value.DoubleArray;
import fr.gael.drb.value.Float;
import fr.gael.drb.value.FloatArray;
import fr.gael.drb.value.Int;
import fr.gael.drb.value.IntArray;
import fr.gael.drb.value.LongArray;
import fr.gael.drb.value.Short;
import fr.gael.drb.value.ShortArray;
import fr.gael.drb.value.String;
import fr.gael.drb.value.UnsignedByte;
import fr.gael.drb.value.UnsignedByteArray;
import fr.gael.drb.value.UnsignedInt;
import fr.gael.drb.value.UnsignedIntArray;
import fr.gael.drb.value.UnsignedLong;
import fr.gael.drb.value.UnsignedLongArray;
import fr.gael.drb.value.UnsignedShort;
import fr.gael.drb.value.UnsignedShortArray;
import fr.gael.drb.value.Value;
import java.io.EOFException;
import java.io.IOException;
import org.apache.log4j.Logger;

class BlockTools {
    private static Logger logger = Logger.getLogger(BlockTools.class);
    private static final int[] MASK = new int[]{255, 127, 63, 31, 15, 7, 3, 1};
    private byte[] buffer = new byte[0];

    BlockTools() {
    }

    protected final long extractAsciiLong(byte[] buffer) {
        return this.extractAsciiLong(new java.lang.String(buffer));
    }

    protected final long extractAsciiLong(byte[] buffer, int offset, int length) {
        return this.extractAsciiLong(new java.lang.String(buffer, offset, length));
    }

    protected final long extractAsciiLong(java.lang.String buffer) {
        java.lang.String tmpStr = buffer.trim();
        if (tmpStr.startsWith("+")) {
            tmpStr = tmpStr.substring(1);
        }
        return Long.parseLong(tmpStr);
    }

    protected final double extractAsciiDouble(byte[] buffer) {
        return this.extractAsciiDouble(new java.lang.String(buffer));
    }

    protected final double extractAsciiDouble(byte[] buffer, int offset, int length) {
        return this.extractAsciiDouble(new java.lang.String(buffer, offset, length));
    }

    protected final double extractAsciiDouble(java.lang.String buffer) {
        java.lang.String tmpStr = buffer.trim();
        return java.lang.Double.parseDouble(tmpStr);
    }

    protected final Value extractValue(RandomAccessData file, long offset, int bit_offset, int length, int bit_length, int encoding, int value_type, int array_value_type, int array_size) throws EOFException, IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("extractValue(file, offset=" + offset + ", length=" + length + ", bit_length=" + bit_length + ", encoding=" + encoding + ", value_type=" + value_type + ", array_value_type=" + array_value_type + ", array_size=" + array_size);
        }
        if (file == null) {
            return null;
        }
        try {
            file.seek(offset);
            if (encoding == 2 || value_type == 7 || value_type == 8 || encoding == 1 && value_type == 10) {
                this.buffer = new byte[length];
                int lengthRead = length;
                file.readFully(this.buffer);
                if (lengthRead == -1) {
                    throw new EOFException("BlockTools.extractValue(): Unable to read at offset " + offset);
                }
                if (lengthRead != length) {
                    logger.error("fr.gael.drb.impl.sdf.BlockTools.extractValue() : Cannot read " + length + " byte(s) from file.");
                    return null;
                }
            }
            if (encoding != 2 && encoding != 1) {
                logger.error("fr.gael.drb.impl.sdf.BlockTools.extractValue() : Encoding not supported ! (encoding=" + encoding + ").");
                return null;
            }
            if (bit_offset > 0 || bit_length > 0) {
                int bufferLength = length + (bit_offset + bit_length) / 8;
                if ((bit_offset + bit_length) % 8 > 0) {
                    ++bufferLength;
                }
                this.buffer = new byte[bufferLength];
                file.readFully(this.buffer);
                this.buffer[0] = (byte)(this.buffer[0] & MASK[bit_offset]);
                int value = 0;
                for (int i = bufferLength - 1; i >= 0; --i) {
                    value += (this.buffer[i] & 0xFF) << 8 * (bufferLength - 1 - i);
                }
                int rightShift = 8 - (bit_offset + bit_length) % 8;
                if (rightShift == 8) {
                    rightShift = 0;
                }
                return new BinaryInteger(value >>= rightShift, 8 * length + bit_length);
            }
            switch (value_type) {
                case 7: {
                    return new String(this.buffer);
                }
                case 12: {
                    if (encoding == 2) {
                        return new UnsignedByte((byte)this.extractAsciiLong(this.buffer));
                    }
                    return new UnsignedByte(file.readByte());
                }
                case 1: {
                    if (encoding == 2) {
                        return new Byte((byte)this.extractAsciiLong(this.buffer));
                    }
                    return new Byte(file.readByte());
                }
                case 13: {
                    if (encoding == 2) {
                        return new UnsignedShort((short)this.extractAsciiLong(this.buffer));
                    }
                    return new UnsignedShort(file.readShort());
                }
                case 2: {
                    if (encoding == 2) {
                        return new Short((short)this.extractAsciiLong(this.buffer));
                    }
                    return new Short(file.readShort());
                }
                case 14: {
                    if (encoding == 2) {
                        return new UnsignedInt((int)this.extractAsciiLong(this.buffer));
                    }
                    return new UnsignedInt(file.readInt());
                }
                case 3: {
                    if (encoding == 2) {
                        return new Int((int)this.extractAsciiLong(this.buffer));
                    }
                    return new Int(file.readInt());
                }
                case 15: {
                    if (encoding == 2) {
                        return new UnsignedLong(this.extractAsciiLong(this.buffer));
                    }
                    return new UnsignedLong(file.readLong());
                }
                case 4: {
                    if (encoding == 2) {
                        return new fr.gael.drb.value.Long(this.extractAsciiLong(this.buffer));
                    }
                    return new fr.gael.drb.value.Long(file.readLong());
                }
                case 5: {
                    if (encoding == 2) {
                        return new Float((float)this.extractAsciiDouble(this.buffer));
                    }
                    return new Float(file.readFloat());
                }
                case 6: {
                    if (encoding == 2) {
                        return new Double(this.extractAsciiDouble(this.buffer));
                    }
                    return new Double(file.readDouble());
                }
                case 8: {
                    if (encoding == 2) {
                        return new DateTime(new java.lang.String(this.buffer));
                    }
                    return new DateTime(this.buffer);
                }
                case 10: {
                    int itemLength = length / array_size;
                    int curOffset = 0;
                    switch (array_value_type) {
                        case 1: 
                        case 12: {
                            if (encoding == 2) {
                                byte[] byteArray = new byte[array_size];
                                for (int i = 0; i < array_size; ++i) {
                                    byteArray[i] = (byte)this.extractAsciiLong(this.buffer, curOffset, itemLength);
                                    curOffset += itemLength;
                                }
                                if (array_value_type == 12) {
                                    return new UnsignedByteArray(byteArray);
                                }
                                return new ByteArray(byteArray);
                            }
                            if (array_value_type == 12) {
                                return new UnsignedByteArray(this.buffer);
                            }
                            return new ByteArray(this.buffer);
                        }
                        case 6: {
                            double[] doubleArray = new double[array_size];
                            if (encoding == 2) {
                                for (int i = 0; i < array_size; ++i) {
                                    doubleArray[i] = this.extractAsciiDouble(this.buffer, curOffset, itemLength);
                                    curOffset += itemLength;
                                }
                            } else {
                                long tmpLong = 0L;
                                for (int i = 0; i < array_size; ++i) {
                                    tmpLong = ((long)(this.buffer[i * 8] & 0xFF) << 56) + ((long)(this.buffer[i * 8 + 1] & 0xFF) << 48) + ((long)(this.buffer[i * 8 + 2] & 0xFF) << 40) + ((long)(this.buffer[i * 8 + 3] & 0xFF) << 32) + ((long)(this.buffer[i * 8 + 4] & 0xFF) << 24) + ((long)(this.buffer[i * 8 + 5] & 0xFF) << 16) + ((long)(this.buffer[i * 8 + 6] & 0xFF) << 8) + (long)(this.buffer[i * 8 + 7] & 0xFF);
                                    doubleArray[i] = java.lang.Double.longBitsToDouble(tmpLong);
                                }
                            }
                            return new DoubleArray(doubleArray);
                        }
                        case 5: {
                            float[] floatArray = new float[array_size];
                            if (encoding == 2) {
                                for (int i = 0; i < array_size; ++i) {
                                    floatArray[i] = (float)this.extractAsciiDouble(this.buffer, curOffset, itemLength);
                                    curOffset += itemLength;
                                }
                            } else {
                                int tmpInt = 0;
                                for (int i = 0; i < array_size; ++i) {
                                    tmpInt = ((this.buffer[i * 4] & 0xFF) << 24) + ((this.buffer[i * 4 + 1] & 0xFF) << 16) + ((this.buffer[i * 4 + 2] & 0xFF) << 8) + (this.buffer[i * 4 + 3] & 0xFF);
                                    floatArray[i] = java.lang.Float.intBitsToFloat(tmpInt);
                                }
                            }
                            return new FloatArray(floatArray);
                        }
                        case 14: {
                            int[] intArray = new int[array_size];
                            if (encoding == 2) {
                                for (int i = 0; i < array_size; ++i) {
                                    intArray[i] = (int)this.extractAsciiLong(this.buffer, curOffset, itemLength);
                                    curOffset += itemLength;
                                }
                            } else {
                                for (int i = 0; i < array_size; ++i) {
                                    intArray[i] = ((this.buffer[i * 4] & 0xFF) << 24) + ((this.buffer[i * 4 + 1] & 0xFF) << 16) + ((this.buffer[i * 4 + 2] & 0xFF) << 8) + (this.buffer[i * 4 + 3] & 0xFF);
                                }
                            }
                            return new UnsignedIntArray(intArray);
                        }
                        case 3: {
                            int[] intArray = new int[array_size];
                            if (encoding == 2) {
                                for (int i = 0; i < array_size; ++i) {
                                    intArray[i] = (int)this.extractAsciiLong(this.buffer, curOffset, itemLength);
                                    curOffset += itemLength;
                                }
                            } else {
                                for (int i = 0; i < array_size; ++i) {
                                    intArray[i] = ((this.buffer[i * 4] & 0xFF) << 24) + ((this.buffer[i * 4 + 1] & 0xFF) << 16) + ((this.buffer[i * 4 + 2] & 0xFF) << 8) + (this.buffer[i * 4 + 3] & 0xFF);
                                }
                            }
                            return new IntArray(intArray);
                        }
                        case 4: 
                        case 15: {
                            long[] longArray = new long[array_size];
                            if (encoding == 2) {
                                for (int i = 0; i < array_size; ++i) {
                                    longArray[i] = this.extractAsciiLong(this.buffer, curOffset, itemLength);
                                    curOffset += itemLength;
                                }
                            } else {
                                for (int i = 0; i < array_size; ++i) {
                                    longArray[i] = ((long)(this.buffer[i * 8] & 0xFF) << 56) + ((long)(this.buffer[i * 8 + 1] & 0xFF) << 48) + ((long)(this.buffer[i * 8 + 2] & 0xFF) << 40) + ((long)(this.buffer[i * 8 + 3] & 0xFF) << 32) + ((long)(this.buffer[i * 8 + 4] & 0xFF) << 24) + ((long)(this.buffer[i * 8 + 5] & 0xFF) << 16) + ((long)(this.buffer[i * 8 + 6] & 0xFF) << 8) + (long)(this.buffer[i * 8 + 7] & 0xFF);
                                }
                            }
                            if (array_value_type == 15) {
                                return new UnsignedLongArray(longArray);
                            }
                            return new LongArray(longArray);
                        }
                        case 13: {
                            short[] shortArray = new short[array_size];
                            if (encoding == 2) {
                                for (int i = 0; i < array_size; ++i) {
                                    shortArray[i] = (short)this.extractAsciiLong(this.buffer, curOffset, itemLength);
                                    curOffset += itemLength;
                                }
                            } else {
                                for (int i = 0; i < array_size; ++i) {
                                    shortArray[i] = (short)((this.buffer[i * 2] << 8) + (this.buffer[i * 2 + 1] & 0xFF));
                                }
                            }
                            return new UnsignedShortArray(shortArray);
                        }
                        case 2: {
                            short[] shortArray = new short[array_size];
                            if (encoding == 2) {
                                for (int i = 0; i < array_size; ++i) {
                                    shortArray[i] = (short)this.extractAsciiLong(this.buffer, curOffset, itemLength);
                                    curOffset += itemLength;
                                }
                            } else {
                                for (int i = 0; i < array_size; ++i) {
                                    shortArray[i] = (short)((this.buffer[i * 2] << 8) + (this.buffer[i * 2 + 1] & 0xFF));
                                }
                            }
                            return new ShortArray(shortArray);
                        }
                    }
                    return null;
                }
            }
            logger.error("fr.gael.drb.impl.sdf.BlockTools.extractValue() : Value type not supported (" + value_type + ").");
            return null;
        }
        catch (NumberFormatException e) {
            logger.error("fr.gael.drb.impl.sdf.BlockTools.extractValue() : Error while extracting value from Ascii buffer.");
            logger.error("   " + e);
            return null;
        }
        catch (Exception e) {
            logger.error("fr.gael.drb.impl.sdf.BlockTools.extractValue() : Error while reading file (offset=" + offset + ", length=" + length + ").");
            logger.error("   " + e);
            return null;
        }
    }
}

