/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.sdf;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.apache.log4j.Logger;

final class KeyTreeMap {
    private static Logger logger = Logger.getLogger(KeyTreeMap.class);
    private int depth;
    private int size;
    private Map children;

    protected KeyTreeMap() {
        this(-1);
    }

    protected KeyTreeMap(int depth) {
        this.depth = depth;
        this.size = 0;
        this.children = new TreeMap();
    }

    protected final void add(int[] key, long value) {
        if (key == null || key.length == 0) {
            logger.warn("KeyTreeMap.add() WARNING: key is null or empty, nothing added to the tree.");
            return;
        }
        if (this.depth <= 0) {
            this.depth = key.length;
        } else if (key.length != this.depth) {
            logger.error("KeyTreeMap.add() ERROR: The given key is not consistent with the depth of the tree.");
            return;
        }
        Map curLevelMap = this.children;
        for (int i = 0; i < this.depth - 1; ++i) {
            TreeMap tmpLevelMap = (TreeMap)curLevelMap.get(new Integer(key[i]));
            if (tmpLevelMap == null) {
                tmpLevelMap = new TreeMap();
                curLevelMap.put(new Integer(key[i]), tmpLevelMap);
            }
            curLevelMap = tmpLevelMap;
        }
        if (curLevelMap.put(new Integer(key[this.depth - 1]), new Long(value)) == null) {
            ++this.size;
        }
    }

    protected final long get(int[] key) {
        if (key == null || key.length != this.depth) {
            return -1L;
        }
        Map curLevelMap = this.children;
        for (int i = 0; i < this.depth - 1; ++i) {
            Map tmpLevelMap = (Map)curLevelMap.get(new Integer(key[i]));
            if (tmpLevelMap == null) {
                return -1L;
            }
            curLevelMap = tmpLevelMap;
        }
        Long value = (Long)curLevelMap.get(new Integer(key[this.depth - 1]));
        if (value == null) {
            return -1L;
        }
        return value;
    }

    protected final int getSize() {
        return this.size;
    }

    protected final void clear() {
        this.children.clear();
        this.size = 0;
    }

    public String toString() {
        return "{depth=" + this.depth + ", size=" + this.getSize() + ", " + this.children + "}";
    }

    protected final KeyTreeMapIterator iterator() {
        return new KeyTreeMapIterator();
    }

    public static void main(String[] args) {
        System.out.println("\nTest part 1");
        KeyTreeMap ktree = new KeyTreeMap();
        ktree.add(new int[]{0, 2, 0, 0}, 66L);
        ktree.add(new int[]{0, 2, 0, 1}, 177L);
        ktree.add(new int[]{1, 0, 0, 0}, 321L);
        ktree.add(new int[]{1, 0, 0, 1}, 457L);
        ktree.add(new int[]{0, 1, 0, 1}, 44L);
        ktree.add(new int[]{0, 2, 0, 4}, 205L);
        ktree.add(new int[]{0, 2, 0, 1}, 186L);
        ktree.add(new int[]{0, 2, 0}, 99L);
        System.out.println(ktree.get(new int[]{1, 0, 0, 0}));
        System.out.println(ktree.get(new int[]{0, 2, 0, 2}));
        System.out.println(ktree.get(new int[]{0, 2, 0, 1}));
        System.out.println(ktree.get(new int[]{0, 2, 0}));
        System.out.println("toString() = " + ktree);
        ktree.clear();
        System.out.println("after clear() = " + ktree);
        System.out.println("\nTest part 2");
        ktree = new KeyTreeMap();
        System.out.println("toString() = " + ktree);
        for (int i = 0; i < 3; ++i) {
            if (i == 1) {
                ktree.add(new int[]{i, 0, 0}, 100 * i);
                continue;
            }
            for (int j = 0; j < 5; ++j) {
                if (j < 2) {
                    ktree.add(new int[]{i, j, 0}, 100 * i + 10 * j);
                    continue;
                }
                for (int k = 0; k < 3; ++k) {
                    ktree.add(new int[]{i, j, k}, 100 * i + 10 * j + k);
                }
            }
        }
        System.out.println("toString() = " + ktree);
        KeyTreeMapIterator iterator = ktree.iterator();
        System.out.println("iterator = " + iterator);
        int i = 1;
        while (iterator.hasNext()) {
            System.out.print(iterator.next() + " ");
            if (i % 2 == 0) {
                iterator.remove();
            }
            ++i;
        }
        System.out.println();
        System.out.println("toString() = " + ktree);
        iterator = ktree.iterator();
        System.out.println("iterator = " + iterator);
        while (iterator.hasNext()) {
            System.out.print(iterator.next() + " ");
        }
        System.out.println();
    }

    final class KeyTreeMapIterator
    implements Iterator {
        Map[] map;
        Iterator[] iterator;
        Iterator subIterator;
        int level = -1;

        protected KeyTreeMapIterator() {
            if (KeyTreeMap.this.depth > 0) {
                this.level = 0;
                this.map = new Map[KeyTreeMap.this.depth];
                this.map[0] = KeyTreeMap.this.children;
                this.iterator = new Iterator[KeyTreeMap.this.depth];
                this.iterator[0] = this.map[0].values().iterator();
                this.subIterator = this.nextSubIterator();
            }
        }

        private final Iterator nextSubIterator() {
            while (this.level >= 0) {
                if (this.iterator[this.level].hasNext()) {
                    if (this.level < KeyTreeMap.this.depth - 1) {
                        this.map[this.level + 1] = (Map)this.iterator[this.level].next();
                        this.iterator[this.level + 1] = this.map[this.level + 1].values().iterator();
                        ++this.level;
                        continue;
                    }
                    return this.iterator[this.level];
                }
                --this.level;
            }
            return null;
        }

        @Override
        public final boolean hasNext() {
            if (this.level < 0) {
                return false;
            }
            if (this.subIterator.hasNext()) {
                return true;
            }
            this.subIterator = this.nextSubIterator();
            return this.subIterator != null && this.subIterator.hasNext();
        }

        public final Object next() {
            if (!this.subIterator.hasNext()) {
                this.subIterator = this.nextSubIterator();
            }
            if (this.subIterator == null) {
                throw new NoSuchElementException();
            }
            return this.subIterator.next();
        }

        @Override
        public final void remove() {
            this.subIterator.remove();
            KeyTreeMap.this.size--;
            int tmpLevel = this.level;
            while (tmpLevel >= 0 && this.map[tmpLevel].size() == 0) {
                this.iterator[--tmpLevel].remove();
            }
        }
    }
}

