/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.sdf;

import fr.gael.drb.DrbFactoryImpl;
import fr.gael.drb.DrbNode;
import fr.gael.drb.impl.DrbNodeImpl;
import fr.gael.drb.impl.sdf.DefaultBlock;
import fr.gael.drb.impl.sdf.Descriptor;
import fr.gael.drb.impl.sdf.RandomAccessData;
import fr.gael.drb.impl.sdf.RandomAccessFileData;
import fr.gael.drb.impl.sdf.RandomAccessStreamData;
import fr.gael.drb.xsd.XmlSchema;
import fr.gael.drb.xsd.XsdComplexType;
import fr.gael.drb.xsd.XsdElement;
import fr.gael.drb.xsd.XsdFactory;
import fr.gael.drb.xsd.XsdModelGroup;
import fr.gael.drb.xsd.XsdParticle;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import org.apache.log4j.Logger;

public final class SdfFactory
implements DrbFactoryImpl {
    private static Logger logger = Logger.getLogger(SdfFactory.class);

    @Override
    public final String getIdentifier() {
        return "sdf";
    }

    @Override
    public final String getName() {
        return "Structured Data File";
    }

    @Override
    public final DrbNode open(URL uri) {
        return null;
    }

    @Override
    public final DrbNode open(DrbNode base_node) {
        return null;
    }

    @Override
    public final DrbNode open(URL uri, DrbNode base_node) {
        return null;
    }

    public DrbNode open(DrbNode base_node, DrbNode schema_node) {
        XmlSchema schemaDesc;
        try {
            XsdFactory descLoader = new XsdFactory();
            String descName = schema_node.getName();
            schemaDesc = descLoader.open(schema_node);
            if (schemaDesc == null || schemaDesc.getRootElements() == null) {
                logger.error("fr.gael.drb.impl.sdf.SdfFactory.open() : No element found in  \"" + descName + "\"");
                return null;
            }
        }
        catch (Exception e) {
            logger.error("fr.gael.drb.impl.sdf.SdfFactory.open() : Error while parsing XML-Schema.");
            logger.error("   " + e);
            return null;
        }
        return this.open(base_node, schemaDesc, schema_node.getParent().getPath());
    }

    public DrbNode open(DrbNode base_node, XmlSchema xml_schema, String schema_path) {
        Descriptor rootDesc;
        RandomAccessFile file;
        RandomAccessData fileData = null;
        boolean create_mode = false;
        if (base_node == null || xml_schema == null) {
            logger.error("fr.gael.drb.impl.sdf.SdfFactory.open() : null parameter.");
            logger.error("   base_node   = " + (base_node == null ? null : "\"" + base_node.getName() + "\""));
            return null;
        }
        if (!(base_node instanceof DrbNodeImpl)) {
            logger.error("fr.gael.drb.impl.sdf.SdfFactory.open() : cannot retrieve a valid implementation." + (base_node == null ? null : "\"" + base_node.getName() + "\""));
            return null;
        }
        DrbNodeImpl baseImpl = (DrbNodeImpl)base_node;
        String baseNodeName = base_node.getName();
        if (fileData == null && (file = (RandomAccessFile)baseImpl.getImpl(RandomAccessFile.class)) != null) {
            fileData = new RandomAccessFileData(file);
        }
        if (fileData == null && baseImpl.hasImpl(InputStream.class)) {
            fileData = new RandomAccessStreamData(baseImpl);
        }
        if (fileData == null) {
            logger.error("fr.gael.drb.impl.sdf.SdfFactory.open() : Unable to get RandomAccessFile implementation from node \"" + baseNodeName + "\"");
            return null;
        }
        try {
            XmlSchema schemaDesc = xml_schema;
            if (schemaDesc == null || schemaDesc.getRootElements() == null) {
                logger.error("fr.gael.drb.impl.sdf.SdfFactory.open() : No element found in  \"" + schema_path + "\"");
                return null;
            }
            if (schemaDesc.getRootElements().length != 1) {
                logger.error("fr.gael.drb.impl.sdf.SdfFactory.open() : Node descriptor is not unique (nb=" + schemaDesc.getRootElements().length + ") from schema \"" + schema_path + "\"");
                return null;
            }
            XsdElement nodeDesc = schemaDesc.getDefaultRootElement();
            create_mode = fileData.available() <= 0L;
            rootDesc = this.parseNodeDescriptor(fileData, create_mode, nodeDesc, null, 0);
            rootDesc.setParent(null);
            rootDesc.setOffsetType(1);
            rootDesc.setOffset(null, 0L);
            rootDesc.setOccurrenceCountType(1);
            rootDesc.setOccurrenceCount(null, 1L);
            rootDesc.setAsRoot(base_node, schema_path);
        }
        catch (Exception e) {
            logger.error("fr.gael.drb.impl.sdf.SdfFactory.open() : Error while parsing node descriptors.");
            logger.error("   " + e);
            return null;
        }
        DefaultBlock rootBlock = new DefaultBlock(rootDesc, new int[0]);
        return rootBlock;
    }

    private Descriptor parseNodeDescriptor(RandomAccessData file, boolean create_mode, XsdParticle particle, Descriptor parent_descriptor, int depth) {
        if (particle == null) {
            return null;
        }
        Descriptor currentDescriptor = null;
        XsdModelGroup complex_content = null;
        if (particle instanceof XsdElement) {
            XsdElement element = (XsdElement)particle;
            currentDescriptor = new Descriptor(file, create_mode, element, depth);
            if (element.getType() == null || element.getType().getStructure() == null) {
                return currentDescriptor;
            }
            XsdComplexType structureType = element.getType().getStructure();
            complex_content = structureType.getComplexContent();
        } else if (particle instanceof XsdModelGroup) {
            complex_content = (XsdModelGroup)particle;
            currentDescriptor = parent_descriptor;
        } else {
            logger.error("fr.gael.drb.impl.sdf.SdfFactory.parseNodeDescriptor() : Only ELEMENT_TERM is implemented at this time.");
            return null;
        }
        if (complex_content == null) {
            return currentDescriptor;
        }
        Descriptor prevDescriptor = null;
        Descriptor nextDescriptor = null;
        int length = complex_content.getLength();
        for (int i = 0; i < length; ++i) {
            prevDescriptor = nextDescriptor;
            nextDescriptor = this.parseNodeDescriptor(file, create_mode, complex_content.getParticle(i), currentDescriptor, depth + 1);
            if (nextDescriptor == null) continue;
            if (currentDescriptor != nextDescriptor) {
                currentDescriptor.addChild(nextDescriptor);
                nextDescriptor.setParent(currentDescriptor);
            }
            if (prevDescriptor == null) continue;
            prevDescriptor.setNextSibling(nextDescriptor);
            nextDescriptor.setPreviousSibling(prevDescriptor);
        }
        return currentDescriptor;
    }
}

