/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.sds.schema;

import fr.gael.drb.query.Query;
import fr.gael.drb.value.Long;
import org.apache.log4j.Logger;

public class SdfAttribute {
    private static Logger logger = Logger.getLogger(SdfAttribute.class);
    private static final int UNKNOWN = -1;
    public static final int FIXED = 1;
    public static final int CONSTANT = 2;
    public static final int VARIABLE = 3;
    public static final int READ_ONLY = 1;
    public static final int WRITE_ONCE = 1;
    public static final int READ_WRITE = 3;
    public static final int SINGLE = 1;
    public static final int MULTIPLE = 2;
    protected static final short ROOT = 1;
    protected static final short PARENT = 2;
    protected static final short SELF = 3;
    protected String query;
    protected short queryContext = (short)3;
    protected Query queryObject;
    protected int accessType = -1;
    protected int occurrenceType = -1;
    protected Long map;

    protected SdfAttribute() {
        this(3, 2);
    }

    protected SdfAttribute(int access_type) {
        this(access_type, 2);
    }

    protected SdfAttribute(int access_type, int occurs_type) {
        this.setAccessType(access_type);
        this.setOccurrenceType(occurs_type);
    }

    protected final int getType() {
        if (this.occurrenceType == 2) {
            return 3;
        }
        if (this.occurrenceType == 1) {
            if (this.accessType == 3) {
                return 2;
            }
            return 1;
        }
        return -1;
    }

    protected final int getAccessType() {
        return this.accessType;
    }

    protected final int getOccurrenceType() {
        return this.occurrenceType;
    }

    protected final boolean isMutable() {
        return this.accessType == 3;
    }

    protected final boolean isSingle() {
        return this.occurrenceType == 1;
    }

    protected final boolean hasQuery() {
        return this.query != null;
    }

    protected final void setQuery(String query) {
        this.queryObject = null;
        this.query = query;
    }

    protected final void setQueryContext(short query_context) {
        this.queryContext = query_context;
    }

    protected final void setOccurrenceType(int occurrence_type) {
        if (occurrence_type != this.occurrenceType) {
            this.occurrenceType = occurrence_type;
            this.map = new Long(0L);
        }
    }

    protected final void setAccessType(int access_type) {
        this.accessType = access_type;
    }

    protected final long getValue() {
        Long map_value = this.map;
        if (map_value == null) {
            return -1L;
        }
        return map_value.longValue();
    }

    protected final long getValue(int[] key) {
        if (this.occurrenceType == -1) {
            return -1L;
        }
        Long mapValue = this.map;
        if (mapValue == null) {
            return -1L;
        }
        return mapValue.longValue();
    }

    protected void setValue(int[] key, long value) {
        if (this.occurrenceType == -1) {
            logger.error("SdfAttribute.setValue() ERROR: Value type is unknown => value not updated.");
            return;
        }
        this.map = new Long(value);
    }

    protected void setValue(long value) {
        if (this.occurrenceType != 1) {
            logger.error("SdfAttribute.setValue() ERROR: Value type is invalid => value not updated.");
            return;
        }
        this.map = new Long(value);
    }

    protected final void clear() {
        if (this.accessType == 3) {
            this.map = null;
        }
    }

    public String toString() {
        String tmpStr;
        switch (this.accessType) {
            case 1: {
                tmpStr = "access=READ_ONLY";
                break;
            }
            case 3: {
                tmpStr = "access=READ_WRITE";
                break;
            }
            default: {
                tmpStr = "access=INVALID";
            }
        }
        switch (this.occurrenceType) {
            case 1: {
                tmpStr = tmpStr + " occurs=SINGLE " + this.map;
                break;
            }
            case 2: {
                tmpStr = tmpStr + " occurs=MULTIPLE " + this.map;
                break;
            }
            default: {
                tmpStr = tmpStr + " occurs=INVALID";
            }
        }
        return "{" + tmpStr + "}";
    }
}

