/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.xml;

import fr.gael.drb.DrbAbstractNode;
import fr.gael.drb.DrbAttributeList;
import fr.gael.drb.DrbDefaultNodeList;
import fr.gael.drb.DrbDefaultSequence;
import fr.gael.drb.DrbFactory;
import fr.gael.drb.DrbItem;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbNodeList;
import fr.gael.drb.DrbNodesChangeEvent;
import fr.gael.drb.DrbSequence;
import fr.gael.drb.impl.DrbNodeImpl;
import fr.gael.drb.impl.xml.SaxDocument;
import fr.gael.drb.impl.xml.SaxElementTag;
import fr.gael.drb.impl.xml.SaxHandler;
import fr.gael.drb.impl.xml.SaxInputStream;
import fr.gael.drb.impl.xml.XmlFactory;
import fr.gael.drb.impl.xml.XmlNode;
import fr.gael.drb.impl.xml.XmlWriter;
import fr.gael.drb.query.Query;
import fr.gael.drb.value.String;
import fr.gael.drb.value.Value;
import fr.gael.drb.xsd.Namespace;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class SaxNode
extends DrbNodeImpl {
    private static Logger logger = Logger.getLogger(SaxNode.class);
    private SaxDocument document;
    protected SaxNode parent;
    protected SaxElementTag tag;
    protected int depth;
    protected Value value;
    protected DrbAttributeList attributes;
    protected ArrayList children;
    protected Namespace namespace;
    protected boolean loaded = false;

    protected SaxNode(SaxDocument document) {
        this.document = document;
        this.depth = 0;
        this.tag = new SaxElementTag();
        this.tag.index = 0;
        this.parent = null;
        this.load();
    }

    protected SaxNode(SaxNode parent, int index) {
        this.document = parent.document;
        this.parent = parent;
        this.depth = parent.depth + 1;
        this.tag = parent.getTagAt(index);
        this.loaded = false;
    }

    protected SaxElementTag getTagAt(int index) {
        return (SaxElementTag)this.children.get(index);
    }

    protected int getTagCount() {
        if (this.loaded) {
            return this.children.size();
        }
        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SaxNode) {
            SaxNode sax_node = (SaxNode)obj;
            if (this.document != sax_node.document || this.depth != sax_node.depth) {
                return false;
            }
            SaxNode self_ancestor = this;
            SaxNode other_ancestor = sax_node;
            while (self_ancestor != other_ancestor) {
                if (self_ancestor.tag.index != other_ancestor.tag.index) {
                    return false;
                }
                self_ancestor = self_ancestor.parent;
                other_ancestor = other_ancestor.parent;
            }
            return true;
        }
        return false;
    }

    private boolean load() {
        if (this.loaded) {
            return true;
        }
        InputStream input_stream = (InputStream)this.document.getImpl(InputStream.class);
        if (input_stream == null) {
            return false;
        }
        SaxInputStream sax_stream = new SaxInputStream(input_stream, this);
        try {
            SAXParserFactory builder_factory = SAXParserFactory.newInstance();
            builder_factory.setNamespaceAware(true);
            SAXParser sax_parser = builder_factory.newSAXParser();
            InputSource source = new InputSource(sax_stream);
            java.lang.String system_identifier = this.document.getPath();
            if (system_identifier != null) {
                source.setSystemId(system_identifier);
            }
            SaxHandler handler = new SaxHandler(this, sax_stream);
            sax_parser.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            sax_parser.getXMLReader().setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            sax_parser.parse(source, (DefaultHandler)handler);
            input_stream.close();
            this.loaded = true;
        }
        catch (IOException e) {
            logger.error("fr.gael.drb.impl.xml.SaxNode(input_stream) : Warning : Document cannot be parsed.");
            logger.error("fr.gael.drb.impl.xml.SaxNode(input_stream) : Warning : " + e.getMessage());
            return false;
        }
        catch (ParserConfigurationException e) {
            logger.error("fr.gael.drb.impl.xml.SaxNode(input_stream) : Warning : Document cannot be parsed.");
            logger.error("fr.gael.drb.impl.xml.SaxNode(input_stream) : Warning : " + e.getMessage());
            return false;
        }
        catch (SAXException e) {
            logger.error("fr.gael.drb.impl.xml.SaxNode(input_stream) : Warning : Document cannot be parsed.");
            logger.error("fr.gael.drb.impl.xml.SaxNode(input_stream) : Warning : " + e.getMessage());
            return false;
        }
        return this.loaded;
    }

    @Override
    public java.lang.String getName() {
        return this.tag.name;
    }

    @Override
    public java.lang.String getNamespaceURI() {
        if ("".equals(this.tag.namespaceURI)) {
            return null;
        }
        return this.tag.namespaceURI;
    }

    @Override
    public Namespace getNamespaceBindings() {
        this.load();
        return this.namespace;
    }

    @Override
    public int getIndex() {
        return this.tag.index;
    }

    @Override
    public int getValueType() {
        return 7;
    }

    @Override
    public Value getValue() {
        if (!this.loaded) {
            this.load();
        }
        return this.value;
    }

    @Override
    public DrbAttributeList getAttributes() {
        if (!this.loaded) {
            this.load();
        }
        return this.attributes;
    }

    @Override
    public DrbNode getParent() {
        if (this.parent == null) {
            return this.document;
        }
        return this.parent;
    }

    @Override
    public DrbNode getChildAt(int index) {
        if (index < 0 || index >= this.getChildrenCount()) {
            return null;
        }
        this.load();
        SaxNode child = this.getTagAt(index).getNodeReference();
        if (child == null) {
            child = new SaxNode(this, index);
            this.getTagAt(index).setNodeReference(child);
        }
        return child;
    }

    @Override
    public int getChildrenCount() {
        return this.tag.childrenCount;
    }

    @Override
    public DrbNodeList getChildren() {
        if (this.tag.childrenCount == 0) {
            return null;
        }
        this.load();
        DrbDefaultNodeList children = new DrbDefaultNodeList();
        for (int i = 0; i < this.tag.childrenCount; ++i) {
            children.add(this.getChildAt(i));
        }
        return children;
    }

    @Override
    public DrbNode getNamedChild(java.lang.String name, int occurrence) {
        if (name == null || occurrence <= 0) {
            logger.error("SaxNode.getNamedChild(): Invalid parameter (name=\"" + name + "\", occurrence=" + occurrence);
            return null;
        }
        if (occurrence > this.tag.childrenCount) {
            return null;
        }
        this.load();
        int current_occurence = 0;
        for (int itag = 0; itag < this.tag.childrenCount; ++itag) {
            SaxElementTag current_tag = this.getTagAt(itag);
            if (name.equals(current_tag.name)) {
                ++current_occurence;
            }
            if (current_occurence != occurrence) continue;
            return this.getChildAt(itag);
        }
        return null;
    }

    @Override
    public java.lang.String toString() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        XmlFactory.writeXML(this, stream);
        return stream.toString();
    }

    private boolean move(long src_offset, long len, long dst_offset) {
        try {
            RandomAccessFile file = (RandomAccessFile)this.document.getImpl(RandomAccessFile.class);
            byte[] buf = new byte[1024];
            boolean off = false;
            if (len == -1L) {
                len = file.length() - src_offset;
            }
            long old_file_len = file.length();
            long file_len = old_file_len + dst_offset - src_offset;
            if (src_offset < dst_offset) {
                src_offset += len;
                dst_offset += len;
                while (len > 0L) {
                    if (len >= 1024L) {
                        len -= 1024L;
                        file.seek(src_offset -= 1024L);
                        file.readFully(buf, 0, 1024);
                        file.seek(dst_offset -= 1024L);
                        file.write(buf, 0, 1024);
                        continue;
                    }
                    logger.debug("Moving " + len + " bytes from " + src_offset + " to " + dst_offset);
                    file.seek(src_offset -= len);
                    file.readFully(buf, 0, (int)len);
                    file.seek(dst_offset -= len);
                    file.write(buf, 0, (int)len);
                    len = 0L;
                }
                logger.debug("File resized from " + old_file_len + " to " + file.length());
            } else {
                while (len > 0L) {
                    file.seek(src_offset);
                    if (len >= 1024L) {
                        file.readFully(buf, 0, 1024);
                        len -= 1024L;
                        file.seek(dst_offset);
                        file.write(buf, 0, 1024);
                        src_offset += 1024L;
                        dst_offset += 1024L;
                        continue;
                    }
                    file.readFully(buf, 0, (int)len);
                    file.seek(dst_offset);
                    file.write(buf, 0, (int)len);
                    len = 0L;
                }
                file.setLength(file_len);
            }
            file.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public Value setValue(Value value) throws NullPointerException, ClassCastException, UnsupportedOperationException {
        DrbDefaultSequence content = new DrbDefaultSequence(this.getChildren());
        if (value != null) {
            content.addItem(0, value);
        }
        long old_end_offset = this.tag.endOffset;
        this.tag.endOffset = this.writeNode(this.tag.startOffset, this.tag.endOffset, this.getName(), this.getNamespaceURI(), this.getNamespaceBindings(), this.getAttributes(), content);
        this.loaded = false;
        if (old_end_offset != this.tag.endOffset) {
            this.structureChanged(new DrbNodesChangeEvent(this.document.getFirstChild()));
        } else if (this.tag.childrenCount == 0) {
            this.nodesChanged(new DrbNodesChangeEvent(this));
        } else {
            this.structureChanged(new DrbNodesChangeEvent(this));
        }
        if (value == null) {
            return null;
        }
        return value.convertTo(7);
    }

    @Override
    public void setAttributes(DrbAttributeList attributes) throws NullPointerException, UnsupportedOperationException {
        this.load();
        this.tag.endOffset = this.writeNode(this.tag.startOffset, this.tag.endOffset, this.getName(), this.getNamespaceURI(), this.getNamespaceBindings(), attributes, this.getContent());
        this.loaded = false;
        this.structureChanged(new DrbNodesChangeEvent(this));
    }

    @Override
    public void rename(java.lang.String name) throws NullPointerException, UnsupportedOperationException {
        if (name == null) {
            throw new NullPointerException("SaxNode.rename() : The reference to the new name is null.");
        }
        this.load();
        long old_end_offset = this.tag.endOffset;
        this.tag.endOffset = this.writeNode(this.tag.startOffset, this.tag.endOffset, name, this.getNamespaceURI(), this.getNamespaceBindings(), this.getAttributes(), this.getContent());
        this.tag.name = name;
        this.loaded = false;
        if (old_end_offset != this.tag.endOffset) {
            this.structureChanged(new DrbNodesChangeEvent(this.document.getFirstChild()));
        } else if (this.tag.childrenCount == 0) {
            this.nodesChanged(new DrbNodesChangeEvent(this));
        } else {
            this.structureChanged(new DrbNodesChangeEvent(this));
        }
    }

    @Override
    public DrbNode replaceChild(int index, DrbNode new_node) throws NullPointerException, IndexOutOfBoundsException, UnsupportedOperationException {
        if (new_node == null) {
            throw new NullPointerException("XmlNode.replaceChild() : Reference to the node is null.");
        }
        logger.debug("replaceChild at index " + index + " node=" + new_node.getName());
        if (index < 0 || index >= this.getChildrenCount()) {
            throw new IndexOutOfBoundsException("XmlNode.replaceChild() : Index #" + index);
        }
        this.load();
        SaxElementTag replace_tag = this.getTagAt(index);
        replace_tag.childrenCount = new_node.getChildrenCount();
        replace_tag.name = new_node.getName();
        replace_tag.namespaceURI = new_node.getNamespaceURI();
        replace_tag.setNodeReference(null);
        long new_end_offset = this.writeNode(replace_tag.startOffset, replace_tag.endOffset, replace_tag.name, replace_tag.namespaceURI, ((DrbAbstractNode)new_node).getNamespaceBindings(), new_node.getAttributes(), ((DrbAbstractNode)new_node).getContent());
        long diff_offset = new_end_offset - replace_tag.endOffset;
        replace_tag.endOffset = new_end_offset;
        if (diff_offset != 0L) {
            SaxNode ancestor = this;
            int descendant_index = index;
            while (ancestor != null) {
                ancestor.tag.startCloseOffset += diff_offset;
                ancestor.tag.endOffset += diff_offset;
                for (int i = descendant_index + 1; i < ancestor.tag.childrenCount; ++i) {
                    SaxElementTag descendant_tag = ancestor.getTagAt(i);
                    descendant_tag.moveTo(descendant_tag.startOffset + diff_offset);
                }
                descendant_index = ancestor.tag.index;
                ancestor = ancestor.parent;
            }
        }
        this.nodesRemoved(new DrbNodesChangeEvent(this));
        return this.getChildAt(index);
    }

    @Override
    public void removeChild(int index) throws IndexOutOfBoundsException, UnsupportedOperationException {
        int children_count = this.getChildrenCount();
        if (index < 0 || index >= children_count) {
            throw new IndexOutOfBoundsException("SaxNode.removeChild(" + index + ") : Index #" + index + " out of bound (children count =" + children_count + ")");
        }
        this.load();
        SaxElementTag removed_tag = this.getTagAt(index);
        long start_offset = removed_tag.startOffset;
        long stop_offset = removed_tag.endOffset;
        this.move(stop_offset, -1L, start_offset);
        removed_tag.setNodeReference(null);
        this.children.remove(index);
        --this.tag.childrenCount;
        for (int ichild = index; ichild < this.tag.childrenCount; ++ichild) {
            SaxElementTag child_tag = this.getTagAt(ichild);
            --child_tag.index;
        }
        long removed_len = stop_offset - start_offset;
        if (removed_len != 0L) {
            SaxNode ancestor = this;
            int descendant_index = index - 1;
            while (ancestor != null) {
                ancestor.tag.startCloseOffset -= removed_len;
                ancestor.tag.endOffset -= removed_len;
                for (int i = descendant_index + 1; i < ancestor.tag.childrenCount; ++i) {
                    SaxElementTag descendant_tag = ancestor.getTagAt(i);
                    descendant_tag.moveTo(descendant_tag.startOffset - removed_len);
                }
                descendant_index = ancestor.tag.index;
                ancestor = ancestor.parent;
            }
        }
        this.nodesRemoved(new DrbNodesChangeEvent(this));
    }

    @Override
    public DrbNode insertChild(DrbNode new_node, int index) throws NullPointerException, UnsupportedOperationException, IndexOutOfBoundsException {
        int children_count = this.getChildrenCount();
        if (new_node == null || index < 0 || index > children_count) {
            throw new IndexOutOfBoundsException("SaxNode.insertChild() : Index #" + index);
        }
        this.load();
        long inserted_len = 0L;
        if (children_count == 0) {
            DrbDefaultSequence content = new DrbDefaultSequence(new_node);
            long new_end_offset = this.writeNode(this.tag.startOffset, this.tag.endOffset, this.getName(), this.getNamespaceURI(), this.getNamespaceBindings(), this.getAttributes(), content);
            this.loaded = false;
            inserted_len = new_end_offset - this.tag.endOffset;
        } else {
            long child_start_offset = index < children_count ? this.getTagAt((int)index).startOffset : this.tag.startCloseOffset;
            long child_end_offset = this.writeNode(child_start_offset, child_start_offset, new_node.getName(), new_node.getNamespaceURI(), ((DrbAbstractNode)new_node).getNamespaceBindings(), new_node.getAttributes(), ((DrbAbstractNode)new_node).getContent());
            inserted_len = child_end_offset - child_start_offset;
            SaxElementTag inserted_tag = new SaxElementTag();
            inserted_tag.index = index;
            inserted_tag.name = new_node.getName();
            inserted_tag.namespaceURI = new_node.getNamespaceURI();
            inserted_tag.startOffset = child_start_offset;
            inserted_tag.endOffset = child_end_offset;
            inserted_tag.childrenCount = new_node.getChildrenCount();
            this.children.add(index, inserted_tag);
            for (int ichild = index + 1; ichild <= children_count; ++ichild) {
                ++this.getTagAt((int)ichild).index;
            }
        }
        ++this.tag.childrenCount;
        if (inserted_len != 0L) {
            SaxNode ancestor = this;
            int descendant_index = index;
            while (ancestor != null) {
                ancestor.tag.startCloseOffset += inserted_len;
                ancestor.tag.endOffset += inserted_len;
                for (int i = descendant_index + 1; i < ancestor.tag.childrenCount; ++i) {
                    SaxElementTag descendant_tag = ancestor.getTagAt(i);
                    descendant_tag.moveTo(descendant_tag.startOffset + inserted_len);
                }
                descendant_index = ancestor.tag.index;
                ancestor = ancestor.parent;
            }
        }
        DrbNode child = this.getChildAt(index);
        this.nodesInserted(new DrbNodesChangeEvent(this));
        return child;
    }

    @Override
    public DrbNode appendChild(DrbNode node) throws NullPointerException, UnsupportedOperationException {
        int child_count = this.getChildrenCount();
        return this.insertChild(node, child_count);
    }

    private long writeNode(long start_offset, long end_offset, java.lang.String qname, java.lang.String namespace_uri, Namespace ns_bindings, DrbAttributeList attributes, DrbSequence content) {
        logger.debug("Write node start=" + start_offset + ", end=" + end_offset);
        try {
            long inserted_len = 0L;
            java.lang.String header = "";
            java.lang.String footer = "";
            java.lang.String prefix = null;
            if (ns_bindings == null) {
                ns_bindings = new Namespace();
                ns_bindings.bind("xml", "http://www.w3.org/XML/1998/namespace");
                ns_bindings.bind("xmlns", "http://www.w3.org/2000/xmlns/");
            }
            if ((prefix = ns_bindings.resolvePrefix(namespace_uri)) != null && !"".equals(prefix)) {
                qname = prefix + ":" + qname;
            } else {
                prefix = null;
            }
            header = "<" + qname;
            if (attributes != null) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    java.lang.String attr_name = attributes.item(i).getName();
                    java.lang.String attr_uri = attributes.item(i).getNamespaceURI();
                    if (attr_uri != null && attr_uri.length() > 0) {
                        java.lang.String attr_prefix = ns_bindings.resolvePrefix(attr_uri);
                        if ("http://www.w3.org/XML/1998/namespace".equals(attr_uri)) {
                            attr_prefix = "xml";
                        }
                        if (attr_prefix == null || attr_prefix.length() == 0) {
                            attr_prefix = ns_bindings.createPrefix("ns", attr_uri);
                        }
                        attr_name = attr_prefix + ":" + attr_name;
                    }
                    Value attr_value = attributes.item(i).getValue();
                    header = header + " " + attr_name + "=\"";
                    if (attr_value != null) {
                        header = header + attr_value.toString();
                    }
                    header = header + "\"";
                }
            }
            if (ns_bindings != null) {
                java.lang.String[] prefixes = ns_bindings.getDeclaredPrefixes();
                for (int i = 0; i < prefixes.length; ++i) {
                    java.lang.String ns_uri = ns_bindings.resolveNamespace(prefixes[i]);
                    if (ns_uri == null) {
                        ns_uri = "";
                    }
                    ns_uri = XmlNode.toXML(ns_uri);
                    if ("".equals(prefixes[i]) || "xml".equalsIgnoreCase(prefixes[i]) || "xmlns".equalsIgnoreCase(prefixes[i]) || "http://www.w3.org/XML/1998/namespace".equals(ns_uri) || "http://www.w3.org/2000/xmlns/".equals(ns_uri)) continue;
                    header = header + " xmlns:" + prefixes[i] + "=\"" + ns_uri + "\"";
                }
            }
            if (prefix == null && namespace_uri != null) {
                header = header + " xmlns=\"" + XmlNode.toXML(namespace_uri) + "\"";
            }
            header = header + ">";
            footer = "</" + qname + ">";
            File tmp_file = File.createTempFile("drb", "xml");
            tmp_file.deleteOnExit();
            FileWriter tmp_output = new FileWriter(tmp_file);
            tmp_output.write(header);
            if (content != null) {
                java.lang.String default_ns_uri = null;
                if (ns_bindings != null) {
                    default_ns_uri = ns_bindings.getDefaultNamespaceURI();
                }
                XmlWriter.Context context = new XmlWriter.Context(ns_bindings, default_ns_uri);
                XmlWriter xml_writer = new XmlWriter(tmp_output, "UTF-8");
                for (int i = 0; i < content.getLength(); ++i) {
                    DrbItem item = content.getItem(i);
                    if (item.getItemType() == 1) {
                        xml_writer.save((DrbNode)item, context, false);
                        continue;
                    }
                    if (item.getValue() == null) continue;
                    tmp_output.write(XmlNode.toXML(item.getValue().toString()));
                }
            }
            tmp_output.write(footer);
            tmp_output.close();
            inserted_len = tmp_file.length();
            logger.debug("Write node start=" + start_offset + ", end=" + end_offset + " inserted_len=" + inserted_len);
            this.move(end_offset, -1L, start_offset + inserted_len);
            RandomAccessFile file = (RandomAccessFile)this.document.getImpl(RandomAccessFile.class);
            FileInputStream tmp_stream = new FileInputStream(tmp_file);
            byte[] buf = new byte[1024];
            file.seek(start_offset);
            while (tmp_stream.available() > 0) {
                int len = tmp_stream.read(buf);
                file.write(buf, 0, len);
            }
            file.close();
            tmp_stream.close();
            tmp_file.delete();
            return start_offset + inserted_len;
        }
        catch (IOException e) {
            throw new UnsupportedOperationException(e.getMessage());
        }
    }

    public static void main(java.lang.String[] args) {
        DrbNode context_node = DrbFactory.open(".");
        DrbNode input = (DrbNode)new Query(args[0]).evaluate(context_node).getItem(0);
        DrbNode xml = new SaxDocument(input).getNamedChild("root", 1);
        xml.setValue(new String("toto"));
    }
}

