/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.query;

import fr.gael.drb.DrbSequence;
import fr.gael.drb.query.DynamicContext;
import fr.gael.drb.query.Function;
import fr.gael.drb.query.FunctionBody;
import fr.gael.drb.query.FunctionSignature;
import fr.gael.drb.query.QName;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

class BuiltInFunction
extends Function {
    private static Logger logger = Logger.getLogger(BuiltInFunction.class);
    private static Map<QName, Function> builtInFunctions = new HashMap<QName, Function>();
    private FunctionBody body;

    protected BuiltInFunction(FunctionSignature signature, FunctionBody body) {
        super(signature);
        if (body == null) {
            throw new NullPointerException("The function body cannot be null");
        }
        this.body = body;
    }

    @Override
    public DrbSequence evaluate(DynamicContext context, List<DrbSequence> values) {
        return this.body.evaluate(context, this.getSignature().convert(values));
    }

    static Function getBuiltInFunction(QName name, int arity) {
        Function function = builtInFunctions.get(name);
        if (function != null && function.getSignature().matches(name, arity)) {
            return function;
        }
        return null;
    }
}

