/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.query;

import fr.gael.drb.DrbDefaultSequence;
import fr.gael.drb.DrbSequence;
import fr.gael.drb.query.AbstractExpression;
import fr.gael.drb.query.DefaultVariable;
import fr.gael.drb.query.DynamicContext;
import fr.gael.drb.query.DynamicException;
import fr.gael.drb.query.DynamicVariable;
import fr.gael.drb.query.Expression;
import fr.gael.drb.query.QName;
import fr.gael.drb.query.Query;
import fr.gael.drb.query.StaticException;
import fr.gael.drb.query.Token;
import fr.gael.drb.value.Int;
import java.util.HashMap;
import java.util.Vector;
import org.apache.log4j.Logger;

class FLWORExpression
extends AbstractExpression {
    Logger logger = Logger.getLogger(FLWORExpression.class);
    private HashMap<QName, DynamicVariable> letBindings = new HashMap();
    private Vector<QName> letKeys = new Vector();
    private HashMap<QName, DynamicVariable> forBindings = new HashMap();
    private HashMap<QName, DefaultVariable> forPositionalVariable = new HashMap();
    private Vector<QName> forKeys = new Vector();
    private Expression whereExpression = null;
    private Expression returnExpression = null;
    private FLWORExpression nestedFLWORExpression = null;

    FLWORExpression(Token token) {
        super("FLWOR", token);
    }

    public void addForBinding(DynamicVariable variable, DefaultVariable positional_variable) {
        if (variable == null) {
            throw new NullPointerException("Cannot assign null variable to \"for\" clause");
        }
        if (this.nestedFLWORExpression == null) {
            if (variable.getExpression().isUpdating()) {
                throw new StaticException("XUST0001 - The for binding of a FLWOR expression must not contain an updating expression.", this.getToken());
            }
            this.forBindings.put(variable.getQName(), variable);
            if (positional_variable != null) {
                this.forPositionalVariable.put(variable.getQName(), positional_variable);
            }
            this.forKeys.add(variable.getQName());
        } else {
            this.nestedFLWORExpression.addForBinding(variable, positional_variable);
        }
    }

    public void addLetBinding(DynamicVariable variable) {
        if (variable == null) {
            throw new NullPointerException("Cannot assign null variable to \"let\" clause");
        }
        if (variable.getExpression() == null) {
            throw new NullPointerException("Cannot assign variable with null expression to \"let\" clause");
        }
        if (variable.getExpression().isUpdating()) {
            throw new StaticException("XUST0001 - The let binding of a FLWOR expression must not contain an updating expression.", this.getToken());
        }
        if (this.nestedFLWORExpression == null && this.forBindings.size() > 0) {
            this.nestedFLWORExpression = new FLWORExpression(this.getToken());
            this.nestedFLWORExpression.setReturnExpression(this.returnExpression);
            this.returnExpression = null;
            this.nestedFLWORExpression.setWhereExpression(this.whereExpression);
            this.whereExpression = null;
        }
        if (this.nestedFLWORExpression == null) {
            this.letBindings.put(variable.getQName(), variable);
            this.letKeys.add(variable.getQName());
        } else {
            this.nestedFLWORExpression.addLetBinding(variable);
        }
    }

    public void setReturnExpression(Expression return_expression) {
        if (this.nestedFLWORExpression == null) {
            this.returnExpression = return_expression;
        } else {
            this.nestedFLWORExpression.setReturnExpression(return_expression);
        }
    }

    public void setWhereExpression(Expression where_expression) {
        if (this.nestedFLWORExpression == null) {
            this.whereExpression = where_expression;
        } else {
            this.nestedFLWORExpression.setWhereExpression(where_expression);
        }
    }

    @Override
    public DrbSequence evaluate(DynamicContext outer_context) {
        DynamicContext context = new DynamicContext(outer_context);
        for (int ibind = 0; ibind < this.letKeys.size(); ++ibind) {
            if (this.isCancellationRequested()) {
                this.throwCancelException();
            }
            DynamicVariable variable = this.letBindings.get(this.letKeys.get(ibind));
            variable.initialize(context);
            context.addInScopeVariable(variable);
        }
        Vector<DrbSequence> forSequenceList = new Vector<DrbSequence>();
        for (int ibind = 0; ibind < this.forKeys.size(); ++ibind) {
            if (this.isCancellationRequested()) {
                this.throwCancelException();
            }
            DynamicVariable variable = this.forBindings.get(this.forKeys.get(ibind));
            variable.initialize(context);
            DrbSequence forSequence = variable.getValue();
            if (forSequence == null) {
                throw new DynamicException(this, "Error while evaluating the \"for\" clause binding " + variable);
            }
            if (forSequence.getLength() <= 0) {
                return new DrbDefaultSequence();
            }
            forSequenceList.add(forSequence);
        }
        int forSequenceSize = forSequenceList.size();
        int[] indices = new int[forSequenceSize];
        int[] lengths = new int[forSequenceSize];
        int context_size = 0;
        for (int index = 0; index < forSequenceSize; ++index) {
            indices[index] = 0;
            lengths[index] = ((DrbSequence)forSequenceList.get(index)).getLength();
            if (lengths[index] == 0) continue;
            if (context_size == 0) {
                context_size = lengths[index];
                continue;
            }
            context_size *= lengths[index];
        }
        DrbSequence output_sequence = null;
        context.focus.setContextSize(context_size);
        for (int position = 0; position < context_size; ++position) {
            context.focus.setContextPosition(position + 1);
            if (this.isCancellationRequested()) {
                this.throwCancelException();
            }
            if (position != 0) {
                int isequence;
                for (isequence = forSequenceSize - 1; isequence >= 0; --isequence) {
                    int n = isequence;
                    indices[n] = indices[n] + 1;
                    if (indices[isequence] < lengths[isequence]) break;
                    indices[isequence] = 0;
                }
                if (isequence == 0 && indices[0] == 0) break;
            }
            for (int ibind = 0; ibind < this.forKeys.size(); ++ibind) {
                DrbSequence sequence = (DrbSequence)forSequenceList.get(ibind);
                DynamicVariable variable = this.forBindings.get(this.forKeys.get(ibind));
                if (sequence.getLength() >= 1) {
                    variable.setValue(sequence.getItem(indices[ibind]));
                } else {
                    variable.setValue(sequence);
                }
                context.addInScopeVariable(variable);
                DefaultVariable positionalVariable = this.forPositionalVariable.get(this.forKeys.get(ibind));
                if (positionalVariable == null) continue;
                positionalVariable.setValue(new Int(indices[ibind] + 1));
                context.addInScopeVariable(positionalVariable);
            }
            DrbSequence returnSequence = this.processReturnClause(context);
            if (returnSequence == null) continue;
            if (output_sequence == null) {
                output_sequence = new DrbDefaultSequence(returnSequence);
                continue;
            }
            if (!(output_sequence instanceof DrbDefaultSequence)) {
                output_sequence = new DrbDefaultSequence(output_sequence);
            }
            for (int item = 0; item < returnSequence.getLength(); ++item) {
                ((DrbDefaultSequence)output_sequence).add(returnSequence.getItem(item));
            }
        }
        if (this.letBindings.size() > 0 && context_size <= 0) {
            output_sequence = this.processReturnClause(context);
        }
        if (output_sequence == null) {
            return new DrbDefaultSequence();
        }
        return output_sequence;
    }

    private DrbSequence processReturnClause(DynamicContext context) {
        DrbSequence returnSequence = null;
        if (this.nestedFLWORExpression == null) {
            if (this.whereExpression != null) {
                DrbSequence whereSequence = this.whereExpression.evaluate(context);
                if (whereSequence == null) {
                    throw new DynamicException(this, "Error while evaluating the \"where\" clause at position " + context.focus.getContextPosition());
                }
                if (!Query.getEffectiveBooleanValue(whereSequence)) {
                    return null;
                }
            }
            returnSequence = this.returnExpression.evaluate(context);
        } else {
            returnSequence = this.nestedFLWORExpression.evaluate(context);
        }
        if (returnSequence == null) {
            throw new DynamicException(this, "Error while evaluating the \"return\" clause at position " + context.focus.getContextPosition());
        }
        return returnSequence;
    }

    @Override
    public void cancel(String reason) {
        super.cancel(reason);
        this.whereExpression.cancel(reason);
        this.returnExpression.cancel(reason);
    }

    public String toString() {
        String output = "";
        if (this.letBindings.size() > 0) {
            output = output + "let (bindings...)\n";
        }
        if (this.forBindings.size() > 0) {
            output = output + "for (bidings)\n";
        }
        if (this.whereExpression != null) {
            output = output + "where " + this.whereExpression + "\n";
        }
        output = output + "return " + this.returnExpression + "\n";
        return output;
    }

    @Override
    public boolean isUpdating() {
        double key = Math.random();
        this.logger.debug("FLOWR.isUpdating() : Start " + key);
        boolean bool = this.returnExpression != null && this.returnExpression.isUpdating() || this.nestedFLWORExpression != null && this.nestedFLWORExpression.isUpdating();
        this.logger.debug("FLOWR.isUpdating() : Stop " + key);
        return bool;
    }
}

