/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.query;

import fr.gael.drb.DrbDefaultNodeList;
import fr.gael.drb.DrbItem;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbSequence;
import fr.gael.drb.query.AbstractExpression;
import fr.gael.drb.query.DynamicContext;
import fr.gael.drb.query.Expression;
import fr.gael.drb.query.Token;
import fr.gael.drb.query.TypeException;

class SequenceCombinationExpression
extends AbstractExpression {
    protected static int UNION = 0;
    protected static int INTERSECT = 1;
    protected static int EXCEPT = 2;
    protected Expression leftOperand;
    protected Expression rightOperand;
    protected int combination;

    public SequenceCombinationExpression(Token token, Expression left_operand, int combination, Expression right_operand) {
        super("Sequence combination", token);
        this.leftOperand = left_operand;
        this.combination = combination;
        this.rightOperand = right_operand;
    }

    public String toString() {
        String combination_string;
        switch (this.combination) {
            case 0: {
                combination_string = "union";
                break;
            }
            case 1: {
                combination_string = "intersect";
                break;
            }
            case 2: {
                combination_string = "except";
                break;
            }
            default: {
                combination_string = "(unkown combination #" + this.combination + ")";
            }
        }
        return this.leftOperand + " " + combination_string + " " + this.rightOperand;
    }

    @Override
    public DrbSequence evaluate(DynamicContext context) {
        DrbDefaultNodeList outputSequence;
        block17: {
            int iout;
            boolean already_insterted;
            DrbNode leftNode;
            DrbItem leftItem;
            int ileft;
            DrbSequence rightSequence;
            DrbSequence leftSequence;
            block16: {
                outputSequence = new DrbDefaultNodeList();
                leftSequence = this.leftOperand.evaluate(context);
                rightSequence = this.rightOperand.evaluate(context);
                if (this.combination == UNION) {
                    for (ileft = 0; ileft < leftSequence.getLength(); ++ileft) {
                        leftItem = leftSequence.getItem(ileft);
                        if (leftItem.getItemType() != 1) {
                            throw new TypeException(this, "The item #" + (ileft + 1) + " of the left operand is not a node.");
                        }
                        leftNode = (DrbNode)leftItem;
                        already_insterted = false;
                        for (iout = 0; iout < outputSequence.getLength(); ++iout) {
                            if (!leftNode.equals(outputSequence.item(iout))) continue;
                            already_insterted = true;
                            break;
                        }
                        if (already_insterted) continue;
                        outputSequence.addItem(leftNode);
                    }
                    for (int iright = 0; iright < rightSequence.getLength(); ++iright) {
                        DrbItem rightItem = rightSequence.getItem(iright);
                        if (rightItem.getItemType() != 1) {
                            throw new TypeException(this, "The item #" + (iright + 1) + " of the right operand is not a node.");
                        }
                        DrbNode rightNode = (DrbNode)rightItem;
                        already_insterted = false;
                        for (iout = 0; iout < outputSequence.getLength(); ++iout) {
                            if (!rightNode.equals(outputSequence.item(iout))) continue;
                            already_insterted = true;
                            break;
                        }
                        if (already_insterted) continue;
                        outputSequence.addItem(rightNode);
                    }
                }
                if (this.combination == INTERSECT) break block16;
                if (this.combination != EXCEPT) break block17;
            }
            for (ileft = 0; ileft < leftSequence.getLength(); ++ileft) {
                leftItem = leftSequence.getItem(ileft);
                if (leftItem.getItemType() != 1) {
                    throw new TypeException(this, "The item #" + (ileft + 1) + " of the left operand is not a node.");
                }
                leftNode = (DrbNode)leftItem;
                already_insterted = false;
                for (iout = 0; iout < outputSequence.getLength(); ++iout) {
                    if (!leftNode.equals(outputSequence.item(iout))) continue;
                    already_insterted = true;
                    break;
                }
                boolean exists_in_righ_operand = false;
                for (int iright = 0; iright < rightSequence.getLength(); ++iright) {
                    DrbItem rightItem = rightSequence.getItem(iright);
                    if (rightItem.getItemType() != 1) {
                        throw new TypeException(this, "The item #" + (iright + 1) + " of the right operand is not a node.");
                    }
                    DrbNode rightNode = (DrbNode)rightItem;
                    if (!leftNode.equals(rightNode)) continue;
                    exists_in_righ_operand = true;
                    break;
                }
                if (already_insterted) continue;
                if (this.combination != INTERSECT || !exists_in_righ_operand) {
                    if (this.combination != EXCEPT || exists_in_righ_operand) continue;
                }
                outputSequence.addItem(leftNode);
            }
        }
        return outputSequence;
    }

    @Override
    public boolean isUpdating() {
        return this.leftOperand.isUpdating() || this.rightOperand.isUpdating();
    }
}

