/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.query;

import fr.gael.drb.DrbSequence;
import fr.gael.drb.query.AbstractExpression;
import fr.gael.drb.query.DynamicContext;
import fr.gael.drb.query.Expression;
import fr.gael.drb.query.SequenceResult;
import fr.gael.drb.query.Token;
import java.util.Iterator;
import java.util.Vector;

class SequenceExpression
extends AbstractExpression {
    private Vector<Expression> expression = new Vector();

    public SequenceExpression(Token token) {
        super("Sequence", token);
    }

    public SequenceExpression(Token token, Expression expression) {
        this(token);
        this.addExpression(expression);
    }

    public void addExpression(Expression expression) {
        this.expression.add(expression);
    }

    @Override
    public DrbSequence evaluate(DynamicContext context) {
        SequenceResult sequence = new SequenceResult();
        for (int iexpr = 0; iexpr < this.expression.size(); ++iexpr) {
            if (this.isCancellationRequested()) {
                this.throwCancelException();
            }
            DrbSequence expressionSequence = this.expression.get(iexpr).evaluate(context);
            sequence.append(expressionSequence);
        }
        return sequence;
    }

    @Override
    public void cancel(String reason) {
        super.cancel(reason);
        for (int iexpr = 0; iexpr < this.expression.size(); ++iexpr) {
            this.expression.get(iexpr).cancel(reason);
        }
    }

    public String toString() {
        String s = "(";
        Iterator it = this.iterator();
        while (it.hasNext()) {
            s = s + it.next().toString();
            if (!it.hasNext()) continue;
            s = s + ", ";
        }
        s = s + ")";
        return s;
    }

    @Override
    public boolean isConstant() {
        boolean bool = true;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            bool = bool && ((Expression)it.next()).isConstant();
        }
        return bool;
    }

    @Override
    public boolean isUpdating() {
        boolean bool = false;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            bool = bool || ((Expression)it.next()).isUpdating();
        }
        return bool;
    }

    public Iterator iterator() {
        return new SequenceExpressionIterator();
    }

    public class SequenceExpressionIterator
    implements Iterator {
        private Iterator iterator;

        public SequenceExpressionIterator() {
            this.iterator = SequenceExpression.this.expression.iterator();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Removing an expression from a sequenceExpression is not supported");
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            return this.iterator.next();
        }
    }
}

