/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.query;

import fr.gael.drb.query.Environment;
import fr.gael.drb.query.Function;
import fr.gael.drb.query.QName;
import fr.gael.drb.query.Variable;
import fr.gael.drb.xsd.Namespace;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

class StaticContext
extends Environment {
    Logger logger = Logger.getLogger(StaticContext.class);
    private Map<QName, Variable> inScopeVariable = new HashMap<QName, Variable>();
    private Map<QName, Function> inScopeFunction = new HashMap<QName, Function>();

    StaticContext() {
        this(new Environment());
    }

    StaticContext(Environment env) {
        if (env == null) {
            env = new Environment();
        }
        this.setNamespace(env.getNamespace().cloneNamespace());
        this.setDefaultElementNamespaceURI(env.getDefaultElementNamespaceURI());
        this.setDefaultFunctionNamespaceURI(env.getDefaultFunctionNamespaceURI());
        this.setBaseURI(env.getBaseURI());
        this.setExternalVariableMap(env.getExternalVariableMap());
        this.resolver = env.resolver;
        if (env.isBackwardCompatibilityModeSet) {
            this.setBackwardCompatibilityMode(env.isBackwardCompatibilityMode());
        }
    }

    StaticContext(StaticContext context) {
        this((Environment)context);
        Set<QName> varnameSet = context.inScopeVariable.keySet();
        for (QName varName : varnameSet) {
            Variable variable = (Variable)context.inScopeVariable.get(varName).clone();
            this.inScopeVariable.put(varName, variable);
        }
        this.inScopeFunction.putAll(context.inScopeFunction);
    }

    public void addInScopeVariable(Variable variable) {
        this.inScopeVariable.put(variable.getQName(), variable);
    }

    public boolean containsInScopeVariable(String name) {
        Namespace namespaces = this.getNamespace();
        String localName = Namespace.toLocal(name);
        String prefix = Namespace.toPrefix(name);
        String namespace = null;
        namespace = prefix == null ? this.getDefaultElementNamespaceURI() : namespaces.resolveNamespace(prefix);
        return this.containsInScopeVariable(new QName(localName, namespace));
    }

    public boolean containsInScopeVariable(QName name) {
        return this.inScopeVariable.containsKey(name);
    }

    public Variable getInScopeVariable(String name) {
        Namespace namespaces = this.getNamespace();
        String prefix = Namespace.toPrefix(name);
        String namespace = null;
        if (prefix != null) {
            namespace = namespaces.resolveNamespace(prefix);
        }
        return this.getInScopeVariable(new QName(name, namespace));
    }

    public Variable getInScopeVariable(QName name) {
        Variable variable = this.inScopeVariable.get(name);
        if (variable == null) {
            variable = this.getExternalVariable(name.toString());
        }
        return variable;
    }

    protected Collection<Variable> getInScopeVariables() {
        return this.inScopeVariable.values();
    }

    public void addInScopeFunction(Function function) {
        this.inScopeFunction.put(function.getQName(), function);
    }

    public boolean containsInScopeFunction(String name) {
        Namespace namespaces = this.getNamespace();
        String localName = Namespace.toLocal(name);
        String prefix = Namespace.toPrefix(name);
        String namespace = null;
        namespace = prefix == null ? this.getDefaultFunctionNamespaceURI() : namespaces.resolveNamespace(prefix);
        return this.containsInScopeFunction(new QName(localName, namespace));
    }

    public boolean containsInScopeFunction(QName name) {
        return this.inScopeFunction.containsKey(name);
    }

    public Function getInScopeFunction(String name) {
        Namespace namespaces = this.getNamespace();
        String localName = Namespace.toLocal(name);
        String prefix = Namespace.toPrefix(name);
        String namespace = null;
        namespace = prefix == null ? this.getDefaultFunctionNamespaceURI() : namespaces.resolveNamespace(prefix);
        return this.getInScopeFunction(new QName(localName, namespace), -1);
    }

    public Function getInScopeFunction(QName name) {
        return this.inScopeFunction.get(name);
    }

    public Function getInScopeFunction(QName name, int arity) {
        Function function = this.inScopeFunction.get(name);
        if (function == null || arity == function.getArity()) {
            return function;
        }
        return null;
    }

    protected Map<QName, Function> getInScopeFunctions() {
        return this.inScopeFunction;
    }
}

