/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.query;

import fr.gael.drb.query.ParseException;
import fr.gael.drb.query.Token;

public class StaticException
extends RuntimeException {
    private ParseException parseException = null;
    private Token token;

    protected StaticException(String message, Token token) {
        super(message);
        this.token = token;
    }

    protected StaticException(ParseException exception) {
        this.parseException = exception;
        this.token = exception.currentToken;
    }

    protected ParseException getParseException() {
        return this.parseException;
    }

    public int getBeginLine() {
        if (this.token != null) {
            return this.token.beginLine;
        }
        return -1;
    }

    public int getEndLine() {
        if (this.token != null) {
            return this.token.endLine;
        }
        return -1;
    }

    public int getBeginColumn() {
        if (this.token != null) {
            return this.token.beginColumn;
        }
        return -1;
    }

    public int getEndColumn() {
        if (this.token != null) {
            return this.token.endColumn;
        }
        return -1;
    }

    @Override
    public String getMessage() {
        if (this.parseException != null) {
            int max_size = 0;
            for (int i = 0; i < this.parseException.expectedTokenSequences.length; ++i) {
                if (max_size >= this.parseException.expectedTokenSequences[i].length) continue;
                max_size = this.parseException.expectedTokenSequences[i].length;
            }
            String output_message = "Unexpected \"";
            Token token = this.parseException.currentToken.next;
            for (int i = 0; i < max_size; ++i) {
                if (i != 0) {
                    output_message = output_message + " ";
                }
                if (token.kind == 0) {
                    output_message = output_message + this.parseException.tokenImage[0];
                    break;
                }
                output_message = output_message + ParseException.add_escapes(token.image);
                token = token.next;
            }
            output_message = output_message + "\" at line " + this.parseException.currentToken.next.beginLine + ", column " + this.parseException.currentToken.next.beginColumn + ".";
            return output_message;
        }
        return super.getMessage() + " at line " + this.getBeginLine() + ", column " + this.getBeginColumn() + ".";
    }

    public String getDetailedMessage() {
        if (this.parseException != null) {
            return this.parseException.getMessage() + ".";
        }
        return super.getMessage() + " at line " + this.getBeginLine() + ", column " + this.getBeginColumn() + ".";
    }
}

