/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.value;

import fr.gael.drb.value.Int;
import fr.gael.drb.value.Value;

public class BinaryInteger
extends Int {
    public static short DIGIT_AS_NEEDED = (short)-1;
    private int numDigit;

    public BinaryInteger(int v) {
        super(v);
        this.numDigit = DIGIT_AS_NEEDED;
    }

    public BinaryInteger(int v, int num_digit) {
        super(v);
        this.numDigit = num_digit;
    }

    @Override
    public String toString() {
        if (this.numDigit < 0) {
            return Integer.toBinaryString(this.value);
        }
        char[] binStr = new char[this.numDigit];
        int bitmask = 1 << this.numDigit - 1;
        for (int i = 0; i < this.numDigit; ++i) {
            binStr[i] = (bitmask & this.value) == 0 ? 48 : 49;
            bitmask >>= 1;
        }
        return new String(binStr);
    }

    @Override
    public int getType() {
        return 11;
    }

    @Override
    public Value convertTo(int type) throws ClassCastException {
        if (type == 11) {
            return this;
        }
        return super.convertTo(type);
    }
}

