/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.value;

import fr.gael.drb.value.DateTime;
import fr.gael.drb.value.DayTimeDuration;
import fr.gael.drb.value.Double;
import fr.gael.drb.value.Numeric;
import fr.gael.drb.value.String;
import fr.gael.drb.value.Value;
import fr.gael.drb.value.YearMonthDuration;

public class Duration
extends DayTimeDuration {
    static final int PRIORITY = 7;
    static final double DAYS_PER_YEAR = 365.25;
    static final long SECONDS_PER_MONTH = 2629800L;
    protected long yearMonth;

    public static Duration parseDuration(java.lang.String s) {
        if (s == null || s.length() < 2) {
            return null;
        }
        boolean haveSign = s.startsWith("-");
        if (haveSign) {
            s = s.substring(1);
        }
        if (s.length() < 3 || !s.startsWith("P")) {
            return null;
        }
        s = s.substring(1);
        long years = 0L;
        long months = 0L;
        long days = 0L;
        long hours = 0L;
        long minutes = 0L;
        double seconds = 0.0;
        int index = -1;
        index = s.indexOf(89);
        if (index > 0) {
            years = Long.parseLong(s.substring(0, index));
            s = s.substring(index + 1, s.length());
        }
        if ((index = s.indexOf(77)) > 0 && (s.indexOf(84) < 0 || index < s.indexOf(84))) {
            months = Long.parseLong(s.substring(0, index));
            s = s.substring(index + 1, s.length());
        }
        if ((index = s.indexOf(68)) > 0) {
            days = Long.parseLong(s.substring(0, index));
            s = s.substring(index + 1, s.length());
        }
        if (s.startsWith("T")) {
            s = s.substring(1);
        }
        if ((index = s.indexOf(72)) > 0) {
            hours = Long.parseLong(s.substring(0, index));
            s = s.substring(index + 1, s.length());
        }
        if ((index = s.indexOf(77)) > 0) {
            minutes = Long.parseLong(s.substring(0, index));
            s = s.substring(index + 1, s.length());
        }
        if ((index = s.indexOf(83)) > 0) {
            seconds = java.lang.Double.parseDouble(s.substring(0, index));
            s = s.substring(index + 1, s.length());
        }
        if (s.length() != 0) {
            return null;
        }
        long year_month = years * 12L + months;
        double day_time = (double)(days * 86400L + hours * 3600L + minutes * 60L) + seconds;
        if (haveSign) {
            year_month = -year_month;
            day_time = -day_time;
        }
        return new Duration(year_month, day_time);
    }

    public Duration(long year_month, double day_time) {
        super(day_time);
        this.setDuration(year_month, day_time);
    }

    void setDuration(long year_month, double day_time) {
        if (day_time < 0.0 && year_month > 0L) {
            long carry_month = 1L + (long)(Math.abs(day_time) / 2629800.0);
            year_month -= carry_month;
            day_time += (double)(carry_month * 2629800L);
        } else if (day_time > 0.0 && year_month < 0L) {
            long carry_month = 1L + (long)(Math.abs(day_time) / 2629800.0);
            year_month += carry_month;
            day_time -= (double)(carry_month * 2629800L);
        }
        if (Math.abs(day_time) >= 2629800.0) {
            if (day_time < 0.0) {
                year_month += (long)(day_time / 2629800.0);
                day_time = -Math.abs(day_time) % 2629800.0;
            } else {
                year_month += (long)(day_time / 2629800.0);
                day_time %= 2629800.0;
            }
        }
        this.dayTime = day_time;
        this.yearMonth = year_month;
    }

    long getYearMonth() {
        return this.yearMonth;
    }

    long getYears() {
        return Math.abs(this.yearMonth) / 12L;
    }

    int getMonths() {
        return (int)(Math.abs(this.yearMonth) % 12L);
    }

    @Override
    public java.lang.String toString() {
        long years = this.getYears();
        int months = this.getMonths();
        int hours = this.getHours();
        int minutes = this.getMinutes();
        double seconds = this.getSeconds();
        java.lang.String str = "P" + this.getYears() + "Y" + this.getMonths() + "M" + this.getDays() + "D";
        if (this.dayTime < 0.0 || this.yearMonth < 0L) {
            str = "-" + str;
        }
        if (hours == 0 && minutes == 0 && seconds == 0.0) {
            return str;
        }
        return str + "T" + this.getHours() + "H" + this.getMinutes() + "M" + this.getSeconds() + "S";
    }

    @Override
    public int getType() {
        return 16;
    }

    @Override
    public Value convertTo(int type) throws ClassCastException {
        switch (type) {
            case 16: {
                return this;
            }
            case 17: {
                return new DayTimeDuration(this.dayTime + (double)(this.yearMonth * 2629800L));
            }
            case 18: {
                return new YearMonthDuration(this.yearMonth);
            }
            case 7: {
                return new String(this.toString());
            }
        }
        return new Double(this.dayTime + (double)(this.yearMonth * 2629800L)).convertTo(type);
    }

    @Override
    public void assign(Value v) {
        Duration vd = (Duration)v.convertTo(16);
        this.yearMonth = vd.getYearMonth();
        this.dayTime = vd.getDayTime();
    }

    @Override
    public int getPriority() {
        return 7;
    }

    @Override
    public Value add(Value x) {
        Duration vd = (Duration)x.convertTo(16);
        return new Duration(this.getYearMonth() + vd.getYearMonth(), this.getDayTime() + vd.getDayTime());
    }

    @Override
    public Value unaryMinus() {
        return new Duration(-this.getYearMonth(), -this.getDayTime());
    }

    @Override
    public Value sub(Value x) {
        Duration vd = (Duration)x.convertTo(16);
        return new Duration(this.getYearMonth() - vd.getYearMonth(), this.getDayTime() - vd.getDayTime());
    }

    @Override
    public Value multiply(Value x) {
        Numeric num = (Numeric)x.convertTo(9);
        double year_month = (double)this.yearMonth * num.doubleValue();
        double day_time = this.dayTime * num.doubleValue();
        return new Duration((long)year_month, day_time += year_month - (double)((long)year_month));
    }

    @Override
    public Value divide(Value x) {
        Numeric num = (Numeric)x.convertTo(9);
        double year_month = (double)this.yearMonth / num.doubleValue();
        double day_time = this.dayTime / num.doubleValue();
        return new Duration((long)year_month, day_time += year_month - (double)((long)year_month));
    }

    @Override
    public Value modulus(Value x) {
        return null;
    }

    @Override
    public int compareTo(Value v) {
        Duration vd = (Duration)v.convertTo(16);
        double diff = this.getYearMonth() - vd.getYearMonth();
        if (diff < 0.0) {
            return -1;
        }
        if (diff > 0.0) {
            return 1;
        }
        diff = this.getDayTime() - vd.getDayTime();
        if (diff < 0.0) {
            return -1;
        }
        if (diff > 0.0) {
            return 1;
        }
        return 0;
    }

    public static void main(java.lang.String[] args) {
        int iDate;
        Duration dur = new Duration(Long.parseLong(args[0]), java.lang.Double.parseDouble(args[1]));
        System.out.println("Test :  convert a Duration(" + args[0] + "," + args[1] + ")");
        System.out.println("toString : " + dur.convertTo(7));
        System.out.println("toDouble : " + dur.convertTo(6));
        System.out.println("toLong : " + dur.convertTo(4));
        if (args.length > 3) {
            System.out.println("-- CMP --");
            Duration dur2 = new Duration(Long.parseLong(args[2]), java.lang.Double.parseDouble(args[3]));
            System.out.println("'" + dur + "' compareTo '" + dur2 + " = " + dur.compareTo(dur2));
        }
        java.lang.String[] dates = new java.lang.String[]{"01-JAN-2000 00:00:00.000000", "31-DEC-1999 04:00:00.004321", "01-JUL-1973 15:15:00.000937", "01-JAN-2002 10:30:50.876543"};
        System.out.println("-- SUM --");
        DateTime date_time1 = null;
        for (iDate = 0; iDate < dates.length; ++iDate) {
            date_time1 = new DateTime(dates[iDate]);
            System.out.println("'" + date_time1 + "' + '" + dur + " = " + date_time1.add(dur).convertTo(8));
        }
        System.out.println("-- DIF --");
        for (iDate = 0; iDate < dates.length; ++iDate) {
            date_time1 = new DateTime(dates[iDate]);
            System.out.println("'" + date_time1 + "' - '" + dur + " = " + date_time1.sub(dur).convertTo(8));
        }
    }
}

