/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.value;

import fr.gael.drb.value.AbstractNumeric;
import fr.gael.drb.value.Decimal;
import fr.gael.drb.value.Numeric;
import fr.gael.drb.value.Value;
import java.math.BigDecimal;
import java.math.BigInteger;

public class Integer
extends AbstractNumeric {
    public static final int PRIORITY = 5;
    protected BigInteger value;

    public Integer(String val) {
        if (val.startsWith("+")) {
            val = val.substring(1);
        }
        this.value = new BigInteger(val);
    }

    public Integer(byte[] val) {
        this.value = new BigInteger(val);
    }

    public Integer(long val) {
        this.value = BigInteger.valueOf(val);
    }

    public Integer(int val) {
        this.value = BigInteger.valueOf(val);
    }

    public Integer(BigInteger val) {
        this.value = val;
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    public int getType() {
        return 27;
    }

    @Override
    public final int getPriority() {
        return 5;
    }

    @Override
    public Value convertTo(int type) throws ClassCastException {
        switch (type) {
            case 27: {
                return this;
            }
            case 26: {
                return new Decimal(new BigDecimal(this.value));
            }
        }
        return super.convertTo(type);
    }

    @Override
    public void assign(Value v) {
        this.value = new BigInteger(v.toString());
    }

    @Override
    public Value unaryMinus() {
        return new Integer(this.value.negate());
    }

    @Override
    public final Value add(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).add(x);
        }
        Integer num = (Integer)x.convertTo(27);
        return new Integer(this.value.add(num.value));
    }

    @Override
    public Value sub(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).sub(x);
        }
        Integer num = (Integer)x.convertTo(27);
        return new Integer(this.value.subtract(num.value));
    }

    @Override
    public Value multiply(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).multiply(x);
        }
        Integer num = (Integer)x.convertTo(27);
        return new Integer(this.value.multiply(num.value));
    }

    @Override
    public final Value divide(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).divide(x);
        }
        Integer num = (Integer)x.convertTo(27);
        return new Integer(this.value.divide(num.value));
    }

    @Override
    public Value modulus(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).modulus(x);
        }
        Integer num = (Integer)x.convertTo(27);
        return new Integer(this.value.mod(num.value));
    }

    @Override
    public int compareTo(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).compareTo(x);
        }
        Integer num = (Integer)x.convertTo(27);
        return this.value.compareTo(num.value);
    }

    @Override
    public final boolean booleanValue() {
        return this.value.signum() != 0;
    }

    @Override
    public final byte byteValue() {
        return this.value.byteValue();
    }

    @Override
    public final short shortValue() {
        return this.value.shortValue();
    }

    @Override
    public final int intValue() {
        return this.value.intValue();
    }

    @Override
    public final long longValue() {
        return this.value.longValue();
    }

    @Override
    public final float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public final double doubleValue() {
        return this.value.doubleValue();
    }

    @Override
    public final BigInteger integerValue() {
        return new BigInteger(this.value.toByteArray());
    }

    @Override
    protected final BigDecimal decimalValue() {
        return new BigDecimal(this.toString());
    }

    @Override
    public final void assign(boolean value) {
        this.value = BigInteger.valueOf(value ? 1L : 0L);
    }

    @Override
    public final void assign(byte value) {
        this.value = BigInteger.valueOf(value);
    }

    @Override
    public final void assign(short value) {
        this.value = BigInteger.valueOf(value);
    }

    @Override
    public final void assign(int value) {
        this.value = BigInteger.valueOf(value);
    }

    @Override
    public final void assign(long value) {
        this.value = BigInteger.valueOf(value);
    }

    @Override
    public final void assign(float value) {
        this.value = new BigDecimal(Float.toString(value)).toBigInteger();
    }

    @Override
    public final void assign(double value) {
        this.value = new BigDecimal(Double.toString(value)).toBigInteger();
    }
}

