/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.value;

import fr.gael.drb.value.AbstractNumericArray;
import fr.gael.drb.value.Long;
import fr.gael.drb.value.Numeric;
import fr.gael.drb.value.NumericArray;
import fr.gael.drb.value.String;
import fr.gael.drb.value.UnsignedLong;
import fr.gael.drb.value.Value;
import fr.gael.drb.value.ValueFormat;

public class UnsignedLongArray
extends AbstractNumericArray
implements ValueFormat {
    static final int PRIORITY = 4;
    private long[] value;

    public UnsignedLongArray(long[] v) {
        this.value = new long[v.length];
        System.arraycopy(v, 0, this.value, 0, v.length);
    }

    public UnsignedLongArray(int size) {
        this.value = new long[size];
    }

    public final long[] getData() {
        return this.value;
    }

    @Override
    public java.lang.String getFormattedString(int length) {
        java.lang.String str = "";
        for (int i = 0; i < this.length(); ++i) {
            str = str + new Long(this.value[i]).getFormattedString(8);
        }
        return str;
    }

    @Override
    public final byte[] getFormattedBuffer() {
        byte[] buffer = new byte[8 * this.length()];
        for (int i = 0; i < this.length(); ++i) {
            long long_value = this.value[i];
            buffer[8 * i + 0] = (byte)(long_value >>> 56);
            buffer[8 * i + 1] = (byte)(long_value >>> 48);
            buffer[8 * i + 2] = (byte)(long_value >>> 40);
            buffer[8 * i + 3] = (byte)(long_value >>> 32);
            buffer[8 * i + 4] = (byte)(long_value >>> 24);
            buffer[8 * i + 5] = (byte)(long_value >>> 16);
            buffer[8 * i + 6] = (byte)(long_value >>> 8);
            buffer[8 * i + 7] = (byte)long_value;
        }
        return buffer;
    }

    @Override
    public final int getType() {
        return 10;
    }

    @Override
    public final int getPriority() {
        return 4;
    }

    @Override
    public final Value convertTo(int type) throws ClassCastException {
        if (type == 10) {
            return this;
        }
        if (type == 7) {
            return new String(this.toString());
        }
        throw new ClassCastException();
    }

    @Override
    public final void assign(Value v) throws ClassCastException {
        NumericArray b = (NumericArray)v;
        this.value = new long[b.length()];
        for (int i = 0; i < this.length(); ++i) {
            this.value[i] = b.longValue(i);
        }
    }

    @Override
    public final int getArrayType() {
        return 15;
    }

    @Override
    public final Value getElement(int index) {
        return new UnsignedLong(this.value[index]);
    }

    @Override
    public final void assign(int index, Value element) {
        element = element.convertTo(9);
        this.value[index] = ((Numeric)element).longValue();
    }

    @Override
    public final int length() {
        return this.value.length;
    }

    @Override
    public final boolean booleanValue(int index) {
        return this.value[index] != 0L;
    }

    @Override
    public final byte byteValue(int index) {
        return (byte)this.value[index];
    }

    @Override
    public final int intValue(int index) {
        return (int)this.value[index];
    }

    @Override
    public final long longValue(int index) {
        return this.value[index];
    }

    @Override
    public final short shortValue(int index) {
        return (short)this.value[index];
    }

    @Override
    public final float floatValue(int index) {
        return this.value[index];
    }

    @Override
    public final double doubleValue(int index) {
        return this.value[index];
    }

    @Override
    public final void assign(int index, boolean value) {
        this.value[index] = value ? 1 : 0;
    }

    @Override
    public final void assign(int index, byte value) {
        this.value[index] = value;
    }

    @Override
    public final void assign(int index, int value) {
        this.value[index] = value;
    }

    @Override
    public final void assign(int index, short value) {
        this.value[index] = value;
    }

    @Override
    public final void assign(int index, long value) {
        this.value[index] = value;
    }

    @Override
    public final void assign(int index, float value) {
        this.value[index] = (long)value;
    }

    @Override
    public final void assign(int index, double value) {
        this.value[index] = (long)value;
    }

    public java.lang.String toString() {
        StringBuffer strbuf = new StringBuffer(this.value.length * 3);
        for (int i = 0; i < this.value.length; ++i) {
            if (i != 0) {
                strbuf.append(" ");
            }
            strbuf.append(UnsignedLong.toString(this.value[i]));
        }
        return strbuf.toString();
    }
}

