/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.xsd;

import fr.gael.drb.DrbAbstractNode;
import fr.gael.drb.DrbAttributeList;
import fr.gael.drb.DrbDefaultNodeList;
import fr.gael.drb.DrbDefaultSequence;
import fr.gael.drb.DrbItem;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbNodeList;
import fr.gael.drb.DrbSequence;
import fr.gael.drb.impl.DrbNodeImpl;
import fr.gael.drb.value.Value;
import fr.gael.drb.xsd.Namespace;
import org.apache.log4j.Logger;

class DrbNodeFilter
extends DrbNodeImpl {
    private static Logger logger = Logger.getLogger(DrbNodeFilter.class);
    protected DrbNode baseNode;

    protected DrbNodeFilter(DrbNode baseNode) {
        this.baseNode = baseNode;
    }

    public DrbNode getBase() {
        return this.baseNode;
    }

    @Override
    public void close(boolean deep) {
        if (this.baseNode instanceof DrbNodeImpl) {
            ((DrbNodeImpl)this.baseNode).close(deep);
        }
    }

    protected DrbNodeFilter getInstance(DrbNode base_node) {
        if (base_node == null) {
            return null;
        }
        return new DrbNodeFilter(base_node);
    }

    @Override
    public String getName() {
        return this.baseNode.getName();
    }

    @Override
    protected String getXPathName() {
        try {
            return this.getXPathName((DrbAbstractNode)this.baseNode);
        }
        catch (ClassCastException e) {
            return super.getXPathName();
        }
    }

    @Override
    public String getPath() {
        return this.baseNode.getPath();
    }

    @Override
    public int getIndex() {
        return this.baseNode.getIndex();
    }

    @Override
    public String getNamespaceURI() {
        return this.baseNode.getNamespaceURI();
    }

    @Override
    public Namespace getNamespaceBindings() {
        try {
            return ((DrbAbstractNode)this.baseNode).getNamespaceBindings();
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @Override
    public int getValueType() {
        return this.baseNode.getValueType();
    }

    @Override
    public Value getValue() {
        return this.baseNode.getValue();
    }

    @Override
    public DrbAttributeList getAttributes() {
        return this.baseNode.getAttributes();
    }

    @Override
    public DrbNode getParent() {
        return this.getInstance(this.baseNode.getParent());
    }

    @Override
    public final boolean hasChild() {
        return this.baseNode.hasChild();
    }

    @Override
    public DrbNode getNamedChild(String name, int occurence) {
        if (name == null || occurence <= 0) {
            logger.error("DrbNodeFilter.getNamedChild(): Invalid parameters.");
            return null;
        }
        return this.getInstance(this.baseNode.getNamedChild(name, occurence));
    }

    @Override
    public final DrbNode getFirstChild() {
        return this.getInstance(this.baseNode.getFirstChild());
    }

    @Override
    public final DrbNode getLastChild() {
        return this.getInstance(this.baseNode.getLastChild());
    }

    @Override
    public final DrbNode getChildAt(int index) {
        return this.getInstance(this.baseNode.getChildAt(index));
    }

    @Override
    public DrbNodeList getChildren() {
        DrbNodeList children = this.baseNode.getChildren();
        if (children == null) {
            children = this.baseNode.getChildren();
        }
        if (children == null || children.getLength() == 0) {
            return null;
        }
        DrbDefaultNodeList list = new DrbDefaultNodeList();
        for (int inode = 0; inode < children.getLength(); ++inode) {
            list.add(this.getInstance(children.item(inode)));
        }
        return list;
    }

    @Override
    public DrbSequence getContent() {
        DrbSequence content = null;
        if (!(this.baseNode instanceof DrbAbstractNode)) {
            return super.getContent();
        }
        content = ((DrbAbstractNode)this.baseNode).getContent();
        if (content == null || content.getLength() == 0) {
            return null;
        }
        DrbDefaultSequence list = new DrbDefaultSequence();
        for (int inode = 0; inode < content.getLength(); ++inode) {
            DrbItem item = content.getItem(inode);
            if (item.getItemType() == 1) {
                list.addItem(this.getInstance((DrbNode)item));
                continue;
            }
            list.addItem(item);
        }
        return list;
    }

    @Override
    public final int getChildrenCount() {
        return this.baseNode.getChildrenCount();
    }

    @Override
    public DrbNode getPreviousSibling() {
        return this.getInstance(this.baseNode.getPreviousSibling());
    }

    @Override
    public DrbNode getNextSibling() {
        return this.getInstance(this.baseNode.getNextSibling());
    }

    @Override
    public void rename(String name) throws NullPointerException, UnsupportedOperationException {
        this.baseNode.rename(name);
    }

    @Override
    public Value setValue(Value value) throws NullPointerException, ClassCastException, UnsupportedOperationException {
        return this.baseNode.setValue(value);
    }

    @Override
    public void setAttributes(DrbAttributeList attributes) throws NullPointerException, UnsupportedOperationException {
        this.baseNode.setAttributes(attributes);
    }

    @Override
    public void setNamespaceURI(String namespace_uri) throws NullPointerException, UnsupportedOperationException {
        this.baseNode.setNamespaceURI(namespace_uri);
    }

    @Override
    public DrbNode insertChild(DrbNode node, int index) throws NullPointerException, UnsupportedOperationException, IndexOutOfBoundsException {
        return this.getInstance(this.baseNode.insertChild(node, index));
    }

    @Override
    public DrbNode appendChild(DrbNode node) throws NullPointerException, UnsupportedOperationException {
        return this.getInstance(this.baseNode.appendChild(node));
    }

    @Override
    public DrbNode replaceChild(int index, DrbNode new_node) throws NullPointerException, IndexOutOfBoundsException, UnsupportedOperationException {
        return this.getInstance(this.baseNode.replaceChild(index, new_node));
    }

    @Override
    public void removeChild(int index) throws IndexOutOfBoundsException, UnsupportedOperationException {
        this.baseNode.removeChild(index);
    }

    @Override
    public boolean hasImpl(Class api) {
        if (this.baseNode instanceof DrbNodeImpl) {
            return ((DrbNodeImpl)this.baseNode).hasImpl(api);
        }
        return super.hasImpl(api);
    }

    @Override
    public Object getImpl(Class api) {
        if (this.baseNode instanceof DrbNodeImpl) {
            return ((DrbNodeImpl)this.baseNode).getImpl(api);
        }
        return super.getImpl(api);
    }
}

