/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.xsd.builder;

import fr.gael.drb.DrbAbstractNode;
import fr.gael.drb.DrbAttributeList;
import fr.gael.drb.DrbFactory;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbNodeList;
import fr.gael.drb.impl.xml.XmlWriter;
import fr.gael.drb.value.Value;
import fr.gael.drb.value.ValueArray;
import fr.gael.drb.xsd.Namespace;
import fr.gael.drb.xsd.XmlSchema;
import fr.gael.drb.xsd.XsdAtomicType;
import fr.gael.drb.xsd.XsdAttributeGroup;
import fr.gael.drb.xsd.XsdComplexType;
import fr.gael.drb.xsd.XsdElement;
import fr.gael.drb.xsd.XsdListType;
import fr.gael.drb.xsd.XsdModelGroup;
import fr.gael.drb.xsd.XsdParticle;
import fr.gael.drb.xsd.XsdSimpleType;
import fr.gael.drb.xsd.XsdType;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class XmlSchemaBuilder {
    private static Logger logger = Logger.getLogger(XmlSchemaBuilder.class);
    private String targetNamespace = null;
    private String typePrefix = "";
    private ArrayList global_type_list = null;
    private Pattern doublePattern = null;
    private Pattern integerPattern = null;
    private Pattern dateTimePattern = null;
    protected Namespace staticNamespace = new Namespace();

    public XmlSchemaBuilder() {
        this.integerPattern = Pattern.compile("(\\+|\\-)?[0-9]+");
        this.doublePattern = Pattern.compile("(\\+|\\-)?[0-9]*\\.?[0-9]*((d|D|e|E)(\\+|\\-)?[0-9]+)?");
        this.dateTimePattern = Pattern.compile("..-...-.... ..:..:..\\.......");
        this.global_type_list = new ArrayList();
        this.staticNamespace = new Namespace();
        this.staticNamespace.bind("xs", "http://www.w3.org/2001/XMLSchema");
    }

    public XmlSchema createSchema(DrbNode node) {
        if (node == null) {
            return null;
        }
        this.targetNamespace = node.getNamespaceURI();
        XsdElement[] root_elements = new XsdElement[]{this.createElement(node, 1, 1)};
        root_elements[0] = this.refineElement(root_elements[0], node, 1);
        XsdType[] global_types = new XsdType[this.global_type_list.size()];
        this.global_type_list.toArray(global_types);
        Namespace namespace = new Namespace();
        namespace.addNamespaces(this.staticNamespace);
        namespace.setDefaultNamespaceURI(this.targetNamespace);
        if (node instanceof DrbAbstractNode) {
            Namespace node_namespace = ((DrbAbstractNode)node).getNamespaceBindings();
            String prefix = null;
            if (node_namespace != null) {
                prefix = node_namespace.resolvePrefix(this.targetNamespace);
            }
            if (prefix != null && this.targetNamespace != null) {
                namespace.bind(prefix, this.targetNamespace);
            }
        }
        XmlSchema schema = new XmlSchema(root_elements, global_types, namespace);
        schema.setTargetNamespace(this.targetNamespace);
        return schema;
    }

    private XsdElement createElement(DrbNode node, int min_occurs, int max_occurs) {
        XsdType type = this.createType(node);
        XsdElement element = new XsdElement(min_occurs, max_occurs, node.getName(), type);
        element.setTargetNamespace(this.targetNamespace);
        return element;
    }

    protected XsdElement refineElement(XsdElement element, DrbNode node, int occurs) {
        return element;
    }

    private XsdType createType(DrbNode node) {
        XsdSimpleType datatype = null;
        Value value = node.getValue();
        if (value != null) {
            datatype = this.createSimpleType(value);
        }
        DrbNodeList children = node.getChildren();
        DrbAttributeList attributes = node.getAttributes();
        if (value == null || children != null && children.getLength() > 0) {
            int index = this.global_type_list.size();
            String old_type_prefix = this.typePrefix;
            this.typePrefix = this.typePrefix + node.getName() + "_";
            XsdModelGroup model_group = this.createModelGroup(children);
            this.typePrefix = old_type_prefix;
            XsdAttributeGroup attribute_group = this.createAttributeGroup(attributes);
            XsdComplexType complex_type = new XsdComplexType(this.typePrefix + node.getName(), attribute_group, model_group, (XsdType)datatype, 1);
            complex_type.setTargetNamespace(this.targetNamespace);
            this.global_type_list.add(index, complex_type);
            logger.debug("Schema Builder: Added " + complex_type.getName() + ".");
            return complex_type;
        }
        if (this.targetNamespace != datatype.getTargetNamespace() && !"http://www.w3.org/2001/XMLSchema".equals(datatype.getTargetNamespace())) {
            this.global_type_list.add(datatype);
        }
        return datatype;
    }

    private XsdModelGroup createModelGroup(DrbNodeList list) {
        if (list == null) {
            return new XsdModelGroup(1, 1, new XsdParticle[0], 1);
        }
        ArrayList<XsdElement> particle_list = new ArrayList<XsdElement>();
        int occurs = 1;
        Hashtable<String, XsdType> type_hash = new Hashtable<String, XsdType>();
        for (int i = 0; i < list.getLength(); i += occurs) {
            DrbNode node = list.item(i);
            String name = node.getName();
            occurs = 1;
            for (int j = i + 1; j < list.getLength() && name.equals(list.item(j).getName()); ++j) {
                ++occurs;
            }
            XsdType type = (XsdType)type_hash.get(node.getName());
            if (type == null) {
                type = this.createType(node);
                type_hash.put(node.getName(), type);
            }
            XsdElement element = new XsdElement(occurs, occurs, node.getName(), type);
            element = this.refineElement(element, node, occurs);
            particle_list.add(element);
        }
        XsdParticle[] content = new XsdParticle[particle_list.size()];
        particle_list.toArray(content);
        XsdModelGroup model_group = new XsdModelGroup(1, 1, content, 1);
        return model_group;
    }

    private XsdAttributeGroup createAttributeGroup(DrbAttributeList attributes) {
        return null;
    }

    private XsdSimpleType createSimpleType(Value value) {
        if (value == null) {
            return new XsdAtomicType(-2);
        }
        XsdSimpleType type = null;
        if (value.getType() == 10) {
            XsdSimpleType item_type = new XsdAtomicType(((ValueArray)value).getArrayType());
            item_type = (XsdSimpleType)XmlSchema.getDefaultSchema().getType(item_type.getName());
            type = new XsdListType(item_type, null);
            type.setTargetNamespace(this.targetNamespace);
        } else {
            if (value.getType() == 7) {
                try {
                    Value integer = value.convertTo(27);
                    type = (XsdSimpleType)XmlSchema.getDefaultSchema().getType("integer");
                }
                catch (ClassCastException integer) {
                    // empty catch block
                }
                if (type == null) {
                    try {
                        Value decimal = value.convertTo(26);
                        type = (XsdSimpleType)XmlSchema.getDefaultSchema().getType("decimal");
                    }
                    catch (ClassCastException decimal) {
                        // empty catch block
                    }
                }
                if (type == null) {
                    try {
                        Value date_time = value.convertTo(8);
                        type = (XsdSimpleType)XmlSchema.getDefaultSchema().getType("dateTime");
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
            }
            if (type == null) {
                type = new XsdAtomicType(value.getType());
                type.setTargetNamespace("http://www.w3.org/2001/XMLSchema");
                type = (XsdSimpleType)XmlSchema.getDefaultSchema().getType(type.getName());
            }
        }
        return type;
    }

    public static void main(String[] args) {
        DrbNode input_node = DrbFactory.open(args[0]);
        XmlSchemaBuilder xsd_builder = new XmlSchemaBuilder();
        XmlSchema xml_schema = xsd_builder.createSchema(input_node);
        XmlWriter.writeXML(xml_schema.toNode(), System.out);
    }
}

