/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.daml.impl.test;

import com.hp.hpl.jena.ontology.daml.DAMLClass;
import com.hp.hpl.jena.ontology.daml.DAMLInstance;
import com.hp.hpl.jena.ontology.daml.DAMLModel;
import com.hp.hpl.jena.ontology.daml.DAMLObjectProperty;
import com.hp.hpl.jena.ontology.daml.DAMLRestriction;
import com.hp.hpl.jena.ontology.daml.impl.test.DAMLTestBase;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.Iterator;
import junit.framework.TestSuite;

public class TestDAMLClass
extends DAMLTestBase {
    public static TestSuite suite() {
        return new TestDAMLClass("TestDAMLClass");
    }

    public TestDAMLClass(String name) {
        super(name);
    }

    public DAMLTestBase.OntTestCase[] getTests() {
        return new DAMLTestBase.OntTestCase[]{new DAMLTestBase.OntTestCase("DAMLClass.prop_subClassOf"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass C = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                1.assertEquals((String)"prop_subClassOf property", (Object)RDFS.subClassOf, (Object)A.prop_subClassOf().getProperty());
                1.assertEquals((String)"sub-class cardinality", (int)2, (int)A.prop_subClassOf().count());
                A.prop_subClassOf().add((RDFNode)B);
                this.iteratorTest((Iterator)A.prop_subClassOf().getAll(), new Object[]{A, B, DAML_OIL.Thing});
                1.assertEquals((String)"sub-class cardinality", (int)3, (int)A.prop_subClassOf().count());
                A.prop_subClassOf().add((RDFNode)C);
                1.assertEquals((String)"sub-class cardinality", (int)4, (int)A.prop_subClassOf().count());
                this.iteratorTest((Iterator)A.prop_subClassOf().getAll(), new Object[]{A, B, C, DAML_OIL.Thing});
                A.prop_subClassOf().remove((RDFNode)C);
                1.assertEquals((String)"sub-class cardinality", (int)3, (int)A.prop_subClassOf().count());
                this.iteratorTest((Iterator)A.prop_subClassOf().getAll(), new Object[]{A, B, DAML_OIL.Thing});
                1.assertTrue((String)"hasValue", (boolean)A.prop_subClassOf().hasValue((RDFNode)B));
                1.assertTrue((String)"hasValue", (!A.prop_subClassOf().hasValue((RDFNode)C) ? 1 : 0) != 0);
            }
        }, new DAMLTestBase.OntTestCase("DAMLClass.prop_disjointWith"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass C = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                2.assertEquals((String)"prop_disjointwith property", (Object)DAML_OIL.disjointWith, (Object)A.prop_disjointWith().getProperty());
                2.assertEquals((String)"disjointWith cardinality", (int)0, (int)A.prop_disjointWith().count());
                A.prop_disjointWith().add((RDFNode)B);
                2.assertEquals((String)"disjointwith cardinality", (int)1, (int)A.prop_disjointWith().count());
                A.prop_disjointWith().add((RDFNode)C);
                2.assertEquals((String)"disjointWith cardinality", (int)2, (int)A.prop_disjointWith().count());
                this.iteratorTest((Iterator)A.prop_disjointWith().getAll(), new Object[]{B, C});
                A.prop_disjointWith().remove((RDFNode)C);
                2.assertEquals((String)"disjointwith cardinality", (int)1, (int)A.prop_disjointWith().count());
                this.iteratorTest((Iterator)A.prop_disjointWith().getAll(), new Object[]{B});
                2.assertTrue((String)"hasValue", (boolean)A.prop_disjointWith().hasValue((RDFNode)B));
                2.assertTrue((String)"hasValue", (!A.prop_disjointWith().hasValue((RDFNode)C) ? 1 : 0) != 0);
            }
        }, new DAMLTestBase.OntTestCase("DAMLClass.prop_sameClassAs"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass C = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                3.assertEquals((String)"prop_sameClassAs property", (Object)DAML_OIL.sameClassAs, (Object)A.prop_sameClassAs().getProperty());
                3.assertEquals((String)"sameClassAs cardinality", (int)0, (int)A.prop_sameClassAs().count());
                A.prop_sameClassAs().add((RDFNode)B);
                3.assertEquals((String)"sameClassAs cardinality", (int)1, (int)A.prop_sameClassAs().count());
                A.prop_sameClassAs().add((RDFNode)C);
                3.assertEquals((String)"sameClassAs cardinality", (int)2, (int)A.prop_sameClassAs().count());
                this.iteratorTest((Iterator)A.prop_sameClassAs().getAll(), new Object[]{B, C});
                A.prop_sameClassAs().remove((RDFNode)C);
                3.assertEquals((String)"sameClassAs cardinality", (int)1, (int)A.prop_sameClassAs().count());
                this.iteratorTest((Iterator)A.prop_sameClassAs().getAll(), new Object[]{B});
                3.assertTrue((String)"hasValue", (boolean)A.prop_sameClassAs().hasValue((RDFNode)B));
                3.assertTrue((String)"hasValue", (!A.prop_sameClassAs().hasValue((RDFNode)C) ? 1 : 0) != 0);
            }
        }, new DAMLTestBase.OntTestCase("DAMLClass.prop_complementOf"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass C = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                4.assertEquals((String)"prop_complementOf property", (Object)DAML_OIL.complementOf, (Object)A.prop_complementOf().getProperty());
                4.assertEquals((String)"complementOf cardinality", (int)0, (int)A.prop_complementOf().count());
                A.prop_complementOf().add((RDFNode)B);
                4.assertEquals((String)"complementOf cardinality", (int)1, (int)A.prop_complementOf().count());
                A.prop_complementOf().add((RDFNode)C);
                4.assertEquals((String)"complementOf cardinality", (int)2, (int)A.prop_complementOf().count());
                this.iteratorTest((Iterator)A.prop_complementOf().getAll(), new Object[]{B, C});
                A.prop_complementOf().remove((RDFNode)C);
                4.assertEquals((String)"complementOf cardinality", (int)1, (int)A.prop_complementOf().count());
                this.iteratorTest((Iterator)A.prop_complementOf().getAll(), new Object[]{B});
                4.assertTrue((String)"hasValue", (boolean)A.prop_complementOf().hasValue((RDFNode)B));
                4.assertTrue((String)"hasValue", (!A.prop_complementOf().hasValue((RDFNode)C) ? 1 : 0) != 0);
            }
        }, new DAMLTestBase.OntTestCase("DAMLClass.getSubClasses"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass C = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                C.prop_subClassOf().add((RDFNode)B);
                B.prop_subClassOf().add((RDFNode)A);
                5.assertEquals((String)"subClassOf A", (Object)B, (Object)A.getSubClass());
                this.iteratorTest((Iterator)A.getSubClasses(), new Object[]{B, C});
                this.iteratorTest((Iterator)A.getSubClasses(false), new Object[]{B});
                this.iteratorTest((Iterator)A.getSubClasses(true), new Object[]{B, C});
            }
        }, new DAMLTestBase.OntTestCase("DAMLClass.getSuperClasses"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass C = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                A.prop_subClassOf().add((RDFNode)B);
                B.prop_subClassOf().add((RDFNode)C);
                this.iteratorTest((Iterator)A.getSuperClasses(), new Object[]{B, C, DAML_OIL.Thing});
                this.iteratorTest((Iterator)A.getSuperClasses(false), new Object[]{B});
                this.iteratorTest((Iterator)A.getSuperClasses(true), new Object[]{B, C, DAML_OIL.Thing});
            }
        }, new DAMLTestBase.OntTestCase("DAMLClass.getSameClasses"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass C = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                A.prop_sameClassAs().add((RDFNode)B);
                B.prop_sameClassAs().add((RDFNode)C);
                this.iteratorTest((Iterator)A.getSameClasses(), new Object[]{B});
                A.prop_sameClassAs().add((RDFNode)C);
                this.iteratorTest((Iterator)A.getSameClasses(), new Object[]{B, C});
            }
        }, new DAMLTestBase.OntTestCase("DAMLClass.getInstances"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLInstance a = m.createDAMLInstance(A, "http://jena.hpl.hp.com/testing/ontology#a");
                DAMLInstance b = m.createDAMLInstance(A, "http://jena.hpl.hp.com/testing/ontology#b");
                DAMLInstance c = m.createDAMLInstance(A, "http://jena.hpl.hp.com/testing/ontology#c");
                this.iteratorTest((Iterator)A.getInstances(), new Object[]{a, b, c});
            }
        }, new DAMLTestBase.OntTestCase("DAMLClass.disjointUnionOf"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass C = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                DAMLClass D = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#D");
                9.assertEquals((String)"prop_disjointUnionOf property", (Object)DAML_OIL.disjointUnionOf, (Object)A.prop_disjointUnionOf().getProperty());
                9.assertEquals((String)"disjointUnionOf cardinality", (int)0, (int)A.prop_disjointUnionOf().count());
                A.prop_disjointUnionOf().add((RDFNode)m.createDAMLList(new RDFNode[]{B, C}));
                9.assertEquals((String)"disjointUnionOf cardinality", (int)1, (int)A.prop_disjointUnionOf().count());
                this.iteratorTest((Iterator)A.prop_disjointUnionOf().getList().getAll(), new Object[]{B, C});
                A.prop_disjointUnionOf().getList().add((RDFNode)D);
                this.iteratorTest((Iterator)A.prop_disjointUnionOf().getList().getAll(), new Object[]{B, C, D});
                9.assertTrue((String)"contains", (boolean)A.prop_disjointUnionOf().getList().contains((RDFNode)D));
                9.assertTrue((String)"contains", (boolean)A.prop_disjointUnionOf().getList().contains((RDFNode)B));
                9.assertTrue((String)"contains", (boolean)A.prop_disjointUnionOf().getList().contains((RDFNode)C));
            }
        }, new DAMLTestBase.OntTestCase("DAMLClass.unionOf"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass C = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                DAMLClass D = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#D");
                10.assertEquals((String)"prop_unionOf property", (Object)DAML_OIL.unionOf, (Object)A.prop_unionOf().getProperty());
                10.assertEquals((String)"unionOf cardinality", (int)0, (int)A.prop_unionOf().count());
                A.prop_unionOf().add((RDFNode)m.createDAMLList(new RDFNode[]{B, C}));
                10.assertEquals((String)"unionOf cardinality", (int)1, (int)A.prop_unionOf().count());
                this.iteratorTest((Iterator)A.prop_unionOf().getList().getAll(), new Object[]{B, C});
                A.prop_unionOf().getList().add((RDFNode)D);
                this.iteratorTest((Iterator)A.prop_unionOf().getList().getAll(), new Object[]{B, C, D});
                10.assertTrue((String)"contains", (boolean)A.prop_unionOf().getList().contains((RDFNode)D));
                10.assertTrue((String)"contains", (boolean)A.prop_unionOf().getList().contains((RDFNode)B));
                10.assertTrue((String)"contains", (boolean)A.prop_unionOf().getList().contains((RDFNode)C));
            }
        }, new DAMLTestBase.OntTestCase("DAMLClass.intersectionOf"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass C = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                DAMLClass D = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#D");
                11.assertEquals((String)"prop_intersectionOf property", (Object)DAML_OIL.intersectionOf, (Object)A.prop_intersectionOf().getProperty());
                11.assertEquals((String)"intersectionOf cardinality", (int)0, (int)A.prop_intersectionOf().count());
                A.prop_intersectionOf().add((RDFNode)m.createDAMLList(new RDFNode[]{B, C}));
                11.assertEquals((String)"intersectionOf cardinality", (int)1, (int)A.prop_intersectionOf().count());
                this.iteratorTest((Iterator)A.prop_intersectionOf().getList().getAll(), new Object[]{B, C});
                A.prop_intersectionOf().getList().add((RDFNode)D);
                this.iteratorTest((Iterator)A.prop_intersectionOf().getList().getAll(), new Object[]{B, C, D});
                11.assertTrue((String)"contains", (boolean)A.prop_intersectionOf().getList().contains((RDFNode)D));
                11.assertTrue((String)"contains", (boolean)A.prop_intersectionOf().getList().contains((RDFNode)B));
                11.assertTrue((String)"contains", (boolean)A.prop_intersectionOf().getList().contains((RDFNode)C));
            }
        }, new DAMLTestBase.OntTestCase("DAMLClass.oneOf"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass C = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                DAMLClass D = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#D");
                12.assertEquals((String)"prop_oneOf property", (Object)DAML_OIL.oneOf, (Object)A.prop_oneOf().getProperty());
                12.assertEquals((String)"oneOf cardinality", (int)0, (int)A.prop_oneOf().count());
                A.prop_oneOf().add((RDFNode)m.createDAMLList(new RDFNode[]{B, C}));
                12.assertEquals((String)"oneOf cardinality", (int)1, (int)A.prop_oneOf().count());
                this.iteratorTest((Iterator)A.prop_oneOf().getList().getAll(), new Object[]{B, C});
                A.prop_oneOf().getList().add((RDFNode)D);
                this.iteratorTest((Iterator)A.prop_oneOf().getList().getAll(), new Object[]{B, C, D});
                12.assertTrue((String)"contains", (boolean)A.prop_oneOf().getList().contains((RDFNode)D));
                12.assertTrue((String)"contains", (boolean)A.prop_oneOf().getList().contains((RDFNode)B));
                12.assertTrue((String)"contains", (boolean)A.prop_oneOf().getList().contains((RDFNode)C));
            }
        }, new DAMLTestBase.OntTestCase("DAMLClass.getDefinedProperties"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                B.prop_subClassOf().add((RDFNode)A);
                DAMLObjectProperty p = m.createDAMLObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                DAMLObjectProperty q = m.createDAMLObjectProperty("http://jena.hpl.hp.com/testing/ontology#q");
                DAMLObjectProperty r = m.createDAMLObjectProperty("http://jena.hpl.hp.com/testing/ontology#r");
                p.prop_domain().add((RDFNode)B);
                q.prop_domain().add((RDFNode)B);
                r.prop_domain().add((RDFNode)A);
                this.iteratorTest((Iterator)A.getDefinedProperties(), new Object[]{r});
                this.iteratorTest((Iterator)B.getDefinedProperties(), new Object[]{p, q, r});
            }
        }, new DAMLTestBase.OntTestCase("DAMLRestriction.prop_onProperty"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLRestriction A = m.createDAMLRestriction("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLObjectProperty p = m.createDAMLObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                14.assertEquals((String)"prop_onProperty property", (Object)DAML_OIL.onProperty, (Object)A.prop_onProperty().getProperty());
                14.assertEquals((String)"onProperty cardinality", (int)0, (int)A.prop_onProperty().count());
                A.prop_onProperty().add((RDFNode)p);
                14.assertEquals((String)"onProperty cardinality", (int)1, (int)A.prop_onProperty().count());
                this.iteratorTest((Iterator)A.prop_onProperty().getAll(), new Object[]{p});
            }
        }, new DAMLTestBase.OntTestCase("DAMLRestriction.prop_toClass"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLRestriction A = m.createDAMLRestriction("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                15.assertEquals((String)"prop_toClass property", (Object)DAML_OIL.toClass, (Object)A.prop_toClass().getProperty());
                15.assertEquals((String)"toClass cardinality", (int)0, (int)A.prop_toClass().count());
                A.prop_toClass().add((RDFNode)B);
                15.assertEquals((String)"toClass cardinality", (int)1, (int)A.prop_toClass().count());
                this.iteratorTest((Iterator)A.prop_toClass().getAll(), new Object[]{B});
            }
        }, new DAMLTestBase.OntTestCase("DAMLRestriction.prop_hasClass"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLRestriction A = m.createDAMLRestriction("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                16.assertEquals((String)"prop_hasClass property", (Object)DAML_OIL.hasClass, (Object)A.prop_hasClass().getProperty());
                16.assertEquals((String)"hasClass cardinality", (int)0, (int)A.prop_hasClass().count());
                A.prop_hasClass().add((RDFNode)B);
                16.assertEquals((String)"hasClass cardinality", (int)1, (int)A.prop_hasClass().count());
                this.iteratorTest((Iterator)A.prop_hasClass().getAll(), new Object[]{B});
            }
        }, new DAMLTestBase.OntTestCase("DAMLRestriction.prop_cardinality"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLRestriction A = m.createDAMLRestriction("http://jena.hpl.hp.com/testing/ontology#A");
                17.assertEquals((String)"prop_cardinality property", (Object)DAML_OIL.cardinality, (Object)A.prop_cardinality().getProperty());
                17.assertEquals((String)"cardinality cardinality", (int)0, (int)A.prop_cardinality().count());
                A.prop_cardinality().addInt(1);
                17.assertEquals((String)"cardinality cardinality", (int)1, (int)A.prop_cardinality().count());
                17.assertEquals((String)"cardinality", (int)1, (int)A.prop_cardinality().getInt());
            }
        }};
    }
}

