/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.sds;

import fr.gael.drb.DrbAttributeList;
import fr.gael.drb.DrbNode;
import fr.gael.drb.impl.sds.BlockTools;
import fr.gael.drb.impl.sds.DefaultBlock;
import fr.gael.drb.impl.sds.Descriptor;
import fr.gael.drb.impl.sds.IntMap;
import fr.gael.drb.impl.sds.Length;
import fr.gael.drb.value.String;
import fr.gael.drb.value.Value;
import java.io.EOFException;
import java.io.IOException;
import java.lang.ref.SoftReference;
import org.apache.log4j.Logger;

class MultipleOccurrenceBlock
extends DefaultBlock {
    private static Logger logger = Logger.getLogger(MultipleOccurrenceBlock.class);
    protected int occurrence;
    protected int occurrenceCount;
    protected Length offset;
    protected Length length;

    protected MultipleOccurrenceBlock(Descriptor descriptor, int[] key, int occurrence_count, Length offset, Length length) {
        super(descriptor, key);
        if (key.length == 0 || occurrence_count < 0 || occurrence_count <= key[key.length - 1]) {
            logger.error("MultipleOccurrenceBlock.MultipleOccurrenceBlock() ERROR: Invalid parameter(s).");
            logger.error("   descriptor name = " + (descriptor == null ? null : descriptor.getName()));
            logger.error("   key.length      = " + key.length);
            if (key.length == 0) {
                logger.error("      The root block should not be instanciated as MultipleOccurrenceBlock !");
            }
            logger.error("   key             = " + IntMap.keyToString(key));
            logger.error("   occurrence_count = " + occurrence_count);
        }
        this.occurrence = key[key.length - 1];
        this.occurrenceCount = occurrence_count;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public Value getValue() {
        if (this.hasChild()) {
            return null;
        }
        Value value = (Value)this.blockValue.get();
        if (value == null) {
            Length start_offset = new Length(this.offset.getLength() + (long)this.descriptor.headerPadding.length, this.offset.getBitLength());
            Length stop_offset = new Length(this.offset.getLength() + this.length.getLength() - (long)this.descriptor.headerPadding.length - (long)this.descriptor.footerPadding.length, this.offset.getBitLength() + this.length.getBitLength());
            try {
                value = BlockTools.extractValue(this.descriptor, start_offset, stop_offset, 0L, new Length(0L));
                if (value != null && value.getType() == 7 && "token".equals(this.descriptor.getType().getName())) {
                    value = new String(value.toString().trim());
                }
                this.blockValue = new SoftReference<Value>(value);
            }
            catch (EOFException e) {
                logger.error(e);
                logger.error("MultipleOccurrenceBlock.getValue(): Unable to read value for node \"" + this.getName() + "\" (key=" + IntMap.keyToString(this.key) + ").");
            }
            catch (IOException e) {
                logger.error(e);
                logger.error("MultipleOccurrenceBlock.getValue(): Unable to read value for node \"" + this.getName() + "\" (key=" + IntMap.keyToString(this.key) + ").");
            }
        }
        return value;
    }

    @Override
    public DrbAttributeList getAttributes() {
        return null;
    }

    @Override
    public DrbNode getPreviousSibling() {
        if (this.occurrence > 0) {
            int[] previousKey = IntMap.getSiblingKey(this.key, this.occurrence - 1);
            return new MultipleOccurrenceBlock(this.descriptor, previousKey, this.occurrenceCount, new Length(this.offset.getLength() - this.length.getLength(), this.offset.getBitLength() - this.length.getBitLength()), this.length);
        }
        Descriptor previousDesc = this.descriptor;
        while ((previousDesc = previousDesc.getPreviousSibling()) != null) {
            int[] previousKey = IntMap.getSiblingKey(this.key, 0);
            int descOccurrenceCount = previousDesc.getOccurrenceCount(previousKey);
            if (descOccurrenceCount <= 0) continue;
            previousKey = IntMap.getSiblingKey(this.key, descOccurrenceCount - 1);
            return MultipleOccurrenceBlock.createOptimalBlock(previousDesc, previousKey, descOccurrenceCount);
        }
        return null;
    }

    @Override
    public DrbNode getNextSibling() {
        if (this.occurrence < this.occurrenceCount - 1) {
            int[] nextKey = IntMap.getSiblingKey(this.key, this.occurrence + 1);
            return new MultipleOccurrenceBlock(this.descriptor, nextKey, this.occurrenceCount, new Length(this.offset.getLength() + this.length.getLength(), this.offset.getBitLength() + this.length.getBitLength()), this.length);
        }
        Descriptor nextDesc = this.descriptor;
        while ((nextDesc = nextDesc.getNextSibling()) != null) {
            int[] nextKey = IntMap.getSiblingKey(this.key, 0);
            int descOccurrenceCount = nextDesc.getOccurrenceCount(nextKey);
            if (descOccurrenceCount <= 0) continue;
            return MultipleOccurrenceBlock.createOptimalBlock(nextDesc, nextKey, descOccurrenceCount);
        }
        return null;
    }
}

