/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.sds;

import fr.gael.drb.DrbDefaultAttribute;
import fr.gael.drb.DrbDefaultAttributeList;
import fr.gael.drb.DrbDefaultMutableNode;
import fr.gael.drb.DrbFactory;
import fr.gael.drb.DrbNode;
import fr.gael.drb.impl.DrbNodeImpl;
import fr.gael.drb.impl.sds.AbstractBlock;
import fr.gael.drb.impl.sds.Descriptor;
import fr.gael.drb.impl.sds.LengthAttribute;
import fr.gael.drb.impl.sds.OffsetAttribute;
import fr.gael.drb.impl.sds.PhysicalAttribute;
import fr.gael.drb.impl.xml.XmlWriter;
import fr.gael.drb.value.Boolean;
import fr.gael.drb.value.Int;
import fr.gael.drb.value.Long;
import fr.gael.drb.value.String;
import fr.gael.drb.value.Value;
import fr.gael.drb.xsd.XmlSchema;
import fr.gael.drb.xsd.XsdAnnotation;
import fr.gael.drb.xsd.XsdAppinfo;
import fr.gael.drb.xsd.XsdDocumentation;
import fr.gael.drb.xsd.XsdElement;
import fr.gael.drb.xsd.builder.XmlSchemaBuilder;
import org.apache.log4j.Logger;

public final class SdfSchemaBuilder
extends XmlSchemaBuilder {
    private static Logger logger = Logger.getLogger(SdfSchemaBuilder.class);

    public SdfSchemaBuilder() {
        this.staticNamespace.bind("sdf", AbstractBlock.SDF_NAMESPACE);
    }

    @Override
    public XmlSchema createSchema(DrbNode node) {
        XmlSchema schema = super.createSchema(node);
        return schema;
    }

    @Override
    protected XsdElement refineElement(XsdElement element, DrbNode node, int occurs) {
        XsdElement sdf_element = super.refineElement(element, node, occurs);
        try {
            AbstractBlock block = (AbstractBlock)((DrbNodeImpl)node).getImpl(AbstractBlock.class);
            if (block == null) {
                return sdf_element;
            }
            Descriptor desc = block.descriptor;
            if (desc.occurrenceCount.getType() != 1) {
                element.setOccurs(0, XsdElement.UNBOUNDED_OCCURS);
            }
            DrbNode block_node = this.createBlock(desc, occurs);
            XsdDocumentation[] documentations = null;
            if (desc.documentation != null) {
                documentations = new XsdDocumentation[]{new XsdDocumentation(new String(desc.documentation))};
            }
            XsdAppinfo[] appinfos = null;
            if (block_node.getAttributes() != null || block_node.getChildren() != null && block_node.getChildren().getLength() > 0) {
                appinfos = new XsdAppinfo[]{new XsdAppinfo(block_node)};
            }
            if (documentations != null || appinfos != null) {
                XsdAnnotation annotation = new XsdAnnotation(appinfos, documentations);
                element.setAnnotation(annotation);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return sdf_element;
    }

    private DrbNode createBlock(Descriptor desc, int occurs) {
        DrbNode array_node;
        DrbNode delim_node;
        DrbNode length_node;
        DrbNode footer_node;
        DrbNode header_node;
        DrbNode encoding_node;
        DrbNode offset_node;
        DrbNode occurs_node;
        DrbDefaultMutableNode block_node = new DrbDefaultMutableNode("block");
        block_node.setNamespaceURI(AbstractBlock.SDF_NAMESPACE);
        if (desc.fileNodePath != null) {
            DrbDefaultAttributeList block_attribs = new DrbDefaultAttributeList();
            block_attribs.add(new DrbDefaultAttribute("query", (Value)new String(desc.fileNodePath), block_node));
            block_node.setAttributes(block_attribs);
        }
        if ((desc.occurrenceCount.getType() != 1 || (long)occurs != desc.occurrenceCount.getValue()) && (occurs_node = this.createOccurrence(desc.occurrenceCount)) != null) {
            block_node.appendChild(occurs_node);
        }
        if (desc.blockOffset.specified && (offset_node = this.createOffset(desc.blockOffset)) != null) {
            block_node.appendChild(offset_node);
        }
        if ((encoding_node = this.createEncoding(desc)) != null) {
            block_node.appendChild(encoding_node);
        }
        if ((header_node = this.createHeaderPadding(desc)) != null) {
            block_node.appendChild(header_node);
        }
        if ((footer_node = this.createFooterPadding(desc)) != null) {
            block_node.appendChild(footer_node);
        }
        if (desc.contentLength.specified && (length_node = this.createLength(desc.contentLength)) != null) {
            block_node.appendChild(length_node);
        }
        if ((delim_node = this.createDelimiter(desc.delimiter)) != null) {
            block_node.appendChild(delim_node);
        }
        if (desc.valueType == 10 && (array_node = this.createArray(desc)) != null) {
            block_node.appendChild(array_node);
        }
        return block_node;
    }

    private DrbNode createArray(Descriptor desc) {
        DrbNode delim_node;
        DrbNode length_node;
        DrbDefaultMutableNode array_node = new DrbDefaultMutableNode("array");
        array_node.setNamespaceURI(AbstractBlock.SDF_NAMESPACE);
        DrbNode occurs_node = this.createOccurrence(desc.itemCount);
        if (occurs_node != null) {
            array_node.appendChild(occurs_node);
        }
        if ((length_node = this.createLength(desc.itemLength)) != null) {
            array_node.appendChild(length_node);
        }
        if ((delim_node = this.createDelimiter(desc.arrayDelimiter)) != null) {
            array_node.appendChild(delim_node);
        }
        return array_node;
    }

    private DrbNode createLength(LengthAttribute length) {
        DrbDefaultMutableNode length_node = new DrbDefaultMutableNode("length");
        length_node.setNamespaceURI(AbstractBlock.SDF_NAMESPACE);
        DrbDefaultAttributeList length_attribs = new DrbDefaultAttributeList();
        int length_unit = length.getUnit();
        boolean unbounded = false;
        if (length.query != null) {
            length_attribs.add(new DrbDefaultAttribute("query", (Value)new String(length.query), length_node));
            if (length.getOccurrenceType() == 1) {
                length_attribs.add(new DrbDefaultAttribute("constant", (Value)new Boolean(true), length_node));
            } else {
                length_attribs.add(new DrbDefaultAttribute("constant", (Value)new Boolean(false), length_node));
            }
        } else if (length.getType() == 1) {
            long len = length.getValue(null);
            if (length_unit == 1 && len % 8L == 0L) {
                len /= 8L;
                length_unit = 2;
            }
            length_node.setValue(new Long(len));
        } else {
            length_node.setValue(new String("unbounded"));
            unbounded = true;
            return null;
        }
        if (length_unit == 1 && !unbounded) {
            length_attribs.add(new DrbDefaultAttribute("unit", (Value)new String("bit"), length_node));
        }
        length_node.setAttributes(length_attribs);
        return length_node;
    }

    private DrbNode createOffset(OffsetAttribute offset) {
        DrbDefaultMutableNode offset_node = new DrbDefaultMutableNode("offset");
        offset_node.setNamespaceURI(AbstractBlock.SDF_NAMESPACE);
        DrbDefaultAttributeList offset_attribs = new DrbDefaultAttributeList();
        int offset_unit = offset.getUnit();
        if (offset.query != null) {
            offset_attribs.add(new DrbDefaultAttribute("query", (Value)new String(offset.query), offset_node));
            if (offset.getOccurrenceType() == 1) {
                offset_attribs.add(new DrbDefaultAttribute("constant", (Value)new Boolean(true), offset_node));
            } else {
                offset_attribs.add(new DrbDefaultAttribute("constant", (Value)new Boolean(false), offset_node));
            }
        } else if (offset.getType() == 1) {
            long len = offset.getValue(null);
            if (offset_unit == 1 && len % 8L == 0L) {
                len /= 8L;
                offset_unit = 2;
            }
            offset_node.setValue(new Long(len));
        }
        switch (offset.getOrigin()) {
            case 1: {
                offset_attribs.add(new DrbDefaultAttribute("origin", (Value)new String("root"), offset_node));
                break;
            }
            case 2: {
                offset_attribs.add(new DrbDefaultAttribute("origin", (Value)new String("parent"), offset_node));
            }
        }
        offset_node.setAttributes(offset_attribs);
        if (offset_unit == 1) {
            offset_attribs.add(new DrbDefaultAttribute("unit", (Value)new String("bit"), offset_node));
        }
        offset_node.setAttributes(offset_attribs);
        return offset_node;
    }

    private DrbNode createOccurrence(PhysicalAttribute occurs_count) {
        DrbDefaultMutableNode occurs_node = new DrbDefaultMutableNode("occurrence");
        occurs_node.setNamespaceURI(AbstractBlock.SDF_NAMESPACE);
        DrbDefaultAttributeList occurs_attribs = new DrbDefaultAttributeList();
        if (occurs_count.query != null) {
            occurs_attribs.add(new DrbDefaultAttribute("query", (Value)new String(occurs_count.query), occurs_node));
            if (occurs_count.getOccurrenceType() == 1) {
                occurs_attribs.add(new DrbDefaultAttribute("constant", (Value)new Boolean(true), occurs_node));
            } else {
                occurs_attribs.add(new DrbDefaultAttribute("constant", (Value)new Boolean(false), occurs_node));
            }
        } else if (occurs_count.getType() == 1) {
            long occurs = occurs_count.getValue(null);
            occurs_node.setValue(new Long(occurs));
        } else {
            occurs_node.setValue(new String("unbounded"));
        }
        occurs_node.setAttributes(occurs_attribs);
        return occurs_node;
    }

    private DrbNode createDelimiter(java.lang.String delimiter) {
        if (delimiter.length() == 0) {
            return null;
        }
        DrbDefaultMutableNode delim_node = new DrbDefaultMutableNode("delimiter");
        delim_node.setNamespaceURI(AbstractBlock.SDF_NAMESPACE);
        DrbDefaultAttributeList delim_attribs = new DrbDefaultAttributeList();
        delim_attribs.add(new DrbDefaultAttribute("value", (Value)new String(delimiter), delim_node));
        delim_node.setAttributes(delim_attribs);
        return delim_node;
    }

    private DrbNode createHeaderPadding(Descriptor desc) {
        if (desc.headerPadding.length == 0) {
            return null;
        }
        DrbDefaultMutableNode padding_node = new DrbDefaultMutableNode("padding");
        padding_node.setNamespaceURI(AbstractBlock.SDF_NAMESPACE);
        DrbDefaultAttributeList padding_attribs = new DrbDefaultAttributeList();
        padding_attribs.add(new DrbDefaultAttribute("type", (Value)new String("header"), padding_node));
        if (desc.headerPadding.content.length() > 0) {
            padding_attribs.add(new DrbDefaultAttribute("content", (Value)new String(desc.headerPadding.content), padding_node));
        }
        padding_node.setValue(new Int(desc.headerPadding.length));
        padding_node.setAttributes(padding_attribs);
        return padding_node;
    }

    private DrbNode createEncoding(Descriptor desc) {
        if (desc.valueType == -1) {
            return null;
        }
        DrbDefaultMutableNode encoding_node = new DrbDefaultMutableNode("encoding");
        encoding_node.setNamespaceURI(AbstractBlock.SDF_NAMESPACE);
        if (desc.getEncoding() == 2) {
            encoding_node.setValue(new String("ASCII"));
        } else if (desc.getEncoding() == 1) {
            encoding_node.setValue(new String("BINARY"));
        } else {
            return null;
        }
        return encoding_node;
    }

    private DrbNode createFooterPadding(Descriptor desc) {
        if (desc.footerPadding.length == 0) {
            return null;
        }
        DrbDefaultMutableNode padding_node = new DrbDefaultMutableNode("padding");
        padding_node.setNamespaceURI(AbstractBlock.SDF_NAMESPACE);
        DrbDefaultAttributeList padding_attribs = new DrbDefaultAttributeList();
        padding_attribs.add(new DrbDefaultAttribute("type", (Value)new String("footer"), padding_node));
        if (desc.footerPadding.content.length() > 0) {
            padding_attribs.add(new DrbDefaultAttribute("content", (Value)new String(desc.footerPadding.content), padding_node));
        }
        padding_node.setValue(new Int(desc.footerPadding.length));
        padding_node.setAttributes(padding_attribs);
        return padding_node;
    }

    public static void main(java.lang.String[] args) {
        DrbNode input_node = DrbFactory.open(args[0]);
        SdfSchemaBuilder xsd_builder = new SdfSchemaBuilder();
        XmlSchema xml_schema = ((XmlSchemaBuilder)xsd_builder).createSchema(input_node);
        XmlWriter.writeXML(xml_schema.toNode(), System.out);
    }
}

