/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.query;

import fr.gael.drb.DrbAbstractNode;
import fr.gael.drb.DrbAttribute;
import fr.gael.drb.DrbAttributeList;
import fr.gael.drb.DrbDefaultAttribute;
import fr.gael.drb.DrbDefaultAttributeList;
import fr.gael.drb.DrbDefaultSequence;
import fr.gael.drb.DrbItem;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbSequence;
import fr.gael.drb.query.AbstractExpression;
import fr.gael.drb.query.ConstructorNode;
import fr.gael.drb.query.DynamicContext;
import fr.gael.drb.query.DynamicException;
import fr.gael.drb.query.Expression;
import fr.gael.drb.query.QName;
import fr.gael.drb.query.Token;
import fr.gael.drb.value.String;
import fr.gael.drb.value.Value;
import fr.gael.drb.value.ValueArray;
import fr.gael.drb.xsd.Namespace;
import java.util.Vector;
import org.apache.log4j.Logger;

class ConstructorExpression
extends AbstractExpression {
    private static Logger logger = Logger.getLogger(ConstructorExpression.class);
    protected QName name = null;
    protected Vector expressions = new Vector();
    private Vector attributeNames = new Vector();
    private Vector attributeExpressions = new Vector();
    protected Namespace declaredNamespaces = new Namespace();
    java.lang.String elementDefaultNamespaceURI = null;
    private boolean is_string_value = false;

    public ConstructorExpression(Token token, java.lang.String name) {
        super("Element constructor", token);
        this.name = new QName(name);
    }

    public ConstructorExpression(java.lang.String name, Token token) {
        super(name, token);
    }

    public void addChildExpression(Expression child_expression) {
        this.expressions.add(child_expression);
    }

    public void addAttributeExpressions(java.lang.String name, Vector expressions) {
        QName attribute_name = new QName(name);
        this.attributeNames.add(attribute_name);
        this.attributeExpressions.add(expressions);
    }

    public void bindNamespace(java.lang.String prefix, java.lang.String uri) {
        this.declaredNamespaces.bind(prefix, uri);
    }

    public void bindNamespace(DynamicContext context, java.lang.String prefix, java.lang.String uri) {
        if (uri == null || prefix == null) {
            return;
        }
        java.lang.String element_uri = context.elementNamespace.resolveNamespace(prefix);
        if (element_uri != null) {
            if (!element_uri.equals(uri)) {
                this.declaredNamespaces.bind(prefix, uri);
                context.elementNamespace.bind(prefix, uri);
            }
        } else {
            this.declaredNamespaces.bind(prefix, uri);
            context.elementNamespace.bind(prefix, uri);
        }
    }

    public void setElementDefaultNamespaceURI(java.lang.String uri) {
        this.elementDefaultNamespaceURI = uri;
    }

    @Override
    public DrbSequence evaluate(DynamicContext outer_context) {
        DynamicContext context = new DynamicContext(outer_context);
        ConstructorNode node = new ConstructorNode(this.name.getLocalName());
        Namespace namespaces = context.getNamespace();
        if (namespaces != null) {
            namespaces.addNamespaces(this.declaredNamespaces);
        } else {
            context.setNamespace(this.declaredNamespaces);
        }
        context.elementNamespace.addNamespaces(this.declaredNamespaces);
        if (this.elementDefaultNamespaceURI != null) {
            context.setDefaultElementNamespaceURI(this.elementDefaultNamespaceURI);
        }
        this.setNodeURI(context, node, this.name);
        this.processAttributes(context, node);
        this.processContent(context, node);
        node.setNamespaceBindings(this.declaredNamespaces);
        return new DrbDefaultSequence(node);
    }

    protected void setNodeURI(DynamicContext context, ConstructorNode node, QName name) {
        Namespace namespace = context.getNamespace();
        if (name.getPrefix() == null && context.getDefaultElementNamespaceURI() != null) {
            java.lang.String prefix = namespace.resolvePrefix(context.getDefaultElementNamespaceURI());
            if (prefix != null && !prefix.equals("")) {
                this.bindNamespace(context, prefix, context.getDefaultElementNamespaceURI());
            }
            node.setNamespaceURI(context.getDefaultElementNamespaceURI());
        } else if (name.getPrefix() != null) {
            java.lang.String nURI = namespace.resolveNamespace(name.getPrefix());
            if (nURI == null) {
                throw new DynamicException(this, "XQDY0074 - The prefix \"" + name.getPrefix() + "\" has not been bound.");
            }
            node.setNamespaceURI(nURI);
            this.bindNamespace(context, namespace.resolvePrefix(nURI), nURI);
        }
    }

    protected void processContent(DynamicContext context, DrbNode node) {
        ValueArray array;
        StringBuffer content_final_string = new StringBuffer();
        StringBuffer value_final_string = new StringBuffer();
        DrbDefaultSequence content = new DrbDefaultSequence();
        DrbDefaultSequence valueArray = new DrbDefaultSequence();
        for (int iexpression = 0; iexpression < this.expressions.size(); ++iexpression) {
            DrbSequence expression_sequence = ((Expression)this.expressions.get(iexpression)).evaluate(context);
            if (expression_sequence == null) {
                logger.warn("Error while evaluating sub-expression #" + (iexpression + 1) + " value for element constructor " + this.name + ".");
                continue;
            }
            StringBuffer content_item_string = new StringBuffer();
            StringBuffer value_item_string = new StringBuffer();
            for (int iitem = 0; iitem < expression_sequence.getLength(); ++iitem) {
                DrbItem item = expression_sequence.getItem(iitem);
                if (item.getItemType() == 1) {
                    content_final_string.append(content_item_string);
                    if (content_final_string.length() != 0) {
                        content.addItem(new String(content_final_string.toString()));
                        content_final_string = new StringBuffer();
                        content_item_string = new StringBuffer();
                    }
                    if (!this.isStringValue()) {
                        value_final_string.append(value_item_string);
                        if (value_final_string.length() != 0) {
                            valueArray.addItem(new String(value_final_string.toString()));
                            value_final_string = new StringBuffer();
                            value_item_string = new StringBuffer();
                        }
                    }
                    if (this.expressions.get(iexpression) instanceof ConstructorExpression) {
                        node.appendChild((DrbNode)item);
                    } else {
                        ((DrbAbstractNode)node).appendReference((DrbNode)item);
                    }
                    content.addItem(item);
                    continue;
                }
                if (item.getItemType() == 2) {
                    DrbAttributeList list;
                    content_final_string.append(content_item_string);
                    if (content_final_string.length() != 0) {
                        content.addItem(new String(content_final_string.toString()));
                        content_final_string = new StringBuffer();
                        content_item_string = new StringBuffer();
                    }
                    if (!this.isStringValue()) {
                        value_final_string.append(value_item_string);
                        if (value_final_string.length() != 0) {
                            valueArray.addItem(new String(value_final_string.toString()));
                            value_final_string = new StringBuffer();
                            value_item_string = new StringBuffer();
                        }
                    }
                    if ((list = node.getAttributes()) == null) {
                        list = new DrbDefaultAttributeList();
                    }
                    this.checkExistingAttribute(list, (DrbAttribute)item);
                    list.addItem(list.getLength(), item);
                    node.setAttributes(list);
                    java.lang.String attr_uri = ((DrbAttribute)item).getNamespaceURI();
                    if (attr_uri == null) continue;
                    this.bindNamespace(context, context.getNamespace().resolvePrefix(attr_uri), attr_uri);
                    continue;
                }
                if (item.getItemType() == 3) {
                    Value item_value = (Value)item;
                    try {
                        if (iitem >= 1) {
                            content_item_string.append(this.getAdjacentTextNodeSeparator());
                        }
                        content_item_string.append(item_value.convertTo(7));
                        if (this.isStringValue()) {
                            if (value_item_string.length() != 0) {
                                value_item_string.append(this.getAdjacentTextNodeSeparator());
                            }
                            value_item_string.append(item_value.convertTo(7));
                            continue;
                        }
                        if (item_value instanceof String) {
                            if (value_item_string.length() != 0) {
                                value_item_string.append(this.getAdjacentTextNodeSeparator());
                            }
                            value_item_string.append(item_value);
                            continue;
                        }
                        value_final_string.append(value_item_string);
                        if (value_final_string.length() != 0) {
                            valueArray.addItem(new String(value_final_string.toString()));
                            value_final_string = new StringBuffer();
                            value_item_string = new StringBuffer();
                        }
                        valueArray.addItem(item_value);
                        continue;
                    }
                    catch (ClassCastException e) {
                        throw new DynamicException(this, "Unable to convert item #" + (iitem + 1) + " to string (element constructor " + this.name + ")");
                    }
                }
                logger.warn("Attribute items are not supported nested in an element constructor " + this.name + ".");
            }
            content_final_string.append(content_item_string);
            value_final_string.append(value_item_string);
        }
        if (content_final_string.length() != 0) {
            content.addItem(new String(content_final_string.toString()));
        }
        if (value_final_string.length() != 0) {
            valueArray.addItem(new String(value_final_string.toString()));
        }
        if ((array = valueArray.atomize()).length() != 0) {
            ((DrbAbstractNode)node).setValue(array.getLength() == 1 ? (Value)array.getItem(0) : array);
        }
    }

    private void processAttributes(DynamicContext context, DrbNode node) {
        DrbDefaultAttributeList attribute_list = null;
        for (int iattr = 0; iattr < this.attributeNames.size(); ++iattr) {
            DrbDefaultAttribute attribute = new DrbDefaultAttribute(((QName)this.attributeNames.get(iattr)).getLocalName(), null, node);
            Vector expressions = (Vector)this.attributeExpressions.get(iattr);
            boolean value_initialized = false;
            boolean concatenation_performed = false;
            if (expressions == null) {
                throw new DynamicException(this, "Invalid expression vector for attribute " + ((QName)this.attributeNames.get(iattr)).getName());
            }
            java.lang.String attribute_string = "";
            for (int iexpression = 0; iexpression < expressions.size(); ++iexpression) {
                Expression current_expression = (Expression)expressions.get(iexpression);
                if (current_expression == null) {
                    throw new DynamicException(this, "The nested expression #" + (iexpression + 1) + " of attribute \"" + ((QName)this.attributeNames.get(iattr)).getName() + "\" is null");
                }
                DrbSequence attribute_item = current_expression.evaluate(context);
                if (attribute_item != null) {
                    attribute_item = attribute_item.atomize();
                }
                if (attribute_item == null) {
                    throw new DynamicException(this, "Error while evaluating sub-expression #" + (iexpression + 1) + " value for attribute " + ((QName)this.attributeNames.get(iattr)).getName());
                }
                java.lang.String attribute_string_item = "";
                for (int iitem = 0; iitem < attribute_item.getLength(); ++iitem) {
                    DrbItem item = attribute_item.getItem(iitem);
                    if (item == null) {
                        throw new DynamicException(this, "Null item resulting from evaluation of attribute " + ((QName)this.attributeNames.get(iattr)).getName());
                    }
                    Value attribute_value = (Value)item;
                    if (attribute_value == null) {
                        throw new DynamicException(this, "Null value resulting from evaluation of attribute " + ((QName)this.attributeNames.get(iattr)).getName());
                    }
                    if (!value_initialized) {
                        attribute.setValue(attribute_value);
                        value_initialized = true;
                        attribute_string_item = attribute_string_item + ((String)attribute_value.convertTo(7)).toString();
                        continue;
                    }
                    try {
                        if (!attribute_string_item.equals("")) {
                            attribute_string_item = attribute_string_item + " ";
                        }
                        attribute_string_item = attribute_string_item + ((String)attribute_value.convertTo(7)).toString();
                    }
                    catch (ClassCastException e) {
                        throw new DynamicException(this, "XQ0052 - Unable to cast item #" + (iitem + 1) + " to string (attribute " + ((QName)this.attributeNames.get(iattr)).getName() + ")");
                    }
                    concatenation_performed = true;
                }
                attribute_string = attribute_string + attribute_string_item;
            }
            if (!value_initialized || concatenation_performed) {
                attribute.setValue(new String(attribute_string));
            }
            this.setAttributeURI(context, attribute, (QName)this.attributeNames.get(iattr));
            if (attribute_list == null) {
                attribute_list = new DrbDefaultAttributeList();
            }
            this.checkExistingAttribute(attribute_list, attribute);
            QName attr_name = (QName)this.attributeNames.get(iattr);
            if (attr_name.getPrefix() != null) {
                this.bindNamespace(context, context.getNamespace().resolvePrefix(attribute.getNamespaceURI()), attribute.getNamespaceURI());
            }
            attribute_list.add(attribute);
        }
        if (attribute_list != null) {
            node.setAttributes(attribute_list);
        }
    }

    private void checkExistingAttribute(DrbAttributeList attribute_list, DrbAttribute attribute) {
        for (int i = 0; i < attribute_list.getLength(); ++i) {
            DrbItem current_item = attribute_list.getItem(i);
            if (!current_item.getName().equals(attribute.getName())) continue;
            if (current_item.getNamespaceURI() == null && attribute.getNamespaceURI() == null) {
                throw new DynamicException(this, "XQDY0025 - Impossible to declare two attributes with the same name " + current_item.getName());
            }
            if (current_item.getNamespaceURI() == null || !current_item.getNamespaceURI().equals(attribute.getNamespaceURI())) continue;
            throw new DynamicException(this, "XQDY0025 - Impossible to declare two attributes with the same name " + current_item.getName());
        }
    }

    private void setAttributeURI(DynamicContext context, DrbDefaultAttribute attribute, QName name) {
        Namespace namespace = context.getNamespace();
        if (name.getPrefix() == null) {
            attribute.setNamespaceURI(null);
        } else if (name.getPrefix() != null) {
            java.lang.String nURI = namespace.resolveNamespace(name.getPrefix());
            if (nURI == null) {
                throw new DynamicException(this, "XQDY0074 - The prefix \"" + name.getPrefix() + "\" has not been bound.");
            }
            attribute.setNamespaceURI(nURI);
        }
    }

    public void setIsStringValue(boolean bool) {
        this.is_string_value = bool;
    }

    public boolean isStringValue() {
        return this.is_string_value;
    }

    protected java.lang.String getAdjacentTextNodeSeparator() {
        return " ";
    }

    public java.lang.String toString() {
        QName effective_name = this.name;
        if (this.name == null) {
            effective_name = new QName("unnamed");
        }
        java.lang.String output = "<" + this.name + ">\n   ";
        if (this.expressions.size() > 0) {
            for (int iexpression = 0; iexpression < this.expressions.size(); ++iexpression) {
                output = output + this.expressions.get(iexpression);
            }
        }
        output = output + "\n</" + this.name + ">";
        return output;
    }
}

