/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.xsd;

import fr.gael.drb.DrbDefaultAttribute;
import fr.gael.drb.DrbDefaultAttributeList;
import fr.gael.drb.DrbDefaultMutableNode;
import fr.gael.drb.DrbDefaultNodeList;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbNodeList;
import fr.gael.drb.value.Float;
import fr.gael.drb.value.Int;
import fr.gael.drb.value.Integer;
import fr.gael.drb.value.Value;
import fr.gael.drb.xsd.XsdAtomicType;
import fr.gael.drb.xsd.XsdComplexType;
import fr.gael.drb.xsd.XsdElement;
import fr.gael.drb.xsd.XsdInvalid;
import fr.gael.drb.xsd.XsdInvalidModelGroup;
import fr.gael.drb.xsd.XsdParticle;

public class XsdModelGroup
extends XsdParticle {
    static final String SEQUENCE_TAG = "sequence";
    static final String CHOICE_TAG = "choice";
    static final String ALL_TAG = "all";
    public static final int SEQUENCE_MODEL = 1;
    public static final int CHOICE_MODEL = 2;
    public static final int ALL_MODEL = 3;
    private XsdParticle[] content;
    private int compositor = 1;

    public XsdModelGroup(int minoccurs, int maxoccurs, XsdParticle[] content, int compositor) {
        super(minoccurs, maxoccurs);
        if (content == null) {
            content = new XsdParticle[]{};
        }
        this.content = content;
        this.compositor = compositor;
    }

    @Override
    public final boolean isNillable() {
        if (this.getMinOccurs() == 0) {
            return true;
        }
        for (int i = 0; i < this.content.length; ++i) {
            if (this.content[i].isNillable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int getTerm() {
        return 1;
    }

    public final int getCompositor() {
        return this.compositor;
    }

    final XsdParticle[] getContent() {
        return this.content;
    }

    public final XsdParticle getParticle(int index) {
        if (index < 0 || index >= this.content.length) {
            return null;
        }
        return this.content[index];
    }

    public final int getLength() {
        return this.content.length;
    }

    XsdModelGroup deriveByExtension(XsdModelGroup extension) {
        XsdParticle[] extcontent = null;
        int ext_compositor = this.getCompositor();
        int ext_min_occurs = this.getMinOccurs();
        int ext_max_occurs = this.getMaxOccurs();
        if (extension != null) {
            if (extension.getCompositor() != this.getCompositor() || this.getCompositor() != 1 || this.getMinOccurs() != 1 || this.getMaxOccurs() != 1) {
                if (this.content.length > 0) {
                    ext_compositor = 1;
                    ext_min_occurs = 1;
                    ext_max_occurs = 1;
                    extcontent = new XsdParticle[]{this, extension};
                } else {
                    ext_compositor = extension.getCompositor();
                    ext_min_occurs = extension.getMinOccurs();
                    ext_max_occurs = extension.getMaxOccurs();
                    extcontent = extension.content;
                }
            } else {
                extcontent = new XsdParticle[this.content.length + extension.content.length];
                System.arraycopy(extension.content, 0, extcontent, this.content.length, extension.content.length);
                System.arraycopy(this.content, 0, extcontent, 0, this.content.length);
            }
        } else {
            extcontent = new XsdParticle[this.content.length];
            System.arraycopy(this.content, 0, extcontent, 0, this.content.length);
        }
        return new XsdModelGroup(ext_min_occurs, ext_max_occurs, extcontent, ext_compositor);
    }

    XsdModelGroup deriveByRestriction(XsdModelGroup restriction) {
        XsdParticle[] rescontent = new XsdParticle[this.content.length];
        System.arraycopy(this.content, 0, rescontent, 0, this.content.length);
        int minoccurs = this.getMinOccurs();
        int maxoccurs = this.getMaxOccurs();
        if (restriction != null && restriction.getCompositor() == this.getCompositor()) {
            for (int i = 0; i < this.content.length; ++i) {
                XsdElement elti;
                if (!(this.content[i] instanceof XsdElement) || (elti = (XsdElement)this.content[i]).getName() == null) continue;
                for (int j = 0; j < restriction.content.length; ++j) {
                    int k;
                    if (!(restriction.content[j] instanceof XsdElement)) continue;
                    XsdElement eltj = (XsdElement)restriction.content[j];
                    if (!elti.getName().equals(eltj.getName())) continue;
                    XsdElement newelt = new XsdElement(eltj.getMinOccurs(), eltj.getMaxOccurs(), eltj.getName(), eltj.getType());
                    DrbDefaultNodeList nodelist = new DrbDefaultNodeList();
                    if (elti.getExternalNodes() != null) {
                        for (k = 0; k < elti.getExternalNodes().getLength(); ++k) {
                            nodelist.add(elti.getExternalNodes().item(k));
                        }
                    }
                    if (eltj.getExternalNodes() != null) {
                        for (k = 0; k < eltj.getExternalNodes().getLength(); ++k) {
                            nodelist.add(eltj.getExternalNodes().item(k));
                        }
                    }
                    newelt.setExternalNodes(nodelist);
                    rescontent[i] = newelt;
                }
            }
            if (restriction.getMinOccurs() > minoccurs) {
                minoccurs = restriction.getMinOccurs();
            }
            if (restriction.getMaxOccurs() < maxoccurs) {
                maxoccurs = restriction.getMaxOccurs();
            }
        }
        return new XsdModelGroup(minoccurs, maxoccurs, rescontent, this.getCompositor());
    }

    @Override
    DrbNode toNode() {
        String tag = SEQUENCE_TAG;
        switch (this.compositor) {
            case 1: {
                tag = SEQUENCE_TAG;
                break;
            }
            case 2: {
                tag = CHOICE_TAG;
            }
        }
        DrbDefaultMutableNode groupnode = new DrbDefaultMutableNode(tag);
        groupnode.setNamespaceURI("http://www.w3.org/2001/XMLSchema");
        DrbDefaultAttributeList attributes = new DrbDefaultAttributeList();
        if (this.getMinOccurs() != 1 && this.getMaxOccurs() != 0) {
            attributes.add(new DrbDefaultAttribute("minOccurs", (Value)new Int(this.getMinOccurs()), groupnode));
        }
        if (this.getMaxOccurs() != 1) {
            attributes.add(new DrbDefaultAttribute("maxOccurs", (Value)new Int(this.getMaxOccurs()), groupnode));
        }
        groupnode.setAttributes(attributes);
        if (this.content != null) {
            for (int i = 0; i < this.content.length; ++i) {
                DrbNode particlenode = this.content[i].toNode();
                if (particlenode == null) continue;
                groupnode.appendChild(particlenode);
            }
        }
        return groupnode;
    }

    @Override
    public XsdInvalid isValid(DrbNodeList nodelist) {
        XsdInvalidModelGroup invalid;
        if (nodelist == null) {
            nodelist = new DrbDefaultNodeList();
        }
        if (this.search(nodelist, 0, invalid = new XsdInvalidModelGroup(nodelist, this, 0, 0, 0)) == nodelist.getLength()) {
            return null;
        }
        return invalid;
    }

    @Override
    public int search(DrbNodeList nodelist, int start) {
        return this.search(nodelist, start, new XsdInvalidModelGroup(nodelist, this, start, start, 0));
    }

    int search(DrbNodeList nodelist, int start, XsdInvalidModelGroup invalid) {
        int occurs;
        if (nodelist == null) {
            nodelist = new DrbDefaultNodeList();
        }
        if (start < 0) {
            return -1;
        }
        int startindex = start;
        int endindex = start;
        for (occurs = 0; startindex < nodelist.getLength() && occurs < this.getMaxOccurs(); ++occurs) {
            block0 : switch (this.getCompositor()) {
                case 1: {
                    int i;
                    for (i = 0; i < this.content.length; ++i) {
                        invalid.setStopParticle(i);
                        int newendindex = this.content[i].search(nodelist, endindex);
                        if (newendindex < endindex) {
                            invalid.setStopIndex(endindex);
                            return -1;
                        }
                        invalid.setStopIndex(newendindex);
                        if (newendindex == endindex && !this.content[i].isNillable()) {
                            endindex = startindex;
                            break block0;
                        }
                        endindex = newendindex;
                    }
                    break;
                }
                case 2: {
                    int i;
                    invalid.setStopIndex(startindex);
                    invalid.setStopParticle(-1);
                    for (i = 0; i < this.content.length; ++i) {
                        int curendindex = this.content[i].search(nodelist, startindex);
                        if (curendindex < startindex || curendindex <= endindex) continue;
                        invalid.setStopParticle(i);
                        endindex = curendindex;
                    }
                    break;
                }
            }
            if (endindex < startindex) {
                return -1;
            }
            if (startindex == endindex) break;
            startindex = endindex;
        }
        if (!(occurs >= this.getMinOccurs() || occurs == 0 && this.isNillable())) {
            occurs = 0;
            endindex = start;
            return -1;
        }
        return endindex;
    }

    public static void main(String[] args) {
        System.out.println("Loading ...");
        System.out.println("   <xsd:element name='toto' type='point'/>\n");
        System.out.println("   <xsd:complexType name='point'>");
        System.out.println("     <xsd:sequence>");
        System.out.println("       <xsd:element name='x' type='xsd:float'");
        System.out.println("                    minOccurs='1' maxOccurs='1'/>");
        System.out.println("       <xsd:element name='y' type='xsd:int'");
        System.out.println("                    minOccurs='0' maxOccurs='1'/>");
        System.out.println("       <xsd:element name='z' type='xsd:int'");
        System.out.println("                    minOccurs='0' maxOccurs='1'/>");
        System.out.println("     </xsd:sequence>");
        System.out.println("   </xsd:complexType>");
        XsdAtomicType floattype = new XsdAtomicType(5, null);
        XsdAtomicType inttype = new XsdAtomicType(27, null);
        XsdElement xelt = new XsdElement(1, 1, "x", floattype);
        XsdElement yelt = new XsdElement(0, 1, "y", inttype);
        XsdElement zelt = new XsdElement(0, 1, "z", inttype);
        XsdModelGroup group = new XsdModelGroup(1, 1, new XsdParticle[]{xelt, yelt, zelt}, 1);
        XsdComplexType pointtype = new XsdComplexType("point", group, null);
        XsdElement pointelt = new XsdElement(1, 1, "toto", pointtype);
        DrbDefaultMutableNode node1 = new DrbDefaultMutableNode("toto");
        DrbDefaultMutableNode node1x = new DrbDefaultMutableNode("x");
        node1x.setValue(new Float(1.0f));
        node1.appendChild(node1x);
        DrbDefaultMutableNode node1y = new DrbDefaultMutableNode("y");
        node1y.setValue(new Integer(2));
        node1.appendChild(node1y);
        System.out.println("\n\nChecking \n" + node1 + " -> " + pointelt.isValid(node1));
        DrbDefaultMutableNode node2 = new DrbDefaultMutableNode("toto");
        DrbDefaultMutableNode node2y = new DrbDefaultMutableNode("y");
        node2y.setValue(new Integer(1));
        node2.appendChild(node2y);
        DrbDefaultMutableNode node2x = new DrbDefaultMutableNode("x");
        node2x.setValue(new Float(2.0f));
        node2.appendChild(node1x);
        System.out.println("\n\nChecking \n" + node2 + " -> " + pointelt.isValid(node2));
        DrbDefaultMutableNode node3 = new DrbDefaultMutableNode("toto");
        DrbDefaultMutableNode node3x = new DrbDefaultMutableNode("x");
        node3x.setValue(new Float(1.0f));
        node3.appendChild(node3x);
        System.out.println("\n\nChecking \n" + node3 + " -> " + pointelt.isValid(node3));
        DrbDefaultMutableNode node4 = new DrbDefaultMutableNode("toto");
        DrbDefaultMutableNode node4x = new DrbDefaultMutableNode("x");
        node4x.setValue(new Float(1.0f));
        node4.appendChild(node4x);
        node4.appendChild(node4x);
        System.out.println("\n\nChecking \n" + node4 + " -> " + pointelt.isValid(node4));
        DrbDefaultMutableNode node5 = new DrbDefaultMutableNode("toto");
        DrbDefaultMutableNode node5x = new DrbDefaultMutableNode("x");
        node5x.setValue(new Float(1.0f));
        node5.appendChild(node5x);
        DrbDefaultMutableNode node5z = new DrbDefaultMutableNode("z");
        node5z.setValue(new Integer(1));
        node5.appendChild(node5z);
        System.out.println("\n\nChecking \n" + node5 + " -> " + pointelt.isValid(node5));
    }
}

