/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.streams;

import fr.gael.streams.CacheUtils;
import fr.gael.streams.CachedFile;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.event.CacheEventListenerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TemporaryFilesCacheListener
extends CacheEventListenerFactory {
    private static Logger LOGGER = LogManager.getLogger(TemporaryFilesCacheListener.class);

    public CacheEventListener createCacheEventListener(Properties properties) {
        return new TemporaryFilesCacheEventListener();
    }

    private static class TemporaryFilesCacheEventListener
    implements CacheEventListener {
        private boolean cleanerStarted = false;

        private TemporaryFilesCacheEventListener() {
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public void notifyElementRemoved(Ehcache cache, Element element) throws CacheException {
        }

        public void notifyElementPut(Ehcache cache, Element element) throws CacheException {
            if (!"CACHE_SIZE".equals(element.getObjectKey())) {
                this.runEvictionIfNeeded(cache);
            }
        }

        public void notifyElementUpdated(Ehcache cache, Element element) throws CacheException {
            if ("CACHE_SIZE".equals(element.getObjectKey())) {
                this.runEvictionIfNeeded(cache);
            }
        }

        public void notifyElementExpired(Ehcache cache, Element element) {
            if (!"CACHE_SIZE".equals(element.getObjectKey())) {
                this.deleteFile(element);
            }
        }

        public void notifyElementEvicted(Ehcache cache, Element element) {
            if (!"CACHE_SIZE".equals(element.getObjectKey())) {
                this.deleteFile(element);
            }
        }

        public void notifyRemoveAll(Ehcache cache) {
        }

        public void dispose() {
        }

        private boolean checkEviction(Ehcache cache) {
            return (double)CacheUtils.getTotalSize() > 0.9 * (double)CacheUtils.MAX_SIZE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runEvictionIfNeeded(final Ehcache cache) {
            if (this.checkEviction(cache)) {
                List keys = cache.getKeys();
                final TreeSet<CachedFile> cachedFiles = new TreeSet<CachedFile>(new Comparator<CachedFile>(){

                    @Override
                    public int compare(CachedFile file1, CachedFile file2) {
                        return file1.getLastAccess().compareTo(file2.getLastAccess());
                    }
                });
                long currentSize = 0L;
                for (String key : keys) {
                    CachedFile cachedFile;
                    Element cachedElement;
                    if ("CACHE_SIZE".equals(key) || (cachedElement = cache.get((Serializable)((Object)key))) == null || (cachedFile = (CachedFile)cachedElement.getObjectValue()) == null) continue;
                    cachedFiles.add(cachedFile);
                    currentSize += cachedFile.getSize().longValue();
                }
                final long size = currentSize;
                if ((double)size > 0.9 * (double)CacheUtils.MAX_SIZE) {
                    TemporaryFilesCacheEventListener temporaryFilesCacheEventListener = this;
                    synchronized (temporaryFilesCacheEventListener) {
                        if (!this.cleanerStarted) {
                            Thread t = new Thread("StreamCacheCleaner"){

                                @Override
                                public void run() {
                                    long cSize = size;
                                    while ((double)cSize > 0.8 * (double)CacheUtils.MAX_SIZE) {
                                        LOGGER.info("Cache is full, removing first element - size = " + cSize);
                                        CachedFile polledCachedFile = (CachedFile)cachedFiles.pollFirst();
                                        if (polledCachedFile == null) {
                                            cleanerStarted = false;
                                            return;
                                        }
                                        String key = polledCachedFile.getFileName();
                                        LOGGER.info("Removing " + polledCachedFile.getFileName());
                                        if (!this.deleteFile(cache.get((Serializable)((Object)key)))) continue;
                                        cSize -= polledCachedFile.getSize().longValue();
                                        CacheUtils.updateTotalSize(-polledCachedFile.getSize().longValue());
                                        cache.remove((Serializable)((Object)key));
                                    }
                                    cleanerStarted = false;
                                }
                            };
                            this.cleanerStarted = true;
                            t.start();
                        }
                    }
                }
            }
        }

        private boolean deleteFile(Element element) {
            Object value = element.getObjectKey();
            if (value instanceof String) {
                String fileName = (String)value;
                Path path = Paths.get(CacheUtils.getCompleteFileName(fileName), new String[0]);
                LOGGER.info("DELETING : " + path);
                CacheUtils.deregisterAndCloseOpenedStream(fileName);
                for (int i = 0; i <= 2; ++i) {
                    boolean deleted = path.toFile().delete();
                    if (deleted) {
                        LOGGER.info("DELETED : " + path);
                    }
                    path = path.getParent();
                }
                return true;
            }
            return false;
        }
    }
}

