/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.sdf;

import fr.gael.drb.DrbAttribute;
import fr.gael.drb.DrbAttributeList;
import fr.gael.drb.DrbItem;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbNodeList;
import fr.gael.drb.DrbSequence;
import fr.gael.drb.impl.sdf.AbstractBlock;
import fr.gael.drb.impl.sdf.BlockTools;
import fr.gael.drb.impl.sdf.DefaultBlock;
import fr.gael.drb.impl.sdf.IntMap;
import fr.gael.drb.impl.sdf.PhysicalAttribute;
import fr.gael.drb.impl.sdf.RandomAccessData;
import fr.gael.drb.query.Query;
import fr.gael.drb.value.Int;
import fr.gael.drb.value.Value;
import fr.gael.drb.value.ValueFormat;
import fr.gael.drb.xsd.XsdElement;
import fr.gael.drb.xsd.XsdSimpleType;
import fr.gael.drb.xsd.XsdType;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

class Descriptor {
    protected static final int MAX_BUFFER_SIZE = 10240;
    protected static final int UNIT_BIT = 1;
    protected static final int UNIT_BYTE = 2;
    protected static final int ENCODING_BINARY = 1;
    protected static final int ENCODING_ASCII = 2;
    protected static final int ENCODING_EBCDIC = 3;
    private static Logger logger = Logger.getLogger(Descriptor.class);
    protected PhysicalAttribute occurrenceCount;
    protected PhysicalAttribute offset;
    protected int bitOffset;
    protected PhysicalAttribute length;
    protected int bitLength;
    protected String occurrenceCountQuery;
    protected boolean occurrenceCountQueryConstant;
    protected boolean occurrenceCountFromParent;
    protected Query occurrenceCountQueryObject;
    protected DrbNode contextNode;
    protected String offsetQuery;
    protected String lengthQuery;
    protected Query lengthQueryObject;
    protected boolean lengthQueryConstant;
    protected int lengthQuerySolvedId;
    protected String documentation;
    private RandomAccessData file;
    private DrbNode baseNode;
    private String schemaNodePath;
    private Descriptor root;
    private Descriptor parent;
    private ArrayList children;
    private Descriptor previousSibling;
    private Descriptor nextSibling;
    private String name;
    private String fullName;
    private XsdElement nodeDesc;
    private XsdType type;
    private int valueType;
    private int arrayValueType;
    private int arraySize;
    private long arrayElementSize;
    private boolean singleAncestors;
    private int offsetFromPreviousSibling;
    private int headerPadding;
    private String headerPaddingContent;
    private int footerPadding;
    private String footerPaddingContent;
    private int encoding;

    protected Descriptor(RandomAccessData file, String name, String full_name) {
        this.name = name;
        this.fullName = full_name;
        this.file = file;
        this.encoding = 1;
        this.valueType = -2;
        this.arrayValueType = -2;
        this.arraySize = 0;
        this.arrayElementSize = 0L;
        this.children = new ArrayList();
        this.occurrenceCount = new PhysicalAttribute();
        this.offset = new PhysicalAttribute();
        this.bitOffset = 0;
        this.length = new PhysicalAttribute();
        this.bitLength = 0;
        this.offsetFromPreviousSibling = 0;
        this.headerPadding = 0;
        this.footerPadding = 0;
        this.singleAncestors = true;
        this.occurrenceCountQueryConstant = true;
        this.occurrenceCountFromParent = false;
        this.lengthQueryConstant = true;
        this.lengthQuerySolvedId = 0;
    }

    protected Descriptor(RandomAccessData file, boolean create_mode, XsdElement node, int depth) {
        this(file, node.getName() != null ? node.getName() : "", "");
        logger.debug("New Descriptor \"" + this.name + "\"");
        this.setSchema(node);
        XsdType nodeType = node.getType();
        XsdSimpleType valueType = nodeType.getDatatype();
        if (valueType != null) {
            this.setValueType(valueType.getTypeId());
        } else {
            this.setValueType(-1);
        }
        logger.debug("Parse structure external children");
        if (!this.parseExternalChildren(node.getName(), nodeType.getExternalNodes())) {
            logger.error("fr.gael.drb.impl.sdf.Descriptor.Descriptor(file, node) : Error while parsing structure external children for node \"" + node.getName() + "\".");
            logger.error("   Descriptor may be inconsistent and cause wrong data access in file.");
        }
        logger.debug("Parse node external children");
        if (!this.parseExternalChildren(node.getName(), node.getExternalNodes())) {
            logger.error("fr.gael.drb.impl.sdf.Descriptor.Descriptor(file, node) : Error while parsing external children for node \"" + node.getName() + "\".");
            logger.error("   Descriptor may be inconsistent and cause wrong data access in file.");
        }
        long length = this.length.getValue(null);
        logger.debug("Get current length (" + this.name + ")= " + length);
        if (this.valueType == 10) {
            logger.debug("Case of array");
            if (length == -1L) {
                logger.warn("fr.gael.drb.impl.sdf.Descriptor.Descriptor(file, node) : Will be unable to solve array element size for \"" + this.name + "\".");
                this.arrayElementSize = 0L;
            } else {
                this.arrayElementSize = length;
                this.setLength(null, -1L);
            }
            if (this.occurrenceCountQuery != null) {
                logger.debug("Swap occurrence count query to length query");
                this.lengthQuery = this.occurrenceCountQuery;
                this.occurrenceCountQuery = null;
                this.lengthQueryConstant = this.occurrenceCountQueryConstant;
                this.occurrenceCountQueryConstant = true;
            } else if (this.arraySize == -1) {
                logger.warn("fr.gael.drb.impl.sdf.Descriptor.Descriptor(file, node) : Will be unable to solve array size for \"" + this.name + "\".");
            } else {
                length = (long)this.arraySize * this.arrayElementSize;
            }
        }
        if (!this.occurrenceCountQueryConstant) {
            this.setOccurrenceCountType(3);
        } else {
            this.setOccurrenceCountType(1);
            if (this.occurrenceCountQuery == null && this.occurrenceCount.getValue(null) == -1L) {
                logger.debug("Set occurrence count to default value (1)");
                this.setOccurrenceCount(null, 1L);
            }
        }
        if (!this.lengthQueryConstant) {
            logger.debug("Length query is not constant, set type to VARIABLE");
            this.setLengthType(3);
        } else if (this.lengthQuery == null && this.getLengthType() != -1) {
            logger.debug("Set length to FIXED");
            length = length + (long)this.headerPadding + (long)this.footerPadding;
            this.setLengthType(1);
            this.setLength(null, length);
        }
        if (create_mode) {
            logger.debug("Case of 0 byte size file");
            if (depth == 1) {
                this.setOccurrenceCountType(1);
                this.setOccurrenceCount(null, 0L);
            } else {
                this.setOccurrenceCountType(2);
                this.occurrenceCountQuery = null;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("+++ " + this.name + " : occCount = " + this.occurrenceCount + ", length = " + this.length + ", arraySize = " + this.arraySize + ", arrayElementSize = " + this.arrayElementSize + ", occConst=" + this.occurrenceCountQueryConstant + ", occFromParent=" + this.occurrenceCountFromParent + ", lenConst=" + this.lengthQueryConstant);
        }
    }

    private int parseUnit(DrbAttribute attribute) {
        logger.debug("parseUnit()");
        Value attributeValue = null;
        try {
            attributeValue = attribute.getValue();
            if (attributeValue == null) {
                logger.error("fr.gael.drb.impl.sdf.Descriptor.parseUnit() : Unit attribute value is null.");
                return -1;
            }
            String attributeValueStr = attributeValue.toString();
            if (attributeValueStr.equals("byte")) {
                return 2;
            }
            if (attributeValueStr.equals("bit")) {
                return 1;
            }
            logger.error("fr.gael.drb.impl.sdf.Descriptor.parseUnit() : Unknown unit attribute value (" + attributeValueStr + ").");
            return -1;
        }
        catch (ClassCastException e) {
            logger.error("fr.gael.drb.impl.sdf.Descriptor.parseUnit() : Error while extracting unit attribute value (" + attributeValue + ").");
            logger.error("   " + e);
            return -1;
        }
    }

    private boolean parseLength(DrbNode node) {
        logger.debug("parseLength()");
        Value nodeValue = null;
        Value attributeValue = null;
        int nbAttribute = 0;
        DrbAttributeList attributeList = node.getAttributes();
        boolean bitLengthUnit = false;
        boolean lengthQueryDefined = false;
        if (attributeList != null && (nbAttribute = attributeList.getLength()) > 0) {
            block8: for (int j = 0; j < nbAttribute; ++j) {
                DrbAttribute attribute = attributeList.item(j);
                if (attribute.getName().equals("unit")) {
                    switch (this.parseUnit(attribute)) {
                        case 2: {
                            bitLengthUnit = false;
                            continue block8;
                        }
                        case 1: {
                            bitLengthUnit = true;
                            continue block8;
                        }
                        default: {
                            logger.error("fr.gael.drb.impl.sdf.Descriptor.parseLength() : Error while parsing unit attribute.");
                            return false;
                        }
                    }
                }
                if (attribute.getName().equals("query")) {
                    try {
                        attributeValue = attribute.getValue();
                        if (attributeValue == null) {
                            logger.error("fr.gael.drb.impl.sdf.Descriptor.parseLength() : Length query attribute value is null.");
                            return false;
                        }
                        this.lengthQuery = attributeValue.toString();
                        lengthQueryDefined = true;
                        continue;
                    }
                    catch (ClassCastException e) {
                        logger.error("fr.gael.drb.impl.sdf.Descriptor.parseLength() : Error while extracting length query attribute value (" + attributeValue + ").");
                        logger.error("   " + e);
                        return false;
                    }
                }
                logger.error("fr.gael.drb.impl.sdf.Descriptor.parseLength() : Unknown length attribute (" + attribute.getName() + ").");
                return false;
            }
        }
        if (!lengthQueryDefined) {
            try {
                nodeValue = node.getValue();
                if (nodeValue == null) {
                    logger.error("fr.gael.drb.impl.sdf.Descriptor.parseLength() : Length value is null.");
                    return false;
                }
                int length = ((Int)nodeValue.convertTo(3)).intValue();
                this.setLengthType(1);
                if (bitLengthUnit) {
                    if (length > 32) {
                        logger.error("fr.gael.drb.impl.sdf.Descriptor.parseLength() : Length value greater than 32 bits is not supported yet.");
                    }
                    this.bitLength = length % 8;
                    this.setLength(null, length / 8);
                } else {
                    this.bitLength = 0;
                    this.setLength(null, length);
                }
            }
            catch (ClassCastException e) {
                logger.error("fr.gael.drb.impl.sdf.Descriptor.parseLength() : Error while extracting length value (" + nodeValue + ").");
                logger.error("   " + e);
                return false;
            }
        }
        return true;
    }

    private boolean parseEncoding(DrbNode node) {
        logger.debug("parseEncoding()");
        Value nodeValue = null;
        nodeValue = node.getValue();
        if (nodeValue == null) {
            logger.error("fr.gael.drb.impl.sdf.Descriptor.parseEncoding() : Encoding value is null.");
            return false;
        }
        String tmpString = nodeValue.toString();
        if (tmpString.equals("ASCII")) {
            this.encoding = 2;
        } else if (tmpString.equals("BINARY")) {
            this.encoding = 1;
        } else if (tmpString.equals("EBCDIC")) {
            this.encoding = 3;
        } else {
            logger.error("fr.gael.drb.impl.sdf.Descriptor.parseEncoding() : Unknown encoding value (" + tmpString + ").");
            return false;
        }
        return true;
    }

    private boolean parseBlock(DrbNode node) {
        logger.debug("parseBlock()");
        for (int i = 0; i < node.getChildrenCount(); ++i) {
            DrbNode nodeChild = node.getChildAt(i);
            String nodeName = nodeChild.getName();
            if (nodeName.equals("occurrence")) {
                if (this.parseOccurrence(nodeChild)) continue;
                logger.error("fr.gael.drb.impl.sdf.Descriptor.parseBlock() : Error while parsing occurrence node.");
                return false;
            }
            if (nodeName.equals("length")) {
                if (this.parseLength(nodeChild)) continue;
                logger.error("fr.gael.drb.impl.sdf.Descriptor.parseBlock() : Error while parsing length node.");
                return false;
            }
            if (nodeName.equals("offset")) {
                if (this.parseOffset(nodeChild)) continue;
                logger.error("fr.gael.drb.impl.sdf.Descriptor.parseBlock() : Error while parsing offset node.");
                return false;
            }
            if (nodeName.equals("padding")) {
                if (this.parsePadding(nodeChild)) continue;
                logger.error("fr.gael.drb.impl.sdf.Descriptor.parseBlock() : Error while parsing padding node.");
                return false;
            }
            if (nodeName.equals("encoding")) {
                if (this.parseEncoding(nodeChild)) continue;
                logger.error("fr.gael.drb.impl.sdf.Descriptor.parseBlock() : Error while parsing encoding node.");
                return false;
            }
            logger.warn("fr.gael.drb.impl.sdf.Descriptor.parseBlock() : Unknown element \"" + nodeName + "\", ignored.");
        }
        return true;
    }

    private boolean parseOccurrence(DrbNode node) {
        logger.debug("parseOccurrence()");
        Value nodeValue = null;
        Value attributeValue = null;
        int nbAttribute = 0;
        DrbAttributeList attributeList = node.getAttributes();
        if (attributeList != null && (nbAttribute = attributeList.getLength()) > 0) {
            for (int j = 0; j < nbAttribute; ++j) {
                DrbAttribute attribute = attributeList.item(j);
                if (attribute.getName().equals("query")) {
                    try {
                        attributeValue = attribute.getValue();
                        if (attributeValue == null) {
                            logger.error("fr.gael.drb.impl.sdf.Descriptor.parseOccurrence() : Occurrence query attribute value is null.");
                            return false;
                        }
                        this.occurrenceCountQuery = attributeValue.toString();
                        logger.debug("   occurrenceCountQuery=[" + this.occurrenceCountQuery + "]");
                        if (this.valueType != 0 && this.valueType != 12 && this.valueType != 1 && this.valueType != 6 && this.valueType != 5 && this.valueType != 14 && this.valueType != 3 && this.valueType != 15 && this.valueType != 4 && this.valueType != 13 && this.valueType != 2) continue;
                        logger.debug("   Consider as array");
                        this.arrayValueType = this.valueType;
                        this.arraySize = -1;
                        this.valueType = 10;
                        continue;
                    }
                    catch (ClassCastException e) {
                        logger.error("fr.gael.drb.impl.sdf.Descriptor.parseOccurrence() : Error while extracting occurrence query attribute value (" + attributeValue + ").");
                        logger.error("   " + e);
                        return false;
                    }
                }
                if (attribute.getName().equals("constant")) {
                    try {
                        attributeValue = attribute.getValue();
                        if (attributeValue == null) {
                            logger.error("fr.gael.drb.impl.sdf.Descriptor.parseOccurrence():Occurrence constant attribute value is null.");
                            return false;
                        }
                        if (attributeValue.toString().equals("false")) {
                            this.occurrenceCountQueryConstant = false;
                            continue;
                        }
                        this.occurrenceCountQueryConstant = true;
                        continue;
                    }
                    catch (ClassCastException e) {
                        logger.error("fr.gael.drb.impl.sdf.Descriptor.parseOccurrence() : Error while extracting occurrence constant  attribute value (" + attributeValue + ").");
                        logger.error("   " + e);
                        return false;
                    }
                }
                if (attribute.getName().equals("parent")) {
                    try {
                        attributeValue = attribute.getValue();
                        if (attributeValue == null) {
                            logger.error("fr.gael.drb.impl.sdf.Descriptor.parseOccurrence():Occurrence parent attribute value is null.");
                            return false;
                        }
                        if (!attributeValue.toString().equals("true")) continue;
                        this.occurrenceCountFromParent = true;
                        continue;
                    }
                    catch (ClassCastException e) {
                        logger.error("fr.gael.drb.impl.sdf.Descriptor.parseOccurrence() : Error while extracting occurrence parent  attribute value (" + attributeValue + ").");
                        logger.error("   " + e);
                        return false;
                    }
                }
                logger.error("fr.gael.drb.impl.sdf.Descriptor.parseOccurrence() : Unknown occurrence attribute name (" + attribute.getName() + ").");
                return false;
            }
        } else {
            try {
                nodeValue = node.getValue();
                if (nodeValue == null) {
                    logger.error("fr.gael.drb.impl.sdf.Descriptor.parseOccurrence() : Occurrence value is null.");
                    return false;
                }
                int occurrence = ((Int)nodeValue.convertTo(3)).intValue();
                if (occurrence > 1 && (this.valueType == 0 || this.valueType == 12 || this.valueType == 1 || this.valueType == 6 || this.valueType == 5 || this.valueType == 14 || this.valueType == 3 || this.valueType == 15 || this.valueType == 4 || this.valueType == 13 || this.valueType == 2)) {
                    this.arrayValueType = this.valueType;
                    this.arraySize = occurrence;
                    this.valueType = 10;
                    this.setOccurrenceCountType(1);
                    this.setOccurrenceCount(null, 1L);
                }
                this.setOccurrenceCountType(1);
                this.setOccurrenceCount(null, occurrence);
            }
            catch (ClassCastException e) {
                logger.error("fr.gael.drb.impl.sdf.Descriptor.parseOccurrence() : Error while extracting occurrence value (" + nodeValue + ").");
                logger.error("   " + e);
                return false;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("   query=" + (this.occurrenceCountQuery != null) + ", constant=" + this.occurrenceCountQueryConstant + ", fromParent=" + this.occurrenceCountFromParent + ", array=" + (this.valueType == 10) + ", occurrence=" + this.occurrenceCount);
        }
        return true;
    }

    private boolean parsePadding(DrbNode node) {
        logger.debug("parsePadding()");
        Value nodeValue = null;
        Value attributeValue = null;
        String content = "";
        boolean headerType = false;
        int nbAttribute = 0;
        DrbAttributeList attributeList = node.getAttributes();
        if (attributeList == null || (nbAttribute = attributeList.getLength()) == 0) {
            logger.error("fr.gael.drb.impl.sdf.Descriptor.parsePadding() : Missing padding attribute.");
            return false;
        }
        for (int j = 0; j < nbAttribute; ++j) {
            DrbAttribute attribute = attributeList.item(j);
            if (attribute.getName().equals("type")) {
                try {
                    attributeValue = attribute.getValue();
                    if (attributeValue == null) {
                        logger.error("fr.gael.drb.impl.sdf.Descriptor.parsePadding() : Padding type attribute value is null.");
                        return false;
                    }
                    nodeValue = node.getValue();
                    if (nodeValue == null) {
                        logger.error("fr.gael.drb.impl.sdf.Descriptor.parsePadding() : Padding value is null.");
                        return false;
                    }
                    int padding = ((Int)nodeValue.convertTo(3)).intValue();
                    if (attributeValue.toString().equals("header")) {
                        headerType = true;
                        this.headerPadding += padding;
                        continue;
                    }
                    if (attributeValue.toString().equals("footer")) {
                        headerType = false;
                        this.footerPadding += padding;
                        continue;
                    }
                    logger.error("fr.gael.drb.impl.sdf.Descriptor.parsePadding() : Unknown padding attribute value (" + attributeValue + ").");
                    return false;
                }
                catch (ClassCastException e) {
                    logger.error("fr.gael.drb.impl.sdf.Descriptor.parsePadding() : Error while extracting padding value (" + nodeValue + ").");
                    logger.error("   " + e);
                    return false;
                }
            }
            if (attribute.getName().equals("content")) {
                try {
                    attributeValue = attribute.getValue();
                    if (attributeValue == null) {
                        logger.error("fr.gael.drb.impl.sdf.Descriptor.parsePadding() : Padding content attribute value is null.");
                        return false;
                    }
                    content = attributeValue.toString();
                    continue;
                }
                catch (ClassCastException e) {
                    logger.error("fr.gael.drb.impl.sdf.Descriptor.parsePadding() : Error while extracting padding content value (" + nodeValue + ").");
                    logger.error("   " + e);
                    return false;
                }
            }
            logger.error("fr.gael.drb.impl.sdf.Descriptor.parsePadding() : Unknown padding attribute name (" + attribute.getName() + ").");
            return false;
        }
        if (headerType) {
            this.headerPaddingContent = content;
        } else {
            this.footerPaddingContent = content;
        }
        return true;
    }

    private boolean parseAnnotation(DrbNode node) {
        logger.debug("parseAnnotation()");
        for (int i = 0; i < node.getChildrenCount(); ++i) {
            DrbNode nodeChild = node.getChildAt(i);
            if (!nodeChild.getName().equals("documentation") || this.parseDocumentation(nodeChild)) continue;
            logger.error("fr.gael.drb.impl.sdf.Descriptor.parseAnnotation() : Error while parsing documentation node.");
            return false;
        }
        return true;
    }

    private boolean parseDocumentation(DrbNode node) {
        logger.debug("parseDocumentation()");
        Value nodeValue = null;
        try {
            String tmpString;
            nodeValue = node.getValue();
            if (nodeValue == null) {
                logger.error("fr.gael.drb.impl.sdf.Descriptor.parseDocumentation() : Documentation value is null.");
                return false;
            }
            this.documentation = tmpString = nodeValue.toString();
        }
        catch (ClassCastException e) {
            logger.error("fr.gael.drb.impl.sdf.Descriptor.parseDocumentation() : Error while extracting documentation value (" + nodeValue + ").");
            logger.error("   " + e);
            return false;
        }
        return true;
    }

    private boolean parseOffset(DrbNode node) {
        logger.debug("parseOffset()");
        Value nodeValue = null;
        try {
            nodeValue = node.getValue();
            if (nodeValue == null) {
                logger.error("fr.gael.drb.impl.sdf.Descriptor.parseOffset() : Offset value is null.");
                return false;
            }
            this.offsetFromPreviousSibling = ((Int)nodeValue.convertTo(3)).intValue();
        }
        catch (ClassCastException e) {
            logger.error("fr.gael.drb.impl.sdf.Descriptor.parseOffset() : Error while extracting offset value (" + nodeValue + ").");
            logger.error("   " + e);
            return false;
        }
        return true;
    }

    private boolean parseExternalChildren(String parsed_node_name, DrbNodeList external_children) {
        logger.debug("parseExternalChildren(" + parsed_node_name + ")");
        if (external_children == null) {
            return true;
        }
        for (int i = 0; i < external_children.getLength(); ++i) {
            DrbNode nodeChild = external_children.item(i);
            String nodeName = nodeChild.getName();
            if (nodeName.equals("block")) {
                if (this.parseBlock(nodeChild)) continue;
                logger.warn("fr.gael.drb.impl.sdf.Descriptor.parseExternalChildren() : Error while parsing block information in node \"" + parsed_node_name + "\", ignored.");
                return false;
            }
            if (!nodeName.equals("annotation") || this.parseAnnotation(nodeChild)) continue;
            logger.warn("fr.gael.drb.impl.sdf.Descriptor.parseExternalChildren():Error while parsing annotation in node \"" + parsed_node_name + "\", ignored.");
            return false;
        }
        return true;
    }

    protected final String getDocumentation() {
        return this.documentation;
    }

    protected final RandomAccessData getFile() {
        return this.file;
    }

    protected final void dispose() {
        try {
            if (this.file != null) {
                this.file.close();
            }
        }
        catch (IOException e) {
            logger.error("fr.gael.drb.impl.sdf.Descriptor : Cannot close the file.");
        }
    }

    protected final boolean isSingleOccurrence(int[] key) {
        if (logger.isDebugEnabled()) {
            logger.debug("<" + this.name + ">.isSingleOccurrence(" + IntMap.keyToString(key) + ")");
        }
        return this.singleAncestors && this.getOccurrenceCount(key) == 1;
    }

    protected final int getValueType() {
        return this.valueType;
    }

    protected final XsdType getType() {
        return this.type;
    }

    protected final XsdElement getSchema() {
        return this.nodeDesc;
    }

    protected final void setValueType(int valueType) {
        this.valueType = valueType;
    }

    protected final void setSchema(XsdElement node_desc) {
        this.nodeDesc = node_desc;
        if (node_desc != null && node_desc.getType() != null) {
            this.type = node_desc.getType();
        }
    }

    protected final String getName() {
        return this.name;
    }

    protected final String getFullName() {
        return this.fullName;
    }

    protected int getChildrenCount() {
        return this.children.size();
    }

    protected int getEncoding() {
        return this.encoding;
    }

    protected final Value getValue(int[] key) {
        long offset;
        long length;
        if (logger.isDebugEnabled()) {
            logger.debug("<" + this.name + ">.getValue(" + IntMap.keyToString(key) + ")");
        }
        if ((length = this.getLength(key)) == -1L) {
            logger.info("fr.gael.drb.impl.sdf.Descriptor.getValue() : length is UNKNOWN.");
        }
        if (this.valueType == 10 && this.arrayElementSize > 0L && length >= 0L) {
            this.arraySize = (int)(length / this.arrayElementSize);
        }
        if ((offset = this.getOffset(key)) == -1L) {
            logger.info("fr.gael.drb.impl.sdf.Descriptor.getValue() : offset is UNKNOWN.");
        }
        try {
            BlockTools blockTools = new BlockTools();
            Value value = blockTools.extractValue(this.file, offset + (long)this.headerPadding, this.bitOffset, (int)(length - (long)(this.headerPadding + this.footerPadding)), this.bitLength, this.encoding, this.valueType, this.arrayValueType, this.arraySize);
            blockTools = null;
            return value;
        }
        catch (EOFException e) {
            logger.error(e);
            logger.error("Descriptor.getValue(): Unable to read value for node \"" + this.name + "\" (key=" + IntMap.keyToString(key) + ").");
        }
        catch (IOException e) {
            logger.error(e);
            logger.error("Descriptor.getValue(): Unable to read value for node \"" + this.name + "\" (key=" + IntMap.keyToString(key) + ").");
        }
        return null;
    }

    protected Value setValue(Value value, int[] key) throws UnsupportedOperationException {
        long length;
        Value output_value;
        if (logger.isDebugEnabled()) {
            logger.debug("<" + this.name + ">.setValue([" + value + "], " + IntMap.keyToString(key) + ")");
        }
        if (value == null) {
            throw new NullPointerException("Descriptor.setValue(): the value to set is null.");
        }
        if (value != null && value.getType() != this.valueType) {
            try {
                output_value = value.convertTo(this.valueType);
            }
            catch (ClassCastException exception) {
                logger.error(this.name + " : Cannot convert value (type = #" + value.getType() + ") to output type #" + this.valueType + ".");
                output_value = null;
            }
        } else {
            output_value = value;
        }
        if ((length = this.getLength(key)) == -1L) {
            throw new UnsupportedOperationException("Descriptor.setValue(): length is UNKNOWN.");
        }
        long valueLength = length - (long)this.headerPadding - (long)this.footerPadding;
        long offset = this.getOffset(key);
        if (offset == -1L) {
            throw new UnsupportedOperationException("Descriptor.setValue(): offset is UNKNOWN.");
        }
        try {
            if (this.encoding == 2) {
                this.file.seek(offset - (long)this.offsetFromPreviousSibling);
                String outString = Descriptor.getFixedString("", this.offsetFromPreviousSibling, ' ');
                outString = outString + Descriptor.getFixedString(this.headerPaddingContent, this.headerPadding, ' ');
                outString = output_value == null ? outString + Descriptor.getFixedString(null, (int)valueLength, ' ') : (output_value instanceof ValueFormat ? outString + Descriptor.getFixedString(((ValueFormat)((Object)output_value)).getFormattedString((int)valueLength), (int)valueLength, ' ') : outString + Descriptor.getFixedString(output_value.toString(), (int)valueLength, ' '));
                outString = outString + Descriptor.getFixedString(this.footerPaddingContent, this.footerPadding, ' ');
                this.file.writeBytes(outString);
            } else {
                byte[] buffer;
                this.file.seek(offset);
                if (output_value instanceof ValueFormat) {
                    buffer = ((ValueFormat)((Object)output_value)).getFormattedBuffer();
                } else {
                    if (output_value != null) {
                        logger.warn(this.name + " : Value type not supported yet for binary output ! valueType=" + output_value.getType());
                    }
                    byte[] outputString = output_value.toString().getBytes();
                    buffer = new byte[(int)valueLength];
                    for (int ichar = 0; ichar < outputString.length && (long)ichar < valueLength; ++ichar) {
                        buffer[ichar] = outputString[ichar];
                    }
                }
                if (this.headerPadding > 0) {
                    this.file.writeBytes(Descriptor.getFixedString(this.headerPaddingContent, this.headerPadding, ' '));
                }
                this.file.write(buffer);
                if (this.footerPadding > 0) {
                    this.file.writeBytes(Descriptor.getFixedString(this.footerPaddingContent, this.footerPadding, ' '));
                }
            }
        }
        catch (IOException e) {
            logger.error(e);
            logger.error("Descriptor.setValue(): Error while writing value for node \"" + this.name + "\" (key=" + IntMap.keyToString(key) + ").");
        }
        return output_value;
    }

    protected DrbNode appendChild(DrbNode node, int[] key, boolean is_copying, boolean return_node, int level) throws UnsupportedOperationException {
        if (logger.isDebugEnabled()) {
            logger.debug("<" + this.name + ">.appendChild(node, key=" + IntMap.keyToString(key) + ", is_copying=" + is_copying + ", return_node=" + return_node + ", level=" + level + ")");
        }
        if (node == null) {
            throw new NullPointerException("Descriptor.appendChild(): The reference to the node to append is null.");
        }
        if (this.getChildrenCount() == 0) {
            throw new UnsupportedOperationException("Descriptor.appendChild(): \"" + this.name + "\" node does not accept any child.");
        }
        boolean found = false;
        Descriptor childDesc = this.getFirstChild();
        while (!found && childDesc != null) {
            if (childDesc.getName().equals(node.getName())) {
                found = true;
                continue;
            }
            childDesc = childDesc.getNextSibling();
        }
        if (!found) {
            throw new UnsupportedOperationException("Descriptor.appendChild(): \"" + this.getName() + "\" node does not accept any child named \"" + node.getName() + "\".");
        }
        int[] childKey = IntMap.getChildKey(key, 0);
        int currentOccurrenceCount = childDesc.getOccurrenceCount(childKey);
        childKey = IntMap.getChildKey(key, currentOccurrenceCount);
        if (!is_copying && node instanceof AbstractBlock) {
            is_copying = true;
            AbstractBlock block = (AbstractBlock)node;
            long blockLength = block.getLength();
            long l = Descriptor.copyFileSegment(block.descriptor.file, block.getOffset(), childDesc.file, childDesc.getOffset(childKey), block.getLength());
        }
        if (node.hasChild()) {
            int childrenCount = node.getChildrenCount();
            for (int i = 0; i < childrenCount; ++i) {
                childDesc.setOccurrenceCount(childKey, currentOccurrenceCount + 1);
                childDesc.appendChild(node.getChildAt(i), childKey, is_copying, false, level + 1);
            }
        } else {
            Value value;
            if (!is_copying && (value = node.getValue()) != null) {
                childDesc.setValue(value, childKey);
            }
            childDesc.setOccurrenceCount(childKey, currentOccurrenceCount + 1);
        }
        if (!return_node) {
            return null;
        }
        return AbstractBlock.createOptimalBlock(childDesc, childKey, currentOccurrenceCount + 1);
    }

    protected static final long copyFileSegment(RandomAccessData input_file, long input_offset, RandomAccessData output_file, long output_offset, long length) {
        if (input_file == null || output_file == null || input_offset < 0L || output_offset < 0L || length < 0L) {
            logger.error("Descriptor.copyFileSegment(): Invalid parameter(s) :");
            logger.error("   input_file    = " + input_file);
            logger.error("   input_offset  = " + input_offset);
            logger.error("   output_file   = " + output_file);
            logger.error("   output_offset = " + output_offset);
            logger.error("   length       = " + length);
            return -1L;
        }
        int curRead = 0;
        int totalRead = 0;
        try {
            input_file.seek(input_offset);
            output_file.seek(output_offset);
            byte[] buffer = new byte[10240];
            long loopNumber = length / 10240L;
            int curLength = 10240;
            int lastLength = (int)(length % 10240L);
            for (long i = 0L; i <= loopNumber; ++i) {
                if (i == loopNumber) {
                    buffer = new byte[lastLength];
                    curLength = lastLength;
                }
                curRead = curLength;
                input_file.readFully(buffer);
                if (curRead < curLength) {
                    if (curRead == -1) {
                        logger.info("Descriptor.copyFileSegment(): EOF reached in input file");
                        return totalRead;
                    }
                    byte[] tmpBuffer = new byte[curRead];
                    System.arraycopy(buffer, 0, tmpBuffer, 0, curRead);
                    buffer = tmpBuffer;
                    i = loopNumber;
                }
                totalRead += curRead;
                output_file.write(buffer);
            }
            return totalRead;
        }
        catch (IOException e) {
            logger.error(e);
            logger.error("Descriptor.copyFileSegment(): Unable to copy " + length + " byte(s) from \"" + input_file + "\" (offset=" + input_offset + ") to \"" + output_file + "\" (offset=" + output_offset + ").");
            return -1L;
        }
    }

    protected final long solveOccurrenceCount(int[] key) {
        if (logger.isDebugEnabled()) {
            logger.debug("<" + this.name + ">.solveOccurrenceCount(" + IntMap.keyToString(key) + ")");
        }
        if (this.occurrenceCountQuery == null) {
            return -1L;
        }
        return this.queryEval(key, this.occurrenceCountQueryObject, this.occurrenceCountQuery);
    }

    protected final long solveOffset(int[] key) {
        if (logger.isDebugEnabled()) {
            logger.debug("<" + this.name + ">.solveOffset(" + IntMap.keyToString(key) + ")");
        }
        if (this.offsetQuery == null) {
            int offsetType;
            long previousLength;
            int occurrence;
            int descOccurrenceCount = occurrence = key[key.length - 1];
            boolean previousFound = false;
            int previousFactor = 1;
            Descriptor previousDesc = this;
            int[] previousKey = key;
            while (!previousFound && previousDesc != null) {
                if (descOccurrenceCount > 0) {
                    int lengthType = previousDesc.getLengthType();
                    if (descOccurrenceCount > 1 && (lengthType == 1 || lengthType == 2)) {
                        previousKey = IntMap.getSiblingKey(key, 0);
                        previousFactor = descOccurrenceCount;
                    } else {
                        previousKey = IntMap.getSiblingKey(key, descOccurrenceCount - 1);
                    }
                    previousFound = true;
                    continue;
                }
                if ((previousDesc = previousDesc.getPreviousSibling()) == null) continue;
                previousKey = IntMap.getSiblingKey(key, 0);
                descOccurrenceCount = previousDesc.getOccurrenceCount(previousKey);
            }
            if (!previousFound) {
                previousDesc = this.getParent();
                previousKey = IntMap.getParentKey(key);
                previousLength = 0L;
            } else {
                if (previousDesc.getLengthType() != 1) {
                    int i = previousDesc.lengthQuerySolvedId;
                    while (i < previousKey[previousKey.length - 1]) {
                        previousDesc.getLength(IntMap.getSiblingKey(previousKey, i));
                        previousDesc.lengthQuerySolvedId = i++;
                    }
                }
                previousLength = previousDesc.getLength(previousKey);
            }
            long previousOffset = previousDesc.getOffset(previousKey);
            long previousBitsFromOffset = (long)previousDesc.getBitOffset() + (long)previousFactor * (8L * previousLength + (long)previousDesc.getBitLength());
            this.bitOffset = (int)(previousBitsFromOffset % 8L);
            long solvedOffset = previousOffset + previousBitsFromOffset / 8L;
            if (occurrence == 0) {
                solvedOffset += (long)this.getOffsetFromPreviousSibling();
            }
            if ((offsetType = this.getOffsetType()) == -1) {
                this.offset.setType(1);
            }
            if (offsetType != 1) {
                this.offset.clear();
            }
            return solvedOffset;
        }
        logger.error("fr.gael.drb.impl.sdf.Descriptor.solveOffset() : NOT IMPLEMENTED YET !");
        return -1L;
    }

    protected final long solveLength(int[] key) {
        if (logger.isDebugEnabled()) {
            logger.debug("<" + this.name + ">.solveLength(" + IntMap.keyToString(key) + ")");
        }
        boolean fixedChildrenLength = true;
        long totalLength = 0L;
        if (this.lengthQuery == null) {
            if (this.children.size() == 0) {
                return -1L;
            }
            for (int iDesc = 0; iDesc < this.children.size(); ++iDesc) {
                Descriptor childDesc = (Descriptor)this.children.get(iDesc);
                int childAdditionalOffset = childDesc.getOffsetFromPreviousSibling();
                int childOccurrenceCount = childDesc.getOccurrenceCount(IntMap.getChildKey(key, 0));
                for (int iOccur = 0; iOccur < childOccurrenceCount; ++iOccur) {
                    long childLength = childDesc.getLength(IntMap.getChildKey(key, iOccur));
                    if (childLength == -1L) {
                        logger.warn("fr.gael.drb.impl.sdf.Descriptor.solveLength() : Unable to get \"" + childDesc.getName() + "\" length.");
                        return -1L;
                    }
                    int lengthType = childDesc.getLengthType();
                    if (iOccur == 0 && (lengthType == 1 || lengthType == 2)) {
                        totalLength = totalLength + (long)childAdditionalOffset + childLength * (long)childOccurrenceCount;
                        iOccur = childOccurrenceCount;
                        continue;
                    }
                    totalLength = totalLength + (long)childAdditionalOffset + childLength;
                }
                if (childDesc.getLengthType() == 1) continue;
                fixedChildrenLength = false;
            }
        } else {
            int[] keyToUse;
            if (this.getLengthType() == 1) {
                keyToUse = new int[key.length];
                for (int i = 0; i < key.length; ++i) {
                    keyToUse[i] = 0;
                }
            } else {
                keyToUse = key;
            }
            totalLength = this.queryEval(keyToUse, this.lengthQueryObject, this.lengthQuery);
        }
        if (this.getLengthType() == -1) {
            if (fixedChildrenLength) {
                this.setLengthType(1);
            } else {
                this.setLengthType(3);
            }
        }
        return totalLength;
    }

    protected final long queryEval(int[] key, Query query_obj, String query_str) {
        DrbSequence itemList;
        if (logger.isDebugEnabled()) {
            logger.debug("<" + this.name + ">.queryEval(key=" + IntMap.keyToString(key) + ", query_obj, query_str=\"" + query_str + "\")");
        }
        if (this.contextNode == null) {
            this.contextNode = new DefaultBlock(this, key);
        } else {
            ((DefaultBlock)this.contextNode).key = key;
        }
        if (query_obj == null) {
            try {
                query_obj = new Query(query_str);
            }
            catch (Exception e) {
                logger.error("fr.gael.drb.impl.sdf.Descriptor.queryEval() : Cannot parse query (" + e + ")");
                return -1L;
            }
        }
        if ((itemList = query_obj.evaluate(this.contextNode)) == null || itemList.getLength() <= 0) {
            logger.error("fr.gael.drb.impl.sdf.Descriptor.queryEval() : Empty result list.");
            return -1L;
        }
        DrbItem resultItem = itemList.getItem(0);
        Value result_value = resultItem.getValue();
        if (result_value == null) {
            logger.error("fr.gael.drb.impl.sdf.Descriptor.queryEval() : Empty result value");
            return -1L;
        }
        try {
            result_value = result_value.convertTo(3);
        }
        catch (ClassCastException e) {
            logger.error("fr.gael.drb.impl.sdf.Descriptor.queryEval() : Cannot convert value to integer.");
            return -1L;
        }
        return ((Int)result_value).intValue();
    }

    protected final int getOffsetFromPreviousSibling() {
        return this.offsetFromPreviousSibling;
    }

    protected final void setOffsetFromPreviousSibling(int offset_from_previous_sibling) {
        this.offsetFromPreviousSibling = offset_from_previous_sibling;
    }

    protected final int getBitOffset() {
        return this.bitOffset;
    }

    protected final int getBitLength() {
        return this.bitLength;
    }

    protected final int getOccurrenceCount(int[] key) {
        long tmpValue;
        if (logger.isDebugEnabled()) {
            logger.debug("<" + this.name + ">.getOccurrenceCount(" + IntMap.keyToString(key) + ")");
        }
        if ((tmpValue = this.occurrenceCount.getValue(key)) == -1L) {
            logger.debug("   case of unknown occurrence count value");
            tmpValue = this.solveOccurrenceCount(key);
            if (tmpValue == -1L) {
                logger.debug("   unable to solve occurrence count");
                return 0;
            }
            this.setOccurrenceCount(key, tmpValue);
        }
        return (int)tmpValue;
    }

    protected final long getOffset(int[] key) {
        long tmpValue;
        if (logger.isDebugEnabled()) {
            logger.debug("<" + this.name + ">.getOffset(" + IntMap.keyToString(key) + ")");
        }
        if ((tmpValue = this.offset.getValue(key)) == -1L) {
            tmpValue = this.solveOffset(key);
            this.setOffset(key, tmpValue);
        }
        return tmpValue;
    }

    protected final long getLength(int[] key) {
        long tmpValue;
        if (logger.isDebugEnabled()) {
            logger.debug("<" + this.name + ">.getLength(" + IntMap.keyToString(key) + ")");
        }
        if ((tmpValue = this.length.getValue(key)) == -1L) {
            tmpValue = this.solveLength(key);
            logger.debug("   solveLength=" + tmpValue);
            if (this.valueType == 10) {
                logger.debug("   case of array, length=" + (tmpValue *= this.arrayElementSize));
            }
            tmpValue = tmpValue + (long)this.headerPadding + (long)this.footerPadding;
            logger.debug("   length with paddings=" + tmpValue);
            this.setLength(key, tmpValue);
        }
        return tmpValue;
    }

    protected final void setOccurrenceCountType(int type) {
        logger.debug("<" + this.name + ">.setOccurrenceCountType(" + type + ")");
        this.occurrenceCount.setType(type);
    }

    protected final int getOccurrenceCountType() {
        return this.occurrenceCount.getType();
    }

    protected final void setOffsetType(int type) {
        logger.debug("<" + this.name + ">.setOffsetType(" + type + ")");
        if (type == 3) {
            logger.debug("   offset is variable, set offset type to VARIABLE for all children");
            for (int i = 0; i < this.children.size(); ++i) {
                ((Descriptor)this.children.get(i)).setOffsetType(type);
            }
        }
        this.offset.setType(type);
    }

    protected final int getOffsetType() {
        return this.offset.getType();
    }

    protected final void setLengthType(int type) {
        logger.debug("<" + this.name + ">.setLengthType(" + type + ")");
        this.length.setType(type);
    }

    protected final int getLengthType() {
        return this.length.getType();
    }

    protected final void setOccurrenceCount(int[] key, long value) {
        if (logger.isDebugEnabled()) {
            logger.debug("<" + this.name + ">.setOccurrenceCount(key=" + IntMap.keyToString(key) + ", value=" + value + ")");
        }
        this.occurrenceCount.setValue(key, value);
    }

    protected final void setOffset(int[] key, long value) {
        if (logger.isDebugEnabled()) {
            logger.debug("<" + this.name + ">.setOffset(key=" + IntMap.keyToString(key) + ", value=" + value + ")");
        }
        this.offset.setValue(key, value);
    }

    protected final void setLength(int[] key, long value) {
        if (logger.isDebugEnabled()) {
            logger.debug("<" + this.name + ">.setLength(key=" + IntMap.keyToString(key) + ", value=" + value + ")");
        }
        this.length.setValue(key, value);
    }

    protected final DrbNode getBaseNode() {
        return this.baseNode;
    }

    protected final String getBaseNodePath() {
        return this.baseNode.getPath();
    }

    protected final String getSchemaNodePath() {
        return this.schemaNodePath;
    }

    protected final Descriptor getRoot() {
        return this.root;
    }

    protected final void setAsRoot(DrbNode base_node, String schema_node_path) {
        if (logger.isDebugEnabled()) {
            logger.debug("<" + this.name + ">.setAsRoot(base_node=" + (base_node == null ? null : base_node.getName()) + ", schema_node_path=" + schema_node_path + ")");
        }
        if (base_node == null) {
            logger.error("fr.gael.drb.impl.sdf.Descriptor.setAsRoot() : base_node is null.");
            return;
        }
        this.setRoot(this, base_node, schema_node_path, true, 0);
    }

    private final void setRoot(Descriptor root, DrbNode base_node, String schema_node_path, boolean single_ancestors, int depth) {
        if (logger.isDebugEnabled()) {
            logger.debug("<" + this.name + ">.setRoot(root=" + (root == null ? null : root.name) + ", base_node=" + (base_node == null ? null : base_node.getName()) + ", schema_node_path=" + schema_node_path + ", single_ancestors=" + single_ancestors + ", depth=" + depth + ")");
        }
        this.root = root;
        this.baseNode = base_node;
        this.schemaNodePath = schema_node_path;
        this.singleAncestors = single_ancestors;
        int[] key = new int[]{};
        for (int i = 0; i < depth; ++i) {
            key = IntMap.getChildKey(key, 0);
        }
        boolean singleOccurrence = this.isSingleOccurrence(key);
        if (this.getOffsetType() == -1) {
            if (singleOccurrence) {
                this.offset.setType(1);
            } else {
                this.offset.setType(3);
            }
        }
        for (int i = 0; i < this.children.size(); ++i) {
            ((Descriptor)this.children.get(i)).setRoot(root, base_node, schema_node_path, singleOccurrence, depth + 1);
        }
        if (this.getOccurrenceCountType() == 3) {
            logger.debug("   occurrence count is variable, check if ancestors are single");
            logger.debug("   To be implemented !");
        }
    }

    protected final Descriptor getParent() {
        return this.parent;
    }

    protected final void setParent(Descriptor parent) {
        if (logger.isDebugEnabled()) {
            logger.debug("<" + this.name + ">.setParent(" + (parent == null ? null : parent.name) + ")");
        }
        this.parent = parent;
    }

    protected final Descriptor getFirstChild() {
        return this.getChildAt(0);
    }

    protected final Descriptor getLastChild() {
        return this.getChildAt(this.children.size() - 1);
    }

    protected final Descriptor getChildAt(int index) {
        if (index < 0) {
            logger.error("fr.gael.drb.impl.sdf.Descriptor.getChildAt() : Invalid parameter.");
            logger.error("   index = " + index);
            return null;
        }
        if (this.children.size() == 0 || index >= this.children.size()) {
            return null;
        }
        return (Descriptor)this.children.get(index);
    }

    protected final Descriptor getPreviousSibling() {
        return this.previousSibling;
    }

    protected final void setPreviousSibling(Descriptor previous_sibling) {
        this.previousSibling = previous_sibling;
    }

    protected final Descriptor getNextSibling() {
        return this.nextSibling;
    }

    protected final void setNextSibling(Descriptor next_sibling) {
        this.nextSibling = next_sibling;
    }

    protected final void addChild(Descriptor new_child) {
        if (new_child == null) {
            logger.warn("fr.gael.drb.impl.sdf.Descriptor.addChild() : Invalid parameter.");
            logger.warn("   new_child is null => children list unchanged.");
            return;
        }
        this.children.add(new_child);
    }

    public String toString() {
        String tmpStr;
        String info = "fr.gael.drb.impl.sdf.Descriptor {\n";
        info = info + "   Name            : " + this.name + "\n";
        info = info + "   FullName        : " + this.fullName + "\n";
        switch (this.encoding) {
            case 1: {
                tmpStr = "BINARY";
                break;
            }
            case 2: {
                tmpStr = "ASCII";
                break;
            }
            case 3: {
                tmpStr = "EBCDIC";
                break;
            }
            default: {
                tmpStr = "" + this.encoding;
            }
        }
        info = info + "   Encoding        : " + tmpStr + "\n";
        info = info + "   SingleOccurrence: " + this.isSingleOccurrence(null) + "\n";
        info = info + "   OccurrenceCount : " + this.occurrenceCount + "\n";
        info = info + "   Offset (bytes)  : " + this.offset + "\n";
        info = info + "   Length (bytes)  : " + this.length + "\n";
        info = info + "   bitLength       : " + this.bitLength + "\n";
        info = info + "   Prev.Sibl.Offset: " + this.offsetFromPreviousSibling + "\n";
        info = info + "   Header padding  : " + this.headerPadding + " [" + this.headerPaddingContent + "]\n";
        info = info + "   Footer padding  : " + this.footerPadding + " [" + this.footerPaddingContent + "]\n";
        switch (this.valueType) {
            case -2: {
                tmpStr = "UNKNOWN_ID";
                break;
            }
            case -1: {
                tmpStr = "NULL_ID";
                break;
            }
            case 0: {
                tmpStr = "BOOLEAN_ID";
                break;
            }
            case 1: {
                tmpStr = "BYTE_ID";
                break;
            }
            case 12: {
                tmpStr = "BYTE_ID";
                break;
            }
            case 2: {
                tmpStr = "SHORT_ID";
                break;
            }
            case 13: {
                tmpStr = "SHORT_ID";
                break;
            }
            case 3: {
                tmpStr = "INT_ID";
                break;
            }
            case 14: {
                tmpStr = "INT_ID";
                break;
            }
            case 4: {
                tmpStr = "LONG_ID";
                break;
            }
            case 15: {
                tmpStr = "LONG_ID";
                break;
            }
            case 5: {
                tmpStr = "FLOAT_ID";
                break;
            }
            case 6: {
                tmpStr = "DOUBLE_ID";
                break;
            }
            case 7: {
                tmpStr = "STRING_ID";
                break;
            }
            case 8: {
                tmpStr = "DATE_ID";
                break;
            }
            case 9: {
                tmpStr = "NUMERIC_ID";
                break;
            }
            case 10: {
                tmpStr = "ARRAY_ID (inside type = " + this.arrayValueType + ")";
                break;
            }
            case 100: {
                tmpStr = "OTHER_ID";
                break;
            }
            default: {
                tmpStr = "" + this.valueType;
            }
        }
        info = info + "   Value type      : " + tmpStr + "\n";
        info = info + "   Root Name       : " + (this.root == null ? null : this.root.name) + "\n";
        info = info + "   Parent Name     : " + (this.parent == null ? null : this.parent.name) + "\n";
        info = info + "   Previous Name   : " + (this.previousSibling == null ? null : this.previousSibling.name) + "\n";
        info = info + "   Next Name       : " + (this.nextSibling == null ? null : this.nextSibling.name) + "\n";
        info = info + "   Children        : { ";
        for (int i = 0; i < this.children.size(); ++i) {
            info = info + "\"" + ((Descriptor)this.children.get((int)i)).name + "\" ";
        }
        info = info + "}\n";
        info = info + "}\n";
        return info;
    }

    public static final String getFixedString(String in_str, int length, char fill_char) {
        int inStrLength;
        if (length < 0) {
            logger.error("Descriptor.getFixedString(): Invalid parameter(s).");
            logger.error("   length = " + length);
            return "";
        }
        if (length == 0) {
            return "";
        }
        if (in_str == null) {
            in_str = "";
        }
        if ((inStrLength = in_str.length()) == length) {
            return in_str;
        }
        if (inStrLength > length) {
            return in_str.substring(0, length);
        }
        for (int i = 0; i < length - inStrLength; ++i) {
            in_str = in_str + fill_char;
        }
        return in_str;
    }
}

