/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.sds;

import fr.gael.drb.DrbDefaultMutableNode;
import fr.gael.drb.DrbFactory;
import fr.gael.drb.DrbItem;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbSequence;
import fr.gael.drb.DrbSimpleNode;
import fr.gael.drb.impl.DrbNodeImpl;
import fr.gael.drb.impl.sds.AbstractBlock;
import fr.gael.drb.impl.sds.BlockEvent;
import fr.gael.drb.impl.sds.BlockListener;
import fr.gael.drb.impl.sds.BlockTools;
import fr.gael.drb.impl.sds.DefaultBlock;
import fr.gael.drb.impl.sds.DynamicException;
import fr.gael.drb.impl.sds.IntMap;
import fr.gael.drb.impl.sds.Length;
import fr.gael.drb.impl.sds.LengthAttribute;
import fr.gael.drb.impl.sds.OffsetAttribute;
import fr.gael.drb.impl.sds.PhysicalAttribute;
import fr.gael.drb.impl.sds.RandomAccessData;
import fr.gael.drb.impl.sds.RandomAccessFileData;
import fr.gael.drb.impl.sds.RandomAccessStreamData;
import fr.gael.drb.impl.sds.SdfFactory;
import fr.gael.drb.impl.sds.SdfViewDescriptor;
import fr.gael.drb.impl.sds.StaticException;
import fr.gael.drb.impl.sds.ValueFormat;
import fr.gael.drb.impl.xml.XmlWriter;
import fr.gael.drb.query.Query;
import fr.gael.drb.value.Boolean;
import fr.gael.drb.value.Comparison;
import fr.gael.drb.value.Int;
import fr.gael.drb.value.Value;
import fr.gael.drb.xsd.XmlSchema;
import fr.gael.drb.xsd.XsdAtomicType;
import fr.gael.drb.xsd.XsdElement;
import fr.gael.drb.xsd.XsdFactory;
import fr.gael.drb.xsd.XsdListType;
import fr.gael.drb.xsd.XsdSimpleType;
import fr.gael.drb.xsd.XsdType;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.TreeSet;
import org.apache.log4j.Logger;

class Descriptor
implements BlockListener {
    protected static final int ENCODING_UNKNOWN = -1;
    protected static final int ENCODING_BINARY = 1;
    protected static final int ENCODING_TEXT = 2;
    protected static final String CHARSET_ASCII = "ASCII";
    protected static final String CHARSET_US_ASCII = "US-ASCII";
    protected static final String CHARSET_EBCDIC = "cp037";
    protected static final int BYTE_ORDERING_LSB = 1;
    protected static final int BYTE_ORDERING_MSB = 2;
    private static Logger logger = Logger.getLogger(Descriptor.class);
    private BlockListener parentListener = new ParentBlockListener();
    private BlockListener previousListener = new PreviousBlockListener();
    private BlockListener childListener = new ChildrenBlockListener();
    private RandomAccessData file;
    private DrbNode fileNode;
    protected String fileNodePath;
    private DrbNode baseNode;
    private String schemaNodePath;
    private Descriptor root;
    private int depth;
    protected int index;
    private Descriptor parent;
    private ArrayList children;
    private ArrayList substitution;
    private Descriptor substitutionGroup;
    private Descriptor previousSibling;
    private Descriptor nextSibling;
    protected String name;
    private String fullName;
    private XsdElement nodeDesc;
    private XsdType type;
    protected int valueType;
    protected int arrayValueType;
    protected PhysicalAttribute itemCount;
    protected LengthAttribute itemLength;
    private boolean singleAncestors;
    protected OffsetAttribute blockOffset;
    protected Padding headerPadding;
    protected Padding leading;
    protected Padding trailing;
    protected Padding footerPadding;
    protected String delimiter;
    protected String arrayDelimiter;
    protected PhysicalAttribute blockName;
    protected SdfViewDescriptor viewDesc;
    protected PhysicalAttribute occurrenceCount;
    protected PhysicalAttribute childrenCount;
    private PhysicalAttribute substitutionMap;
    protected OffsetAttribute offset;
    protected LengthAttribute contentLength;
    protected LengthAttribute length;
    protected int encoding;
    protected String charsetName;
    protected ValueFormat textFormat;
    protected int byteOrdering;
    protected DrbNode contextNode;
    protected String valueQuery;
    protected Query valueQueryObject;
    protected Signature signature;
    protected String documentation;
    private static String tab = "";

    @Override
    public void blockReplaced(BlockEvent e) {
        int i;
        this.blockOffset.clear();
        this.offset.clear();
        this.contentLength.clear();
        this.length.clear();
        this.itemLength.clear();
        this.itemCount.clear();
        this.childrenCount.clear();
        this.substitutionMap.clear();
        if (this.substitutionGroup == null && !e.isParent() && this.length.getAccessType() == 3) {
            if (this.getParent() != null) {
                this.getParent().childListener.blockReplaced(e);
            }
            if (this.getNextSibling() != null) {
                this.getNextSibling().previousListener.blockReplaced(e);
            }
        }
        for (i = 0; i < this.substitution.size(); ++i) {
            this.getSubstitution(i).blockReplaced(e);
        }
        for (i = 0; i < this.children.size(); ++i) {
            this.getChildAt((int)i).parentListener.blockReplaced(e);
        }
    }

    @Override
    public void blockInserted(BlockEvent e) {
        int i;
        this.blockOffset.clear();
        this.offset.clear();
        this.contentLength.clear();
        this.length.clear();
        this.itemLength.clear();
        this.itemCount.clear();
        this.childrenCount.clear();
        this.substitutionMap.clear();
        if (this.substitutionGroup == null && !e.isParent()) {
            if (this.getParent() != null) {
                this.getParent().childListener.blockInserted(e);
            }
            if (this.getNextSibling() != null) {
                this.getNextSibling().previousListener.blockInserted(e);
            }
        }
        for (i = 0; i < this.substitution.size(); ++i) {
            this.getSubstitution(i).blockInserted(e);
        }
        for (i = 0; i < this.children.size(); ++i) {
            this.getChildAt((int)i).parentListener.blockInserted(e);
        }
    }

    @Override
    public void blockRemoved(BlockEvent e) {
        int i;
        this.blockOffset.clear();
        this.offset.clear();
        this.contentLength.clear();
        this.length.clear();
        this.itemLength.clear();
        this.itemCount.clear();
        this.childrenCount.clear();
        this.substitutionMap.clear();
        if (this.substitutionGroup == null && !e.isParent()) {
            if (this.getParent() != null) {
                this.getParent().childListener.blockRemoved(e);
            }
            if (this.getNextSibling() != null) {
                this.getNextSibling().previousListener.blockRemoved(e);
            }
        }
        for (i = 0; i < this.substitution.size(); ++i) {
            this.getSubstitution(i).blockRemoved(e);
        }
        for (i = 0; i < this.children.size(); ++i) {
            this.getChildAt((int)i).parentListener.blockRemoved(e);
        }
    }

    @Override
    public void blockMoved(BlockEvent e) {
        Descriptor instance_desc;
        this.blockOffset.clear();
        this.offset.clear();
        if (this.substitutionGroup == null && !e.isParent()) {
            if (this.getNextSibling() != null) {
                this.getNextSibling().previousListener.blockMoved(e);
            } else if (this.getParent() != null) {
                this.getParent().childListener.blockMoved(e);
            }
        }
        if ((instance_desc = e.getDescriptor()) != this) {
            instance_desc.blockMoved(e);
        } else {
            for (int i = 0; i < this.children.size(); ++i) {
                this.getChildAt((int)i).parentListener.blockMoved(e);
            }
        }
    }

    @Override
    public void blockResized(BlockEvent e) {
        int[] sibling_key = IntMap.getSiblingKey(e.getKey(), 0);
        int[] key = e.getKey();
        if (key.length > 0 && key[key.length - 1] + 1 < this.getOccurrenceCount(sibling_key)) {
            this.blockOffset.clear();
            this.offset.clear();
            int n = key.length - 1;
            key[n] = key[n] + 1;
            this.blockMoved(new BlockEvent(BlockEvent.PREVIOUS | BlockEvent.RESIZE, this, key));
        } else if (this.getNextSibling() != null) {
            this.getNextSibling().previousListener.blockResized(e);
        } else if (this.getParent() != null) {
            this.getParent().childListener.blockResized(e);
        }
    }

    protected Descriptor(RandomAccessData file, String name, String full_name) {
        this.name = name;
        this.fullName = full_name;
        this.file = file;
        this.encoding = -1;
        this.charsetName = CHARSET_ASCII;
        this.byteOrdering = 2;
        this.valueType = -1;
        this.arrayValueType = -2;
        this.itemCount = new PhysicalAttribute(3);
        this.itemLength = new LengthAttribute(3);
        this.itemLength.setUnit((short)2);
        this.children = new ArrayList();
        this.substitution = new ArrayList();
        this.substitutionMap = new PhysicalAttribute(3);
        this.occurrenceCount = new PhysicalAttribute(1);
        this.occurrenceCount.setOccurrenceType(1);
        this.occurrenceCount.setValue(1L);
        this.childrenCount = new PhysicalAttribute(3);
        this.offset = new OffsetAttribute(3);
        this.blockOffset = new OffsetAttribute(1);
        this.blockOffset.setOccurrenceType(1);
        this.blockOffset.setValue(0L);
        this.contentLength = new LengthAttribute(3);
        this.length = new LengthAttribute(3);
        this.headerPadding = new Padding(0, "");
        this.leading = new Padding(0, "");
        this.trailing = new Padding(0, "");
        this.footerPadding = new Padding(0, "");
        this.delimiter = "";
        this.arrayDelimiter = "";
        this.singleAncestors = true;
        this.index = 0;
    }

    protected Descriptor(RandomAccessData file, boolean create_mode, XsdElement node, int depth) {
        this(file, node.getName() != null ? node.getName() : "", "");
        this.depth = depth;
        this.setSchema(node);
        XsdType node_type = node.getType();
        XsdSimpleType value_type = null;
        if (node_type == null) {
            logger.warn("The element '" + node.getName() + "' has no type.");
        } else {
            value_type = node_type.getDatatype();
        }
        if (value_type != null) {
            this.setValueType(value_type.getTypeId());
            if (value_type.getVariety() == 3) {
                XsdListType array_type = (XsdListType)value_type;
                this.arrayValueType = array_type.getItemTypeId();
            }
        } else {
            this.setValueType(-1);
        }
    }

    protected final String getDocumentation() {
        return this.documentation;
    }

    protected final void dispose() {
        try {
            if (this.file != null) {
                this.file.close();
            }
        }
        catch (IOException e) {
            logger.error("fr.gael.drb.impl.sdf.Descriptor : Cannot close the file.");
        }
    }

    protected final boolean isSingleOccurrence(int[] key) {
        return this.singleAncestors && this.getOccurrenceCount(key) == 1;
    }

    protected final int getValueType() {
        return this.valueType;
    }

    protected final int getArrayValueType() {
        return this.arrayValueType;
    }

    protected final Padding getHeaderPadding() {
        return this.headerPadding;
    }

    protected final String getDelimiter() {
        return this.delimiter;
    }

    protected final String getArrayDelimiter() {
        return this.arrayDelimiter;
    }

    protected final XsdType getType() {
        return this.type;
    }

    protected final XsdElement getSchema() {
        return this.nodeDesc;
    }

    protected final void setValueType(int value_type) {
        this.valueType = value_type;
    }

    protected final void setSchema(XsdElement node_desc) {
        this.nodeDesc = node_desc;
        if (node_desc != null && node_desc.getType() != null) {
            this.type = node_desc.getType();
        }
    }

    protected final String getName() {
        return this.name;
    }

    protected final String getPath() {
        if (this.getParent() != null) {
            return this.getParent().getPath() + "/" + this.getName();
        }
        return this.getName();
    }

    protected final String getFullName() {
        return this.fullName;
    }

    protected int getChildrenCount() {
        return this.children.size();
    }

    protected int getEncoding() {
        return this.encoding;
    }

    protected int getByteOrdering() {
        return this.byteOrdering;
    }

    protected final AbstractBlock createOptimalBlock(int[] key) {
        return new DefaultBlock(this, key);
    }

    protected final Value getValue(int[] key) {
        Value value = this.getValue(key, null, null);
        return value;
    }

    protected final Value getValue(int[] key, Length start_offset, Length stop_offset) {
        Length value_offset;
        Length value_length;
        Descriptor instance_desc = this.getInstance(key);
        if (instance_desc != this) {
            return instance_desc.getValue(key);
        }
        if (this.valueType == -1) {
            return null;
        }
        if (this.valueQuery != null) {
            return this.queryEvalValue(key, this.valueQueryObject, this.valueQuery);
        }
        Length item_length = null;
        long item_count = -1L;
        int left_padding = this.leading.length;
        int right_padding = this.trailing.length;
        if (this.contentLength.getAccessType() != 1 && !this.contentLength.hasQuery()) {
            value_length = null;
        } else {
            value_length = this.getLength(key);
            if (value_length == null) {
                logger.info("fr.gael.drb.impl.sdf.Descriptor.getValue() : length is UNKNOWN.");
            } else {
                value_length = this.contentLength.getLength(key);
            }
        }
        if (value_length != null) {
            value_length.setLength(value_length.getLength() - (long)left_padding - (long)right_padding, value_length.getBitLength());
        }
        if (this.valueType == 10) {
            item_length = this.getItemLength(key);
            item_count = this.getItemOccurrenceCount(key);
        }
        if (this.valueType == 10 && value_length != null && (item_count < 0L || item_length == null)) {
            if (item_count < 0L) {
                item_count = (8L * value_length.getLength() + (long)value_length.getBitLength()) / (8L * item_length.getLength() + (long)item_length.getBitLength());
            } else if (item_count != 0L) {
                item_length = new Length(0L, (8L * value_length.getLength() + (long)value_length.getBitLength()) / item_count);
            }
        }
        if ((value_offset = this.getOffset(key)) == null) {
            logger.error("fr.gael.drb.impl.sdf.Descriptor.getValue() : offset is UNKNOWN.");
            return null;
        }
        try {
            Value value;
            BlockTools blockTools = new BlockTools();
            if (start_offset == null) {
                start_offset = new Length(value_offset.getLength() + (long)this.headerPadding.length, value_offset.getBitLength());
            } else {
                start_offset.setLength(value_offset.getLength() + (long)this.headerPadding.length, value_offset.getBitLength());
            }
            if (stop_offset == null) {
                stop_offset = new Length(-1L, -1L);
            }
            if (value_length != null) {
                stop_offset.setLength(start_offset.getLength() + value_length.getLength(), start_offset.getBitLength() + value_length.getBitLength());
            }
            if ((value = BlockTools.extractValue(this, start_offset, stop_offset, item_count, item_length)) != null && value.getType() == 7 && "token".equals(this.type.getName())) {
                value = new fr.gael.drb.value.String(value.toString().trim());
            }
            blockTools = null;
            if (value_length != null) {
                stop_offset.setLength(start_offset.getLength() + value_length.getLength(), start_offset.getBitLength() + value_length.getBitLength());
            }
            return value;
        }
        catch (EOFException e) {
            logger.error(e);
            logger.error("Descriptor.getValue(): Unable to read value for node \"" + this.getPath() + "\" (key=" + IntMap.keyToString(key) + ").");
        }
        catch (IOException e) {
            logger.error(e);
            logger.error("Descriptor.getValue(): Unable to read value for node \"" + this.getPath() + "\" (key=" + IntMap.keyToString(key) + ").");
        }
        return null;
    }

    protected Value setValue(Value value, int[] key) throws UnsupportedOperationException {
        Length value_length = null;
        Length old_length = this.getLength(key);
        if (old_length == null) {
            throw new UnsupportedOperationException("Descriptor.setValue(): length is UNKNOWN.");
        }
        value_length = this.contentLength.isMutable() || this.contentLength.getValue() < 0L ? null : this.contentLength.getLength(key);
        Length offset = this.getOffset(key);
        if (offset == null) {
            throw new UnsupportedOperationException("Descriptor.setValue(): offset is UNKNOWN.");
        }
        Length new_length = old_length;
        try {
            if (value_length == null && offset.getLength() < this.getFile().length()) {
                File temp_file = File.createTempFile("sdf-" + this.getName() + "-", ".tmp");
                RandomAccessFileData output_file = new RandomAccessFileData(temp_file);
                new_length = this.serializeValue(value, output_file, new Length(0L), null);
                ((RandomAccessData)output_file).close();
                temp_file.delete();
                this.setLength(key, new_length);
                if (old_length.getLength() != new_length.getLength() || old_length.getBitLength() != new_length.getBitLength()) {
                    Length old_end_offset = new Length(offset.getLength() + old_length.getLength(), offset.getBitLength() + old_length.getBitLength());
                    Length new_end_offset = new Length(offset.getLength() + new_length.getLength(), offset.getBitLength() + new_length.getBitLength());
                    this.getFile().move(old_end_offset, new_end_offset);
                    BlockEvent e = new BlockEvent(BlockEvent.RESIZE, this, key);
                    this.blockResized(e);
                }
            }
        }
        catch (IOException e) {
            throw new UnsupportedOperationException("Descriptor.setValue(): cannot create temporary file." + e.getMessage());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Serializing " + value + " at offset " + offset + " length=" + value_length);
        }
        this.serializeValue(value, this.getFile(), offset, value_length);
        if (logger.isDebugEnabled()) {
            logger.debug("Serializing " + value + " at offset " + offset + " length=" + value_length + ". OK");
        }
        return value;
    }

    protected static final void copyChildDescriptor(int[] input_key, Descriptor input_desc, int[] output_key, Descriptor output_desc) {
        int[] input_childKey = IntMap.getChildKey(input_key, 0);
        int[] output_childKey = IntMap.getChildKey(output_key, 0);
        for (int i = 0; i < output_desc.getChildrenCount(); ++i) {
            Descriptor input_childDesc = (Descriptor)input_desc.children.get(i);
            Descriptor output_childDesc = (Descriptor)output_desc.children.get(i);
            output_childDesc.setOccurrenceCount(output_childKey, input_childDesc.occurrenceCount.getValue(input_childKey));
            Descriptor.copyChildDescriptor(input_childKey, input_childDesc, output_childKey, output_childDesc);
        }
    }

    protected DrbNode appendChild(DrbNode node, int[] key, boolean return_node, int level) throws UnsupportedOperationException, IOException {
        if (node == null) {
            throw new NullPointerException("Descriptor.appendChild(): The reference to the node to append is null.");
        }
        if (this.getChildrenCount() == 0) {
            throw new UnsupportedOperationException("Descriptor.appendChild(): \"" + this.getPath() + "\" node does not accept any child.");
        }
        boolean found = false;
        Descriptor childDesc = this.getFirstChild();
        while (!found && childDesc != null) {
            if (childDesc.isSame(node.getName())) {
                found = true;
                continue;
            }
            childDesc = childDesc.getNextSibling();
        }
        if (!found) {
            throw new UnsupportedOperationException("Descriptor.appendChild(): \"" + this.getName() + "\" node does not accept any child named \"" + node.getName() + "\".");
        }
        int[] childKey = IntMap.getChildKey(key, 0);
        int currentOccurrenceCount = childDesc.getOccurrenceCount(childKey);
        if (currentOccurrenceCount < 0) {
            currentOccurrenceCount = 0;
        }
        childKey = IntMap.getChildKey(key, currentOccurrenceCount);
        return childDesc.insert(node, childKey, return_node, level);
    }

    protected DrbNode insert(DrbNode node, int[] key, boolean return_node, int level) throws UnsupportedOperationException, IOException {
        int currentOccurrenceCount;
        if (this.occurrenceCount.getAccessType() == 1) {
            logger.error("AbstractBlock.insert(): The occurrence is fixed. Cannot add a new occurrence.");
            throw new UnsupportedOperationException(this.getPath() + ": The occurrence count is fixed. Cannot insert a node.");
        }
        int[] sibling_key = key;
        if (key[key.length - 1] != 0) {
            sibling_key = IntMap.getSiblingKey(key, 0);
        }
        if ((currentOccurrenceCount = this.getOccurrenceCount(sibling_key)) < 0) {
            currentOccurrenceCount = 0;
        }
        this.occurrenceCount.setValue(sibling_key, currentOccurrenceCount + 1);
        AbstractBlock block = null;
        if (node instanceof DrbNodeImpl && (block = (AbstractBlock)((DrbNodeImpl)node).getImpl(AbstractBlock.class)) != null && this.schemaNodePath != null && this.schemaNodePath.equals(block.descriptor.schemaNodePath)) {
            Length old_length = null;
            if (key[key.length - 1] < currentOccurrenceCount) {
                old_length = this.getLength(key);
            }
            this.setLength(key, block.getLength());
            Length node_offset = this.getOffset(key);
            Length node_length = block.getLength();
            Length end_offset = new Length(node_offset.getLength() + node_length.getLength(), node_offset.getBitLength() + node_length.getBitLength());
            try {
                this.getFile().move(node_offset, end_offset);
            }
            catch (IOException ex) {
                logger.error(ex);
                logger.error("Descriptor.insert(): Unable to insert " + node_length + " byte(s) into \"" + this.getFile() + "\" at offset=" + node_offset + ".");
                throw new DynamicException(this.getPath() + "Unable to insert " + node_length + " byte(s) into \"" + this.getFile() + "\" at offset=" + node_offset + IntMap.keyToString(key));
            }
            long result = Descriptor.copyFileSegment(block.descriptor.getFile(), block.getOffset(), this.getFile(), node_offset, node_length);
            if (result < 0L) {
                throw new DynamicException(this.getPath() + "Unable to copy " + node_length + " byte(s) into \"" + this.getFile() + "\" at offset=" + node_offset + ". " + IntMap.keyToString(key));
            }
            this.getBase().blockInserted(new BlockEvent(BlockEvent.INSERT, this.getNamedInstance(node.getName()), key));
            Descriptor.copyChildDescriptor(block.key, block.descriptor.getBase(), key, this.getBase());
            this.setOffset(key, node_offset);
            this.setLength(key, node_length);
        } else {
            Length node_offset;
            File temp_file = null;
            RandomAccessData output_file = this.getFile();
            Length output_offset = node_offset = this.getOffset(key);
            Length node_length = null;
            long file_len = Long.MAX_VALUE;
            if (this.contentLength.getType() != 1) {
                file_len = output_file.length();
                if (node_offset.getLength() < file_len) {
                    try {
                        temp_file = File.createTempFile("sdf-" + this.getName() + "-", ".tmp");
                        output_file = new RandomAccessFileData(temp_file);
                        output_offset = new Length(0L);
                        node_length = this.serializeNode(node, key, output_file, output_offset);
                    }
                    catch (IOException ex) {
                        logger.error(ex);
                        logger.error("Descriptor.insert(): Unable to copy the node to the temporary file.");
                        this.occurrenceCount.setValue(sibling_key, currentOccurrenceCount);
                        throw new DynamicException(this.getPath() + "Unable to copy the node to the temporary file." + IntMap.keyToString(key));
                    }
                }
            }
            try {
                if (node_offset.getLength() < file_len) {
                    if (node_length == null) {
                        node_length = this.getLength(key);
                        if (this.delimiter.length() > 0) {
                            node_length = this.contentLength.getLength(key);
                            node_length = new Length(node_length.getLength() + (long)this.headerPadding.length + (long)this.footerPadding.length + (long)this.delimiter.length(), node_length.getBitLength());
                        }
                    }
                    Length end_offset = new Length(node_offset.getLength() + node_length.getLength(), node_offset.getBitLength() + node_length.getBitLength());
                    this.getFile().move(node_offset, end_offset);
                }
            }
            catch (IOException ex) {
                logger.error(ex);
                logger.error("Descriptor.insert(): Unable to insert " + node_length + " byte(s) into \"" + this.getFile() + "\" at offset=" + node_offset + ".");
                throw new DynamicException(this.getPath() + "Unable to insert the node. " + IntMap.keyToString(key));
            }
            if (temp_file != null) {
                long result = Descriptor.copyFileSegment(output_file, output_offset, this.getFile(), node_offset, node_length);
                output_file.close();
                temp_file.delete();
            } else {
                node_length = this.serializeNode(node, key, this.getFile(), node_offset);
            }
            this.getBase().blockInserted(new BlockEvent(BlockEvent.INSERT, this.getNamedInstance(node.getName()), key));
            this.setOffset(key, node_offset);
            this.setLength(key, node_length);
        }
        if (!return_node) {
            return null;
        }
        return AbstractBlock.createOptimalBlock(this, key, currentOccurrenceCount + 1);
    }

    protected DrbNode replace(DrbNode node, int[] key, boolean return_node, int level) throws UnsupportedOperationException, IOException {
        if (node == null) {
            throw new NullPointerException("Descriptor.replace(): The reference to the node to replace is null.");
        }
        if (!this.isSame(node.getName())) {
            throw new UnsupportedOperationException("Descriptor.replace(): \"" + this.getName() + "\" node does not accept any child named \"" + node.getName() + "\".");
        }
        AbstractBlock block = null;
        Length node_offset = this.getOffset(key);
        Length new_length = null;
        Length old_length = this.getLength(key);
        if (node instanceof DrbNodeImpl && (block = (AbstractBlock)((DrbNodeImpl)node).getImpl(AbstractBlock.class)) != null && this.schemaNodePath != null && this.schemaNodePath.equals(block.descriptor.schemaNodePath)) {
            this.setLength(key, block.getLength());
            new_length = block.getLength();
            Length old_end_offset = new Length(node_offset.getLength() + old_length.getLength(), node_offset.getBitLength() + old_length.getBitLength());
            Length new_end_offset = new Length(node_offset.getLength() + new_length.getLength(), node_offset.getBitLength() + new_length.getBitLength());
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("Descriptor<" + this.getPath() + ">.replace(): Replaced " + old_length + " byte(s)  from " + block.getOffset() + " by " + new_length + " byte(s) into \"" + this.getFile() + "\" at offset=" + node_offset + ".");
                }
                this.getFile().move(old_end_offset, new_end_offset);
            }
            catch (IOException ex) {
                logger.error(ex);
                logger.error("Descriptor.blockReplace(): Unable to replace " + old_length + " byte(s) into \"" + this.getFile() + "\" at offset=" + node_offset + ".");
            }
            long result = Descriptor.copyFileSegment(block.descriptor.getFile(), block.getOffset(), this.getFile(), node_offset, block.getLength());
            this.getBase().blockReplaced(new BlockEvent(BlockEvent.REPLACE, this.getNamedInstance(node.getName()), key));
            Descriptor.copyChildDescriptor(block.key, block.descriptor.getBase(), key, this.getBase());
        } else {
            File temp_file = null;
            RandomAccessData output_file = this.getFile();
            if (this.contentLength.getType() != 1 && node_offset.getLength() < output_file.length()) {
                try {
                    temp_file = File.createTempFile("sdf-" + this.getName() + "-", ".tmp");
                    output_file = new RandomAccessFileData(temp_file);
                    Length output_offset = new Length(0L);
                    new_length = this.serializeNode(node, key, output_file, output_offset);
                    Length old_end_offset = new Length(node_offset.getLength() + old_length.getLength(), node_offset.getBitLength() + old_length.getBitLength());
                    Length new_end_offset = new Length(node_offset.getLength() + new_length.getLength(), node_offset.getBitLength() + new_length.getBitLength());
                    if (logger.isDebugEnabled()) {
                        logger.debug("Descriptor<" + this.getPath() + ">.replace(): Replaced " + old_length + " byte(s) by " + new_length + " byte(s) into \"" + this.getFile() + "\" at offset=" + node_offset + ".");
                    }
                    this.getFile().move(old_end_offset, new_end_offset);
                    long result = Descriptor.copyFileSegment(output_file, output_offset, this.getFile(), node_offset, new_length);
                    output_file.close();
                    temp_file.delete();
                }
                catch (IOException ex) {
                    logger.error(ex);
                    logger.error("Descriptor.replace(): Unable to copy the node to the temporary file.");
                    throw new DynamicException(this.getPath() + "Unable to copy the node to the temporary file." + IntMap.keyToString(key));
                }
            } else {
                this.serializeNode(node, key, this.getFile(), node_offset);
                new_length = old_length;
            }
            this.getBase().blockReplaced(new BlockEvent(BlockEvent.REPLACE, this.getNamedInstance(node.getName()), key));
        }
        this.setOffset(key, node_offset);
        this.setLength(key, new_length);
        if (!return_node) {
            return null;
        }
        return AbstractBlock.createOptimalBlock(this, key, -1);
    }

    protected void remove(int[] key) throws UnsupportedOperationException {
        if (this.substitutionGroup != null) {
            this.getBase().remove(key);
            return;
        }
        if (this.occurrenceCount.getAccessType() == 1) {
            logger.error("Descriptor.remove(): " + this.getPath() + " has read-only occurrence.");
            throw new DynamicException(this.getPath() + "Unable to remove node with fixed occurrence." + IntMap.keyToString(key));
        }
        int[] sibling_key = IntMap.getSiblingKey(key, 0);
        int currentOccurrenceCount = this.getOccurrenceCount(sibling_key);
        if (currentOccurrenceCount <= 0) {
            return;
        }
        Length src_offset = this.getOffset(key);
        Length src_length = this.getLength(key);
        try {
            this.getFile().move(new Length(src_offset.getLength() + src_length.getLength(), src_offset.getBitLength() + src_length.getBitLength()), src_offset);
        }
        catch (IOException ex) {
            logger.error(ex);
            logger.error("Descriptor.remove(): Unable to remove " + src_length + " byte(s) from \"" + this.getFile() + "\" at offset=" + src_offset + ").");
        }
        this.occurrenceCount.setValue(IntMap.getSiblingKey(sibling_key, 0), currentOccurrenceCount - 1);
        BlockEvent remove_event = new BlockEvent(BlockEvent.REMOVE, this, key);
        this.blockRemoved(remove_event);
    }

    protected DrbNode create(DrbNode node, int[] key, boolean return_node, int level) throws UnsupportedOperationException, IOException {
        if (node == null) {
            throw new NullPointerException("Descriptor.create(): The reference to the node to replace is null.");
        }
        if (!this.isSame(node.getName())) {
            throw new UnsupportedOperationException("Descriptor.create(): \"" + this.getName() + "\" node does not accept any child named \"" + node.getName() + "\".");
        }
        AbstractBlock block = null;
        Length node_offset = this.getOffset(key);
        Length new_length = null;
        if (node instanceof DrbNodeImpl && (block = (AbstractBlock)((DrbNodeImpl)node).getImpl(AbstractBlock.class)) != null && this.schemaNodePath != null && this.schemaNodePath.equals(block.descriptor.schemaNodePath)) {
            this.setLength(key, block.getLength());
            new_length = block.getLength();
            Length new_end_offset = new Length(node_offset.getLength() + new_length.getLength(), node_offset.getBitLength() + new_length.getBitLength());
            if (logger.isDebugEnabled()) {
                logger.debug("Descriptor<" + this.getPath() + ">.create(): Created " + new_length + " byte(s) into \"" + this.getFile() + "\" at offset=" + node_offset + ".");
            }
            long result = Descriptor.copyFileSegment(block.descriptor.getFile(), block.getOffset(), this.getFile(), node_offset, block.getLength());
            Descriptor.copyChildDescriptor(block.key, block.descriptor.getBase(), key, this.getBase());
        } else {
            File temp_file = null;
            RandomAccessData output_file = this.getFile();
            if (this.contentLength.getType() != 1 && node_offset.getLength() < output_file.length()) {
                try {
                    temp_file = File.createTempFile("sdf-" + this.getName() + "-", ".tmp");
                    output_file = new RandomAccessFileData(temp_file);
                    Length output_offset = new Length(0L);
                    new_length = this.serializeNode(node, key, output_file, output_offset);
                    Length new_end_offset = new Length(node_offset.getLength() + new_length.getLength(), node_offset.getBitLength() + new_length.getBitLength());
                    if (logger.isDebugEnabled()) {
                        logger.debug("Descriptor<" + this.getPath() + ">.create(): Created " + new_length + " byte(s) into \"" + this.getFile() + "\" at offset=" + node_offset + ".");
                    }
                    long result = Descriptor.copyFileSegment(output_file, output_offset, this.getFile(), node_offset, new_length);
                    output_file.close();
                    temp_file.delete();
                }
                catch (IOException ex) {
                    logger.error(ex);
                    logger.error("Descriptor.create(): Unable to copy the node to the temporary file.");
                    throw new DynamicException(this.getPath() + "Unable to copy the node to the temporary file." + IntMap.keyToString(key));
                }
            } else {
                Length new_end_offset = this.serializeNode(node, key, this.getFile(), node_offset);
                new_length = new Length(new_end_offset.getLength() - node_offset.getLength(), new_end_offset.getBitLength() - node_offset.getBitLength());
                if (logger.isDebugEnabled()) {
                    logger.debug("Descriptor{" + this.getPath() + "}.create: Direct serialization. node_offset=" + node_offset + " new_length=" + new_length + " new_offset=" + new_end_offset);
                }
            }
        }
        if (key.length != 0 && this.occurrenceCount.getAccessType() != 1) {
            this.occurrenceCount.setValue(IntMap.getSiblingKey(key, 0), key[key.length - 1] + 1);
            if (logger.isDebugEnabled()) {
                logger.debug("Descriptor{" + this.getPath() + "}.create: occurrence=" + this.getOccurrenceCount(key));
            }
        }
        if (!return_node) {
            return null;
        }
        return AbstractBlock.createOptimalBlock(this, key, -1);
    }

    /*
     * Unable to fully structure code
     */
    protected final Length serializeNode(DrbNode node, int[] key, RandomAccessData output_file, Length output_offset) {
        instance_desc = this.getNamedInstance(node.getName());
        if (instance_desc != this) {
            return instance_desc.serializeNode(node, key, output_file, output_offset);
        }
        if (this.valueType != -1) {
            return this.serializeValue(node.getValue(), output_file, output_offset, null);
        }
        try {
            block23: {
                child_offset = new Length(output_offset.getLength(), output_offset.getBitLength());
                output_file.seek(output_offset);
                if (this.headerPadding.length > 0) {
                    output_file.writeBytes(Descriptor.getFixedString(this.headerPadding.content, this.headerPadding.length, ' '));
                    child_offset.setLength(child_offset.getLength() + (long)this.headerPadding.length, child_offset.getBitLength());
                }
                if (this.getChildrenCount() <= 0) break block23;
                child_key = null;
                first_child_key = null;
                if (key != null) {
                    child_key = IntMap.getChildKey(key, 0);
                }
                child_length = null;
                child_desc = null;
                child_occurs = 0L;
                max_occurs = 0L;
                children_count = node.getChildrenCount();
                child_desc = this.getFirstChild();
                child_occurs = 0L;
                max_occurs = child_desc.getMaxOccurs();
                for (i = 0; i < children_count; ++i) {
                    child_node = node.getChildAt(i);
                    while (!child_desc.isSame(child_node.getName())) {
                        if (child_desc.occurrenceCount.getType() != 1 || child_occurs >= child_desc.occurrenceCount.getValue()) ** GOTO lbl37
                        if (child_desc.contentLength.getType() == 1 && child_desc.contentLength.getValue() >= 0L) {
                            padd_length = child_desc.headerPadding.length + child_desc.footerPadding.length + child_desc.delimiter.length();
                            child_occurs = child_desc.occurrenceCount.getValue() - child_occurs;
                            child_length = child_desc.contentLength.getLength(null);
                            child_offset.setLength(child_offset.getLength() + child_occurs * (child_length.getLength() + (long)padd_length), (long)child_offset.getBitLength() + child_occurs * (long)child_length.getBitLength());
                        } else {
                            Descriptor.logger.error("Descriptor.serializeNode(): Error while writing content at " + this.getPath() + ": Missing children before \"" + child_node.getName() + "\"");
                            throw new UnsupportedOperationException("Error while writing content at " + this.getPath() + ": Missing children before \"" + child_node.getName() + "\"");
lbl37:
                            // 1 sources

                            if (child_key != null && child_desc.occurrenceCount.getType() != 1) {
                                child_key[child_key.length - 1] = 0;
                                child_desc.setOccurrenceCount(child_key, child_occurs);
                            }
                        }
                        child_desc = child_desc.getNextSibling();
                        if (child_desc == null) {
                            Descriptor.logger.error("Descriptor.serializeNode(): at " + this.getPath() + "Error while writing content for node \"" + child_node.getName() + "\"");
                            throw new UnsupportedOperationException("at " + this.getPath() + ": Cannot find description for node \"" + child_node.getName() + "\"\n");
                        }
                        child_occurs = 0L;
                        max_occurs = child_desc.getMaxOccurs();
                    }
                    if (child_occurs >= max_occurs) {
                        Descriptor.logger.error("Descriptor.serializeNode() at " + this.getPath() + ": occurrence count is over the limit =" + max_occurs + " for child \"" + child_node.getName() + "\"");
                        throw new UnsupportedOperationException("Error while writing content at " + this.getPath() + ": Occurrence count is over the limit =" + max_occurs + " for child \"" + child_node.getName() + "\"");
                    }
                    local_offset = null;
                    previous_offset = child_offset;
                    if (++child_occurs == 1L && child_desc.blockOffset.getType() == 1) {
                        local_offset = child_desc.blockOffset.getLength(null);
                    }
                    if (child_desc.blockOffset.getOrigin() == 2) {
                        previous_offset = output_offset;
                    }
                    if (local_offset != null && local_offset.getLength() + (long)local_offset.getBitLength() > 0L) {
                        new_child_offset = new Length(previous_offset.getLength() + local_offset.getLength(), previous_offset.getBitLength() + local_offset.getBitLength());
                        if (this.encoding == 2 || child_desc.encoding == 2) {
                            output_file.clear(child_offset, new_child_offset, (byte)32);
                        } else {
                            output_file.clear(child_offset, new_child_offset, (byte)0);
                        }
                        child_offset = new_child_offset;
                    }
                    if (child_key != null) {
                        child_key[child_key.length - 1] = (int)child_occurs - 1;
                    }
                    child_length = child_desc.serializeNode(child_node, child_key, output_file, child_offset);
                    child_offset.setLength(child_offset.getLength() + child_length.getLength(), child_offset.getBitLength() + child_length.getBitLength());
                }
                if (this.contentLength.getType() == 1 && this.contentLength.getValue() >= 0L) {
                    content_length = this.contentLength.getLength(null);
                    child_offset.setLength(output_offset.getLength() + content_length.getLength() + (long)this.headerPadding.length, output_offset.getBitLength() + content_length.getBitLength());
                }
            }
            if (this.footerPadding.length > 0) {
                output_file.seek(child_offset);
                output_file.writeBytes(Descriptor.getFixedString(this.footerPadding.content, this.footerPadding.length, ' '));
            }
            if (this.delimiter.length() > 0) {
                if (this.footerPadding.length == 0) {
                    output_file.seek(child_offset);
                }
                output_file.writeBytes(this.delimiter);
            }
            return new Length(child_offset.getLength() + (long)this.footerPadding.length + (long)this.delimiter.length() - output_offset.getLength(), child_offset.getBitLength() - output_offset.getBitLength());
        }
        catch (IOException e) {
            Descriptor.logger.error(e);
            e.printStackTrace();
            Descriptor.logger.error("Descriptor.serializeNode(): Error while writing content for node \"" + this.getPath());
            throw new UnsupportedOperationException("Descriptor.serializeNode(): \"" + this.getPath());
        }
    }

    protected final Length serializeValue(Value value, RandomAccessData output_file, Length output_offset, Length default_length) {
        Length start_offset = output_offset;
        Length value_length = null;
        Length item_length = null;
        Object content_length = null;
        long item_count = -1L;
        Object output_value = null;
        if (this.contentLength.getType() == 1) {
            value_length = this.contentLength.getLength(null);
        }
        if (value_length == null) {
            value_length = default_length;
        }
        if (this.valueType == 10) {
            if (this.itemCount.getType() == 1) {
                item_count = this.itemCount.getValue();
            }
            if (this.itemLength.getType() == 1) {
                item_length = this.itemLength.getLength(null);
            }
        }
        try {
            Length compute_length;
            output_file.seek(start_offset);
            if (this.headerPadding.length > 0) {
                output_file.writeBytes(Descriptor.getFixedString(this.headerPadding.content, this.headerPadding.length, ' '));
                start_offset = new Length(output_offset.getLength() + (long)this.headerPadding.length, output_offset.getBitLength());
            }
            if ((compute_length = BlockTools.encodeValue(output_file, this, start_offset, value_length, item_count, item_length, value)) == null) {
                logger.warn("<" + this.getPath() + ">.serializeValue: Cannot encode the value at offset " + start_offset);
                logger.debug(this);
            } else if (value_length == null) {
                value_length = compute_length;
            }
            if (this.footerPadding.length > 0) {
                output_file.writeBytes(Descriptor.getFixedString(this.footerPadding.content, this.footerPadding.length, ' '));
            }
            if (this.delimiter.length() > 0) {
                output_file.writeBytes(this.delimiter);
            }
            return new Length(value_length.getLength() + (long)this.headerPadding.length + (long)this.footerPadding.length + (long)this.delimiter.length(), value_length.getBitLength());
        }
        catch (IOException e) {
            logger.error(e);
            e.printStackTrace();
            logger.error("Descriptor.serializeValue(): Error while writing value for node \"" + this.getPath());
            return null;
        }
    }

    protected static final long copyFileSegment(RandomAccessData input_file, Length input_offset, RandomAccessData output_file, Length output_offset, Length length) {
        if (input_file == null || output_file == null || input_offset == null || output_offset == null || length == null) {
            logger.error("Descriptor.copyFileSegment(): Invalid parameter(s) :");
            logger.error("   input_file    = " + input_file);
            logger.error("   input_offset  = " + input_offset);
            logger.error("   output_file   = " + output_file);
            logger.error("   output_offset = " + output_offset);
            logger.error("   length       = " + length);
            return -1L;
        }
        int curRead = 0;
        int totalRead = 0;
        try {
            input_file.seek(input_offset.getLength(), input_offset.getBitLength());
            output_file.seek(output_offset.getLength(), output_offset.getBitLength());
            int MAX_BUFFER_SIZE = 10240;
            if (length.getLength() < (long)MAX_BUFFER_SIZE) {
                MAX_BUFFER_SIZE = (int)length.getLength();
            }
            byte[] buffer = new byte[MAX_BUFFER_SIZE];
            long loopNumber = length.getLength() / (long)MAX_BUFFER_SIZE;
            int curLength = MAX_BUFFER_SIZE;
            byte curBitLength = 0;
            int lastLength = (int)(length.getLength() % (long)MAX_BUFFER_SIZE);
            for (long i = 0L; i <= loopNumber; ++i) {
                if (i == loopNumber) {
                    curLength = lastLength;
                    curBitLength = length.getBitLength();
                    if (curBitLength == 0) {
                        buffer = new byte[lastLength];
                        logger.debug("Copying block without  remaining bits.");
                    } else {
                        buffer = new byte[lastLength + 1];
                        logger.debug("Copying block with " + curBitLength + " remaining bits.");
                    }
                }
                logger.debug("Reading block loop=" + i + "/" + loopNumber + " length=(" + curLength + "," + curBitLength + ")  buf_len=" + buffer.length + " totalRead=" + totalRead);
                curRead = curLength;
                if (input_file == output_file) {
                    input_file.seek(input_offset.getLength() + (long)totalRead, input_offset.getBitLength());
                }
                if (curBitLength == 0) {
                    input_file.readFully(buffer);
                } else {
                    input_file.readFully(buffer, 0, new Length(curLength, curBitLength));
                }
                if (curRead < curLength) {
                    if (curRead == -1) {
                        logger.info("Descriptor.copyFileSegment(): EOF reached in input file");
                        return totalRead;
                    }
                    byte[] tmpBuffer = new byte[curRead];
                    System.arraycopy(buffer, 0, tmpBuffer, 0, curRead);
                    buffer = tmpBuffer;
                    i = loopNumber;
                }
                if (input_file == output_file) {
                    output_file.seek(output_offset.getLength() + (long)totalRead, output_offset.getBitLength());
                }
                logger.debug("Writing block loop=" + i + "/" + loopNumber + " length=(" + curLength + "," + curBitLength + ")  buf_len=" + buffer.length + " totalRead=" + totalRead);
                if (curBitLength == 0) {
                    output_file.write(buffer);
                } else {
                    output_file.write(buffer, 0, new Length(curLength, curBitLength));
                }
                totalRead += curRead;
            }
            return totalRead;
        }
        catch (IOException e) {
            logger.error(e);
            logger.error("Descriptor.copyFileSegment(): Unable to copy " + length + " byte(s) from \"" + input_file + "\" (offset=" + input_offset + ") to \"" + output_file + "\" (offset=" + output_offset + ").");
            return -1L;
        }
    }

    protected final long solveOccurrenceCount(int[] key, long occurs_limit) {
        if (!this.occurrenceCount.hasQuery()) {
            try {
                if (this.getLengthType() <= 2 && this.signature == null && this.substitution.size() == 0) {
                    this.occurrenceCount.setValue(key, 1L);
                    RandomAccessData file = this.getFile();
                    Length block_offset = this.getOffset(key);
                    Length block_length = this.getLength(key);
                    long file_len = file.length();
                    long occurs = (8L * file_len - 8L * block_offset.getLength() - (long)block_offset.getBitLength()) / (8L * block_length.getLength() + (long)block_length.getBitLength());
                    this.occurrenceCount.setValue(key, occurs);
                    return occurs;
                }
                long occurs = -this.occurrenceCount.getValue(key);
                int[] sibling_key = IntMap.getSiblingKey(key, 0);
                if (occurs < 1L) {
                    occurs = 1L;
                }
                long file_len = this.getFile().length();
                while (occurs <= occurs_limit) {
                    Length current_offset;
                    this.occurrenceCount.setValue(key, occurs);
                    sibling_key[sibling_key.length - 1] = (int)occurs - 1;
                    if (!this.checkSignature(sibling_key) || (current_offset = this.getOffset(sibling_key)).getLength() >= file_len) break;
                    Length current_length = this.getLength(sibling_key);
                    if (current_offset.getLength() + current_length.getLength() > file_len) break;
                    ++occurs;
                }
                if (occurs > occurs_limit) {
                    this.occurrenceCount.setValue(key, -occurs_limit - 1L);
                } else {
                    this.occurrenceCount.setValue(key, occurs - 1L);
                }
                return occurs - 1L;
            }
            catch (Exception e) {
                logger.error("fr.gael.drb.impl.sdf.Descriptor.solveOccurrence() : Cannot solve unbounded occurrence (" + e + ")");
                e.printStackTrace();
                return -1L;
            }
        }
        return this.occurrenceCount.solveValue(this.createOptimalBlock(key));
    }

    protected final boolean isValidKey(int[] key) {
        if (key == null || key.length != this.depth) {
            return false;
        }
        if (key.length == 0) {
            return true;
        }
        int index = key[key.length - 1];
        return index >= 0 && index < this.getBase().getOccurrenceCount(IntMap.getSiblingKey(key, 0), (long)index + 1L);
    }

    private final Length solveOffset(int[] key) {
        Length previousOffset;
        Length solvedOffset;
        int occurrence = key[key.length - 1];
        Length localOffset = this.blockOffset.getLength(key);
        if (this.blockOffset.hasQuery()) {
            localOffset = this.blockOffset.solveLength(this.createOptimalBlock(key));
            if (localOffset == null) {
                throw new DynamicException(this.getPath() + ": cannot evaluate query for key=" + IntMap.keyToString(key));
            }
            this.blockOffset.setLength(key, localOffset);
        }
        Descriptor previousDesc = null;
        int[] previousKey = null;
        if (this.fileNodePath != null && occurrence == 0) {
            solvedOffset = new Length(0L);
        } else if (localOffset != null && this.blockOffset.getOrigin() != 3) {
            if (this.blockOffset.getOrigin() == 1 || this.getParent() == null) {
                previousDesc = this.getRoot();
                previousKey = new int[]{};
            } else if (this.blockOffset.getOrigin() == 2) {
                previousDesc = this.getParent();
                previousKey = IntMap.getParentKey(key);
            }
            previousOffset = previousDesc.getOffset(previousKey);
            solvedOffset = new Length(previousOffset.getLength() + (long)previousDesc.headerPadding.length, previousOffset.getBitLength());
        } else if (!this.offset.hasQuery()) {
            int descOccurrenceCount = occurrence;
            previousDesc = this;
            boolean previousFound = false;
            int previousFactor = 1;
            while (!previousFound && previousDesc != null) {
                if (descOccurrenceCount > 0) {
                    int lengthType = previousDesc.getLengthType();
                    if (descOccurrenceCount == 1 || lengthType <= 2) {
                        previousKey = IntMap.getSiblingKey(key, 0);
                        previousFactor = descOccurrenceCount++;
                        if (previousDesc == this) {
                            // empty if block
                        }
                    } else {
                        previousKey = IntMap.getSiblingKey(key, descOccurrenceCount - 1);
                    }
                    previousFound = true;
                    continue;
                }
                if ((previousDesc = previousDesc.getPreviousSibling()) == null) continue;
                previousKey = IntMap.getSiblingKey(key, 0);
                descOccurrenceCount = previousDesc.getOccurrenceCount(previousKey);
            }
            if (!previousFound) {
                previousDesc = this.getParent();
                previousKey = IntMap.getParentKey(key);
                previousOffset = previousDesc.getOffset(previousKey);
                solvedOffset = new Length(previousOffset.getLength() + (long)previousDesc.headerPadding.length, previousOffset.getBitLength());
            } else if (previousDesc.getLengthType() == 3 && descOccurrenceCount > 1) {
                TreeSet key_set;
                int start_index = 0;
                if (previousKey[previousKey.length - 1] > 0 && (key_set = new TreeSet(previousDesc.length.getSiblingKeys(previousKey))) != null && !key_set.isEmpty() && (start_index = ((Number)key_set.last()).intValue()) > previousKey[previousKey.length - 1] && (start_index = ((Number)key_set.first()).intValue()) > previousKey[previousKey.length - 1]) {
                    start_index = 0;
                }
                int[] sibling_key = IntMap.getSiblingKey(previousKey, start_index);
                previousOffset = previousDesc.getOffset(sibling_key);
                Length previousLength = previousDesc.getLength(sibling_key);
                long byte_offset = previousOffset.getLength();
                long bit_offset = previousOffset.getBitLength();
                for (int i = start_index + 1; i <= previousKey[previousKey.length - 1]; ++i) {
                    sibling_key = IntMap.getSiblingKey(previousKey, i);
                    previousDesc.setOffset(sibling_key, new Length(byte_offset += previousLength.getLength(), bit_offset += (long)previousLength.getBitLength()));
                    previousLength = previousDesc.getLength(sibling_key);
                }
                solvedOffset = new Length(byte_offset += previousLength.getLength(), bit_offset += (long)previousLength.getBitLength());
            } else {
                Length previousLength = previousDesc.getLength(previousKey);
                previousOffset = previousDesc.getOffset(previousKey);
                solvedOffset = new Length(previousOffset.getLength() + (long)previousFactor * previousLength.getLength(), previousOffset.getBitLength() + previousFactor * previousLength.getBitLength());
            }
        } else {
            solvedOffset = this.offset.solveLength(this.createOptimalBlock(key));
        }
        if (occurrence == 0) {
            if (localOffset != null) {
                solvedOffset.setLength(solvedOffset.getLength() + localOffset.getLength(), solvedOffset.getBitLength() + localOffset.getBitLength());
            } else if (this.blockOffset.getOrigin() == 2) {
                previousDesc = this.getParent();
                previousKey = IntMap.getParentKey(key);
                previousOffset = previousDesc.getOffset(previousKey);
                localOffset = new Length(solvedOffset.getLength() - previousOffset.getLength(), solvedOffset.getBitLength() - previousOffset.getBitLength());
                this.blockOffset.setLength(key, localOffset);
            }
        }
        return solvedOffset;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Length solveLength(int[] key) {
        long totalBitLength = 0L;
        long totalLength = 0L;
        if (this.contentLength.hasQuery()) {
            int[] keyToUse;
            if (this.getLengthType() <= 2) {
                keyToUse = new int[key.length];
                int i = 0;
                while (i < key.length) {
                    keyToUse[i] = 0;
                    ++i;
                }
                return this.contentLength.solveLength(this.createOptimalBlock(keyToUse));
            }
            keyToUse = key;
            return this.contentLength.solveLength(this.createOptimalBlock(keyToUse));
        }
        Descriptor instance_desc = this.getInstance(key);
        if (instance_desc != this) {
            return instance_desc.getLength(key);
        }
        Length childAdditionalOffset = new Length(0L);
        if (this.valueType != -1) {
            if (this.valueType == 10 && (this.itemCount.getAccessType() == 1 || this.itemCount.hasQuery()) && (this.itemLength.getAccessType() == 1 || this.itemLength.hasQuery())) {
                int item_occurs = this.getItemOccurrenceCount(key);
                Length item_length = this.getItemLength(key);
                totalLength = (long)item_occurs * item_length.getLength();
                totalBitLength = item_occurs * item_length.getBitLength();
            } else {
                if (this.getEncoding() != 2) return null;
                Length start_offset = new Length(-1L, -1L);
                Length stop_offset = new Length(-1L, -1L);
                Value value = this.getValue(key, start_offset, stop_offset);
                if (value == null) return null;
                totalLength = stop_offset.getLength() - start_offset.getLength();
            }
        }
        int[] first_child_key = IntMap.getChildKey(key, 0);
        int iDesc = 0;
        while (iDesc < this.children.size()) {
            Length childLength;
            int lengthType;
            Descriptor childDesc = (Descriptor)this.children.get(iDesc);
            int childOccurrenceCount = childDesc.getOccurrenceCount(first_child_key);
            if (childDesc.blockOffset.getOrigin() == 3 && childOccurrenceCount > 0) {
                childAdditionalOffset = childDesc.blockOffset.getLength(first_child_key);
                if (childAdditionalOffset != null) {
                    totalLength += childAdditionalOffset.getLength();
                    totalBitLength += (long)childAdditionalOffset.getBitLength();
                }
            } else if (childDesc.blockOffset.getOrigin() == 2 && childDesc.blockOffset.getValue(null) >= 0L) {
                Length solvedLength = childDesc.blockOffset.getLength(first_child_key);
                totalLength = solvedLength.getLength();
                totalBitLength = solvedLength.getBitLength();
            }
            if ((lengthType = childDesc.getLengthType()) <= 2) {
                childLength = childDesc.getLength(first_child_key);
                if (childLength == null) {
                    logger.warn("fr.gael.drb.impl.sdf.Descriptor.solveLength() : Unable to get \"" + childDesc.getPath() + "\" length.");
                    throw new DynamicException("Unable to get \"" + childDesc.getPath() + "\" length.");
                }
                totalLength += childLength.getLength() * (long)childOccurrenceCount;
                totalBitLength += (long)(childLength.getBitLength() * childOccurrenceCount);
            } else {
                for (int iOccur = 0; iOccur < childOccurrenceCount; ++iOccur) {
                    childLength = childDesc.getLength(IntMap.getChildKey(key, iOccur));
                    if (childLength == null) {
                        logger.warn("fr.gael.drb.impl.sdf.Descriptor.solveLength() : Unable to get \"" + childDesc.getName() + "[" + iOccur + "]\" length.");
                        throw new DynamicException("Unable to get \"" + childDesc.getName() + "[" + iOccur + "]\" length.");
                    }
                    totalLength += childLength.getLength();
                    totalBitLength += (long)childLength.getBitLength();
                }
            }
            ++iDesc;
        }
        return new Length(totalLength, totalBitLength);
    }

    protected final long queryEval(int[] key, Query query_obj, String query_str) {
        DrbSequence item_list;
        this.contextNode = this.createOptimalBlock(key);
        if (query_obj == null) {
            try {
                query_obj = new Query(query_str);
            }
            catch (Exception e) {
                logger.error("fr.gael.drb.impl.sdf.Descriptor.queryEval() : Cannot parse query (" + e + ")");
                return -1L;
            }
        }
        if ((item_list = query_obj.evaluate(this.contextNode)) == null || item_list.getLength() <= 0) {
            return -1L;
        }
        DrbItem result_item = item_list.getItem(0);
        Value result_value = result_item.getValue();
        if (result_value == null) {
            return -1L;
        }
        try {
            result_value = result_value.convertTo(3);
        }
        catch (ClassCastException e) {
            logger.error("fr.gael.drb.impl.sdf.Descriptor.queryEval() : Cannot convert value '" + result_value + "' to integer." + result_value.getClass() + "\n");
            return -1L;
        }
        return ((Int)result_value).intValue();
    }

    protected final Value queryEvalValue(int[] key, Query query_obj, String query_str) {
        DrbSequence item_list;
        this.contextNode = this.createOptimalBlock(key);
        if (query_obj == null) {
            try {
                query_obj = new Query(query_str);
            }
            catch (Exception e) {
                logger.error("fr.gael.drb.impl.sdf.Descriptor.queryEval() : Cannot parse query (" + e + ")");
                return null;
            }
        }
        if ((item_list = query_obj.evaluate(this.contextNode)) == null || item_list.getLength() <= 0) {
            logger.error("fr.gael.drb.impl.sdf.Descriptor.queryEval() : Empty result list. (query='" + query_str + "'");
            return null;
        }
        DrbItem result_item = item_list.getItem(0);
        Value result_value = result_item.getValue();
        return result_value;
    }

    protected final boolean checkSignature(int[] key) {
        if (this.signature != null) {
            if (this.signature.query != null) {
                return this.queryEval(key, this.signature.queryObject, this.signature.query) == 1L;
            }
            return ((Comparison)((Object)this.signature.value)).compareTo(this.getValue(key)) == 0;
        }
        if (!this.type.isComplex() || this.substitution.size() == 0) {
            return true;
        }
        for (int idesc = 0; idesc < this.substitution.size(); ++idesc) {
            Descriptor substitution_desc = (Descriptor)this.substitution.get(idesc);
            if (!substitution_desc.checkSignature(key)) continue;
            return true;
        }
        return false;
    }

    protected final Descriptor getBase() {
        if (this.substitutionGroup == null) {
            return this;
        }
        return this.substitutionGroup.getBase();
    }

    protected final Descriptor getInstance(int[] key) {
        if (this.substitution.size() <= 0) {
            return this;
        }
        int idesc = (int)this.substitutionMap.getValue(key);
        if (idesc != -1) {
            return (Descriptor)this.substitution.get(idesc);
        }
        for (idesc = 0; idesc < this.substitution.size(); ++idesc) {
            Descriptor substitution_desc = (Descriptor)this.substitution.get(idesc);
            if (!substitution_desc.checkSignature(key)) continue;
            this.substitutionMap.setValue(key, idesc);
            return substitution_desc;
        }
        return this;
    }

    protected final boolean hasSignature() {
        return this.signature != null || this.substitution.size() > 0;
    }

    protected final Descriptor getSubstitution(int index) {
        return (Descriptor)this.substitution.get(index);
    }

    protected final int getSubstitutionCount() {
        return this.substitution.size();
    }

    protected final Descriptor getNamedInstance(String name) {
        if (this.name.equals(name)) {
            return this;
        }
        for (int idesc = 0; idesc < this.substitution.size(); ++idesc) {
            Descriptor substitution_desc = this.getSubstitution(idesc);
            if ((substitution_desc = substitution_desc.getNamedInstance(name)) == null) continue;
            return substitution_desc;
        }
        return null;
    }

    protected final Descriptor getNamedChild(String name) {
        for (Descriptor childDesc = this.getFirstChild(); childDesc != null; childDesc = childDesc.getNextSibling()) {
            if (!childDesc.isSame(name)) continue;
            return childDesc;
        }
        return null;
    }

    protected final boolean isSame(String name) {
        if (this.name.equals(name)) {
            return true;
        }
        for (int idesc = 0; idesc < this.substitution.size(); ++idesc) {
            Descriptor substitution_desc = this.getSubstitution(idesc);
            if (!substitution_desc.isSame(name)) continue;
            return true;
        }
        return false;
    }

    protected final Long getMaxOccurs() {
        if (this.occurrenceCount.getAccessType() == 1) {
            return this.occurrenceCount.getValue();
        }
        return Long.MAX_VALUE;
    }

    protected final String getNodeName(int[] key) {
        return this.name;
    }

    protected final int getOccurrenceCount(int[] key) {
        return this.getOccurrenceCount(key, Long.MAX_VALUE);
    }

    protected final int getChildrenCount(int[] key, int occurs_limit) {
        Descriptor childDesc;
        Descriptor instance_desc = this.getInstance(key);
        if (instance_desc != this) {
            return instance_desc.getChildrenCount(key, occurs_limit);
        }
        long tmpValue = this.childrenCount.getValue(key);
        if (tmpValue >= 0L) {
            return (int)tmpValue;
        }
        int childrenCount = 0;
        for (childDesc = this.getFirstChild(); childDesc != null; childDesc = childDesc.getNextSibling()) {
            int current_count = childDesc.getOccurrenceCount(IntMap.getChildKey(key, 0), (long)occurs_limit - (long)childrenCount);
            if ((childrenCount += current_count) < occurs_limit) continue;
            break;
        }
        if (childDesc == null) {
            this.childrenCount.setValue(key, childrenCount);
        }
        return childrenCount;
    }

    protected final int getOccurrenceCount(int[] key, Long occurs_limit) {
        long tmpValue = -1L;
        tmpValue = this.occurrenceCount.getValue(key);
        if (tmpValue < 0L) {
            tmpValue = this.solveOccurrenceCount(key, occurs_limit);
            if (tmpValue == -1L) {
                logger.debug("Unable to solve occurrence count for node " + this.getPath());
                return 0;
            }
            if (this.occurrenceCount.hasQuery()) {
                this.setOccurrenceCount(key, tmpValue);
            }
        }
        return (int)tmpValue;
    }

    protected final int getItemOccurrenceCount(int[] key) {
        long tmpValue = this.itemCount.getValue(key);
        if (tmpValue < 0L && this.itemCount.hasQuery()) {
            tmpValue = this.itemCount.solveValue(this.createOptimalBlock(key));
            if (tmpValue == -1L) {
                logger.debug("   unable to solve item occurrence count");
                return 0;
            }
            this.itemCount.setValue(key, tmpValue);
        }
        return (int)tmpValue;
    }

    protected final Length getOffset(int[] key) {
        if (this.substitutionGroup != null) {
            return this.getBase().getOffset(key);
        }
        Length tmpValue = this.offset.getLength(key);
        if (tmpValue == null) {
            tmpValue = this.solveOffset(key);
            this.setOffset(key, tmpValue);
        }
        return tmpValue;
    }

    protected final Length getLength(int[] key) {
        boolean need_update = false;
        Length tmpValue = this.length.getLength(key);
        if (tmpValue != null) {
            return tmpValue;
        }
        tmpValue = this.contentLength.getLength(key);
        if (tmpValue == null) {
            tmpValue = this.solveLength(key);
            if (tmpValue == null) {
                logger.error("<" + this.getPath() + ">.getLength: solved length is null. key=" + IntMap.keyToString(key));
                throw new DynamicException("<" + this.getPath() + ">.getLength: solved length is null. key=" + IntMap.keyToString(key));
            }
            this.contentLength.setLength(key, tmpValue);
        }
        tmpValue.setLength(tmpValue.getLength() + (long)this.headerPadding.length + (long)this.footerPadding.length, tmpValue.getBitLength());
        if (this.delimiter.length() > 0) {
            Length end_offset = this.getOffset(key);
            end_offset.setLength(end_offset.getLength() + tmpValue.getLength(), end_offset.getBitLength() + tmpValue.getBitLength());
            try {
                char cur_char;
                char delimiter_char = this.delimiter.charAt(0);
                RandomAccessData cur_file = this.getFile();
                cur_file.seek(end_offset.getLength(), end_offset.getBitLength());
                long skipped = 1L;
                while (cur_file.available() > 0L && (cur_char = (char)cur_file.readByte()) != delimiter_char) {
                    ++skipped;
                }
                tmpValue.setLength(tmpValue.getLength() + skipped, tmpValue.getBitLength());
            }
            catch (Exception e) {
                return null;
            }
        }
        this.setLength(key, tmpValue);
        return tmpValue;
    }

    protected final Length getItemLength(int[] key) {
        Descriptor instance_desc = this.getInstance(key);
        if (instance_desc != this) {
            return instance_desc.getItemLength(key);
        }
        if (this.valueType != 10) {
            return null;
        }
        Length tmpValue = this.itemLength.getLength(key);
        if (tmpValue == null && this.itemLength.hasQuery()) {
            tmpValue = this.itemLength.solveLength(this.createOptimalBlock(key));
            this.itemLength.setLength(key, tmpValue);
        }
        return tmpValue;
    }

    protected final void setOccurrenceCountType(int type) {
        this.occurrenceCount.setAccessType(type);
    }

    protected final int getOccurrenceCountType() {
        return this.occurrenceCount.getAccessType();
    }

    protected final void setOffsetType(int type) {
        this.offset.setAccessType(type);
    }

    protected final int getOffsetType() {
        return this.offset.getType();
    }

    protected final void setLengthType(int type) {
        this.length.setAccessType(type);
    }

    protected final int getLengthType() {
        return this.length.getType();
    }

    protected final int getContentLengthType() {
        return this.contentLength.getType();
    }

    private final void setItemLengthType(int type) {
        this.itemLength.setAccessType(type);
    }

    protected final int getItemLengthType() {
        return this.itemLength.getAccessType();
    }

    protected final void setOccurrenceCount(int[] key, long value) {
        this.occurrenceCount.setValue(key, value);
    }

    protected final void setOffset(int[] key, Length value) {
        this.offset.setLength(key, value);
    }

    protected final void setLength(int[] key, Length value) {
        this.length.setLength(key, value);
    }

    protected final void setItemLength(int[] key, long value) {
        this.itemLength.setValue(key, value);
    }

    protected final DrbNode getBaseNode() {
        return this.baseNode;
    }

    protected final DrbNode getFileNode() {
        this.getFile();
        return this.fileNode;
    }

    protected final RandomAccessData getFile() {
        RandomAccessFile file_data;
        if (this.file != null) {
            return this.file;
        }
        if (this.fileNodePath == null) {
            if (this.getParent() != null) {
                return this.getParent().getFile();
            }
            this.fileNode = this.baseNode;
        } else {
            this.fileNode = null;
            try {
                Query query_obj = new Query(this.fileNodePath);
                DrbSequence item_list = query_obj.evaluate(this.getBaseNode());
                if (item_list == null || item_list.getLength() <= 0) {
                    logger.error("fr.gael.drb.impl.sdf.Descriptor.getFile() : Empty result list. (query='" + this.fileNodePath + "' baseNode='" + this.baseNode.getPath() + "'");
                    return null;
                }
                this.fileNode = (DrbNode)item_list.getItem(0);
            }
            catch (Exception e) {
                logger.error("fr.gael.drb.impl.sdf.Descriptor.getFile() : Cannot parse query (" + e + ")");
                return null;
            }
        }
        if (!(this.fileNode instanceof DrbNodeImpl)) {
            logger.error("fr.gael.drb.impl.sdf.Descriptor.getFile() : cannot retrieve a valid implementation." + (this.fileNode == null ? null : "\"" + this.fileNode.getName() + "\""));
            return null;
        }
        DrbNodeImpl baseImpl = (DrbNodeImpl)this.fileNode;
        if (this.file == null && (file_data = (RandomAccessFile)baseImpl.getImpl(RandomAccessFile.class)) != null) {
            this.file = new RandomAccessFileData(file_data);
        }
        if (this.file == null && baseImpl.hasImpl(InputStream.class)) {
            this.file = new RandomAccessStreamData(baseImpl);
        }
        if (this.file == null) {
            logger.error("fr.gael.drb.impl.sdf.Descriptor.getFile() : Unable to get RandomAccessFile implementation from node \"" + this.getBaseNodePath() + "\"");
            return null;
        }
        return this.file;
    }

    protected final String getBaseURI() {
        String path = this.baseNode.getPath();
        File baseFile = new File(path);
        try {
            if (baseFile.exists()) {
                return baseFile.toURI().toString();
            }
            URI base_uri = new URI(path);
            return base_uri.toString();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    protected final String getBaseNodePath() {
        return this.baseNode.getPath();
    }

    protected final String getFileNodePath() {
        return this.fileNodePath;
    }

    protected final String getSchemaNodePath() {
        return this.schemaNodePath;
    }

    protected final Descriptor getRoot() {
        if (this.substitutionGroup == null) {
            return this.root;
        }
        return this.substitutionGroup.getRoot();
    }

    protected final void setAsRoot(DrbNode base_node, String schema_node_path) {
        if (base_node == null) {
            logger.error("fr.gael.drb.impl.sdf.Descriptor.setAsRoot() : base_node is null.");
            throw new StaticException("fr.gael.drb.impl.sdf.Descriptor.setAsRoot() : base_node is null.");
        }
        this.offset.setUnit((short)2);
        this.offset.setAccessType(1);
        this.offset.setOccurrenceType(1);
        this.offset.setValue(0L);
        this.index = 0;
        this.setRoot(this, base_node, schema_node_path, true, 0);
    }

    private static int getDefaultEncoding(int type, int arrayType) {
        if (type == 7 || arrayType == 7) {
            return 2;
        }
        return 1;
    }

    private int getDefaultLength(int type) {
        if (this.encoding == 2) {
            switch (type) {
                case 8: {
                    return 27;
                }
            }
        } else {
            switch (type) {
                case 3: 
                case 14: {
                    return 4;
                }
                case 6: {
                    return 8;
                }
                case 5: {
                    return 4;
                }
                case 4: 
                case 15: {
                    return 8;
                }
                case 2: 
                case 13: {
                    return 2;
                }
                case 1: 
                case 12: {
                    return 1;
                }
                case 0: {
                    return 1;
                }
                case 8: {
                    return 12;
                }
            }
        }
        return -1;
    }

    private final void setRoot(Descriptor root, DrbNode base_node, String schema_node_path, boolean single_ancestors, int depth) {
        boolean singleOccurrence;
        this.root = root;
        this.baseNode = base_node;
        this.schemaNodePath = schema_node_path;
        this.singleAncestors = single_ancestors;
        this.depth = depth;
        if (this.encoding == -1) {
            if (this.substitutionGroup != null) {
                this.encoding = this.substitutionGroup.getEncoding();
                this.charsetName = this.substitutionGroup.charsetName;
            } else if (this.getParent() != null) {
                this.encoding = this.getParent().getEncoding();
                this.charsetName = this.getParent().charsetName;
            }
        }
        if (this.encoding == -1) {
            this.encoding = Descriptor.getDefaultEncoding(this.valueType, this.arrayValueType);
        }
        if (this.valueType == 7 || this.arrayValueType == 7) {
            this.encoding = 2;
        }
        if (this.encoding == 2 && this.charsetName == null) {
            this.charsetName = CHARSET_ASCII;
        }
        int[] key = new int[]{};
        for (int i = 0; i < depth; ++i) {
            key = IntMap.getChildKey(key, 0);
        }
        boolean bl = singleOccurrence = this.singleAncestors && this.getOccurrenceCountType() == 1 && this.occurrenceCount.getValue() == 1L;
        if (singleOccurrence) {
            this.blockOffset.setOccurrenceType(1);
            this.offset.setOccurrenceType(1);
            this.contentLength.setOccurrenceType(1);
            this.length.setOccurrenceType(1);
            this.itemLength.setOccurrenceType(1);
            this.itemCount.setOccurrenceType(1);
            this.childrenCount.setOccurrenceType(1);
            this.substitutionMap.setOccurrenceType(1);
        }
        if (this.singleAncestors) {
            this.occurrenceCount.setOccurrenceType(1);
        }
        int length_unit = 2;
        int offset_unit = -1;
        for (int i = 0; i < this.substitution.size(); ++i) {
            this.getSubstitution((int)i).index = this.index;
            this.getSubstitution(i).setRoot(root, base_node, schema_node_path, singleOccurrence, depth);
            if (this.getSubstitution((int)i).length.getUnit() != 1) continue;
            length_unit = 1;
            if (singleOccurrence) continue;
            offset_unit = 1;
        }
        boolean fixed_children_count = true;
        boolean fixed_content_length = true;
        boolean fixed_previous_offset = true;
        boolean constant_previous_offset = false;
        if (this.substitution.size() > 0) {
            fixed_content_length = false;
            fixed_children_count = false;
        }
        if (this.getParent() != null) {
            fixed_previous_offset = singleOccurrence && this.getParent().getOffsetType() == 1 && this.getParent().getLengthType() == 1 && this.getParent().getOccurrenceCountType() == 1;
            constant_previous_offset = singleOccurrence && this.getParent().getOffsetType() <= 2 && this.getParent().getLengthType() <= 2 && this.getParent().getOccurrenceCountType() <= 2;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            Descriptor current_child = (Descriptor)this.children.get(i);
            current_child.setParent(this);
            current_child.index = i;
            if (i > 0) {
                current_child.setPreviousSibling(this.getChildAt(i - 1));
            }
            if (i + 1 < this.children.size()) {
                current_child.setNextSibling(this.getChildAt(i + 1));
            }
            current_child.setRoot(root, base_node, schema_node_path, singleOccurrence, depth + 1);
            if (current_child.getOffsetType() == 3 && !current_child.blockOffset.hasQuery() && fixed_previous_offset && current_child.length.getType() == 1) {
                current_child.setOffsetType(1);
            }
            if (constant_previous_offset && current_child.occurrenceCount.getValue() == 1L && this.blockOffset.getOrigin() == 3 && this.blockOffset.getType() == 1 && this.blockOffset.getValue() == 0L) {
                this.blockOffset.setAccessType(current_child.getOffsetType());
                this.blockOffset.setUnit(current_child.offset.getUnit());
                this.blockOffset.setOccurrenceType(1);
                this.blockOffset.setOrigin((short)2);
                this.blockOffset.setValue(-1L);
            }
            if (current_child.length.getUnit() == 1) {
                length_unit = 1;
            }
            fixed_previous_offset = fixed_previous_offset && current_child.length.getType() == 1 && current_child.occurrenceCount.getType() == 1;
            constant_previous_offset = constant_previous_offset && current_child.length.getType() <= 2 && current_child.occurrenceCount.getType() <= 2;
            fixed_content_length = fixed_content_length && current_child.length.getType() == 1 && current_child.occurrenceCount.getType() == 1;
            fixed_children_count = fixed_children_count && current_child.occurrenceCount.getType() == 1;
        }
        if (fixed_children_count) {
            this.childrenCount.setAccessType(1);
            this.childrenCount.setOccurrenceType(1);
        }
        if (this.valueType != -1) {
            long atomic_length = -1L;
            int atomic_unit = 2;
            if (this.valueType == 10) {
                if (this.encoding == 1 && !this.itemLength.hasQuery()) {
                    this.itemLength.setAccessType(1);
                    this.itemLength.setOccurrenceType(1);
                    if (this.itemLength.getValue() < 0L) {
                        this.itemLength.setUnit((short)2);
                        this.itemLength.setValue(this.getDefaultLength(this.arrayValueType));
                    }
                }
                if (this.itemLength.getAccessType() == 1 && this.itemCount.getAccessType() == 1) {
                    this.contentLength.setAccessType(1);
                }
                if (this.itemLength.getOccurrenceType() == 1 && this.itemCount.getOccurrenceType() == 1) {
                    this.contentLength.setOccurrenceType(1);
                }
            } else if (this.encoding == 1 && !this.contentLength.hasQuery()) {
                this.contentLength.setAccessType(1);
                this.contentLength.setOccurrenceType(1);
                if (this.contentLength.getValue() < 0L) {
                    this.contentLength.setUnit((short)2);
                    this.contentLength.setValue(this.getDefaultLength(this.valueType));
                }
            }
        } else if (fixed_content_length) {
            this.contentLength.setAccessType(1);
            this.contentLength.setOccurrenceType(1);
        }
        if (this.contentLength.getType() == 1 && this.encoding == 1 && this.valueType != -1) {
            Length value_length = null;
            int atomic_type = 0;
            if (this.valueType == 10) {
                atomic_type = this.arrayValueType;
                value_length = this.itemLength.getLength(null);
            } else {
                atomic_type = this.valueType;
                value_length = this.contentLength.getLength(null);
            }
            switch (atomic_type) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    if (value_length.getLength() * 8L + (long)value_length.getBitLength() <= 8L) {
                        atomic_type = 1;
                        break;
                    }
                    if (value_length.getLength() * 8L + (long)value_length.getBitLength() <= 16L) {
                        atomic_type = 2;
                        break;
                    }
                    if (value_length.getLength() * 8L + (long)value_length.getBitLength() <= 32L) {
                        atomic_type = 3;
                        break;
                    }
                    if (value_length.getLength() * 8L + (long)value_length.getBitLength() > 64L) break;
                    atomic_type = 4;
                    break;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    if (value_length.getLength() * 8L + (long)value_length.getBitLength() <= 8L) {
                        atomic_type = 12;
                        break;
                    }
                    if (value_length.getLength() * 8L + (long)value_length.getBitLength() <= 16L) {
                        atomic_type = 13;
                        break;
                    }
                    if (value_length.getLength() * 8L + (long)value_length.getBitLength() <= 32L) {
                        atomic_type = 14;
                        break;
                    }
                    if (value_length.getLength() * 8L + (long)value_length.getBitLength() > 64L) break;
                    atomic_type = 15;
                }
            }
            if (this.valueType == 10 && atomic_type != this.arrayValueType) {
                logger.warn(this.getPath() + " item type changed to " + new XsdAtomicType(atomic_type).getName() + ". length=" + value_length);
                this.arrayValueType = atomic_type;
            } else if (this.valueType != 10 && atomic_type != this.valueType) {
                logger.warn(this.getPath() + " value type changed to " + new XsdAtomicType(atomic_type).getName());
                this.valueType = atomic_type;
            }
        }
        this.length.setUnit(this.contentLength.getUnit());
        if (this.delimiter.length() == 0) {
            this.length.setAccessType(this.contentLength.getAccessType());
        }
        if (this.delimiter.length() == 0) {
            this.length.setOccurrenceType(this.contentLength.getOccurrenceType());
        }
    }

    protected final Descriptor getParent() {
        if (this.substitutionGroup == null) {
            return this.parent;
        }
        return this.substitutionGroup.getParent();
    }

    private final void setParent(Descriptor parent) {
        this.parent = parent;
        for (Descriptor substitution_descriptor : this.substitution) {
            substitution_descriptor.setParent(parent);
        }
    }

    protected final Descriptor getFirstChild() {
        return this.getChildAt(0);
    }

    protected final Descriptor getLastChild() {
        return this.getChildAt(this.children.size() - 1);
    }

    protected final Descriptor getChildAt(int index) {
        if (index < 0) {
            logger.error("fr.gael.drb.impl.sdf.Descriptor.getChildAt() : Invalid parameter.");
            logger.error("   index = " + index);
            return null;
        }
        if (this.children.size() == 0 || index >= this.children.size()) {
            return null;
        }
        return (Descriptor)this.children.get(index);
    }

    protected final Descriptor getPreviousSibling() {
        if (this.substitutionGroup == null) {
            return this.previousSibling;
        }
        return this.substitutionGroup.getPreviousSibling();
    }

    private final void setPreviousSibling(Descriptor previous_sibling) {
        this.previousSibling = previous_sibling;
    }

    protected final Descriptor getNextSibling() {
        if (this.substitutionGroup == null) {
            return this.nextSibling;
        }
        return this.substitutionGroup.getNextSibling();
    }

    private final void setNextSibling(Descriptor next_sibling) {
        this.nextSibling = next_sibling;
    }

    protected final void addChild(Descriptor new_child) {
        if (new_child == null) {
            logger.warn("fr.gael.drb.impl.sdf.Descriptor.addChild() : Invalid parameter.");
            logger.warn("   new_child is null => children list unchanged.");
            return;
        }
        this.children.add(new_child);
    }

    protected final void addSubstitution(Descriptor new_substitution) {
        if (new_substitution == null) {
            logger.warn("fr.gael.drb.impl.sdf.Descriptor.addSubstitution() : Invalid parameter.");
            logger.warn("   new_substitution is null => list unchanged.");
            return;
        }
        new_substitution.substitutionGroup = this;
        this.substitution.add(new_substitution);
    }

    public String toString() {
        int i;
        String tmpStr;
        String info = "fr.gael.drb.impl.sdf.Descriptor {\n";
        info = info + "   Path            : " + this.getPath() + "\n";
        info = info + "   Name            : " + this.name + "\n";
        info = info + "   FullName        : " + this.fullName + "\n";
        switch (this.encoding) {
            case 1: {
                tmpStr = "BINARY";
                break;
            }
            case 2: {
                tmpStr = this.charsetName;
                break;
            }
            default: {
                tmpStr = "" + this.encoding;
            }
        }
        info = info + "   Encoding        : " + tmpStr + "\n";
        info = info + "   SingleAncestor: " + this.singleAncestors + "\n";
        info = info + "   OccurrenceCount : " + this.occurrenceCount + "\n";
        info = info + "   Bl. Offset (bytes) : " + this.blockOffset + "\n";
        info = info + "   Offset (bytes)  : " + this.offset + "\n";
        info = info + "   Length (bytes)  : " + this.length + "\n";
        info = info + "   Content (bytes)  : " + this.contentLength + "\n";
        info = info + "   itemCount : " + this.itemCount + "\n";
        info = info + "   itemLength : " + this.itemLength + "\n";
        if (this.substitution.size() > 0) {
            info = info + "   substitutionMap : " + this.substitutionMap + "\n";
        }
        info = info + "   Header padding  : " + this.headerPadding.length + " [" + this.headerPadding.content + "]\n";
        info = info + "   Footer padding  : " + this.footerPadding.length + " [" + this.footerPadding.content + "]\n";
        switch (this.valueType) {
            case -2: {
                tmpStr = "UNKNOWN_ID";
                break;
            }
            case -1: {
                tmpStr = "NULL_ID";
                break;
            }
            case 0: {
                tmpStr = "BOOLEAN_ID";
                break;
            }
            case 1: {
                tmpStr = "BYTE_ID";
                break;
            }
            case 12: {
                tmpStr = "UNSIGNED_BYTE_ID";
                break;
            }
            case 2: {
                tmpStr = "SHORT_ID";
                break;
            }
            case 13: {
                tmpStr = "UNSIGNED_SHORT_ID";
                break;
            }
            case 3: {
                tmpStr = "INT_ID";
                break;
            }
            case 14: {
                tmpStr = "UNSIGNED_INT_ID";
                break;
            }
            case 4: {
                tmpStr = "LONG_ID";
                break;
            }
            case 15: {
                tmpStr = "UNSIGNED_LONG_ID";
                break;
            }
            case 5: {
                tmpStr = "FLOAT_ID";
                break;
            }
            case 6: {
                tmpStr = "DOUBLE_ID";
                break;
            }
            case 7: {
                tmpStr = "STRING_ID";
                break;
            }
            case 8: {
                tmpStr = "DATE_ID";
                break;
            }
            case 9: {
                tmpStr = "NUMERIC_ID";
                break;
            }
            case 10: {
                tmpStr = "ARRAY_ID (inside type = " + this.arrayValueType + ")";
                break;
            }
            case 100: {
                tmpStr = "OTHER_ID";
                break;
            }
            default: {
                tmpStr = "" + this.valueType;
            }
        }
        info = info + "   Value type      : " + tmpStr + "\n";
        info = info + "   Root Name       : " + (this.root == null ? null : this.root.name) + "\n";
        info = info + "   Parent Name     : " + (this.parent == null ? null : this.parent.name) + "\n";
        info = info + "   Previous Name   : " + (this.previousSibling == null ? null : this.previousSibling.name) + "\n";
        info = info + "   Next Name       : " + (this.nextSibling == null ? null : this.nextSibling.name) + "\n";
        info = info + "   Children        : { ";
        for (i = 0; i < this.children.size(); ++i) {
            info = info + "\"" + ((Descriptor)this.children.get((int)i)).name + "\" ";
        }
        info = info + "}\n";
        info = info + "   Substitution    : { ";
        for (i = 0; i < this.substitution.size(); ++i) {
            info = info + "\"" + ((Descriptor)this.substitution.get((int)i)).name + "\" ";
        }
        info = info + "}\n";
        info = info + "}\n";
        return info;
    }

    public String toXMLString() {
        String tmpStr;
        String info = "<descriptor xmlns=\"" + AbstractBlock.SDF_NAMESPACE + "\" id=\"" + this.hashCode() + "\"";
        info = info + " name=\"" + this.name + "\"\n";
        info = info + " fullName=\"" + this.fullName + "\"\n";
        switch (this.encoding) {
            case 1: {
                tmpStr = "BINARY";
                break;
            }
            case 2: {
                tmpStr = this.charsetName;
                break;
            }
            default: {
                tmpStr = "" + this.encoding;
            }
        }
        info = info + " <encoding>" + tmpStr + "</encoding>\n";
        info = info + " <singleAncestor>" + this.singleAncestors + "</singleAncestor>\n";
        info = info + "   OccurrenceCount : " + this.occurrenceCount + "\n";
        info = info + "   Bl. Offset (bytes) : " + this.blockOffset + "\n";
        info = info + "   Offset (bytes)  : " + this.offset + "\n";
        info = info + "   Length (bytes)  : " + this.length + "\n";
        info = info + "   Content (bytes)  : " + this.contentLength + "\n";
        info = info + "   itemCount : " + this.itemCount + "\n";
        info = info + "   itemLength : " + this.itemLength + "\n";
        info = info + "   Header padding  : " + this.headerPadding.length + " [" + this.headerPadding.content + "]\n";
        info = info + "   Footer padding  : " + this.footerPadding.length + " [" + this.footerPadding.content + "]\n";
        switch (this.valueType) {
            case -2: {
                tmpStr = "UNKNOWN_ID";
                break;
            }
            case -1: {
                tmpStr = "NULL_ID";
                break;
            }
            case 0: {
                tmpStr = "BOOLEAN_ID";
                break;
            }
            case 1: {
                tmpStr = "BYTE_ID";
                break;
            }
            case 12: {
                tmpStr = "BYTE_ID";
                break;
            }
            case 2: {
                tmpStr = "SHORT_ID";
                break;
            }
            case 13: {
                tmpStr = "SHORT_ID";
                break;
            }
            case 3: {
                tmpStr = "INT_ID";
                break;
            }
            case 14: {
                tmpStr = "INT_ID";
                break;
            }
            case 4: {
                tmpStr = "LONG_ID";
                break;
            }
            case 15: {
                tmpStr = "LONG_ID";
                break;
            }
            case 5: {
                tmpStr = "FLOAT_ID";
                break;
            }
            case 6: {
                tmpStr = "DOUBLE_ID";
                break;
            }
            case 7: {
                tmpStr = "STRING_ID";
                break;
            }
            case 8: {
                tmpStr = "DATE_ID";
                break;
            }
            case 9: {
                tmpStr = "NUMERIC_ID";
                break;
            }
            case 10: {
                tmpStr = "ARRAY_ID (inside type = " + this.arrayValueType + ")";
                break;
            }
            case 100: {
                tmpStr = "OTHER_ID";
                break;
            }
            default: {
                tmpStr = "" + this.valueType;
            }
        }
        info = info + "   Value type      : " + tmpStr + "\n";
        info = info + "   Root Name       : " + (this.root == null ? null : this.root.name) + "\n";
        info = info + "   Parent Name     : " + (this.parent == null ? null : this.parent.name) + "\n";
        info = info + "   Previous Name   : " + (this.previousSibling == null ? null : this.previousSibling.name) + "\n";
        info = info + "   Next Name       : " + (this.nextSibling == null ? null : this.nextSibling.name) + "\n";
        info = info + "   Children        : { ";
        for (int i = 0; i < this.children.size(); ++i) {
            info = info + "\"" + ((Descriptor)this.children.get((int)i)).name + "\" ";
        }
        info = info + "}\n";
        info = info + "}\n";
        return info;
    }

    public static final String getFixedString(String in_str, int length, char fill_char) {
        int inStrLength;
        if (length == 0) {
            return "";
        }
        if (in_str == null) {
            in_str = "";
        }
        if ((inStrLength = in_str.length()) == length || length < 0) {
            return in_str;
        }
        if (inStrLength > length) {
            return in_str.substring(0, length);
        }
        for (int i = 0; i < length - inStrLength; ++i) {
            in_str = in_str + fill_char;
        }
        return in_str;
    }

    public static void main(String[] args) throws Exception {
        int index;
        DrbNode base;
        if (args.length == 0 || args[0].equals("--help") || args[0].equals("-help")) {
            System.out.println("Usage: Descriptor [options] file");
            System.out.println("Options are:");
            System.out.println("-schema <schema_file> Set the output XML-Schema.");
            System.out.println("-append <xpath> <node> Append a node the specified path.");
            System.out.println("-replace <xpath> <node> Replace the node at the specified path.");
            System.out.println("-insert <xpath> <node> Insert a node at the specified path.");
            System.out.println("-remove <xpath> <node> Remove the node at the specified path.");
            System.out.println("-value <xpath> <value> Set the value at the specified path.");
            System.out.println("-xml <output_file> Set the output XML file.");
            System.out.println("-out <output_file> Set the output SDF file.");
        }
        DrbNode product_1 = null;
        FileOutputStream xml_output = null;
        RandomAccessFile sdf_output = null;
        String xpath = null;
        DrbNode append_node = null;
        DrbNode replace_node = null;
        DrbNode insert_node = null;
        DrbItem value_item = null;
        DrbSimpleNode schema_node = null;
        DrbNode context_node = DrbFactory.open(".");
        for (int i = 0; i < args.length; ++i) {
            if (args[i].length() == 0) continue;
            if (args[i].equals("-schema")) {
                schema_node = (DrbNode)new Query(args[++i]).evaluate(context_node).getItem(0);
                continue;
            }
            if (args[i].equals("-value")) {
                DrbSequence values;
                xpath = args[++i];
                if ((values = new Query(args[++i]).evaluate(context_node)).getLength() > 1) {
                    value_item = values.atomize();
                    continue;
                }
                value_item = values.getItem(0).getValue();
                continue;
            }
            if (args[i].equals("-append")) {
                xpath = args[++i];
                append_node = (DrbNode)new Query(args[++i]).evaluate(context_node).getItem(0);
                continue;
            }
            if (args[i].equals("-replace")) {
                xpath = args[++i];
                replace_node = (DrbNode)new Query(args[++i]).evaluate(context_node).getItem(0);
                continue;
            }
            if (args[i].equals("-insert")) {
                xpath = args[++i];
                insert_node = (DrbNode)new Query(args[++i]).evaluate(context_node).getItem(0);
                continue;
            }
            if (args[i].equals("-remove")) {
                xpath = args[++i];
                continue;
            }
            if (args[i].equals("-xml")) {
                xml_output = new FileOutputStream(args[++i]);
                continue;
            }
            if (args[i].equals("-out")) {
                sdf_output = new RandomAccessFile(args[++i], "rw");
                continue;
            }
            product_1 = DrbFactory.open(args[i]);
        }
        if (product_1 == null) {
            System.err.println("ERROR: No document specified!");
            return;
        }
        XmlSchema schema = null;
        if (schema_node != null) {
            schema = schema_node.getName().equals("schema") ? new XsdFactory().open((DrbNode)schema_node) : new XsdFactory().open(schema_node.getParent(), schema_node.getNamedChild("schema", 1));
        }
        if (value_item != null) {
            System.err.println("##########Setting value...");
            base = (DrbNode)new Query(xpath).evaluate(product_1).getItem(0);
            base.setValue(value_item.getValue());
        } else if (append_node != null) {
            System.err.println("##########Appending data...");
            base = (DrbNode)new Query(xpath).evaluate(product_1).getItem(0);
            base.appendChild(append_node);
        } else if (replace_node != null) {
            System.err.println("##########Replacing data...");
            base = (DrbNode)new Query(xpath).evaluate(product_1).getItem(0);
            index = base.getIndex();
            base.getParent().replaceChild(index, replace_node);
        } else if (insert_node != null) {
            System.err.println("##########Inserting data...");
            base = (DrbNode)new Query(xpath).evaluate(product_1).getItem(0);
            index = base.getIndex();
            base.getParent().insertChild(insert_node, index);
        } else if (xpath != null) {
            System.err.println("##########Removing data...");
            base = (DrbNode)new Query(xpath).evaluate(product_1).getItem(0);
            index = base.getIndex();
            base.getParent().removeChild(index);
        }
        if (xml_output != null) {
            XmlWriter.Context writer_context = new XmlWriter.Context();
            writer_context.setFilter(0xFFFFFE);
            writer_context.setPreserveSpace(true);
            XmlWriter.writeXML(product_1, xml_output, writer_context, false);
        }
        if (sdf_output != null) {
            Descriptor descriptor = null;
            if (schema != null) {
                DrbDefaultMutableNode base_node = new DrbDefaultMutableNode("sdf");
                base_node.setUserObject(sdf_output);
                AbstractBlock sdf_product = (AbstractBlock)new SdfFactory().open((DrbNode)base_node, schema, schema_node.getPath());
                descriptor = sdf_product.descriptor;
            } else {
                AbstractBlock input_block = (AbstractBlock)((DrbNodeImpl)product_1).getImpl(AbstractBlock.class);
                descriptor = input_block.descriptor;
            }
            descriptor.serializeNode(product_1, new int[0], new RandomAccessFileData(sdf_output), new Length(0L));
        }
    }

    class ParentBlockListener
    implements BlockListener {
        ParentBlockListener() {
        }

        @Override
        public void blockReplaced(BlockEvent e) {
            int[] key = IntMap.getChildKey(e.getKey(), -1);
            Descriptor.this.blockReplaced(new BlockEvent(BlockEvent.PARENT | BlockEvent.REPLACE, Descriptor.this, key));
        }

        @Override
        public void blockInserted(BlockEvent e) {
            int[] key = IntMap.getChildKey(e.getKey(), -1);
            Descriptor.this.blockInserted(new BlockEvent(BlockEvent.PARENT | BlockEvent.INSERT, Descriptor.this, key));
        }

        @Override
        public void blockRemoved(BlockEvent e) {
            int[] key = IntMap.getChildKey(e.getKey(), -1);
            BlockEvent remove_event = new BlockEvent(BlockEvent.PARENT | BlockEvent.REMOVE, Descriptor.this, key);
            Descriptor.this.blockRemoved(remove_event);
        }

        @Override
        public void blockMoved(BlockEvent e) {
            Descriptor previous_desc = e.getDescriptor();
            int[] key = IntMap.getChildKey(e.getKey(), 0);
            BlockEvent move_event = new BlockEvent(BlockEvent.PARENT | BlockEvent.MOVE, Descriptor.this, key);
            Descriptor.this.blockMoved(move_event);
        }

        @Override
        public void blockResized(BlockEvent e) {
        }
    }

    class PreviousBlockListener
    implements BlockListener {
        PreviousBlockListener() {
        }

        @Override
        public void blockReplaced(BlockEvent e) {
            this.blockResized(e);
        }

        @Override
        public void blockInserted(BlockEvent e) {
            int[] key = IntMap.getSiblingKey(e.getKey(), 0);
            Descriptor.this.blockMoved(new BlockEvent(BlockEvent.PREVIOUS | BlockEvent.INSERT, Descriptor.this, key));
        }

        @Override
        public void blockRemoved(BlockEvent e) {
            int[] key = IntMap.getSiblingKey(e.getKey(), 0);
            BlockEvent move_event = new BlockEvent(BlockEvent.PREVIOUS | BlockEvent.REMOVE, Descriptor.this, key);
            Descriptor.this.blockMoved(move_event);
        }

        @Override
        public void blockMoved(BlockEvent e) {
            int[] key = IntMap.getSiblingKey(e.getKey(), 0);
            Descriptor.this.blockMoved(new BlockEvent(BlockEvent.PREVIOUS | BlockEvent.MOVE, Descriptor.this, key));
        }

        @Override
        public void blockResized(BlockEvent e) {
            int[] key = IntMap.getSiblingKey(e.getKey(), 0);
            Descriptor.this.blockMoved(new BlockEvent(BlockEvent.PREVIOUS | BlockEvent.RESIZE, Descriptor.this, key));
        }
    }

    class ChildrenBlockListener
    implements BlockListener {
        ChildrenBlockListener() {
        }

        @Override
        public void blockReplaced(BlockEvent e) {
            this.blockResized(e);
        }

        @Override
        public void blockInserted(BlockEvent e) {
            int[] key = IntMap.getParentKey(e.getKey());
            Descriptor.this.contentLength.clear();
            Descriptor.this.length.clear();
            BlockEvent resize_event = new BlockEvent(BlockEvent.CHILD | BlockEvent.INSERT, Descriptor.this, key);
            Descriptor.this.length.clear();
            Descriptor.this.contentLength.clear();
            Descriptor.this.blockResized(resize_event);
        }

        @Override
        public void blockRemoved(BlockEvent e) {
            int[] key = IntMap.getParentKey(e.getKey());
            Descriptor.this.contentLength.clear();
            Descriptor.this.length.clear();
            BlockEvent resize_event = new BlockEvent(BlockEvent.CHILD | BlockEvent.REMOVE, Descriptor.this, key);
            Descriptor.this.length.clear();
            Descriptor.this.contentLength.clear();
            Descriptor.this.blockResized(resize_event);
        }

        @Override
        public void blockMoved(BlockEvent e) {
            int[] key = IntMap.getParentKey(e.getKey());
            BlockEvent resize_event = new BlockEvent(BlockEvent.CHILD | BlockEvent.MOVE, Descriptor.this, key);
            Descriptor.this.length.clear();
            Descriptor.this.contentLength.clear();
            Descriptor.this.blockResized(resize_event);
        }

        @Override
        public void blockResized(BlockEvent e) {
            int[] key = IntMap.getParentKey(e.getKey());
            BlockEvent resize_event = new BlockEvent(BlockEvent.CHILD | BlockEvent.RESIZE, Descriptor.this, key);
            Descriptor.this.length.clear();
            Descriptor.this.contentLength.clear();
            Descriptor.this.blockResized(resize_event);
        }
    }

    class Padding {
        protected int length;
        protected String content;

        protected Padding(int length, String content) {
            this.length = length;
            this.content = content;
        }
    }

    static class Signature {
        static final int OPTIONAL_USE = 1;
        static final int REQUIRED_USE = 2;
        static final int PROHIBITED_USE = 3;
        protected String query;
        protected Value value;
        protected Query queryObject;
        private int use = 1;

        protected Signature() {
            this.use = 3;
            this.value = new Boolean(true);
        }

        protected Signature(String query) {
            this.query = query;
            this.queryObject = new Query(query);
            this.use = 2;
        }

        protected Signature(Value value) {
            this.value = value;
            this.use = 2;
        }

        public final int getUse() {
            return this.use;
        }
    }
}

