/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.xml;

import fr.gael.drb.DrbDefaultAttribute;
import fr.gael.drb.DrbDefaultAttributeList;
import fr.gael.drb.impl.xml.SaxElementTag;
import fr.gael.drb.impl.xml.SaxInputStream;
import fr.gael.drb.impl.xml.SaxNode;
import fr.gael.drb.value.String;
import fr.gael.drb.value.Value;
import fr.gael.drb.xsd.Namespace;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

class SaxHandler
extends DefaultHandler
implements LexicalHandler {
    private static Logger logger = Logger.getLogger(SaxHandler.class);
    private Locator locator;
    private SaxNode node;
    private int depth;
    private int matchDepth;
    StringBuffer buffer = new StringBuffer();
    protected SaxInputStream stream;
    private long lexicalOffset;
    private SaxNode currentNode;

    protected SaxHandler(SaxNode node, SaxInputStream stream) {
        this.currentNode = node;
        this.node = node;
        this.stream = stream;
        this.matchDepth = this.depth = -1;
        this.lexicalOffset = 0L;
        logger.debug("Loading " + node.getName() + " at index " + node.getIndex() + " start_offset=" + node.tag.startOffset + ", end_offset=" + node.tag.endOffset);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.lexicalOffset = this.stream.getOffset(this.locator.getLineNumber(), this.locator.getColumnNumber() - 1) + 1L;
        if (this.matchDepth == this.currentNode.depth) {
            int whitespace_count;
            if (this.buffer.length() == 0) {
                for (whitespace_count = 0; whitespace_count < length && (ch[start + whitespace_count] == ' ' || ch[start + whitespace_count] == '\t' || ch[start + whitespace_count] == '\n'); ++whitespace_count) {
                }
            }
            this.buffer.append(ch, start + whitespace_count, length - whitespace_count);
            this.currentNode.tag.startCloseOffset = this.lexicalOffset;
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.characters(ch, start, length);
    }

    @Override
    public void startElement(java.lang.String namespaceURI, java.lang.String localName, java.lang.String qName, Attributes atts) {
        ++this.depth;
        this.matchDepth = this.depth;
        if (this.matchDepth == this.currentNode.depth + 1) {
            SaxElementTag child_tag = new SaxElementTag();
            child_tag.index = this.currentNode.tag.childrenCount++;
            child_tag.name = localName;
            child_tag.namespaceURI = namespaceURI;
            child_tag.startOffset = this.lexicalOffset;
            child_tag.endOpenOffset = this.stream.getOffset(this.locator.getLineNumber(), this.locator.getColumnNumber() - 1) + 1L;
            child_tag.childrenCount = 0;
            this.currentNode.children.add(child_tag);
            this.currentNode = new SaxNode(this.currentNode, child_tag.index);
        }
        if (this.matchDepth == this.currentNode.depth) {
            this.buffer = new StringBuffer();
            this.currentNode.tag.name = localName;
            if (!namespaceURI.equals("")) {
                this.currentNode.tag.namespaceURI = namespaceURI;
            }
            if (this.currentNode.depth == 0) {
                this.currentNode.tag.startOffset = this.lexicalOffset;
            }
            this.currentNode.tag.endOpenOffset = this.stream.getOffset(this.locator.getLineNumber(), this.locator.getColumnNumber() - 1) + 1L;
            this.currentNode.tag.startCloseOffset = this.lexicalOffset + 1L;
            this.currentNode.tag.childrenCount = 0;
            this.currentNode.children = new ArrayList();
            DrbDefaultAttributeList attribs = new DrbDefaultAttributeList();
            Namespace namespace = new Namespace();
            for (int iattr = 0; iattr < atts.getLength(); ++iattr) {
                if (atts.getQName(iattr).startsWith("xmlns:")) {
                    java.lang.String ns_prefix = Namespace.toLocal(atts.getQName(iattr));
                    namespace.bind(ns_prefix, atts.getValue(iattr));
                    continue;
                }
                if (atts.getQName(iattr).equals("xmlns")) {
                    namespace.setDefaultNamespaceURI(atts.getValue(iattr));
                    continue;
                }
                DrbDefaultAttribute attr = new DrbDefaultAttribute(atts.getLocalName(iattr), (Value)new String(atts.getValue(iattr)), this.currentNode);
                if (!"".equals(atts.getURI(iattr))) {
                    attr.setNamespaceURI(atts.getURI(iattr));
                }
                attribs.add(attr);
            }
            this.currentNode.attributes = attribs;
            this.currentNode.namespace = namespace;
        }
        this.lexicalOffset = this.stream.getOffset(this.locator.getLineNumber(), this.locator.getColumnNumber() - 1) + 1L;
    }

    @Override
    public void endElement(java.lang.String namespaceURI, java.lang.String localName, java.lang.String qName) throws SAXException {
        SaxElementTag child_tag;
        if (this.matchDepth == this.currentNode.depth) {
            java.lang.String text = this.buffer.toString().trim();
            this.currentNode.value = text.length() > 0 ? new String(text) : null;
            this.currentNode.tag.endOffset = this.stream.getOffset(this.locator.getLineNumber(), this.locator.getColumnNumber() - 1) + 1L;
            this.currentNode.loaded = true;
            if (this.currentNode.tag.endOffset - this.currentNode.tag.endOffset < 10000L) {
                this.currentNode.tag.setNodeReference(this.currentNode, true);
            } else {
                this.currentNode.tag.setNodeReference(this.currentNode, false);
            }
            if (this.currentNode.depth > this.node.depth) {
                this.currentNode = this.currentNode.parent;
            }
        }
        if (this.matchDepth == this.currentNode.depth + 1) {
            child_tag = this.currentNode.getTagAt(this.currentNode.tag.childrenCount - 1);
            this.currentNode.tag.startCloseOffset = child_tag.endOffset = this.stream.getOffset(this.locator.getLineNumber(), this.locator.getColumnNumber() - 1) + 1L;
            this.buffer = new StringBuffer();
        } else if (this.matchDepth == this.currentNode.depth + 2) {
            child_tag = this.currentNode.getTagAt(this.currentNode.tag.childrenCount - 1);
            ++child_tag.childrenCount;
        }
        --this.depth;
        this.matchDepth = this.depth;
        this.lexicalOffset = this.stream.getOffset(this.locator.getLineNumber(), this.locator.getColumnNumber() - 1) + 1L;
    }

    @Override
    public void processingInstruction(java.lang.String target, java.lang.String data) throws SAXException {
        this.lexicalOffset = this.stream.getOffset(this.locator.getLineNumber(), this.locator.getColumnNumber() - 1) + 1L;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
        logger.debug("End Document " + this.node.getName() + " at index " + this.node.getIndex() + " loaded=" + this.node.loaded + " childrenCount=" + this.node.tag.childrenCount + " start_offset=" + this.node.tag.startOffset + ", end_offset=" + this.node.tag.endOffset + ", value='" + this.node.value + "'");
    }

    @Override
    public void comment(char[] ch, int start, int length) {
        this.lexicalOffset = this.stream.getOffset(this.locator.getLineNumber(), this.locator.getColumnNumber() - 1) + 1L;
    }

    @Override
    public void endCDATA() {
        this.lexicalOffset = this.stream.getOffset(this.locator.getLineNumber(), this.locator.getColumnNumber() - 1) + 1L;
    }

    @Override
    public void endDTD() {
    }

    @Override
    public void endEntity(java.lang.String name) {
    }

    @Override
    public void startCDATA() {
        this.lexicalOffset = this.stream.getOffset(this.locator.getLineNumber(), this.locator.getColumnNumber() - 1) + 1L;
    }

    @Override
    public void startDTD(java.lang.String name, java.lang.String publicId, java.lang.String systemId) {
    }

    @Override
    public void startEntity(java.lang.String name) {
    }
}

