/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.query;

import fr.gael.drb.DrbSequence;
import fr.gael.drb.query.CancelException;
import fr.gael.drb.query.DynamicException;
import fr.gael.drb.query.Expression;
import fr.gael.drb.query.Token;
import fr.gael.drb.query.TypeException;
import org.apache.log4j.Logger;

abstract class AbstractExpression
implements Expression {
    private static Logger logger = Logger.getLogger(AbstractExpression.class);
    private String name = "Unknown";
    private Token token;
    private boolean cancelRequested = false;
    private String cancelReason = "Unknown reason";

    public AbstractExpression(String name, Token token) {
        this.setName(name);
        this.setToken(token);
    }

    public void setName(String name) {
        this.name = name;
    }

    public DrbSequence evaluate() throws DynamicException, TypeException, CancelException {
        throw new DynamicException(this, "The context shall not be empty.");
    }

    @Override
    public synchronized void cancel(String reason) {
        this.cancelRequested = true;
    }

    public boolean isCancellationRequested() {
        return this.cancelRequested;
    }

    public void throwCancelException() {
        String message = "";
        message = this.getName() != null ? message + "The " + this.getName() : message + "An";
        message = message + " expression";
        if (this.getToken() != null) {
            message = message + ", declared at line " + this.getToken().beginLine + ", column " + this.getToken().beginColumn + ",";
        }
        message = message + " has been cancelled due to " + this.cancelReason;
        this.cancelRequested = false;
        throw new CancelException(message);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setToken(Token token) {
        this.token = token;
    }

    @Override
    public Token getToken() {
        return this.token;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isUpdating() {
        return false;
    }
}

