/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.query;

import fr.gael.drb.DrbSequence;
import fr.gael.drb.value.AbstractValueArray;
import fr.gael.drb.value.Value;
import fr.gael.drb.value.ValueArray;
import org.apache.log4j.Logger;

final class DataResult
extends AbstractValueArray {
    private static final Logger logger = Logger.getLogger(DataResult.class);
    private static final int MAX_FIFO_SIZE = 65536;
    private DrbSequence sequence;
    private int cursor = 0;
    private int itemCount = 0;
    private int lastPosition = 0;
    private int[] valueIndex;
    private int[] itemSize;
    private Value[] valueCache;
    private int[] fifo;
    private int fifoFirstIndex;
    private int fifoLastIndex;
    private int fifoSize;
    private int valueCount = 0;

    DataResult(DrbSequence sequence) {
        this.sequence = sequence;
        this.lastPosition = sequence.getLength();
        this.valueIndex = new int[this.lastPosition];
        this.itemSize = new int[this.lastPosition];
        this.valueCache = new Value[this.lastPosition];
        this.fifo = new int[this.lastPosition];
        this.fifoFirstIndex = 0;
        this.fifoLastIndex = 0;
        this.fifoSize = 0;
    }

    @Override
    public final int length() {
        while (this.itemCount < this.lastPosition) {
            Value current_value = this.sequence.getItem(this.itemCount).getValue();
            this.valueIndex[this.itemCount] = this.valueCount++;
            if (current_value != null) {
                if (current_value.getType() == 10) {
                    int size = ((ValueArray)current_value).length();
                    if (size < 0) {
                        throw new NegativeArraySizeException("The source item at index " + this.itemCount + " has a negative array size (" + size + ")");
                    }
                    this.itemSize[this.itemCount] = size;
                    this.valueCount += size;
                    this.putCache(current_value, this.itemCount, size);
                } else {
                    this.itemSize[this.itemCount] = 1;
                    this.putCache(current_value, this.itemCount, 1);
                }
            } else {
                this.itemSize[this.itemCount] = 0;
            }
            ++this.itemCount;
        }
        return this.valueCount;
    }

    @Override
    public final int getPriority() {
        return 0;
    }

    @Override
    public final int getArrayType() {
        return -2;
    }

    private void putCache(Value value, int index, int size) {
        this.valueCache[index] = value;
        int newFifoSize = this.fifoSize + size;
        if (newFifoSize > 65536) {
            newFifoSize -= this.itemSize[this.fifoFirstIndex];
            this.valueCache[this.fifo[this.fifoFirstIndex]] = null;
            ++this.fifoFirstIndex;
            if (this.fifoFirstIndex >= this.lastPosition) {
                this.fifoFirstIndex = 0;
            }
        }
        this.fifo[this.fifoLastIndex] = index;
        ++this.fifoLastIndex;
        if (this.fifoLastIndex >= this.lastPosition) {
            this.fifoLastIndex = 0;
        }
        this.fifoSize = newFifoSize;
    }

    @Override
    public final Value getElement(int indice) {
        if (indice < 0) {
            throw new IllegalArgumentException("Value indice is out of bounds");
        }
        if (indice < this.valueCount) {
            int current = this.cursor;
            int first = 0;
            int last = this.itemCount;
            int count = 0;
            int first_indice = 0;
            int last_indice = this.valueCount;
            while (first < last) {
                ++count;
                int current_indice = this.valueIndex[current];
                int array_indice = indice - current_indice;
                if (array_indice < 0) {
                    last = current;
                    last_indice = this.valueIndex[last];
                } else {
                    if (array_indice < this.itemSize[current]) {
                        this.cursor = current;
                        Value value = this.valueCache[current];
                        if (value == null) {
                            value = this.sequence.getItem(current).getValue();
                            this.putCache(value, current, this.itemSize[current]);
                        }
                        if (value == null) {
                            throw new NullPointerException("Unexpected null item value at index " + current);
                        }
                        if (value.getType() == 10) {
                            ValueArray array = (ValueArray)value;
                            return array.getElement(array_indice);
                        }
                        return value;
                    }
                    first = current + 1;
                    first_indice = current_indice + this.itemSize[current];
                }
                if (first_indice < last_indice) {
                    long yrange = last - first;
                    long xdelta = indice - first_indice;
                    long xrange = last_indice - first_indice;
                    current = (int)((yrange * xdelta + xrange * (long)first) / xrange);
                    if (current >= first && current < last) continue;
                    logger.error("Internal error during atomisation:  trials=" + count + " valueCount=" + this.valueCount + " first=<" + first + ", " + first_indice + "> last=<" + last + ", " + last_indice + "> current=<" + current + ", " + current_indice + ">");
                    break;
                }
                logger.error("Internal error during atomisation:  trials=" + count + " valueCount=" + this.valueCount + " first=<" + first + ", " + first_indice + "> last=<" + last + ", " + last_indice + "> current=<" + current + ", " + current_indice + ">");
                break;
            }
            throw new UnsupportedOperationException("Internal error while searching the value at indice " + indice);
        }
        while (this.itemCount < this.lastPosition) {
            ++this.itemCount;
            this.cursor = this.cursor;
            Value current_value = this.sequence.getItem(this.cursor).getValue();
            this.valueIndex[this.cursor] = this.valueCount;
            if (current_value != null) {
                int array_indice = indice - this.valueCount;
                if (current_value.getType() == 10) {
                    int len;
                    ValueArray array = (ValueArray)current_value;
                    this.itemSize[this.cursor] = len = array.length();
                    this.valueCount += len;
                    this.putCache(current_value, this.cursor, len);
                    if (array_indice < len) {
                        return array.getElement(array_indice);
                    }
                    if (len >= 0) continue;
                    throw new NegativeArraySizeException("Cannot read the value  at indice " + indice + ". The source item at index " + this.cursor + " has a negative array size (" + len + ")");
                }
                this.itemSize[this.cursor] = 1;
                ++this.valueCount;
                this.putCache(current_value, this.cursor, 1);
                if (array_indice != 0) continue;
                return current_value;
            }
            this.itemSize[this.cursor] = 0;
        }
        return null;
    }

    @Override
    public final void assign(int index, Value element) {
        throw new UnsupportedOperationException("Atomized sequences are not mutable");
    }

    @Override
    public final void assign(Value v) throws ClassCastException {
        throw new UnsupportedOperationException("Atomoized sequences are not mutable");
    }
}

