/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.query;

import fr.gael.drb.query.ExternalVariable;
import fr.gael.drb.query.ParameterResolver;
import fr.gael.drb.query.QName;
import fr.gael.drb.xsd.Namespace;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class Environment {
    Logger logger = Logger.getLogger(Environment.class);
    public static final String XPATH_FUNCTIONS_URI = "http://www.w3.org/2005/xpath-functions";
    public static final String XQT_ERRORS_PREFIX = "err";
    public static final String XQT_ERRORS_URI = "http://www.w3.org/2005/xqt-errors";
    public static final String XQUERY_LOCAL_FUNCTIONS_URI = "http://www.w3.org/2005/xquery-local-functions";
    public static final String DRB_FUNCTIONS_PREFIX = "drb";
    public static final String GAEL_FUNCTIONS_URI = "http://www.gael.fr";
    public static final String DRB_FUNCTIONS_URI = "http://www.gael.fr/drb";
    public static final String MATH_FUNCTIONS_URI = "http://exslt.org/math";
    private Namespace namespace = new Namespace();
    private String defaultElementNamespaceURI = null;
    private String defaultFunctionNamespaceURI = "http://www.w3.org/2005/xpath-functions";
    private String baseURI = null;
    private Map<QName, ExternalVariable> externalVariable = new HashMap<QName, ExternalVariable>();
    protected ParameterResolver resolver = null;
    private boolean isBackwardCompatibilityMode = false;
    protected boolean isBackwardCompatibilityModeSet = false;

    public Environment() {
        this.namespace.bind("xml", "http://www.w3.org/XML/1998/namespace");
        this.namespace.bind("fn", XPATH_FUNCTIONS_URI);
        this.namespace.bind("xs", "http://www.w3.org/2001/XMLSchema");
        this.namespace.bind("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.namespace.bind("xdt", "http://www.w3.org/2003/11/xpath-datatypes");
        this.namespace.bind("local", XQUERY_LOCAL_FUNCTIONS_URI);
        this.namespace.bind(DRB_FUNCTIONS_PREFIX, DRB_FUNCTIONS_URI);
        this.namespace.bind("math", MATH_FUNCTIONS_URI);
        this.defaultFunctionNamespaceURI = XPATH_FUNCTIONS_URI;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public QName resolveQName(String name) {
        return this.resolveQName(name, null);
    }

    public QName resolveQName(String name, String default_namespace) {
        String prefix = Namespace.toPrefix(name);
        String ns = default_namespace;
        if (prefix != null) {
            ns = this.getNamespace().resolveNamespace(prefix);
        }
        return new QName(name, ns);
    }

    public void setNamespace(Namespace namespace) {
        this.namespace = namespace;
    }

    public String getDefaultElementNamespaceURI() {
        return this.defaultElementNamespaceURI;
    }

    public void setDefaultElementNamespaceURI(String namespace_uri) {
        this.defaultElementNamespaceURI = namespace_uri;
    }

    public String getDefaultFunctionNamespaceURI() {
        return this.defaultFunctionNamespaceURI;
    }

    public void setDefaultFunctionNamespaceURI(String namespace_uri) {
        this.defaultFunctionNamespaceURI = namespace_uri;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setBaseURI(String base_uri) {
        this.baseURI = base_uri;
    }

    protected void addExternalVariable(ExternalVariable variable) {
        this.externalVariable.put(variable.getQName(), variable);
    }

    protected void setExternalVariableMap(Map<QName, ExternalVariable> variable_list) {
        if (variable_list == null) {
            throw new NullPointerException("Null external variable list.");
        }
        this.externalVariable = variable_list;
    }

    protected Map<QName, ExternalVariable> getExternalVariableMap() {
        return this.externalVariable;
    }

    public ExternalVariable getExternalVariable(String name) {
        return this.getExternalVariable(this.resolveQName(name));
    }

    public ExternalVariable getExternalVariable(QName name) {
        return this.externalVariable.get(name);
    }

    public ExternalVariable[] getExternalVariables() {
        Collection<ExternalVariable> variables = this.externalVariable.values();
        if (variables == null) {
            return null;
        }
        Object[] vars = variables.toArray();
        if (vars.length > 0) {
            ExternalVariable[] output = new ExternalVariable[vars.length];
            for (int ivar = 0; ivar < output.length; ++ivar) {
                output[ivar] = (ExternalVariable)vars[ivar];
            }
            return output;
        }
        return null;
    }

    public boolean containsExternalVariable(String name) {
        return this.containsExternalVariable(this.resolveQName(name));
    }

    public boolean containsExternalVariable(QName name) {
        return this.externalVariable.containsKey(name);
    }

    public void setBackwardCompatibilityMode(boolean isBackwardCompatibilityMode) {
        this.isBackwardCompatibilityMode = isBackwardCompatibilityMode;
        this.isBackwardCompatibilityModeSet = true;
    }

    public boolean isBackwardCompatibilityMode() {
        if (!this.isBackwardCompatibilityModeSet) {
            String mode = System.getProperty("fr.gael.drb.query.BackwardCompatibilityMode");
            if (mode != null && mode.equals("true")) {
                this.setBackwardCompatibilityMode(true);
            } else {
                this.setBackwardCompatibilityMode(false);
            }
        }
        return this.isBackwardCompatibilityMode;
    }

    public String toString() {
        String string = "";
        string = string + "Namespaces:\n" + this.namespace;
        string = string + "Default element namespace URI: " + this.defaultElementNamespaceURI + "\n";
        string = string + "Default function namespace URI: " + this.defaultFunctionNamespaceURI + "\n";
        string = string + "External variables: \n";
        ExternalVariable[] variables = this.getExternalVariables();
        if (variables != null) {
            for (int ivar = 0; ivar < variables.length; ++ivar) {
                string = string + "   -> " + variables[ivar] + "\n";
            }
        }
        return string;
    }

    static boolean isReservedNamespace(String uri) {
        return "http://www.w3.org/XML/1998/namespace".equals(uri) || XPATH_FUNCTIONS_URI.equals(uri) || "http://www.w3.org/2001/XMLSchema".equals(uri) || "http://www.w3.org/2001/XMLSchema-instance".equals(uri) || DRB_FUNCTIONS_URI.equals(uri);
    }
}

