/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.query;

class QName {
    private String localName;
    private String prefix;
    private String namespaceURI;

    public QName(QName qname) {
        this.localName = qname.localName;
        this.namespaceURI = qname.namespaceURI;
        this.prefix = qname.prefix;
    }

    public QName(String qname_string) {
        this(qname_string, null);
    }

    public QName(String qname_string, String namespace_uri) {
        int delimiterIndex = qname_string.indexOf(58);
        if (delimiterIndex > 0) {
            this.setPrefix(qname_string.substring(0, delimiterIndex));
            this.setLocalName(qname_string.substring(delimiterIndex + 1));
        } else {
            this.setLocalName(qname_string);
        }
        if (this.getLocalName() == null) {
            throw new NullPointerException("Unable to extract local part of the qualified name.");
        }
        this.namespaceURI = namespace_uri;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setLocalName(String localname) {
        this.localName = localname;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getName() {
        String prefix = this.getPrefix();
        if (prefix != null) {
            return prefix + ":" + this.getLocalName();
        }
        return this.getLocalName();
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public void setNamespaceURI(String ns) {
        this.namespaceURI = ns;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof QName)) {
            return false;
        }
        QName name = (QName)o;
        if (!name.getLocalName().equals(this.getLocalName())) {
            return false;
        }
        if (name.getNamespaceURI() == null && this.getNamespaceURI() == null) {
            return true;
        }
        return name.getNamespaceURI() != null && name.getNamespaceURI().equals(this.getNamespaceURI());
    }

    public int hashCode() {
        return (this.localName + this.namespaceURI).hashCode();
    }
}

