/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.query;

import fr.gael.drb.DrbDefaultSequence;
import fr.gael.drb.DrbItem;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbSequence;
import fr.gael.drb.query.AbstractExpression;
import fr.gael.drb.query.DynamicContext;
import fr.gael.drb.query.DynamicException;
import fr.gael.drb.query.Expression;
import fr.gael.drb.query.Token;
import fr.gael.drb.value.ValueArray;

class ReplaceExpression
extends AbstractExpression {
    private Expression sourceExpression = null;
    private Expression targetExpression = null;
    private boolean valueSpecified = false;

    public ReplaceExpression(Token token) {
        super("Replace", token);
    }

    public void setTargetExpression(Expression target_expression) {
        this.targetExpression = target_expression;
    }

    public void setSourceExpression(Expression source_expression) {
        this.sourceExpression = source_expression;
    }

    public void setValueSpecified(boolean value_specified) {
        this.valueSpecified = value_specified;
    }

    @Override
    public DrbSequence evaluate(DynamicContext context) {
        DrbSequence content_sequence;
        if (this.sourceExpression == null || this.targetExpression == null) {
            throw new DynamicException(this, "Incomplete \"replace\" declaration");
        }
        DrbSequence target_sequence = this.targetExpression.evaluate(context);
        if (target_sequence == null) {
            throw new DynamicException(this, "Error while evaluating the target expression");
        }
        if (target_sequence == null) {
            throw new DynamicException(this, "Error while evaluating the target expression");
        }
        if (target_sequence.getLength() != 1) {
            throw new DynamicException(this, "First parameter must be a single element node or a single document node. Found a sequence of " + target_sequence.getLength() + " item(s)");
        }
        DrbItem target_item = target_sequence.getItem(0);
        if (this.isCancellationRequested()) {
            this.throwCancelException();
        }
        if ((content_sequence = this.sourceExpression.evaluate(context)) == null) {
            throw new DynamicException(this, "Error while evaluating the content parameter");
        }
        if (this.valueSpecified) {
            ValueArray replacing_value = content_sequence.atomize();
            target_item.setValue(replacing_value);
        } else if (target_item.getItemType() == 1) {
            DrbNode target_node = (DrbNode)target_item;
            DrbNode target_parent = target_node.getParent();
            int target_index = target_node.getIndex();
            if (target_parent == null) {
                throw new DynamicException(this, "[XUST0001] - While replacing an element, the target node must have a parent");
            }
            if (content_sequence.getLength() == 0) {
                target_parent.removeChild(target_index);
            } else {
                for (int ichild = 0; ichild < content_sequence.getLength(); ++ichild) {
                    DrbItem content_item = content_sequence.getItem(ichild);
                    if (!(content_item instanceof DrbNode)) continue;
                    if (ichild == 0) {
                        target_parent.replaceChild(target_index, (DrbNode)content_item);
                        continue;
                    }
                    target_node.insertChild((DrbNode)content_item, target_index + ichild);
                }
            }
        } else {
            if (target_item.getItemType() == 2) {
                throw new DynamicException(this, "[XUST0001] - Attribute replacement is not implemented");
            }
            throw new DynamicException(this, "[XUST0001] - The target of a 'replace' expression must be a node");
        }
        DrbDefaultSequence output_sequence = new DrbDefaultSequence();
        return output_sequence;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isUpdating() {
        return true;
    }
}

