/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.value;

import fr.gael.drb.value.AbstractValue;
import fr.gael.drb.value.Boolean;
import fr.gael.drb.value.Byte;
import fr.gael.drb.value.Decimal;
import fr.gael.drb.value.Double;
import fr.gael.drb.value.Float;
import fr.gael.drb.value.Int;
import fr.gael.drb.value.Integer;
import fr.gael.drb.value.Logic;
import fr.gael.drb.value.Long;
import fr.gael.drb.value.Numeric;
import fr.gael.drb.value.Short;
import fr.gael.drb.value.String;
import fr.gael.drb.value.UnsignedByte;
import fr.gael.drb.value.UnsignedInt;
import fr.gael.drb.value.UnsignedLong;
import fr.gael.drb.value.UnsignedShort;
import fr.gael.drb.value.Value;
import java.math.BigDecimal;
import java.math.BigInteger;

abstract class AbstractNumeric
extends AbstractValue
implements Numeric,
Comparable {
    AbstractNumeric() {
    }

    @Override
    public int getType() {
        return 9;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Value) {
            return this.compareTo((Value)obj) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.intValue();
    }

    public int compareTo(Object obj) {
        return this.compareTo((Value)obj);
    }

    @Override
    public Value convertTo(int type) throws ClassCastException {
        switch (type) {
            case 9: {
                return this;
            }
            case 3: {
                return new Int(this.intValue());
            }
            case 6: {
                return new Double(this.doubleValue());
            }
            case 7: {
                return new String(this.toString());
            }
            case 5: {
                return new Float(this.floatValue());
            }
            case 4: {
                return new Long(this.longValue());
            }
            case 2: {
                return new Short(this.shortValue());
            }
            case 1: {
                return new Byte(this.byteValue());
            }
            case 0: {
                return new Boolean(this.booleanValue());
            }
            case 15: {
                return new UnsignedLong(this.longValue());
            }
            case 14: {
                return new UnsignedInt(this.intValue());
            }
            case 13: {
                return new UnsignedShort(this.shortValue());
            }
            case 12: {
                return new UnsignedByte(this.byteValue());
            }
            case 27: {
                return new Integer(this.integerValue());
            }
            case 26: {
                return new Decimal(this.decimalValue());
            }
        }
        throw new ClassCastException(this.getClass().getName() + ": cannot cast to " + type);
    }

    @Override
    public final Numeric toNumeric() throws ClassCastException {
        return this;
    }

    protected BigInteger integerValue() {
        return BigInteger.valueOf(this.longValue());
    }

    protected BigDecimal decimalValue() {
        return BigDecimal.valueOf(this.longValue());
    }

    @Override
    public final boolean and(Value x) {
        return this.booleanValue() && ((Logic)((Object)x)).booleanValue();
    }

    @Override
    public final boolean or(Value x) {
        return this.booleanValue() || ((Logic)((Object)x)).booleanValue();
    }
}

