/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.value;

import fr.gael.drb.value.AbstractValueArray;
import fr.gael.drb.value.Boolean;
import fr.gael.drb.value.BooleanArray;
import fr.gael.drb.value.Byte;
import fr.gael.drb.value.ByteArray;
import fr.gael.drb.value.Double;
import fr.gael.drb.value.DoubleArray;
import fr.gael.drb.value.Float;
import fr.gael.drb.value.FloatArray;
import fr.gael.drb.value.Int;
import fr.gael.drb.value.IntArray;
import fr.gael.drb.value.Long;
import fr.gael.drb.value.LongArray;
import fr.gael.drb.value.Numeric;
import fr.gael.drb.value.NumericArray;
import fr.gael.drb.value.Short;
import fr.gael.drb.value.ShortArray;
import fr.gael.drb.value.UnsignedByteArray;
import fr.gael.drb.value.UnsignedIntArray;
import fr.gael.drb.value.UnsignedLongArray;
import fr.gael.drb.value.UnsignedShortArray;
import fr.gael.drb.value.ValueArray;
import fr.gael.drb.value.ValueFormat;

public abstract class AbstractNumericArray
extends AbstractValueArray
implements NumericArray,
ValueFormat {
    public abstract Object getData();

    @Override
    public String getFormattedString(int length) {
        throw new UnsupportedOperationException("String format is not supported");
    }

    @Override
    public byte[] getFormattedBuffer() {
        throw new UnsupportedOperationException("Binary format is not supported");
    }

    @Override
    public int getArrayType() {
        return -2;
    }

    @Override
    public final ValueArray convertArrayTo(int array_type) throws ClassCastException {
        if (array_type == this.getArrayType()) {
            return this;
        }
        switch (array_type) {
            case 9: {
                return this;
            }
            case 3: {
                return new IntArray(this.intValues());
            }
            case 6: {
                return new DoubleArray(this.doubleValues());
            }
            case 5: {
                return new FloatArray(this.floatValues());
            }
            case 4: {
                return new LongArray(this.longValues());
            }
            case 2: {
                return new ShortArray(this.shortValues());
            }
            case 1: {
                return new ByteArray(this.byteValues());
            }
            case 0: {
                return new BooleanArray(this.booleanValues());
            }
            case 15: {
                return new UnsignedLongArray(this.longValues());
            }
            case 14: {
                return new UnsignedIntArray(this.intValues());
            }
            case 13: {
                return new UnsignedShortArray(this.shortValues());
            }
            case 12: {
                return new UnsignedByteArray(this.byteValues());
            }
        }
        throw new ClassCastException(this.getClass().getName() + ": cannot cast to " + array_type);
    }

    public boolean[] booleanValues() {
        boolean[] v = new boolean[this.length()];
        for (int i = 0; i < v.length; ++i) {
            v[i] = this.booleanValue(i);
        }
        return v;
    }

    public byte[] byteValues() {
        byte[] v = new byte[this.length()];
        for (int i = 0; i < v.length; ++i) {
            v[i] = this.byteValue(i);
        }
        return v;
    }

    public short[] shortValues() {
        short[] v = new short[this.length()];
        for (int i = 0; i < v.length; ++i) {
            v[i] = this.shortValue(i);
        }
        return v;
    }

    public int[] intValues() {
        int[] v = new int[this.length()];
        for (int i = 0; i < v.length; ++i) {
            v[i] = this.intValue(i);
        }
        return v;
    }

    public long[] longValues() {
        long[] v = new long[this.length()];
        for (int i = 0; i < v.length; ++i) {
            v[i] = this.longValue(i);
        }
        return v;
    }

    public float[] floatValues() {
        float[] v = new float[this.length()];
        for (int i = 0; i < v.length; ++i) {
            v[i] = this.floatValue(i);
        }
        return v;
    }

    public double[] doubleValues() {
        double[] v = new double[this.length()];
        for (int i = 0; i < v.length; ++i) {
            v[i] = this.doubleValue(i);
        }
        return v;
    }

    @Override
    public boolean booleanValue(int index) {
        return ((Numeric)this.getElement(index)).booleanValue();
    }

    @Override
    public byte byteValue(int index) {
        return ((Numeric)this.getElement(index)).byteValue();
    }

    @Override
    public int intValue(int index) {
        return ((Numeric)this.getElement(index)).intValue();
    }

    @Override
    public long longValue(int index) {
        return ((Numeric)this.getElement(index)).longValue();
    }

    @Override
    public short shortValue(int index) {
        return ((Numeric)this.getElement(index)).shortValue();
    }

    @Override
    public float floatValue(int index) {
        return ((Numeric)this.getElement(index)).floatValue();
    }

    @Override
    public double doubleValue(int index) {
        return ((Numeric)this.getElement(index)).doubleValue();
    }

    @Override
    public void assign(int index, boolean value) {
        this.assign(index, new Boolean(value));
    }

    @Override
    public void assign(int index, byte value) {
        this.assign(index, new Byte(value));
    }

    @Override
    public void assign(int index, int value) {
        this.assign(index, new Int(value));
    }

    @Override
    public void assign(int index, short value) {
        this.assign(index, new Short(value));
    }

    @Override
    public void assign(int index, long value) {
        this.assign(index, new Long(value));
    }

    @Override
    public void assign(int index, float value) {
        this.assign(index, new Float(value));
    }

    @Override
    public void assign(int index, double value) {
        this.assign(index, new Double(value));
    }
}

