/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.value;

import fr.gael.drb.value.AbstractValue;
import fr.gael.drb.value.Arithmetic;
import fr.gael.drb.value.Comparison;
import fr.gael.drb.value.DateTime;
import fr.gael.drb.value.Double;
import fr.gael.drb.value.Duration;
import fr.gael.drb.value.Numeric;
import fr.gael.drb.value.String;
import fr.gael.drb.value.Value;
import fr.gael.drb.value.YearMonthDuration;

public class DayTimeDuration
extends AbstractValue
implements Arithmetic,
Comparison {
    static final int PRIORITY = 7;
    static final int SECONDS_PER_MINUTE = 60;
    static final int SECONDS_PER_HOUR = 3600;
    static final int SECONDS_PER_DAY = 86400;
    protected double dayTime;

    public DayTimeDuration(java.lang.String s) {
        boolean have_sign = s.startsWith("-");
        if (have_sign) {
            s = s.substring(1);
        }
        if (s.length() < 3 || !s.startsWith("P")) {
            return;
        }
        s = s.substring(1);
        long years = 0L;
        long months = 0L;
        long days = 0L;
        long hours = 0L;
        long minutes = 0L;
        double seconds = 0.0;
        int index = -1;
        index = s.indexOf(68);
        if (index > 0) {
            days = Long.parseLong(s.substring(0, index));
            s = s.substring(index + 1, s.length());
        }
        if (s.startsWith("T")) {
            s = s.substring(1);
        }
        if ((index = s.indexOf(72)) > 0) {
            hours = Long.parseLong(s.substring(0, index));
            s = s.substring(index + 1, s.length());
        }
        if ((index = s.indexOf(77)) > 0) {
            minutes = Long.parseLong(s.substring(0, index));
            s = s.substring(index + 1, s.length());
        }
        if ((index = s.indexOf(83)) > 0) {
            seconds = java.lang.Double.parseDouble(s.substring(0, index));
            s = s.substring(index + 1, s.length());
        }
        double day_time = (double)(days * 86400L + hours * 3600L + minutes * 60L) + seconds;
        if (have_sign) {
            day_time = -day_time;
        }
        this.dayTime = day_time;
    }

    public DayTimeDuration(double day_time) {
        this.dayTime = day_time;
    }

    public double getDayTime() {
        return this.dayTime;
    }

    long getDays() {
        return (long)(Math.abs(this.dayTime) / 86400.0);
    }

    int getHours() {
        return (int)(Math.abs(this.dayTime) - (double)(86400L * this.getDays())) / 3600;
    }

    int getMinutes() {
        double minutes = Math.abs(this.dayTime) - (double)(3600 * this.getHours()) - (double)(86400L * this.getDays());
        return (int)(minutes / 60.0);
    }

    double getSeconds() {
        double seconds = Math.abs(this.dayTime) - (double)(60 * this.getMinutes()) - (double)(3600 * this.getHours()) - (double)(86400L * this.getDays());
        return seconds;
    }

    public java.lang.String toString() {
        int hours = this.getHours();
        int minutes = this.getMinutes();
        double seconds = this.getSeconds();
        java.lang.String str = "P" + this.getDays() + "D";
        if (this.dayTime < 0.0) {
            str = "-" + str;
        }
        if (hours == 0 && minutes == 0 && seconds == 0.0) {
            return str;
        }
        return str + "T" + this.getHours() + "H" + this.getMinutes() + "M" + this.getSeconds() + "S";
    }

    @Override
    public int getType() {
        return 17;
    }

    @Override
    public Value convertTo(int type) throws ClassCastException {
        switch (type) {
            case 17: {
                return this;
            }
            case 16: {
                return new Duration(0L, this.dayTime);
            }
            case 18: {
                return new YearMonthDuration((long)(this.dayTime / 2629800.0));
            }
            case 7: {
                return new String(this.toString());
            }
        }
        return new Double(this.getDayTime()).convertTo(type);
    }

    @Override
    public void assign(Value v) {
        DayTimeDuration vd = (DayTimeDuration)v.convertTo(17);
        this.dayTime = vd.getDayTime();
    }

    @Override
    public int getPriority() {
        return 7;
    }

    @Override
    public Value add(Value x) {
        if (x instanceof DateTime) {
            return ((DateTime)x).add(this);
        }
        DayTimeDuration vd = (DayTimeDuration)x.convertTo(17);
        return new DayTimeDuration(this.getDayTime() + vd.getDayTime());
    }

    @Override
    public Value unaryMinus() {
        return new DayTimeDuration(-this.getDayTime());
    }

    @Override
    public Value sub(Value x) {
        DayTimeDuration vd = (DayTimeDuration)x.convertTo(17);
        return new DayTimeDuration(this.getDayTime() - vd.getDayTime());
    }

    @Override
    public Value multiply(Value x) {
        Numeric num = (Numeric)x.convertTo(9);
        return new DayTimeDuration(this.getDayTime() * num.doubleValue());
    }

    @Override
    public Value divide(Value x) {
        Numeric num = (Numeric)x.convertTo(9);
        return new DayTimeDuration(this.getDayTime() / num.doubleValue());
    }

    @Override
    public Value modulus(Value x) {
        Numeric num = (Numeric)x.convertTo(9);
        return new DayTimeDuration(this.getDayTime() % num.doubleValue());
    }

    @Override
    public int compareTo(Value v) {
        DayTimeDuration vd = (DayTimeDuration)v.convertTo(17);
        double diff = this.getDayTime() - vd.getDayTime();
        if (diff < 0.0) {
            return -1;
        }
        if (diff > 0.0) {
            return 1;
        }
        return 0;
    }

    public static void main(java.lang.String[] args) {
        int iDate;
        DayTimeDuration dur = new DayTimeDuration(java.lang.Double.parseDouble(args[0]));
        System.out.println("Test :  convert a dayTimeDuration(" + args[0] + ")");
        System.out.println("toString : " + dur.convertTo(7));
        System.out.println("toDouble : " + dur.convertTo(6));
        System.out.println("toLong : " + dur.convertTo(4));
        if (args.length > 1) {
            System.out.println("-- CMP --");
            DayTimeDuration dur2 = new DayTimeDuration(java.lang.Double.parseDouble(args[1]));
            System.out.println("'" + dur + "' compareTo '" + dur2 + " = " + dur.compareTo(dur2));
        }
        java.lang.String[] dates = new java.lang.String[]{"01-JAN-2000 00:00:00.000000", "31-DEC-1999 04:00:00.004321", "01-JUL-1973 15:15:00.000937", "01-JAN-2002 10:30:50.876543"};
        System.out.println("-- SUM --");
        DateTime date_time1 = null;
        DateTime date_time2 = null;
        for (iDate = 0; iDate < dates.length; ++iDate) {
            date_time1 = new DateTime(dates[iDate]);
            date_time2 = (DateTime)date_time1.add(dur).convertTo(8);
            System.out.println("'" + date_time1 + "' full=" + (long)(date_time1.getFullTime() * 1.0E9) + " time=" + date_time1.getTime() + " nanos=" + date_time1.getNanos());
            System.out.println("'" + date_time1 + "' + '" + dur + " = " + date_time1.add(dur).convertTo(8));
            System.out.println("'" + date_time2 + "' full=" + (long)(date_time2.getFullTime() * 1.0E9) + " time=" + date_time2.getTime() + " nanos=" + date_time2.getNanos());
        }
        System.out.println("-- DIF --");
        for (iDate = 0; iDate < dates.length; ++iDate) {
            System.out.println("'" + date_time1 + "' - '" + dur + " = " + date_time1.sub(dur).convertTo(8));
        }
    }
}

