/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.xsd;

import fr.gael.drb.value.Comparison;
import fr.gael.drb.value.DefaultValueArray;
import fr.gael.drb.value.FloatArray;
import fr.gael.drb.value.Value;
import fr.gael.drb.xsd.XsdAtomicType;
import fr.gael.drb.xsd.XsdFacet;
import fr.gael.drb.xsd.XsdListType;

public class XsdEnumerationFacet
extends XsdFacet {
    static final String TAG = "enumeration";
    private Value[] values;

    XsdEnumerationFacet(Value[] values) {
        this.values = values;
    }

    @Override
    public final int getId() {
        return 4;
    }

    @Override
    public Value getValue() {
        DefaultValueArray valueArray = new DefaultValueArray(this.values.length);
        for (int i = 0; i < this.values.length; ++i) {
            valueArray.assign(i, this.values[i]);
        }
        return valueArray;
    }

    public final Value[] getValues() {
        return this.values;
    }

    @Override
    public final String getName() {
        return TAG;
    }

    public String toString() {
        String str = "{";
        for (int k = 0; k < this.values.length; ++k) {
            if (k > 0) {
                str = str + "; ";
            }
            str = str + this.values[k];
        }
        return str + "}";
    }

    @Override
    public boolean isValid(Value v) {
        if (v == null) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            try {
                Value v2 = v.convertTo(this.values[i].getType());
                if (((Comparison)((Object)this.values[i])).compareTo(v2) != 0) continue;
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static void main(String[] args) {
        System.out.println("Test 1 : <xsd:simpleType name='listOfFloat'>");
        System.out.println("           <xsd:restriction>");
        System.out.println("             <xsd:enumeration value='1 2 3'/>");
        System.out.println("             <xsd:enumeration value='5 6'/>");
        System.out.println("             <xsd:simpleType>");
        System.out.println("               <xsd:list itemType='xsd:float'/>");
        System.out.println("             </xsd:simpleType>");
        System.out.println("           </xsd:restriction>");
        System.out.println("         </xsd:simpleType>\n");
        XsdFacet[] facets = new XsdFacet[]{new XsdEnumerationFacet(new Value[]{new FloatArray(new float[]{1.0f, 2.0f, 3.0f}), new FloatArray(new float[]{5.0f, 6.0f})})};
        XsdAtomicType atomic = new XsdAtomicType(5, null);
        XsdListType list = new XsdListType(atomic, facets);
        FloatArray floatList1 = new FloatArray(new float[]{1.0f, 2.0f, 3.0f});
        FloatArray floatList2 = new FloatArray(new float[]{7.0f, 2.0f, 9.0f});
        FloatArray floatList3 = new FloatArray(new float[]{5.0f, 6.0f});
        System.out.println("Checking floatList1 (" + floatList1 + ") -> " + list.isValid(floatList1));
        System.out.println("Checking floatList2 (" + floatList2 + ") -> " + list.isValid(floatList2));
        System.out.println("Checking floatList3 (" + floatList3 + ") -> " + list.isValid(floatList3));
    }
}

