/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.test;

import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.test.AssemblerTestBase;
import com.hp.hpl.jena.rdf.model.Resource;

public class TestMode
extends AssemblerTestBase {
    static final String someName = "aName";
    static final Resource someRoot = TestMode.resource("aRoot");

    public TestMode(String name) {
        super(name);
    }

    public void testConstantsExist() {
        Mode a = Mode.CREATE;
        Mode b = Mode.DEFAULT;
        Mode c = Mode.REUSE;
        Mode d = Mode.ANY;
        TestMode.assertDiffer(Mode.CREATE, Mode.DEFAULT);
        TestMode.assertDiffer(Mode.CREATE, Mode.REUSE);
        TestMode.assertDiffer(Mode.CREATE, Mode.ANY);
        TestMode.assertDiffer(Mode.DEFAULT, Mode.REUSE);
        TestMode.assertDiffer(Mode.DEFAULT, Mode.ANY);
        TestMode.assertDiffer(Mode.REUSE, Mode.ANY);
    }

    public void testCreate() {
        TestMode.assertEquals((boolean)true, (boolean)Mode.CREATE.permitCreateNew(someRoot, someName));
        TestMode.assertEquals((boolean)false, (boolean)Mode.CREATE.permitUseExisting(someRoot, someName));
    }

    public void testReuse() {
        TestMode.assertEquals((boolean)false, (boolean)Mode.REUSE.permitCreateNew(someRoot, someName));
        TestMode.assertEquals((boolean)true, (boolean)Mode.REUSE.permitUseExisting(someRoot, someName));
    }

    public void testAny() {
        TestMode.assertEquals((boolean)true, (boolean)Mode.ANY.permitCreateNew(someRoot, someName));
        TestMode.assertEquals((boolean)true, (boolean)Mode.ANY.permitUseExisting(someRoot, someName));
    }

    public void testDefault() {
        TestMode.assertEquals((boolean)false, (boolean)Mode.DEFAULT.permitCreateNew(someRoot, someName));
        TestMode.assertEquals((boolean)true, (boolean)Mode.DEFAULT.permitUseExisting(someRoot, someName));
    }
}

