/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.main.iterator;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpSubstitute;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.Binding1;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIter;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterRepeatApply;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterSingleton;
import com.hp.hpl.jena.sparql.engine.main.QC;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.util.iterator.NullIterator;
import com.hp.hpl.jena.util.iterator.SingletonIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class QueryIterGraph
extends QueryIterRepeatApply {
    OpGraph opGraph;

    public QueryIterGraph(QueryIterator input, OpGraph opGraph, ExecutionContext context) {
        super(input, context);
        this.opGraph = opGraph;
    }

    protected QueryIterator nextStage(Binding outerBinding) {
        DatasetGraph ds = this.getExecContext().getDataset();
        Iterator graphNameNodes = QueryIterGraph.makeSources(ds, outerBinding, this.opGraph.getNode());
        QueryIterGraphInner current = new QueryIterGraphInner(outerBinding, graphNameNodes, this.opGraph, this.getExecContext());
        return current;
    }

    private static Node resolve(Binding b, Node n) {
        if (!n.isVariable()) {
            return n;
        }
        return b.get(Var.alloc(n));
    }

    private static Iterator makeSources(DatasetGraph data, Binding b, Node graphVar) {
        Node n2 = QueryIterGraph.resolve(b, graphVar);
        if (n2 != null && !n2.isURI()) {
            return new NullIterator();
        }
        if (n2 == null) {
            return data.listGraphNodes();
        }
        return new SingletonIterator((Object)n2);
    }

    private static class QueryIterGraphInner
    extends QueryIter {
        private Binding parentBinding;
        private Iterator graphNames;
        private OpGraph opGraph;
        private QueryIterator subIter = null;

        public QueryIterGraphInner(Binding parent, Iterator graphNames, OpGraph opGraph, ExecutionContext execCxt) {
            super(execCxt);
            this.parentBinding = parent;
            this.graphNames = graphNames;
            this.opGraph = opGraph;
        }

        protected boolean hasNextBinding() {
            do {
                if (this.subIter == null) {
                    this.subIter = this.nextIterator();
                }
                if (this.subIter == null) {
                    return false;
                }
                if (this.subIter.hasNext()) {
                    return true;
                }
                this.subIter.close();
                this.subIter = this.nextIterator();
            } while (this.subIter != null);
            return false;
        }

        protected Binding moveToNextBinding() {
            if (this.subIter == null) {
                throw new NoSuchElementException(Utils.className(this) + ".moveToNextBinding");
            }
            return this.subIter.nextBinding();
        }

        protected void closeIterator() {
            if (this.subIter != null) {
                this.subIter.close();
            }
            this.subIter = null;
        }

        private QueryIterator nextIterator() {
            if (!this.graphNames.hasNext()) {
                return null;
            }
            Node gn = (Node)this.graphNames.next();
            Graph g = this.getExecContext().getDataset().getGraph(gn);
            if (g == null) {
                return null;
            }
            ExecutionContext execCxt2 = new ExecutionContext(this.getExecContext(), g);
            Binding b = this.parentBinding;
            if (Var.isVar(this.opGraph.getNode())) {
                b = new Binding1(b, Var.alloc(this.opGraph.getNode()), gn);
            }
            QueryIterator qIter = QueryIterGraphInner.buildIterator(b, gn, this.opGraph, execCxt2);
            return qIter;
        }

        private static QueryIterator buildIterator(Binding binding, Node graphNode, OpGraph opGraph, ExecutionContext cxt) {
            if (!graphNode.isURI()) {
                throw new ARQInternalErrorException("QueryIterGraphInner.buildIterator");
            }
            Op op = OpSubstitute.substitute(opGraph.getSubOp(), binding);
            Graph g = cxt.getDataset().getGraph(graphNode);
            if (g == null) {
                return null;
            }
            ExecutionContext cxt2 = new ExecutionContext(cxt, g);
            QueryIterSingleton subInput = new QueryIterSingleton(binding, cxt);
            return QC.compile(op, subInput, cxt2);
        }
    }
}

