/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.optimizer.heuristic;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.engine.optimizer.core.BasicPatternJoin;
import com.hp.hpl.jena.sparql.engine.optimizer.heuristic.HeuristicBasicPattern;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VariableCounting
extends HeuristicBasicPattern {
    private static Log log = LogFactory.getLog((Class)VariableCounting.class);

    public double getCost(Triple triple1) {
        double cost = 1.0;
        int MAX_COST = 8;
        if (triple1.getSubject().isVariable()) {
            cost += 4.0;
        }
        if (triple1.getPredicate().isVariable()) {
            cost += 1.0;
        }
        if (triple1.getObject().isVariable()) {
            cost += 2.0;
        }
        return cost / (double)MAX_COST;
    }

    public double getCost(Triple triple1, Triple triple2) {
        if (!BasicPatternJoin.isJoined(triple1, triple2)) {
            log.error((Object)("The triples are not joined, no cost estimation allowed (Double.MAX_VALUE returned): " + triple1 + " " + triple2));
            return Double.MAX_VALUE;
        }
        double cost = 32.0;
        int MAX_COST = 32;
        List joins = BasicPatternJoin.specificTypes(triple1, triple2);
        Iterator iter = joins.iterator();
        while (iter.hasNext()) {
            String type = (String)iter.next();
            if (type.equals("http://jena.hpl.hp.com/ARQo/join#uSS")) {
                cost -= 2.0;
                continue;
            }
            if (type.equals("http://jena.hpl.hp.com/ARQo/join#uSP")) {
                cost -= 3.0;
                continue;
            }
            if (type.equals("http://jena.hpl.hp.com/ARQo/join#uSO")) {
                cost -= 1.0;
                continue;
            }
            if (type.equals("http://jena.hpl.hp.com/ARQo/join#uPS")) {
                cost -= 3.0;
                continue;
            }
            if (type.equals("http://jena.hpl.hp.com/ARQo/join#uPP")) {
                cost -= 3.0;
                continue;
            }
            if (type.equals("http://jena.hpl.hp.com/ARQo/join#uPO")) {
                cost -= 3.0;
                continue;
            }
            if (type.equals("http://jena.hpl.hp.com/ARQo/join#uOS")) {
                cost -= 1.0;
                continue;
            }
            if (type.equals("http://jena.hpl.hp.com/ARQo/join#uOP")) {
                cost -= 3.0;
                continue;
            }
            if (type.equals("http://jena.hpl.hp.com/ARQo/join#uOO")) {
                cost -= 1.0;
                continue;
            }
            if (type.equals("http://jena.hpl.hp.com/ARQo/join#bSS")) {
                cost -= 4.0;
                continue;
            }
            if (type.equals("http://jena.hpl.hp.com/ARQo/join#bSP")) {
                cost -= 6.0;
                continue;
            }
            if (type.equals("http://jena.hpl.hp.com/ARQo/join#bSO")) {
                cost -= 2.0;
                continue;
            }
            if (type.equals("http://jena.hpl.hp.com/ARQo/join#bPS")) {
                cost -= 6.0;
                continue;
            }
            if (type.equals("http://jena.hpl.hp.com/ARQo/join#bPP")) {
                cost -= 0.0;
                continue;
            }
            if (type.equals("http://jena.hpl.hp.com/ARQo/join#bPO")) {
                cost -= 6.0;
                continue;
            }
            if (type.equals("http://jena.hpl.hp.com/ARQo/join#bOS")) {
                cost -= 2.0;
                continue;
            }
            if (type.equals("http://jena.hpl.hp.com/ARQo/join#bOP")) {
                cost -= 6.0;
                continue;
            }
            if (!type.equals("http://jena.hpl.hp.com/ARQo/join#bOO")) continue;
            cost -= 2.0;
        }
        return cost / (double)MAX_COST * this.getCost(triple1) * this.getCost(triple2);
    }
}

