/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.http.connector;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.security.Principal;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Response;
import org.restlet.Server;
import org.restlet.data.Form;
import org.restlet.data.Method;
import org.restlet.data.Parameter;
import org.restlet.data.Protocol;
import org.restlet.data.Status;
import org.restlet.engine.http.connector.BaseHelper;
import org.restlet.engine.http.connector.ConnectedRequest;
import org.restlet.engine.http.connector.Connection;
import org.restlet.engine.http.connector.ConnectionState;
import org.restlet.engine.http.header.HeaderReader;
import org.restlet.engine.http.header.HeaderUtils;
import org.restlet.engine.util.StringUtils;
import org.restlet.representation.Representation;
import org.restlet.util.Series;
import org.restlet.util.WrapperList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerConnection
extends Connection<Server> {
    public ServerConnection(BaseHelper<Server> helper, Socket socket, SocketChannel socketChannel) throws IOException {
        super(helper, socket, socketChannel);
    }

    protected void addResponseHeaders(Response response, Series<Parameter> headers) {
        HeaderUtils.addResponseHeaders(response, headers);
    }

    @Override
    public boolean canRead() {
        return super.canRead() && (this.getInboundMessages().size() == 0 || this.isPipelining());
    }

    public void commit(Response response) {
        this.getHelper().getOutboundMessages().add(response);
    }

    protected ConnectedRequest createRequest(Context context, ServerConnection connection, String methodName, String resourceUri, String version, Series<Parameter> headers, Representation entity, boolean confidential, Principal userPrincipal) {
        return new ConnectedRequest(this.getHelper().getContext(), this, Method.valueOf(methodName), resourceUri, version, headers, this.createInboundEntity(headers), false, null);
    }

    @Override
    protected void readMessage() throws IOException {
        ConnectedRequest request = null;
        String requestMethod = null;
        String requestUri = null;
        String version = null;
        WrapperList headers = null;
        StringBuilder sb = new StringBuilder();
        int next = this.getInboundStream().read();
        while (next != -1 && !HeaderUtils.isSpace(next)) {
            sb.append((char)next);
            next = this.getInboundStream().read();
        }
        if (next == -1) {
            throw new IOException("Unable to parse the request method. End of stream reached too early.");
        }
        requestMethod = sb.toString();
        sb.delete(0, sb.length());
        next = this.getInboundStream().read();
        while (next != -1 && !HeaderUtils.isSpace(next)) {
            sb.append((char)next);
            next = this.getInboundStream().read();
        }
        if (next == -1) {
            throw new IOException("Unable to parse the request URI. End of stream reached too early.");
        }
        requestUri = sb.toString();
        if (requestUri == null || requestUri.equals("")) {
            requestUri = "/";
        }
        sb.delete(0, sb.length());
        next = this.getInboundStream().read();
        while (next != -1 && !HeaderUtils.isCarriageReturn(next)) {
            sb.append((char)next);
            next = this.getInboundStream().read();
        }
        if (next == -1) {
            throw new IOException("Unable to parse the protocol version. End of stream reached too early.");
        }
        next = this.getInboundStream().read();
        if (HeaderUtils.isLineFeed(next)) {
            version = sb.toString();
            sb.delete(0, sb.length());
            Parameter header = HeaderReader.readHeader(this.getInboundStream(), sb);
            while (header != null) {
                if (headers == null) {
                    headers = new Form();
                }
                headers.add(header);
                header = HeaderReader.readHeader(this.getInboundStream(), sb);
            }
        } else {
            throw new IOException("Unable to parse the protocol version. The carriage return must be followed by a line feed.");
        }
        if (HeaderUtils.isConnectionClose(headers)) {
            this.setState(ConnectionState.CLOSING);
        }
        request = this.createRequest(this.getHelper().getContext(), this, requestMethod, requestUri, version, (Series<Parameter>)headers, this.createInboundEntity((Series<Parameter>)headers), false, null);
        Response response = this.getHelper().createResponse(request);
        response.getServerInfo().setAddress(((Server)this.getHelper().getHelped()).getAddress());
        response.getServerInfo().setPort(((Server)this.getHelper().getHelped()).getPort());
        if (request != null) {
            if (request.isExpectingResponse()) {
                this.getInboundMessages().add(response);
            }
            this.getHelper().getInboundMessages().add(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    @Override
    protected void writeMessage(Response response) {
        Form headers = new Form();
        ConnectedRequest request = (ConnectedRequest)response.getRequest();
        try {
            block38: {
                try {
                    if (request.getMethod() != null && request.getMethod().equals(Method.HEAD)) {
                        this.addEntityHeaders(response.getEntity(), headers);
                        response.setEntity(null);
                    } else if (Method.GET.equals(request.getMethod()) && Status.SUCCESS_OK.equals(response.getStatus()) && !response.isEntityAvailable()) {
                        this.addEntityHeaders(response.getEntity(), headers);
                        this.getLogger().warning("A response with a 200 (Ok) status should have an entity. Make sure that resource \"" + request.getResourceRef() + "\" returns one or sets the status to 204 (No content).");
                    } else if (response.getStatus().equals(Status.SUCCESS_NO_CONTENT)) {
                        this.addEntityHeaders(response.getEntity(), headers);
                        if (response.isEntityAvailable()) {
                            this.getLogger().fine("Responses with a 204 (No content) status generally don't have an entity. Only adding entity headers for resource \"" + request.getResourceRef() + "\".");
                            response.setEntity(null);
                        }
                    } else if (response.getStatus().equals(Status.SUCCESS_RESET_CONTENT)) {
                        if (response.isEntityAvailable()) {
                            this.getLogger().warning("Responses with a 205 (Reset content) status can't have an entity. Ignoring the entity for resource \"" + request.getResourceRef() + "\".");
                            response.setEntity(null);
                        }
                    } else if (response.getStatus().equals(Status.REDIRECTION_NOT_MODIFIED)) {
                        if (response.getEntity() != null) {
                            HeaderUtils.addNotModifiedEntityHeaders(response.getEntity(), headers);
                            response.setEntity(null);
                        }
                    } else if (response.getStatus().isInformational()) {
                        if (response.isEntityAvailable()) {
                            this.getLogger().warning("Responses with an informational (1xx) status can't have an entity. Ignoring the entity for resource \"" + request.getResourceRef() + "\".");
                            response.setEntity(null);
                        }
                        this.addGeneralHeaders(response, headers);
                        this.addResponseHeaders(response, headers);
                    } else {
                        this.addGeneralHeaders(response, headers);
                        this.addResponseHeaders(response, headers);
                        this.addEntityHeaders(response.getEntity(), headers);
                        if (!response.isEntityAvailable()) {
                            if (response.getEntity() != null && response.getEntity().getSize() != 0L) {
                                this.getLogger().warning("A response with an unavailable and non empty entity was returned. Ignoring the entity for resource \"" + response.getRequest().getResourceRef() + "\".");
                            }
                            response.setEntity(null);
                        }
                    }
                    this.writeMessage(response, headers);
                }
                catch (Exception e) {
                    block39: {
                        this.getLogger().log(Level.INFO, "An exception occured while writing the response", e);
                        response.setStatus(Status.SERVER_ERROR_INTERNAL, "An exception occured while writing the response");
                        response.setEntity(null);
                        try {
                            this.writeMessage(response, headers);
                        }
                        catch (IOException ioe) {
                            this.getLogger().log(Level.WARNING, "Unable to send error response", ioe);
                        }
                        Object var7_5 = null;
                        if (!response.getStatus().isInformational() && request.getEntity() != null) {
                            try {}
                            catch (Throwable throwable) {
                                Object var10_12 = null;
                                request.getEntity().release();
                                throw throwable;
                            }
                            try {}
                            catch (IOException e2) {
                                this.getLogger().log(Level.FINE, "Unable to exhaust request entity", e2);
                                Object var10_11 = null;
                                request.getEntity().release();
                                break block39;
                            }
                            request.getEntity().exhaust();
                            Object var10_10 = null;
                            request.getEntity().release();
                        }
                    }
                    if (response.getOnSent() != null) {
                        response.getOnSent().handle(request, response);
                    }
                    this.getOutboundMessages().poll();
                    this.setOutboundBusy(false);
                    return;
                }
                Object var7_4 = null;
                if (!response.getStatus().isInformational() && request.getEntity() != null) {
                    try {
                        try {
                            request.getEntity().exhaust();
                        }
                        catch (IOException e2) {
                            this.getLogger().log(Level.FINE, "Unable to exhaust request entity", e2);
                            Object var10_8 = null;
                            request.getEntity().release();
                            break block38;
                        }
                        Object var10_7 = null;
                        request.getEntity().release();
                    }
                    catch (Throwable throwable) {
                        Object var10_9 = null;
                        request.getEntity().release();
                        throw throwable;
                    }
                }
            }
            if (response.getOnSent() != null) {
                response.getOnSent().handle(request, response);
            }
            this.getOutboundMessages().poll();
            this.setOutboundBusy(false);
            return;
        }
        catch (Throwable throwable) {
            block40: {
                Object var7_6 = null;
                if (!response.getStatus().isInformational() && request.getEntity() != null) {
                    try {}
                    catch (Throwable throwable2) {
                        Object var10_15 = null;
                        request.getEntity().release();
                        throw throwable2;
                    }
                    try {}
                    catch (IOException e2) {
                        this.getLogger().log(Level.FINE, "Unable to exhaust request entity", e2);
                        Object var10_14 = null;
                        request.getEntity().release();
                        break block40;
                    }
                    request.getEntity().exhaust();
                    Object var10_13 = null;
                    request.getEntity().release();
                }
            }
            if (response.getOnSent() != null) {
                response.getOnSent().handle(request, response);
            }
            this.getOutboundMessages().poll();
            this.setOutboundBusy(false);
            throw throwable;
        }
    }

    @Override
    protected void writeMessageHeadLine(Response response, OutputStream headStream) throws IOException {
        Protocol protocol = response.getRequest().getProtocol();
        String protocolVersion = protocol.getVersion();
        String version = protocol.getTechnicalName() + '/' + (protocolVersion == null ? "1.1" : protocolVersion);
        headStream.write(StringUtils.getAsciiBytes(version));
        headStream.write(32);
        headStream.write(StringUtils.getAsciiBytes(Integer.toString(response.getStatus().getCode())));
        headStream.write(32);
        if (response.getStatus().getName() != null) {
            headStream.write(StringUtils.getLatin1Bytes(response.getStatus().getName()));
        } else {
            headStream.write(StringUtils.getAsciiBytes("Status " + response.getStatus().getCode()));
        }
        headStream.write(13);
        headStream.write(10);
    }
}

