/*
 * Decompiled with CFR 0.152.
 */
package arq.examples;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.larq.IndexBuilderString;
import com.hp.hpl.jena.query.larq.IndexLARQ;
import com.hp.hpl.jena.query.larq.LARQ;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelChangedListener;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.util.StringUtils;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.util.FileManager;
import java.io.OutputStream;

public class ExLucene1 {
    public static void main(String[] a) throws Exception {
        System.out.println("ARQ Example: " + Utils.classShortName((Class)ExLucene1.class));
        System.out.println("ARQ: 2.1");
        System.out.println();
        Model model = ModelFactory.createDefaultModel();
        IndexLARQ index = ExLucene1.buildIndex(model, "testing/LARQ/data-1.ttl");
        String searchString = "+document";
        String queryString = StringUtils.join((String)"\n", (String[])new String[]{"PREFIX xsd:    <http://www.w3.org/2001/XMLSchema#>", "PREFIX :       <http://example/>", "PREFIX pf:     <http://jena.hpl.hp.com/ARQ/property#>", "SELECT * {", "    ?lit pf:textMatch '" + searchString + "'.", "}"});
        ExLucene1.performQuery(model, index, queryString);
        index.close();
    }

    static IndexLARQ buildIndex(Model model, String datafile) {
        IndexBuilderString larqBuilder = new IndexBuilderString();
        model.register((ModelChangedListener)larqBuilder);
        FileManager.get().readModel(model, datafile);
        larqBuilder.closeForWriting();
        model.unregister((ModelChangedListener)larqBuilder);
        IndexLARQ index = larqBuilder.getIndex();
        return index;
    }

    static void performQuery(Model model, IndexLARQ index, String queryString) {
        LARQ.setDefaultIndex((IndexLARQ)index);
        Query query2 = QueryFactory.create((String)queryString);
        query2.serialize((OutputStream)System.out);
        System.out.println();
        QueryExecution qExec = QueryExecutionFactory.create((Query)query2, (Model)model);
        ResultSetFormatter.out((OutputStream)System.out, (ResultSet)qExec.execSelect(), (Query)query2);
        qExec.close();
    }
}

