/*
 * Decompiled with CFR 0.152.
 */
package arq;

import arq.cmd.CmdException;
import arq.cmd.TerminationException;
import arq.cmdline.ArgDecl;
import arq.cmdline.CmdARQ;
import arq.cmdline.ModAssembler;
import arq.cmdline.ModDataset;
import arq.cmdline.ModEngine;
import arq.cmdline.ModQueryIn;
import arq.cmdline.ModRemote;
import arq.cmdline.ModResultsOut;
import arq.cmdline.ModTime;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.engine.http.HttpQuery;
import com.hp.hpl.jena.sparql.engine.http.QueryExceptionHTTP;
import com.hp.hpl.jena.sparql.resultset.ResultSetException;
import com.hp.hpl.jena.sparql.resultset.ResultsFormat;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.QueryExecUtils;
import com.hp.hpl.jena.sparql.util.Utils;
import java.io.OutputStream;
import java.util.List;

public class query
extends CmdARQ {
    ArgDecl argRepeat = new ArgDecl(true, "repeat");
    int repeatCount = 1;
    ModTime modTime = new ModTime();
    ModQueryIn modQuery = new ModQueryIn();
    ModDataset modDataset = new ModAssembler();
    ModResultsOut modResults = new ModResultsOut();
    ModRemote modRemote = new ModRemote();
    ModEngine modEngine = new ModEngine();

    public static void main(String[] argv) {
        new query(argv).main();
    }

    public query(String[] argv) {
        super(argv);
        super.addModule(this.modQuery);
        super.addModule(this.modResults);
        super.addModule(this.modDataset);
        super.addModule(this.modRemote);
        super.addModule(this.modEngine);
        super.addModule(this.modTime);
        super.add(this.argRepeat);
    }

    protected void processModulesAndArgs() {
        super.processModulesAndArgs();
        if (this.contains(this.argRepeat)) {
            try {
                this.repeatCount = Integer.parseInt(this.getValue(this.argRepeat));
            }
            catch (NumberFormatException ex) {
                throw new CmdException("Can't parse " + this.getValue(this.argRepeat) + " as an integer", ex);
            }
        }
    }

    protected void exec() {
        for (int i = 0; i < this.repeatCount; ++i) {
            if (this.modRemote.getServiceURL() == null) {
                this.queryExecLocal();
                continue;
            }
            this.queryExecRemote();
        }
    }

    protected String getCommandName() {
        return Utils.className((Object)this);
    }

    protected String getSummary() {
        return this.getCommandName() + " --data=<file> --query=<query>";
    }

    private void queryExecLocal() {
        try {
            Query query2 = this.modQuery.getQuery();
            if (this.isVerbose()) {
                IndentedWriter out = new IndentedWriter((OutputStream)System.out, true);
                query2.serialize(out);
                out.flush();
                System.out.println();
            }
            Dataset dataset = this.modDataset.getDataset();
            this.modTime.startTimer();
            QueryExecution qe = QueryExecutionFactory.create((Query)query2, (Dataset)dataset);
            if (dataset == null && !query2.hasDatasetDescription()) {
                System.err.println("Dataset not specified in query nor provided on command line.");
                throw new TerminationException(1);
            }
            QueryExecUtils.executeQuery((Query)query2, (QueryExecution)qe, (ResultsFormat)this.modResults.getResultsFormat());
            long time = this.modTime.endTimer();
            if (this.modTime.timingEnabled()) {
                System.out.println("Time: " + this.modTime.timeStr(time) + " sec");
            }
            qe.close();
        }
        catch (ARQInternalErrorException intEx) {
            System.err.println(intEx.getMessage());
            if (intEx.getCause() != null) {
                System.err.println("Cause:");
                intEx.getCause().printStackTrace(System.err);
                System.err.println();
            }
            intEx.printStackTrace(System.err);
        }
        catch (ResultSetException ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace(System.err);
        }
        catch (QueryException qEx) {
            throw new CmdException("Query Exeception", qEx);
        }
        catch (JenaException ex) {
            throw ex;
        }
        catch (CmdException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CmdException("Exception", ex);
        }
    }

    private void queryExecRemote() {
        Query query2 = this.modQuery.getQuery();
        try {
            String serviceURL = this.modRemote.getServiceURL();
            QueryExecution qe = QueryExecutionFactory.sparqlService((String)serviceURL, (Query)query2, (List)this.modDataset.getGraphURLs(), (List)this.modDataset.getNamedGraphURLs());
            if (this.modRemote.usePost()) {
                HttpQuery.urlLimit = 0;
            }
            QueryExecUtils.executeQuery((Query)query2, (QueryExecution)qe, (ResultsFormat)this.modResults.getResultsFormat());
        }
        catch (QueryExceptionHTTP ex) {
            throw new CmdException("HTTP Exeception", ex);
        }
        catch (Exception ex) {
            System.out.flush();
            ex.printStackTrace(System.err);
        }
    }
}

