/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.datatypes.DatatypeFormatException;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDateTime;
import com.hp.hpl.jena.enhanced.BuiltinPersonalities;
import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.Personality;
import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphListener;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.rdf.model.Alt;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Bag;
import com.hp.hpl.jena.rdf.model.Container;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelChangedListener;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelLock;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.NsIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.rdf.model.RDFReaderF;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.RDFWriterF;
import com.hp.hpl.jena.rdf.model.RSIterator;
import com.hp.hpl.jena.rdf.model.ReifiedStatement;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceF;
import com.hp.hpl.jena.rdf.model.Selector;
import com.hp.hpl.jena.rdf.model.Seq;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.IteratorFactory;
import com.hp.hpl.jena.rdf.model.impl.LiteralImpl;
import com.hp.hpl.jena.rdf.model.impl.ModelListenerAdapter;
import com.hp.hpl.jena.rdf.model.impl.ModelLockImpl;
import com.hp.hpl.jena.rdf.model.impl.ModelReifier;
import com.hp.hpl.jena.rdf.model.impl.NsIteratorImpl;
import com.hp.hpl.jena.rdf.model.impl.RDFReaderFImpl;
import com.hp.hpl.jena.rdf.model.impl.RDFWriterFImpl;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import com.hp.hpl.jena.rdf.model.impl.StatementImpl;
import com.hp.hpl.jena.rdf.model.impl.StmtIteratorImpl;
import com.hp.hpl.jena.rdf.model.impl.Util;
import com.hp.hpl.jena.shared.Command;
import com.hp.hpl.jena.shared.InvalidPropertyURIException;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.Lock;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.PropertyNotFoundException;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.shared.WrappedIOException;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.Map1Iterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ModelCom
extends EnhGraph
implements Model,
PrefixMapping,
ModelLock {
    private static final RDFReaderF readerFactory = new RDFReaderFImpl();
    private static final RDFWriterF writerFactory = new RDFWriterFImpl();
    private ModelLock modelLock = null;
    private static PrefixMapping defaultPrefixMapping = PrefixMapping.Factory.create();
    protected ModelReifier modelReifier = new ModelReifier(this);
    private Map1 mapAsTriple = new Map1(){

        public Object map1(Object s) {
            return ((Statement)s).asTriple();
        }
    };
    protected Map1 mapAsStatement = new Map1(){

        public Object map1(Object t) {
            return ModelCom.this.asStatement((Triple)t);
        }
    };

    public ModelCom(Graph base) {
        this(base, BuiltinPersonalities.model);
    }

    public ModelCom(Graph base, Personality personality) {
        super(base, personality);
        this.withDefaultMappings(defaultPrefixMapping);
    }

    public static PrefixMapping getDefaultModelPrefixes() {
        return defaultPrefixMapping;
    }

    public static PrefixMapping setDefaultModelPrefixes(PrefixMapping pm) {
        PrefixMapping result = defaultPrefixMapping;
        defaultPrefixMapping = pm;
        return result;
    }

    public QueryHandler queryHandler() {
        return this.getGraph().queryHandler();
    }

    public Graph getGraph() {
        return this.graph;
    }

    protected static Model createWorkModel() {
        return ModelFactory.createDefaultModel();
    }

    public RDFNode asRDFNode(Node n) {
        return n.isLiteral() ? (RDFNode)((Object)this.getNodeAs(n, Literal.class)) : (RDFNode)((Object)this.getNodeAs(n, Resource.class));
    }

    public Resource getResource(String uri, ResourceF f) {
        try {
            return f.createResource(this.getResource(uri));
        }
        catch (Exception e) {
            throw new JenaException(e);
        }
    }

    public Model add(Resource s, Property p, boolean o) {
        return this.add(s, p, String.valueOf(o));
    }

    public Model add(Resource s, Property p, long o) {
        return this.add(s, p, String.valueOf(o));
    }

    public Model add(Resource s, Property p, char o) {
        return this.add(s, p, String.valueOf(o));
    }

    public Model add(Resource s, Property p, float o) {
        return this.add(s, p, String.valueOf(o));
    }

    public Model add(Resource s, Property p, double o) {
        return this.add(s, p, String.valueOf(o));
    }

    public Model add(Resource s, Property p, String o) {
        return this.add(s, p, o, "", false);
    }

    public Model add(Resource s, Property p, String o, boolean wellFormed) {
        this.add(s, p, this.literal(o, "", wellFormed));
        return this;
    }

    public Model add(Resource s, Property p, String o, String lang, boolean wellFormed) {
        this.add(s, p, this.literal(o, lang, wellFormed));
        return this;
    }

    public Model add(Resource s, Property p, String lex, RDFDatatype datatype) {
        this.add(s, p, this.literal(lex, datatype));
        return this;
    }

    private Literal literal(String s, String lang, boolean wellFormed) {
        return new LiteralImpl(Node.createLiteral(s, lang, wellFormed), this);
    }

    private Literal literal(String lex, RDFDatatype datatype) {
        return new LiteralImpl(Node.createLiteral(lex, "", datatype), this);
    }

    public Model add(Resource s, Property p, String o, String l) {
        return this.add(s, p, o, l, false);
    }

    private RDFNode ensureRDFNode(Object o) {
        return o instanceof RDFNode ? (RDFNode)o : this.literal(o.toString(), null, false);
    }

    public Model add(Resource s, Property p, Object o) {
        return this.add(s, p, this.ensureRDFNode(o));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model add(StmtIterator iter) {
        try {
            this.getBulkUpdateHandler().add(this.asTriples(iter));
        }
        finally {
            iter.close();
        }
        return this;
    }

    public Model add(Model m) {
        return this.add(m, false);
    }

    public Model add(Model m, boolean suppressReifications) {
        this.getBulkUpdateHandler().add(m.getGraph(), !suppressReifications);
        return this;
    }

    public RDFReader getReader() {
        return readerFactory.getReader();
    }

    public RDFReader getReader(String lang) {
        return readerFactory.getReader(lang);
    }

    public String setReaderClassName(String lang, String className) {
        return readerFactory.setReaderClassName(lang, className);
    }

    public Model read(String url) {
        readerFactory.getReader().read(this, url);
        return this;
    }

    public Model read(Reader reader, String base) {
        readerFactory.getReader().read((Model)this, reader, base);
        return this;
    }

    public Model read(InputStream reader, String base) {
        readerFactory.getReader().read((Model)this, reader, base);
        return this;
    }

    public Model read(String url, String lang) {
        readerFactory.getReader(lang).read(this, url);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model read(String url, String base, String lang) {
        try {
            InputStream is = new URL(url).openStream();
            try {
                this.read(is, base, lang);
            }
            finally {
                is.close();
            }
        }
        catch (IOException e) {
            throw new WrappedIOException(e);
        }
        return this;
    }

    public Model read(Reader reader, String base, String lang) {
        readerFactory.getReader(lang).read((Model)this, reader, base);
        return this;
    }

    public Model read(InputStream reader, String base, String lang) {
        readerFactory.getReader(lang).read((Model)this, reader, base);
        return this;
    }

    public RDFWriter getWriter() {
        return writerFactory.getWriter();
    }

    public RDFWriter getWriter(String lang) {
        return writerFactory.getWriter(lang);
    }

    public String setWriterClassName(String lang, String className) {
        return writerFactory.setWriterClassName(lang, className);
    }

    public Model write(Writer writer) {
        this.getWriter().write((Model)this, writer, "");
        return this;
    }

    public Model write(Writer writer, String lang) {
        this.getWriter(lang).write((Model)this, writer, "");
        return this;
    }

    public Model write(Writer writer, String lang, String base) {
        this.getWriter(lang).write((Model)this, writer, base);
        return this;
    }

    public Model write(OutputStream writer) {
        this.getWriter().write((Model)this, writer, "");
        return this;
    }

    public Model write(OutputStream writer, String lang) {
        this.getWriter(lang).write((Model)this, writer, "");
        return this;
    }

    public Model write(OutputStream writer, String lang, String base) {
        this.getWriter(lang).write((Model)this, writer, base);
        return this;
    }

    public Model remove(Statement s) {
        this.graph.delete(s.asTriple());
        return this;
    }

    public Model remove(Resource s, Property p, RDFNode o) {
        this.graph.delete(Triple.create(s.asNode(), p.asNode(), o.asNode()));
        return this;
    }

    public Model remove(StmtIterator iter) {
        this.getBulkUpdateHandler().delete(this.asTriples(iter));
        return this;
    }

    public Model remove(Model m) {
        return this.remove(m, false);
    }

    public Model remove(Model m, boolean suppressReifications) {
        this.getBulkUpdateHandler().delete(m.getGraph(), !suppressReifications);
        return this;
    }

    public Model removeAll() {
        this.getGraph().getBulkUpdateHandler().removeAll();
        return this;
    }

    public Model removeAll(Resource s, Property p, RDFNode o) {
        this.getGraph().getBulkUpdateHandler().remove(ModelCom.asNode(s), ModelCom.asNode(p), ModelCom.asNode(o));
        return this;
    }

    public boolean contains(Resource s, Property p, boolean o) {
        return this.contains(s, p, String.valueOf(o));
    }

    public boolean contains(Resource s, Property p, long o) {
        return this.contains(s, p, String.valueOf(o));
    }

    public boolean contains(Resource s, Property p, char o) {
        return this.contains(s, p, String.valueOf(o));
    }

    public boolean contains(Resource s, Property p, float o) {
        return this.contains(s, p, String.valueOf(o));
    }

    public boolean contains(Resource s, Property p, double o) {
        return this.contains(s, p, String.valueOf(o));
    }

    public boolean contains(Resource s, Property p, String o) {
        return this.contains(s, p, o, "");
    }

    public boolean contains(Resource s, Property p, String o, String l) {
        return this.contains(s, p, this.literal(o, l, false));
    }

    public boolean contains(Resource s, Property p, Object o) {
        return this.contains(s, p, this.ensureRDFNode(o));
    }

    public boolean containsAny(Model model) {
        return this.containsAnyThenClose(model.listStatements());
    }

    public boolean containsAll(Model model) {
        return this.containsAllThenClose(model.listStatements());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean containsAnyThenClose(StmtIterator iter) {
        try {
            boolean bl = this.containsAny(iter);
            return bl;
        }
        finally {
            iter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean containsAllThenClose(StmtIterator iter) {
        try {
            boolean bl = this.containsAll(iter);
            return bl;
        }
        finally {
            iter.close();
        }
    }

    public boolean containsAny(StmtIterator iter) {
        while (iter.hasNext()) {
            if (!this.contains(iter.nextStatement())) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(StmtIterator iter) {
        while (iter.hasNext()) {
            if (this.contains(iter.nextStatement())) continue;
            return false;
        }
        return true;
    }

    protected StmtIterator listStatements(Resource S, Property P, Node O) {
        return IteratorFactory.asStmtIterator(this.graph.find(ModelCom.asNode(S), ModelCom.asNode(P), O), this);
    }

    public StmtIterator listStatements(Resource S, Property P, RDFNode O) {
        return this.listStatements(S, P, ModelCom.asNode(O));
    }

    public StmtIterator listStatements(Resource S, Property P, String O) {
        return O == null ? this.listStatements(S, P, Node.ANY) : this.listStatements(S, P, Node.createLiteral(O));
    }

    public StmtIterator listStatements(Resource S, Property P, String O, String L) {
        return O == null ? this.listStatements(S, P, Node.ANY) : this.listStatements(S, P, Node.createLiteral(O, L, false));
    }

    public StmtIterator listStatements(Resource S, Property P, boolean O) {
        return this.listStatements(S, P, String.valueOf(O));
    }

    public StmtIterator listStatements(Resource S, Property P, long O) {
        return this.listStatements(S, P, String.valueOf(O));
    }

    public StmtIterator listStatements(Resource S, Property P, char O) {
        return this.listStatements(S, P, String.valueOf(O));
    }

    public StmtIterator listStatements(Resource S, Property P, float O) {
        return this.listStatements(S, P, String.valueOf(O));
    }

    public StmtIterator listStatements(Resource S, Property P, double O) {
        return this.listStatements(S, P, String.valueOf(O));
    }

    public ResIterator listSubjectsWithProperty(Property p, boolean o) {
        return this.listSubjectsWithProperty(p, String.valueOf(o));
    }

    public ResIterator listSubjectsWithProperty(Property p, long o) {
        return this.listSubjectsWithProperty(p, String.valueOf(o));
    }

    public ResIterator listSubjectsWithProperty(Property p, char o) {
        return this.listSubjectsWithProperty(p, String.valueOf(o));
    }

    public ResIterator listSubjectsWithProperty(Property p, float o) {
        return this.listSubjectsWithProperty(p, String.valueOf(o));
    }

    public ResIterator listSubjectsWithProperty(Property p, double o) {
        return this.listSubjectsWithProperty(p, String.valueOf(o));
    }

    public ResIterator listSubjectsWithProperty(Property p, String o) {
        return this.listSubjectsWithProperty(p, o, "");
    }

    public ResIterator listSubjectsWithProperty(Property p, String o, String l) {
        return this.listSubjectsWithProperty(p, this.literal(o, l, false));
    }

    public ResIterator listSubjectsWithProperty(Property p, Object o) {
        return this.listSubjectsWithProperty(p, this.ensureRDFNode(o));
    }

    public Resource createResource(Resource type) {
        return this.createResource().addProperty(RDF.type, type);
    }

    public Resource createResource(String uri, Resource type) {
        return this.getResource(uri).addProperty(RDF.type, type);
    }

    public Resource createResource(ResourceF f) {
        return this.createResource(null, f);
    }

    public Resource createResource(AnonId id) {
        return new ResourceImpl(id, this);
    }

    public Resource createResource(String uri, ResourceF f) {
        return f.createResource(this.createResource(uri));
    }

    public Literal createTypedLiteral(boolean v) {
        return this.createTypedLiteral(new Boolean(v));
    }

    public Literal createTypedLiteral(int v) {
        return this.createTypedLiteral(new Integer(v));
    }

    public Literal createTypedLiteral(long v) {
        return this.createTypedLiteral(new Long(v));
    }

    public Literal createTypedLiteral(char v) {
        return this.createTypedLiteral(new Character(v));
    }

    public Literal createTypedLiteral(float v) {
        return this.createTypedLiteral(new Float(v));
    }

    public Literal createTypedLiteral(double v) {
        return this.createTypedLiteral(new Double(v));
    }

    public Literal createTypedLiteral(String v) {
        LiteralLabel ll = new LiteralLabel(v);
        return new LiteralImpl(Node.createLiteral(ll), this);
    }

    public Literal createTypedLiteral(Calendar cal) {
        XSDDateTime value = new XSDDateTime(cal);
        LiteralLabel ll = new LiteralLabel(value, "", (RDFDatatype)XSDDatatype.XSDdateTime);
        return new LiteralImpl(Node.createLiteral(ll), this);
    }

    public Literal createTypedLiteral(String lex, RDFDatatype dtype) throws DatatypeFormatException {
        return new LiteralImpl(Node.createLiteral(lex, "", dtype), this);
    }

    public Literal createTypedLiteral(Object value, RDFDatatype dtype) {
        LiteralLabel ll = new LiteralLabel(value, "", dtype);
        return new LiteralImpl(Node.createLiteral(ll), this);
    }

    public Literal createTypedLiteral(String lex, String typeURI) {
        RDFDatatype dt = TypeMapper.getInstance().getSafeTypeByName(typeURI);
        LiteralLabel ll = LiteralLabel.createLiteralLabel(lex, "", dt);
        return new LiteralImpl(Node.createLiteral(ll), this);
    }

    public Literal createTypedLiteral(Object value, String typeURI) {
        RDFDatatype dt = TypeMapper.getInstance().getSafeTypeByName(typeURI);
        LiteralLabel ll = new LiteralLabel(value, "", dt);
        return new LiteralImpl(Node.createLiteral(ll), this);
    }

    public Literal createTypedLiteral(Object value) {
        if (value instanceof Calendar) {
            return this.createTypedLiteral((Calendar)value);
        }
        LiteralLabel ll = new LiteralLabel(value);
        return new LiteralImpl(Node.createLiteral(ll), this);
    }

    public Literal createLiteral(boolean v) {
        return this.createLiteral(String.valueOf(v), "");
    }

    public Literal createLiteral(int v) {
        return this.createLiteral(String.valueOf(v), "");
    }

    public Literal createLiteral(long v) {
        return this.createLiteral(String.valueOf(v), "");
    }

    public Literal createLiteral(char v) {
        return this.createLiteral(String.valueOf(v), "");
    }

    public Literal createLiteral(float v) {
        return this.createLiteral(String.valueOf(v), "");
    }

    public Literal createLiteral(double v) {
        return this.createLiteral(String.valueOf(v), "");
    }

    public Literal createLiteral(String v) {
        return this.createLiteral(v, "");
    }

    public Literal createLiteral(String v, String l) {
        return this.literal(v, l, false);
    }

    public Literal createLiteral(String v, boolean wellFormed) {
        return this.literal(v, "", wellFormed);
    }

    public Literal createLiteral(String v, String l, boolean wellFormed) {
        return this.literal(v, l, wellFormed);
    }

    public Literal createLiteral(Object v) {
        return this.createLiteral(v.toString(), "");
    }

    public Statement createStatement(Resource r, Property p, boolean o) {
        return this.createStatement(r, p, this.createLiteral(o));
    }

    public Statement createStatement(Resource r, Property p, long o) {
        return this.createStatement(r, p, this.createLiteral(o));
    }

    public Statement createStatement(Resource r, Property p, char o) {
        return this.createStatement(r, p, this.createLiteral(o));
    }

    public Statement createStatement(Resource r, Property p, float o) {
        return this.createStatement(r, p, this.createLiteral(o));
    }

    public Statement createStatement(Resource r, Property p, double o) {
        return this.createStatement(r, p, this.createLiteral(o));
    }

    public Statement createStatement(Resource r, Property p, String o) {
        return this.createStatement(r, p, this.createLiteral(o));
    }

    public Statement createStatement(Resource r, Property p, Object o) {
        return this.createStatement(r, p, this.ensureRDFNode(o));
    }

    public Statement createStatement(Resource r, Property p, String o, boolean wellFormed) {
        return this.createStatement(r, p, o, "", wellFormed);
    }

    public Statement createStatement(Resource r, Property p, String o, String l) {
        return this.createStatement(r, p, o, l, false);
    }

    public Statement createStatement(Resource r, Property p, String o, String l, boolean wellFormed) {
        return this.createStatement(r, p, this.literal(o, l, wellFormed));
    }

    public Bag createBag() {
        return this.createBag(null);
    }

    public Alt createAlt() {
        return this.createAlt(null);
    }

    public Seq createSeq() {
        return this.createSeq(null);
    }

    public RDFList createList() {
        return (RDFList)this.getResource(RDF.nil.getURI()).as(RDFList.class);
    }

    public RDFList createList(Iterator members) {
        RDFList list = this.createList();
        while (members != null && members.hasNext()) {
            list = list.with((RDFNode)members.next());
        }
        return list;
    }

    public RDFList createList(RDFNode[] members) {
        return this.createList(Arrays.asList(members).iterator());
    }

    public RDFNode getRDFNode(Node n) {
        return this.asRDFNode(n);
    }

    public Resource getResource(String uri) {
        return IteratorFactory.asResource(ModelCom.makeURI(uri), this);
    }

    public Property getProperty(String uri) {
        if (uri == null) {
            throw new InvalidPropertyURIException(null);
        }
        return IteratorFactory.asProperty(ModelCom.makeURI(uri), this);
    }

    public Property getProperty(String nameSpace, String localName) {
        return this.getProperty(nameSpace + localName);
    }

    public Seq getSeq(String uri) {
        return (Seq)IteratorFactory.asResource(ModelCom.makeURI(uri), Seq.class, this);
    }

    public Seq getSeq(Resource r) {
        return (Seq)r.as(Seq.class);
    }

    public Bag getBag(String uri) {
        return (Bag)IteratorFactory.asResource(ModelCom.makeURI(uri), Bag.class, this);
    }

    public Bag getBag(Resource r) {
        return (Bag)r.as(Bag.class);
    }

    private static Node makeURI(String uri) {
        return uri == null ? Node.createAnon() : Node.createURI(uri);
    }

    public Alt getAlt(String uri) {
        return (Alt)IteratorFactory.asResource(ModelCom.makeURI(uri), Alt.class, this);
    }

    public Alt getAlt(Resource r) {
        return (Alt)r.as(Alt.class);
    }

    public long size() {
        return this.graph.size();
    }

    public boolean isEmpty() {
        return this.graph.isEmpty();
    }

    private void updateNamespace(Set set, Iterator it) {
        while (it.hasNext()) {
            Node node = (Node)it.next();
            if (!node.isURI()) continue;
            String uri = node.getURI();
            String ns = uri.substring(0, Util.splitNamespace(uri));
            set.add(ns);
        }
    }

    private Iterator listPredicates() {
        return this.getGraph().queryHandler().predicatesFor(Node.ANY, Node.ANY);
    }

    private Iterator listTypes() {
        Set types = CollectionFactory.createHashedSet();
        ExtendedIterator it = this.graph.find(null, RDF.type.asNode(), null);
        while (it.hasNext()) {
            types.add(((Triple)it.next()).getObject());
        }
        return types.iterator();
    }

    public NsIterator listNameSpaces() {
        Set nameSpaces = CollectionFactory.createHashedSet();
        this.updateNamespace(nameSpaces, this.listPredicates());
        this.updateNamespace(nameSpaces, this.listTypes());
        return new NsIteratorImpl(nameSpaces.iterator(), nameSpaces);
    }

    private PrefixMapping getPrefixMapping() {
        return this.getGraph().getPrefixMapping();
    }

    public boolean samePrefixMappingAs(PrefixMapping other) {
        return this.getPrefixMapping().samePrefixMappingAs(other);
    }

    public PrefixMapping lock() {
        this.getPrefixMapping().lock();
        return this;
    }

    public PrefixMapping setNsPrefix(String prefix, String uri) {
        this.getPrefixMapping().setNsPrefix(prefix, uri);
        return this;
    }

    public PrefixMapping removeNsPrefix(String prefix) {
        this.getPrefixMapping().removeNsPrefix(prefix);
        return this;
    }

    public PrefixMapping setNsPrefixes(PrefixMapping pm) {
        this.getPrefixMapping().setNsPrefixes(pm);
        return this;
    }

    public PrefixMapping setNsPrefixes(Map map) {
        this.getPrefixMapping().setNsPrefixes(map);
        return this;
    }

    public PrefixMapping withDefaultMappings(PrefixMapping other) {
        this.getPrefixMapping().withDefaultMappings(other);
        return this;
    }

    public String getNsPrefixURI(String prefix) {
        return this.getPrefixMapping().getNsPrefixURI(prefix);
    }

    public String getNsURIPrefix(String uri) {
        return this.getPrefixMapping().getNsURIPrefix(uri);
    }

    public Map getNsPrefixMap() {
        return this.getPrefixMapping().getNsPrefixMap();
    }

    public String expandPrefix(String prefixed) {
        return this.getPrefixMapping().expandPrefix(prefixed);
    }

    public String usePrefix(String uri) {
        return this.getPrefixMapping().shortForm(uri);
    }

    public String qnameFor(String uri) {
        return this.getPrefixMapping().qnameFor(uri);
    }

    public String shortForm(String uri) {
        return this.getPrefixMapping().shortForm(uri);
    }

    public static void addNamespaces(Model m, Map ns) {
        Model pm = m;
        Iterator it = ns.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            String key = (String)e.getKey();
            Set values = (Set)e.getValue();
            Set niceValues = CollectionFactory.createHashedSet();
            Iterator them = values.iterator();
            while (them.hasNext()) {
                String uri = (String)them.next();
                if (!PrefixMappingImpl.isNiceURI(uri)) continue;
                niceValues.add(uri);
            }
            if (niceValues.size() != 1) continue;
            pm.setNsPrefix(key, (String)niceValues.iterator().next());
        }
    }

    public StmtIterator listStatements() {
        return IteratorFactory.asStmtIterator(GraphUtil.findAll(this.graph), this);
    }

    public Model add(Statement s) {
        this.add(s.getSubject(), s.getPredicate(), s.getObject());
        return this;
    }

    public Model add(Statement[] statements) {
        this.getBulkUpdateHandler().add(StatementImpl.asTriples(statements));
        return this;
    }

    protected BulkUpdateHandler getBulkUpdateHandler() {
        return this.getGraph().getBulkUpdateHandler();
    }

    public Model add(List statements) {
        this.getBulkUpdateHandler().add(this.asTriples(statements));
        return this;
    }

    private List asTriples(List statements) {
        ArrayList<Triple> L = new ArrayList<Triple>(statements.size());
        for (int i = 0; i < statements.size(); ++i) {
            L.add(((Statement)statements.get(i)).asTriple());
        }
        return L;
    }

    private Iterator asTriples(StmtIterator it) {
        return new Map1Iterator(this.mapAsTriple, it);
    }

    public Model remove(Statement[] statements) {
        this.getBulkUpdateHandler().delete(StatementImpl.asTriples(statements));
        return this;
    }

    public Model remove(List statements) {
        this.getBulkUpdateHandler().delete(this.asTriples(statements));
        return this;
    }

    public Model add(Resource s, Property p, RDFNode o) {
        this.modelReifier.noteIfReified(s, p, o);
        this.graph.add(Triple.create(s.asNode(), p.asNode(), o.asNode()));
        return this;
    }

    public ReificationStyle getReificationStyle() {
        return this.modelReifier.getReificationStyle();
    }

    public RSIterator listReifiedStatements() {
        return this.modelReifier.listReifiedStatements();
    }

    public RSIterator listReifiedStatements(Statement st) {
        return this.modelReifier.listReifiedStatements(st);
    }

    public boolean isReified(Statement s) {
        return this.modelReifier.isReified(s);
    }

    public Resource getAnyReifiedStatement(Statement s) {
        return this.modelReifier.getAnyReifiedStatement(s);
    }

    public void removeAllReifications(Statement s) {
        this.modelReifier.removeAllReifications(s);
    }

    public void removeReification(ReifiedStatement rs) {
        this.modelReifier.removeReification(rs);
    }

    public ReifiedStatement createReifiedStatement(Statement s) {
        return this.modelReifier.createReifiedStatement(s);
    }

    public ReifiedStatement createReifiedStatement(String uri, Statement s) {
        return this.modelReifier.createReifiedStatement(uri, s);
    }

    public boolean contains(Statement s) {
        return this.graph.contains(s.asTriple());
    }

    public boolean containsResource(RDFNode r) {
        return this.graph.queryHandler().containsNode(r.asNode());
    }

    public boolean contains(Resource s, Property p) {
        return this.contains(s, p, (RDFNode)null);
    }

    public boolean contains(Resource s, Property p, RDFNode o) {
        return this.graph.contains(ModelCom.asNode(s), ModelCom.asNode(p), ModelCom.asNode(o));
    }

    public Statement getRequiredProperty(Resource s, Property p) {
        Statement st = this.getProperty(s, p);
        if (st == null) {
            throw new PropertyNotFoundException(p);
        }
        return st;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement getProperty(Resource s, Property p) {
        StmtIterator iter = this.listStatements(s, p, (RDFNode)null);
        try {
            Statement statement = iter.hasNext() ? iter.nextStatement() : null;
            return statement;
        }
        finally {
            iter.close();
        }
    }

    public static Node asNode(RDFNode x) {
        return x == null ? Node.ANY : x.asNode();
    }

    private NodeIterator listObjectsFor(RDFNode s, RDFNode p) {
        ExtendedIterator xit = this.graph.queryHandler().objectsFor(ModelCom.asNode(s), ModelCom.asNode(p));
        return IteratorFactory.asRDFNodeIterator(xit, this);
    }

    private ResIterator listSubjectsFor(RDFNode p, RDFNode o) {
        ExtendedIterator xit = this.graph.queryHandler().subjectsFor(ModelCom.asNode(p), ModelCom.asNode(o));
        return IteratorFactory.asResIterator(xit, this);
    }

    public ResIterator listSubjects() {
        return this.listSubjectsFor(null, null);
    }

    public ResIterator listSubjectsWithProperty(Property p) {
        return this.listSubjectsFor(p, null);
    }

    public ResIterator listSubjectsWithProperty(Property p, RDFNode o) {
        return this.listSubjectsFor(p, o);
    }

    public NodeIterator listObjects() {
        return this.listObjectsFor(null, null);
    }

    public NodeIterator listObjectsOfProperty(Property p) {
        return this.listObjectsFor(null, p);
    }

    public NodeIterator listObjectsOfProperty(Resource s, Property p) {
        return this.listObjectsFor(s, p);
    }

    public StmtIterator listStatements(Selector selector) {
        StmtIterator sts = IteratorFactory.asStmtIterator(this.findTriplesFrom(selector), this);
        return selector.isSimple() ? sts : new StmtIteratorImpl(sts.filterKeep(this.asFilter(selector)));
    }

    public Filter asFilter(final Selector s) {
        return new Filter(){

            public boolean accept(Object x) {
                return s.test((Statement)x);
            }
        };
    }

    public ExtendedIterator findTriplesFrom(Selector s) {
        return this.graph.find(ModelCom.asNode(s.getSubject()), ModelCom.asNode(s.getPredicate()), ModelCom.asNode(s.getObject()));
    }

    public boolean supportsTransactions() {
        return this.getTransactionHandler().transactionsSupported();
    }

    public Model begin() {
        this.getTransactionHandler().begin();
        return this;
    }

    public Model abort() {
        this.getTransactionHandler().abort();
        return this;
    }

    public Model commit() {
        this.getTransactionHandler().commit();
        return this;
    }

    public Object executeInTransaction(Command cmd) {
        return this.getTransactionHandler().executeInTransaction(cmd);
    }

    private TransactionHandler getTransactionHandler() {
        return this.getGraph().getTransactionHandler();
    }

    public boolean independent() {
        return true;
    }

    public Resource createResource() {
        return IteratorFactory.asResource(Node.createAnon(), this);
    }

    public Resource createResource(String uri) {
        return this.getResource(uri);
    }

    public Property createProperty(String uri) {
        return this.getProperty(uri);
    }

    public Property createProperty(String nameSpace, String localName) {
        return this.getProperty(nameSpace, localName);
    }

    public Statement createStatement(Resource r, Property p, RDFNode o) {
        return new StatementImpl(r, p, o, this);
    }

    public Bag createBag(String uri) {
        return (Bag)this.getBag(uri).addProperty(RDF.type, RDF.Bag);
    }

    public Alt createAlt(String uri) {
        return (Alt)this.getAlt(uri).addProperty(RDF.type, RDF.Alt);
    }

    public Seq createSeq(String uri) {
        return (Seq)this.getSeq(uri).addProperty(RDF.type, RDF.Seq);
    }

    public Statement asStatement(Triple t) {
        return StatementImpl.toStatement(t, this);
    }

    public Statement[] asStatements(Triple[] triples) {
        Statement[] result = new Statement[triples.length];
        for (int i = 0; i < triples.length; ++i) {
            result[i] = this.asStatement(triples[i]);
        }
        return result;
    }

    public List asStatements(List triples) {
        ArrayList<Statement> L = new ArrayList<Statement>(triples.size());
        for (int i = 0; i < triples.size(); ++i) {
            L.add(this.asStatement((Triple)triples.get(i)));
        }
        return L;
    }

    public Model asModel(Graph g) {
        return new ModelCom(g);
    }

    public StmtIterator asStatements(Iterator it) {
        return new StmtIteratorImpl(new Map1Iterator(this.mapAsStatement, it));
    }

    public StmtIterator listBySubject(Container cont) {
        return this.listStatements((Resource)cont, null, (RDFNode)null);
    }

    public void close() {
        this.graph.close();
    }

    public boolean isClosed() {
        return this.graph.isClosed();
    }

    public boolean supportsSetOperations() {
        return true;
    }

    public Model query(Selector selector) {
        return ModelCom.createWorkModel().add(this.listStatements(selector));
    }

    public Model union(Model model) {
        return ModelCom.createWorkModel().add(this).add(model);
    }

    public Model intersection(Model other) {
        return this.size() < other.size() ? ModelCom.intersect(this, other) : ModelCom.intersect(other, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Model intersect(Model smaller, Model larger) {
        Model result = ModelCom.createWorkModel();
        StmtIterator it = smaller.listStatements();
        try {
            Model model = ModelCom.addCommon(result, it, larger);
            return model;
        }
        finally {
            it.close();
        }
    }

    protected static Model addCommon(Model result, StmtIterator it, Model other) {
        while (it.hasNext()) {
            Statement s = it.nextStatement();
            if (!other.contains(s)) continue;
            result.add(s);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model difference(Model model) {
        Model resultModel = ModelCom.createWorkModel();
        StmtIterator iter = null;
        try {
            iter = this.listStatements();
            while (iter.hasNext()) {
                Statement stmt = iter.nextStatement();
                if (model.contains(stmt)) continue;
                resultModel.add(stmt);
            }
            Model model2 = resultModel;
            return model2;
        }
        finally {
            iter.close();
        }
    }

    public String toString() {
        return "<ModelCom  " + this.getGraph() + " | " + this.reifiedToString() + ">";
    }

    public String reifiedToString() {
        return this.statementsToString(this.getHiddenStatements().listStatements());
    }

    protected String statementsToString(StmtIterator it) {
        StringBuffer b = new StringBuffer();
        while (it.hasNext()) {
            b.append(" ").append(it.nextStatement());
        }
        return b.toString();
    }

    public Model getHiddenStatements() {
        return this.modelReifier.getHiddenStatements();
    }

    public boolean isIsomorphicWith(Model m) {
        Graph L = ModelFactory.withHiddenStatements(this).getGraph();
        Graph R = ModelFactory.withHiddenStatements(m).getGraph();
        return L.isIsomorphicWith(R);
    }

    public synchronized ModelLock getModelLock() {
        if (this.modelLock == null) {
            this.modelLock = new ModelLockImpl();
        }
        return this.modelLock;
    }

    public synchronized Lock getLock() {
        return this.getModelLock();
    }

    public void enterCriticalSection(boolean requestReadLock) {
        this.getModelLock().enterCriticalSection(requestReadLock);
    }

    public void leaveCriticalSection() {
        this.getModelLock().leaveCriticalSection();
    }

    public Model register(ModelChangedListener listener) {
        this.getGraph().getEventManager().register(this.adapt(listener));
        return this;
    }

    public Model unregister(ModelChangedListener listener) {
        this.getGraph().getEventManager().unregister(this.adapt(listener));
        return this;
    }

    public GraphListener adapt(ModelChangedListener L) {
        return new ModelListenerAdapter(this, L);
    }

    public Model notifyEvent(Object e) {
        this.getGraph().getEventManager().notifyEvent(this.getGraph(), e);
        return this;
    }
}

