/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.regression;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.RDF;
import java.math.BigInteger;

class DiHyperCube {
    private final Resource[] corners;
    private final int dim;
    private final Model model;
    private int id = 2000;

    public DiHyperCube(int dimension, Model m) {
        int i;
        this.dim = dimension;
        this.model = m;
        this.corners = new Resource[1 << this.dim];
        for (i = 0; i < this.corners.length; ++i) {
            this.corners[i] = m.createResource();
        }
        for (i = 0; i < this.corners.length; ++i) {
            this.addDown(i, this.corners[i]);
        }
    }

    private void addDown(int corner, Resource r) {
        for (int j = 0; j < this.dim; ++j) {
            int bit = 1 << j;
            if ((corner & bit) == 0) continue;
            this.model.add(r, RDF.value, this.corners[corner ^ bit]);
        }
    }

    DiHyperCube dupe(int corner) {
        Resource dup = this.model.createResource();
        for (int j = 0; j < this.dim; ++j) {
            int bit = 1 << j;
            if ((corner & bit) != 0) {
                this.model.add(dup, RDF.value, this.corners[corner ^ bit]);
                continue;
            }
            this.model.add(this.corners[corner ^ bit], RDF.value, dup);
        }
        return this;
    }

    static int bitCount(int i) {
        return BigInteger.valueOf(i).bitCount();
    }

    static boolean equal(int a1, int b1) {
        return DiHyperCube.bitCount(a1) == DiHyperCube.bitCount(b1);
    }

    static boolean equal(int a1, int a2, int b1, int b2) {
        return DiHyperCube.bitCount(a1 ^ a2) == DiHyperCube.bitCount(b1 ^ b2) && DiHyperCube.bitCount(a1 & a2) == DiHyperCube.bitCount(b1 & b2) && DiHyperCube.bitCount(a1 | a2) == DiHyperCube.bitCount(b1 | b2) && Math.min(DiHyperCube.bitCount(a1), DiHyperCube.bitCount(a2)) == Math.min(DiHyperCube.bitCount(b1), DiHyperCube.bitCount(b2));
    }
}

