/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.sds;

import fr.gael.drb.impl.sds.Length;
import fr.gael.drb.value.Integer;
import fr.gael.drb.value.Numeric;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import org.apache.log4j.Logger;

abstract class RandomAccessData
implements DataInput,
DataOutput {
    private static Logger logger = Logger.getLogger(RandomAccessData.class);

    RandomAccessData() {
    }

    abstract void close() throws IOException;

    public long available() throws IOException {
        return 0L;
    }

    abstract void seek(long var1) throws IOException;

    final void seek(Length pos) throws IOException {
        this.seek(pos.getLength(), pos.getBitLength());
    }

    void seek(long pos, int bit_pos) throws IOException {
        this.seek(pos);
    }

    abstract long length() throws IOException;

    void setLength(long len) throws IOException {
        throw new IOException("RandomAccessData.setLength not supported");
    }

    void insert(byte[] b) throws IOException {
        throw new IOException("Insert not supported");
    }

    protected void clear(Length src_offset, Length dst_offset, byte val) throws IOException {
        int MAX_BUFFER_SIZE = 10240;
        long curSrcOffset = src_offset.getLength();
        long curLen = dst_offset.getLength() - src_offset.getLength();
        if (curLen < (long)MAX_BUFFER_SIZE) {
            MAX_BUFFER_SIZE = (int)curLen;
        }
        byte[] buffer = new byte[MAX_BUFFER_SIZE];
        Arrays.fill(buffer, val);
        this.seek(curSrcOffset);
        while (curLen > 0L) {
            if (curLen >= (long)MAX_BUFFER_SIZE) {
                this.write(buffer, 0, MAX_BUFFER_SIZE);
            } else {
                this.write(buffer, 0, (int)curLen);
            }
            curLen -= (long)MAX_BUFFER_SIZE;
        }
    }

    protected long move(Length src_offset, Length dst_offset) throws IOException {
        int MAX_BUFFER_SIZE = 10240;
        long curSrcOffset = src_offset.getLength();
        long cur_dst_offset = dst_offset.getLength();
        long curLen = this.length() - curSrcOffset;
        long fileLen = this.length() + cur_dst_offset - curSrcOffset;
        byte[] buffer = new byte[10240];
        if (curSrcOffset < cur_dst_offset) {
            curSrcOffset += curLen;
            cur_dst_offset += curLen;
            while (curLen > 0L) {
                if (curLen >= 10240L) {
                    curLen -= 10240L;
                    this.seek(curSrcOffset -= 10240L);
                    this.readFully(buffer, 0, 10240);
                    this.seek(cur_dst_offset -= 10240L);
                    this.write(buffer, 0, 10240);
                    continue;
                }
                this.seek(curSrcOffset -= curLen);
                this.readFully(buffer, 0, (int)curLen);
                this.seek(cur_dst_offset -= curLen);
                this.write(buffer, 0, (int)curLen);
                curLen = 0L;
            }
        } else {
            while (curLen > 0L) {
                if (curLen >= 10240L) {
                    this.seek(curSrcOffset);
                    this.readFully(buffer, 0, 10240);
                    this.seek(cur_dst_offset);
                    this.write(buffer, 0, 10240);
                    curSrcOffset += 10240L;
                    cur_dst_offset += 10240L;
                    curLen -= 10240L;
                    continue;
                }
                this.seek(curSrcOffset);
                this.readFully(buffer, 0, (int)curLen);
                this.seek(cur_dst_offset);
                this.write(buffer, 0, (int)curLen);
                curLen = 0L;
            }
            this.setLength(fileLen);
        }
        return curLen;
    }

    public void readFully(byte[] b, int off, Length len) throws IOException {
        this.readFully(b, off, (int)len.getLength());
    }

    public void write(byte[] b, int off, Length len) throws IOException {
        int byteLen = (int)len.getLength();
        byte bitLen = len.getBitLength();
        if (bitLen != 0) {
            throw new IOException("writeBits");
        }
        this.write(b, off, byteLen);
    }

    public void writeBits(int v, int bit_len) throws IOException {
        if (bit_len == 8) {
            this.writeByte(v);
        } else if (bit_len == 16) {
            this.writeShort(v);
        } else if (bit_len == 32) {
            this.writeInt(v);
        }
    }

    public BigInteger readInteger(Length len, boolean is_signed) throws IOException {
        int byteLen = (int)len.getLength();
        byte bitLen = len.getBitLength();
        byte[] buffer = new byte[byteLen + (bitLen + 7) / 8];
        this.readFully(buffer, 0, len);
        if (bitLen > 0) {
            int compBitLen = 8 - bitLen;
            for (int i = byteLen; i > 0; --i) {
                buffer[i] = (byte)((buffer[i] & 0xFF) >>> compBitLen | (buffer[i - 1] & 0xFF) << bitLen);
            }
            buffer[0] = (byte)((buffer[0] & 0xFF) >>> compBitLen);
            if (is_signed) {
                buffer[0] = (byte)(buffer[0] & 0xFF | 255 << bitLen);
            }
        }
        return new BigInteger(buffer);
    }

    public void writeInteger(Numeric num, Length len, boolean is_signed) throws IOException {
        int byteLen = (int)len.getLength();
        byte bitLen = len.getBitLength();
        byte[] intBuf = ((Integer)num.convertTo(27)).integerValue().toByteArray();
        byte[] buffer = new byte[byteLen + (7 + bitLen) / 8];
        int intOff = buffer.length - intBuf.length;
        int pad = 0;
        if (is_signed && (intBuf[0] & 0x80) != 0) {
            pad = -1;
        }
        if (bitLen > 0) {
            int compBitLen = 8 - bitLen;
            for (int i = 0; i < buffer.length; ++i) {
                buffer[i] = i < intOff - 1 ? pad : (i < intOff ? (byte)((intBuf[i + 1 - intOff] & 0xFF) >>> bitLen) : (i + 1 - intOff == intBuf.length ? (byte)((intBuf[i - intOff] & 0xFF) << compBitLen) : (byte)((intBuf[i - intOff] & 0xFF) << compBitLen | (intBuf[i + 1 - intOff] & 0xFF) >>> bitLen)));
            }
        } else {
            for (int i = 0; i < buffer.length; ++i) {
                buffer[i] = i >= intOff ? intBuf[i - intOff] : pad;
            }
        }
        this.write(buffer, 0, len);
    }

    public final void writeFloatLSB(float v) throws IOException {
        this.writeIntLSB(Float.floatToRawIntBits(v));
    }

    public final void writeIntLSB(int v) throws IOException {
        v = (v & 0xFF000000) >>> 24 | (v & 0xFF0000) >>> 8 | (v & 0xFF00) << 8 | (v & 0xFF) << 24;
        this.writeInt(v);
    }

    public final void writeLongLSB(long long_value) throws IOException {
        long_value = (long_value & 0xFF00000000000000L) >>> 56 | (long_value & 0xFF000000000000L) >>> 40 | (long_value & 0xFF0000000000L) >>> 24 | (long_value & 0xFF00000000L) >>> 8 | (long_value & 0xFF000000L) << 8 | (long_value & 0xFF0000L) << 24 | (long_value & 0xFF00L) << 40 | (long_value & 0xFFL) << 56;
        this.writeLong(long_value);
    }

    public void writeDoubleLSB(double v) throws IOException {
        this.writeLongLSB(Double.doubleToRawLongBits(v));
    }
}

