/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.sds;

import fr.gael.drb.DrbAttribute;
import fr.gael.drb.DrbAttributeList;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbNodeList;
import fr.gael.drb.DrbSimpleNode;
import fr.gael.drb.value.Value;
import fr.gael.drb.xsd.XsdComplexType;
import fr.gael.drb.xsd.XsdElement;
import fr.gael.drb.xsd.XsdModelGroup;
import fr.gael.drb.xsd.XsdParticle;
import fr.gael.drb.xsd.XsdSimpleType;
import fr.gael.drb.xsd.XsdType;
import java.util.ArrayList;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class SdfViewDescriptor {
    private static Logger logger = Logger.getLogger(SdfViewDescriptor.class);
    public static final String NAMESPACE = "sdf";
    public static final String MAP_ID = "view";
    public static final int CONTEXT_TARGET = 0;
    public static final int SELF_TARGET = 1;
    protected SdfViewDescriptor parent;
    protected XsdType baseType;
    protected String query;
    protected int target = 0;
    protected String valueQuery;
    protected String name;
    protected int valueType = -1;
    protected ArrayList children = null;

    public SdfViewDescriptor(XsdElement element) {
        this(element, new Hashtable());
    }

    protected SdfViewDescriptor(XsdElement element, Hashtable element_hash) {
        DrbNodeList map_children;
        element_hash.put(element, this);
        this.query = this.name = element.getName();
        this.valueQuery = ".";
        this.target = 0;
        DrbNodeList ext_children = element.getExternalNodes();
        DrbSimpleNode map_node = null;
        if (ext_children != null) {
            for (int i = 0; i < ext_children.getLength(); ++i) {
                String ext_child_name;
                DrbNode ext_child = ext_children.item(i);
                if (ext_child == null || (ext_child_name = ext_child.getName()) == null || !ext_child_name.equals(MAP_ID)) continue;
                map_node = ext_child;
                break;
            }
        }
        if (map_node != null && (map_children = map_node.getChildren()) != null) {
            DrbSimpleNode query_node = null;
            DrbSimpleNode value_node = null;
            DrbAttribute base_attr = map_node.getAttribute("base");
            System.err.println("SdvViewDescriptor: baseAttr " + base_attr);
            if (base_attr != null) {
                String base_type_name = base_attr.getValue().toString();
                this.baseType = element.getType().getSchema().getType(base_type_name);
                System.err.println("SdvViewDescriptor: baseTypeAttr " + this.baseType);
            }
            for (int i = 0; i < map_children.getLength(); ++i) {
                String map_child_name;
                DrbNode map_child = map_children.item(i);
                if (map_child == null || (map_child_name = map_child.getName()) == null) continue;
                if (map_child_name.equals("query")) {
                    query_node = map_child;
                }
                if (!map_child_name.equals("value")) continue;
                value_node = map_child;
            }
            if (query_node != null) {
                Value query_value = query_node.getValue();
                this.query = query_value != null ? query_value.toString() : null;
                DrbAttributeList query_attribs = query_node.getAttributes();
                if (query_attribs != null) {
                    for (int j = 0; j < query_attribs.getLength(); ++j) {
                        Value target_value;
                        DrbAttribute attrib = query_attribs.item(j);
                        if (attrib == null || attrib.getName() == null || attrib.getValue() == null || !attrib.getName().equals("target") || (target_value = attrib.getValue()).toString() == null || !target_value.toString().equals("self")) continue;
                        this.target = 1;
                    }
                }
            }
            if (value_node != null) {
                Value value = value_node.getValue();
                this.valueQuery = value != null ? value.toString() : null;
            }
        }
        if (element.getType() != null) {
            XsdSimpleType simple_type;
            XsdComplexType complex_type = null;
            XsdSimpleType xsdSimpleType = simple_type = complex_type == null ? null : complex_type.getDatatype();
            this.valueType = simple_type != null ? simple_type.getTypeId() : (complex_type == null ? -2 : -1);
            if (complex_type == null) {
                return;
            }
            this.children = new ArrayList();
            XsdModelGroup model_group = complex_type.getComplexContent();
            for (int ichild = 0; ichild < model_group.getLength(); ++ichild) {
                XsdParticle particle = model_group.getParticle(ichild);
                if (particle instanceof XsdElement) {
                    XsdElement child = (XsdElement)particle;
                    Object map_child = element_hash.get(child);
                    if (map_child != null) {
                        this.children.add(map_child);
                        continue;
                    }
                    this.children.add(new SdfViewDescriptor(child, element_hash));
                    continue;
                }
                logger.error("group inside group not supported");
            }
        }
    }

    public void print(String header) {
        System.out.println(header + this.name);
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                ((SdfViewDescriptor)this.children.get(i)).print(header + "   ");
            }
        }
    }
}

