/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.spi;

import fr.gael.drb.DrbAbstractNode;
import fr.gael.drb.DrbAttribute;
import fr.gael.drb.DrbAttributeList;
import fr.gael.drb.DrbDefaultAttributeList;
import fr.gael.drb.DrbDefaultMutableNode;
import fr.gael.drb.DrbDefaultNodeList;
import fr.gael.drb.DrbDefaultSequence;
import fr.gael.drb.DrbFactory;
import fr.gael.drb.DrbFactoryImpl;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbNodeList;
import fr.gael.drb.DrbNodesChangeEvent;
import fr.gael.drb.DrbNodesChangeListener;
import fr.gael.drb.DrbNodesChangeProducer;
import fr.gael.drb.DrbSequence;
import fr.gael.drb.DrbUpdateImpl;
import fr.gael.drb.impl.DrbFactoryResolver;
import fr.gael.drb.impl.DrbNodeImpl;
import fr.gael.drb.impl.sds.SdfFactory;
import fr.gael.drb.impl.spi.DrbAttributeSpi;
import fr.gael.drb.value.Value;
import fr.gael.drb.xsd.Namespace;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class DrbNodeSpi
extends DrbNodeImpl {
    private static Logger logger = Logger.getLogger(DrbNodeSpi.class);
    protected DrbNode baseNode;
    private DrbNode parent;
    private DrbFactoryImpl subImplFactory = null;
    private boolean isSubImplFactoryResolved = false;
    private DrbNode subImpl = null;
    private static boolean isWarningPrinted = false;
    boolean isSubImplChildrenResolved = false;

    public DrbNodeSpi(DrbNode base_node) {
        this(base_node, null);
    }

    public DrbNodeSpi(DrbNode base_node, boolean clone_if_node_spi) {
        this(base_node);
        if (clone_if_node_spi && base_node instanceof DrbNodeSpi) {
            DrbNodeSpi node_to_clone = (DrbNodeSpi)base_node;
            this.baseNode = node_to_clone.baseNode;
            this.parent = node_to_clone.parent;
            this.subImplFactory = node_to_clone.subImplFactory;
            this.isSubImplFactoryResolved = node_to_clone.isSubImplFactoryResolved;
        }
    }

    public DrbNodeSpi(DrbNode base_node, DrbNode parent) {
        if (base_node == null) {
            NullPointerException exception = new NullPointerException("Cannot initialize a DrbNodeSpi class with a null base_node");
            if (logger.isDebugEnabled()) {
                logger.debug("DrbNodeSpi contruction error", exception);
            }
            throw exception;
        }
        this.baseNode = base_node;
        DrbAttribute dir_attr = base_node.getAttribute("directory");
        if (dir_attr == null || dir_attr.getValue() == null || "true".equals(dir_attr.getValue().toString())) {
            this.isSubImplChildrenResolved = true;
            if (!isWarningPrinted && logger.isEnabledFor(Level.WARN)) {
                String base_package = base_node.getClass().getPackage().getName();
                logger.debug("Sub-implemenation resolver is disabled from " + base_package + " nodes until future optimization (this message will not be repeated).");
                isWarningPrinted = true;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[DRB SPI] Current implementation = " + this.getClass().getName());
        }
        this.parent = parent;
    }

    private DrbNode getDelegateNode() {
        DrbNode impl = this.getSubImpl();
        if (impl == null) {
            impl = this.baseNode;
        }
        if (impl == null) {
            throw new NullPointerException("No node to wrap.");
        }
        return impl;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DrbNodeSpi) {
            DrbNodeSpi spi_node = (DrbNodeSpi)obj;
            if (this.baseNode == null) {
                return false;
            }
            return this.baseNode.equals(spi_node.baseNode);
        }
        return false;
    }

    @Override
    public void addNodesChangeListener(DrbNodesChangeListener listener) {
        if (this.baseNode instanceof DrbNodesChangeProducer) {
            ((DrbNodesChangeProducer)((Object)this.baseNode)).addNodesChangeListener(listener);
        } else {
            super.addNodesChangeListener(listener);
        }
    }

    @Override
    public void removeNodesChangeListener(DrbNodesChangeListener listener) {
        if (this.baseNode instanceof DrbNodesChangeProducer) {
            ((DrbNodesChangeProducer)((Object)this.baseNode)).removeNodesChangeListener(listener);
        } else {
            super.removeNodesChangeListener(listener);
        }
    }

    @Override
    public void close(boolean deep) {
        if (this.baseNode instanceof DrbNodeImpl) {
            ((DrbNodeImpl)this.baseNode).close(deep);
        }
        if (deep && this.getSubImpl() != null && this.getSubImpl() instanceof DrbNodeImpl) {
            ((DrbNodeImpl)this.getSubImpl()).close(deep);
        }
    }

    protected DrbFactoryImpl getSubImplFactory() {
        if (!this.isSubImplFactoryResolved) {
            this.subImplFactory = DrbFactoryResolver.resolveImpl(this);
            this.isSubImplFactoryResolved = true;
        }
        return this.subImplFactory;
    }

    private DrbNode getSubImpl() {
        if (logger.isDebugEnabled()) {
            logger.debug("[DRB SPI] Retrieving sub-implementation of node \"" + this.getName() + "\"...");
        }
        if (!this.isSubImplChildrenResolved && this.subImpl == null) {
            DrbFactoryImpl impl = this.getSubImplFactory();
            if (impl == null) {
                return null;
            }
            this.subImpl = impl.open(this);
        }
        return this.subImpl;
    }

    public final void setSchema(String path) throws UnsupportedOperationException {
        if (path == null) {
            logger.error("DrbNodeSpi.setSchema(): Invalid path.");
            throw new UnsupportedOperationException("DrbNodeSpi.setSchema() : Invalid path.");
        }
        DrbNode schema = DrbFactory.openURI(path);
        if (schema == null) {
            logger.error("DrbNodeSpi.setSchema(): Cannot open schema " + path);
            throw new UnsupportedOperationException("DrbNodeSpi.setSchema() : Cannot open schema " + path);
        }
        this.setSchema(schema);
    }

    public final void setSchema(DrbNode schema) {
        try {
            DrbNode node = new SdfFactory().open(this.baseNode, schema, schema.getPath());
            DrbDefaultMutableNode file_node = new DrbDefaultMutableNode(this.baseNode.getName(), this.baseNode.getParent(), this.baseNode.getIndex(), this.baseNode.getPreviousSibling(), this.baseNode.getNextSibling());
            DrbDefaultNodeList list = new DrbDefaultNodeList();
            list.add(node);
            file_node.setChildren(list);
            this.subImpl = file_node;
            this.structureChanged(new DrbNodesChangeEvent(this));
        }
        catch (Exception e) {
            logger.error("DrbNodeSpi.setSchema(): Cannot retreive a sub implementation.");
            throw new UnsupportedOperationException("DrbNodeSpi.setSchema(): Cannot retreive a sub implementation.", e);
        }
    }

    @Override
    public String getName() {
        return this.baseNode.getName();
    }

    @Override
    protected String getXPathName() {
        if (this.baseNode instanceof DrbAbstractNode) {
            return this.getXPathName((DrbAbstractNode)this.baseNode);
        }
        return super.getXPathName();
    }

    @Override
    public boolean allowsMultiOccurrence() {
        if (this.baseNode instanceof DrbAbstractNode) {
            return ((DrbAbstractNode)this.baseNode).allowsMultiOccurrence();
        }
        return super.allowsMultiOccurrence();
    }

    @Override
    public String getPath() {
        try {
            return this.baseNode.getPath();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public int getIndex() {
        try {
            return this.baseNode.getIndex();
        }
        catch (Throwable e) {
            logger.debug("DrbNodeSpi.getIndex(): " + e);
            e.printStackTrace();
            return -1;
        }
    }

    @Override
    public String getNamespaceURI() {
        return this.baseNode.getNamespaceURI();
    }

    @Override
    public Namespace getNamespaceBindings() {
        if (this.baseNode instanceof DrbAbstractNode) {
            return ((DrbAbstractNode)this.baseNode).getNamespaceBindings();
        }
        return null;
    }

    @Override
    public int getValueType() {
        try {
            return this.baseNode.getValueType();
        }
        catch (Throwable e) {
            logger.debug("DrbNodeSpi.getValueType(): " + e);
            return -1;
        }
    }

    @Override
    public Value getValue() {
        return this.baseNode.getValue();
    }

    @Override
    public DrbAttribute getAttribute(String name) {
        DrbAttribute attr = this.baseNode.getAttribute(name);
        if (attr == null) {
            return null;
        }
        return new DrbAttributeSpi(attr, this);
    }

    @Override
    public DrbAttributeList getAttributes() {
        DrbAttributeList attributes = this.baseNode.getAttributes();
        if (attributes == null || attributes.getLength() == 0) {
            return null;
        }
        DrbDefaultAttributeList list = new DrbDefaultAttributeList();
        for (int i = 0; i < attributes.getLength(); ++i) {
            DrbAttribute attrib = attributes.item(i);
            if (attrib == null) continue;
            list.add(new DrbAttributeSpi(attrib, this));
        }
        return list;
    }

    @Override
    public DrbNode getParent() {
        DrbNode parent_node = this.baseNode.getParent();
        if (parent_node != null) {
            return new DrbNodeSpi(parent_node);
        }
        return null;
    }

    @Override
    public final boolean hasChild() {
        DrbNode impl = this.getDelegateNode();
        try {
            return impl.hasChild();
        }
        catch (UnsupportedOperationException e) {
            logger.debug("hasChild not supported by the sub-implementation.", e);
            return false;
        }
    }

    @Override
    public DrbNode getNamedChild(String name, int occurence) {
        if (name == null || occurence <= 0) {
            logger.error("DrbNodeSpi.getNamedChild(): Invalid parameters.");
            return null;
        }
        DrbNode output_child = null;
        DrbNode impl = this.getDelegateNode();
        output_child = impl.getNamedChild(name, occurence);
        if (output_child != null) {
            return new DrbNodeSpi(output_child);
        }
        return null;
    }

    @Override
    public final DrbNode getFirstChild() {
        DrbNode output_child = null;
        DrbNode impl = this.getDelegateNode();
        output_child = impl.getFirstChild();
        if (output_child != null) {
            return new DrbNodeSpi(output_child);
        }
        return null;
    }

    @Override
    public final DrbNode getLastChild() {
        DrbNode output_child = null;
        DrbNode impl = this.getDelegateNode();
        output_child = impl.getLastChild();
        if (output_child != null) {
            return new DrbNodeSpi(output_child);
        }
        return null;
    }

    @Override
    public final DrbNode getChildAt(int index) {
        DrbNode output_child = null;
        try {
            output_child = this.getDelegateNode().getChildAt(index);
        }
        catch (Exception e) {
            logger.error("No child at index #" + index + "(" + e.getMessage() + ")");
            return null;
        }
        if (output_child != null) {
            return new DrbNodeSpi(output_child);
        }
        return null;
    }

    @Override
    public DrbNodeList getChildren() {
        DrbNodeList children = this.getDelegateNode().getChildren();
        if (children == null) {
            return null;
        }
        DrbDefaultNodeList list = new DrbDefaultNodeList();
        for (int inode = 0; inode < children.getLength(); ++inode) {
            DrbNodeSpi child = new DrbNodeSpi(children.item(inode));
            list.add(child);
        }
        return list;
    }

    @Override
    public DrbSequence getContent() {
        DrbSequence content = new DrbDefaultSequence();
        if (this.getSubImpl() == null) {
            content = this.baseNode instanceof DrbAbstractNode ? ((DrbAbstractNode)this.baseNode).getContent() : this.baseNode.getChildren();
        } else {
            for (int inode = 0; inode < content.getLength(); ++inode) {
                DrbNode item = this.getSubImpl();
                if (item.getItemType() == 1) {
                    DrbNodeSpi child = new DrbNodeSpi(item);
                    child.parent = this;
                    content.addItem(inode, child);
                    continue;
                }
                content.addItem(inode, item);
            }
        }
        return content;
    }

    @Override
    public final int getChildrenCount() {
        return this.getDelegateNode().getChildrenCount();
    }

    @Override
    public final DrbNode getPreviousSibling() {
        DrbNode sibling = this.baseNode.getPreviousSibling();
        if (sibling != null) {
            return new DrbNodeSpi(sibling, this.parent);
        }
        return null;
    }

    @Override
    public final DrbNode getNextSibling() {
        DrbNode sibling = this.baseNode.getNextSibling();
        if (sibling != null) {
            return new DrbNodeSpi(sibling, this.parent);
        }
        return null;
    }

    @Override
    public void rename(String name) throws NullPointerException, UnsupportedOperationException {
        this.baseNode.rename(name);
    }

    @Override
    public Value setValue(Value value) throws NullPointerException, ClassCastException, UnsupportedOperationException {
        return this.baseNode.setValue(value);
    }

    @Override
    public void setAttributes(DrbAttributeList attributes) throws NullPointerException, UnsupportedOperationException {
        this.baseNode.setAttributes(attributes);
    }

    @Override
    public void setNamespaceURI(String namespace_uri) throws NullPointerException, UnsupportedOperationException {
        this.baseNode.setNamespaceURI(namespace_uri);
    }

    @Override
    public DrbNode insertChild(DrbNode node, int index) throws NullPointerException, UnsupportedOperationException, IndexOutOfBoundsException {
        if (this.getSubImpl() != null) {
            throw new UnsupportedOperationException("DrbNodeSpi.insertChild(): This operation is not allowed for sub-implementation.");
        }
        DrbNode inserted_node = this.baseNode.insertChild(node, index);
        if (inserted_node != null) {
            return new DrbNodeSpi(inserted_node);
        }
        return null;
    }

    @Override
    public DrbNode appendChild(DrbNode node) throws NullPointerException, UnsupportedOperationException {
        DrbNode appended_node;
        DrbFactoryImpl sub_impl_factory = this.getSubImplFactory();
        if (sub_impl_factory != null) {
            if (!(sub_impl_factory instanceof DrbUpdateImpl)) {
                throw new UnsupportedOperationException("DrbNodeSpi.appendChild(): This operation is not allowed for sub-implementation without updating ability.");
            }
            DrbUpdateImpl sub_impl_update = (DrbUpdateImpl)sub_impl_factory;
            sub_impl_update.put(node, this.baseNode);
        }
        if ((appended_node = this.baseNode.appendChild(node)) != null) {
            return new DrbNodeSpi(appended_node);
        }
        return null;
    }

    @Override
    public DrbNode replaceChild(int index, DrbNode new_node) throws NullPointerException, IndexOutOfBoundsException, UnsupportedOperationException {
        if (this.getSubImpl() != null) {
            throw new UnsupportedOperationException("DrbNodeSpi.replaceChild(): This operation is not allowed for sub-implementation.");
        }
        DrbNode replaced_node = this.baseNode.replaceChild(index, new_node);
        if (replaced_node != null) {
            return new DrbNodeSpi(replaced_node);
        }
        return null;
    }

    @Override
    public void removeChild(int index) throws IndexOutOfBoundsException, UnsupportedOperationException {
        if (this.getSubImpl() != null) {
            throw new UnsupportedOperationException("DrbNodeSpi.removeChild(): This operation is not allowed for sub-implementation.");
        }
        this.baseNode.removeChild(index);
    }

    @Override
    public boolean hasImpl(Class api) {
        if (this.baseNode != null && this.baseNode instanceof DrbNodeImpl) {
            return ((DrbNodeImpl)this.baseNode).hasImpl(api);
        }
        return super.hasImpl(api);
    }

    @Override
    public Object getImpl(Class api) {
        if (this.baseNode != null && this.baseNode instanceof DrbNodeImpl) {
            return ((DrbNodeImpl)this.baseNode).getImpl(api);
        }
        return super.getImpl(api);
    }

    public static DrbNode getDrb250FileNodeFromImplNode(final DrbNode impl_node, DrbNode base_node) {
        DrbDefaultMutableNode node = null;
        node = base_node != null ? new DrbDefaultMutableNode(base_node.getName(), base_node.getParent(), base_node.getIndex(), base_node.getPreviousSibling(), base_node.getNextSibling()){

            @Override
            public void close(boolean deep) {
                super.close(deep);
                if (impl_node instanceof DrbNodeImpl) {
                    ((DrbNodeImpl)impl_node).close(deep);
                }
            }

            @Override
            public Value setValue(Value value) {
                return impl_node.setValue(value);
            }

            @Override
            public Value getValue() {
                return impl_node.getValue();
            }
        } : new DrbDefaultMutableNode("SpiWrappedFile"){

            @Override
            public void close(boolean deep) {
                super.close(deep);
                if (impl_node instanceof DrbNodeImpl) {
                    ((DrbNodeImpl)impl_node).close(deep);
                }
            }

            @Override
            public Value setValue(Value value) {
                return impl_node.setValue(value);
            }

            @Override
            public Value getValue() {
                return impl_node.getValue();
            }
        };
        DrbDefaultNodeList list = new DrbDefaultNodeList();
        list.add(impl_node);
        node.setChildren(list);
        return node;
    }

    public DrbNode getBaseNode() {
        return this.baseNode;
    }
}

