/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.query;

import fr.gael.drb.DrbDefaultSequence;
import fr.gael.drb.DrbItem;
import fr.gael.drb.DrbSequence;
import fr.gael.drb.query.AbstractVariable;
import fr.gael.drb.query.DynamicContext;
import fr.gael.drb.query.QName;
import fr.gael.drb.query.SequenceType;
import fr.gael.drb.query.TypeCastException;

class DefaultVariable
extends AbstractVariable {
    private DrbSequence value = null;

    DefaultVariable(DefaultVariable variable) {
        super(variable);
        this.value = variable.value;
    }

    DefaultVariable(QName name) {
        super(name);
    }

    DefaultVariable(QName name, SequenceType sequence_type) {
        super(name, sequence_type);
    }

    DefaultVariable(QName name, SequenceType sequence_type, DrbSequence value) throws TypeCastException {
        super(name, sequence_type);
        if (value != null) {
            this.setValue(value);
        }
    }

    public void setValue(DrbSequence value) throws TypeCastException {
        if (value == null) {
            this.value = null;
            return;
        }
        SequenceType sequence_type = this.getSequenceType();
        if (sequence_type != null) {
            value = sequence_type.convert(value);
        }
        this.value = value;
    }

    public void setValue(DrbItem value) {
        if (value == null) {
            this.value = null;
            return;
        }
        this.setValue(new DrbDefaultSequence(value));
    }

    @Override
    public DrbSequence getValue() {
        return this.value;
    }

    @Override
    public void initialize(DynamicContext context) {
        if (this.value == null) {
            this.value = new DrbDefaultSequence();
        }
    }

    @Override
    public String toString() {
        DrbSequence value;
        String output_string = "$" + this.getName();
        SequenceType sequence_type = this.getSequenceType();
        if (sequence_type != null) {
            output_string = output_string + " " + sequence_type;
        }
        if ((value = this.getValue()) != null) {
            output_string = output_string + " := " + value;
        }
        return output_string;
    }

    @Override
    public Object clone() {
        return new DefaultVariable(this.getQName(), this.getSequenceType(), this.value);
    }
}

