/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.query;

import fr.gael.drb.DrbDefaultSequence;
import fr.gael.drb.DrbItem;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbSequence;
import fr.gael.drb.query.AbstractExpression;
import fr.gael.drb.query.DynamicContext;
import fr.gael.drb.query.DynamicException;
import fr.gael.drb.query.Expression;
import fr.gael.drb.query.Token;

class InsertExpression
extends AbstractExpression {
    private Expression sourceExpression = null;
    private Expression targetExpression = null;

    public InsertExpression(Token token) {
        super("Insert", token);
    }

    public void setTargetExpression(Expression target_expression) {
        this.targetExpression = target_expression;
    }

    public void setSourceExpression(Expression source_expression) {
        this.sourceExpression = source_expression;
    }

    public String toString() {
        return "do insert " + this.sourceExpression + " into " + this.targetExpression;
    }

    @Override
    public DrbSequence evaluate(DynamicContext context) {
        DrbSequence content_sequence;
        if (this.sourceExpression == null || this.targetExpression == null) {
            throw new DynamicException(this, "Incomplete \"insert\" declaration");
        }
        DrbSequence target_sequence = this.targetExpression.evaluate(context);
        if (target_sequence == null) {
            throw new DynamicException(this, "Error while evaluating the target expression");
        }
        if (target_sequence == null) {
            throw new DynamicException(this, "Error while evaluating the target expression");
        }
        if (target_sequence.getLength() != 1) {
            throw new DynamicException(this, "First parameter must be a single element node or a single document node. Found a sequence of " + target_sequence.getLength() + " item(s)");
        }
        DrbItem target_item = target_sequence.getItem(0);
        if (target_item.getItemType() != 1) {
            throw new DynamicException(this, "First parameter is not a single element node or a single document node");
        }
        DrbNode target_node = (DrbNode)target_item;
        if (this.isCancellationRequested()) {
            this.throwCancelException();
        }
        if ((content_sequence = this.sourceExpression.evaluate(context)) == null) {
            throw new DynamicException(this, "Error while evaluating the content parameter");
        }
        for (int ichild = 0; ichild < content_sequence.getLength(); ++ichild) {
            DrbItem content_item = content_sequence.getItem(ichild);
            if (!(content_item instanceof DrbNode)) continue;
            target_node.appendChild((DrbNode)content_item);
        }
        DrbDefaultSequence output_sequence = new DrbDefaultSequence();
        return output_sequence;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isUpdating() {
        return true;
    }
}

