/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.query;

import fr.gael.drb.DrbDefaultSequence;
import fr.gael.drb.DrbFactory;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbSequence;
import fr.gael.drb.query.AbstractExpression;
import fr.gael.drb.query.DynamicContext;
import fr.gael.drb.query.DynamicException;
import fr.gael.drb.query.Expression;
import fr.gael.drb.query.GeneralStepExpression;
import fr.gael.drb.query.Token;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

class PathExpression
extends AbstractExpression {
    private static Logger logger = Logger.getLogger(PathExpression.class);
    private List<GeneralStepExpression> steps = new ArrayList<GeneralStepExpression>();
    private Expression expression;
    private boolean absolute;
    private String rootPrefix = null;

    public PathExpression(Token token, String root_prefix, Expression base_expression, boolean absolute) {
        super("Path", token);
        this.absolute = absolute;
        this.rootPrefix = root_prefix;
        this.expression = base_expression;
    }

    public void addStep(GeneralStepExpression step) {
        if (step != null) {
            this.steps.add(step);
            if (this.steps.size() > 1) {
                this.steps.get(this.steps.size() - 2).setNextStep(step);
            }
        } else {
            logger.warn("Cannot add an null general step to the path \"" + this + "\".");
        }
    }

    public void setRootPrefix(String root_prefix) {
        this.rootPrefix = root_prefix;
    }

    @Override
    public DrbSequence evaluate(DynamicContext context) {
        DrbDefaultSequence output_sequence = new DrbDefaultSequence();
        DrbSequence sequence = null;
        if (this.expression != null) {
            sequence = this.expression.evaluate(context);
        } else if (this.absolute) {
            DrbNode root_node;
            String root_path = null;
            try {
                if (this.rootPrefix == null) {
                    root_path = "/";
                } else {
                    root_path = this.rootPrefix;
                    if (root_path.equals("http:/")) {
                        root_path = "http://";
                    }
                    if (root_path.equals("ftp:/")) {
                        root_path = "ftp://";
                    }
                }
                root_node = DrbFactory.openURI(root_path);
            }
            catch (Exception exception) {
                throw new DynamicException(this, "Error while opening root \"" + root_path + "\" (" + exception.getMessage() + ")");
            }
            if (root_node == null) {
                return output_sequence;
            }
            sequence = new DrbDefaultSequence();
            ((DrbDefaultSequence)sequence).addItem(root_node);
        } else {
            sequence = new DrbDefaultSequence(context.focus.getContextItem());
        }
        DynamicContext inner_context = new DynamicContext(context);
        if (this.steps.size() == 0) {
            return sequence;
        }
        for (int item = 0; item < sequence.getLength(); ++item) {
            inner_context.focus.setContextItem(sequence.getItem(item));
            inner_context.focus.setContextPosition(item + 1);
            inner_context.focus.setContextSize(sequence.getLength());
            DrbSequence current_sequence = this.steps.get(0).evaluate(inner_context);
            for (int jtem = 0; jtem < current_sequence.getLength(); ++jtem) {
                output_sequence.add(current_sequence.getItem(jtem));
            }
        }
        return output_sequence;
    }

    public String toString() {
        String output = "";
        if (this.expression != null) {
            output = output + this.expression;
        } else if (this.rootPrefix != null) {
            output = this.rootPrefix;
        }
        if (this.absolute) {
            output = output + "/";
        }
        for (int i = 0; i < this.steps.size(); ++i) {
            output = output + "/";
            output = output + this.steps.get(i);
        }
        return output;
    }
}

